/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.bin;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.freedesktop.dbus.bin.DBusDaemon;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.SASL;
import org.freedesktop.dbus.exceptions.DBusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedDBusDaemon
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedDBusDaemon.class);
    private BusAddress address;
    private DBusDaemon daemonThread;
    private int authTypes = 1;
    private Closeable listenSocket;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    @Override
    public void close() throws IOException {
        this.closed.set(true);
        if (this.listenSocket != null) {
            this.listenSocket.close();
            this.listenSocket = null;
        }
        if (this.daemonThread != null) {
            this.daemonThread.close();
            this.daemonThread.dbusServer.interrupt();
            this.daemonThread.sender.interrupt();
            this.daemonThread = null;
        }
    }

    public void startInForeground() {
        block2: {
            Objects.requireNonNull(this.address, "busAddress not set");
            this.daemonThread = new DBusDaemon();
            this.daemonThread.start();
            this.daemonThread.sender.start();
            this.daemonThread.dbusServer.start();
            try {
                this.listen();
            }
            catch (IOException ex) {
                if (this.closed.get()) break block2;
                throw new RuntimeException(ex);
            }
        }
    }

    public void startInBackground() {
        Thread thread = new Thread(this::startInForeground);
        thread.setName("EmbeddedDBusDaemon-" + this.address);
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((th, ex) -> LOGGER.error("Got uncaught exception", ex));
        thread.start();
    }

    private void listen() throws IOException {
        if ("unix".equals(this.address.getType())) {
            this.startUnixSocket(this.address);
        } else if ("tcp".equals(this.address.getType())) {
            this.startTCPSocket(this.address);
        } else {
            throw new IllegalArgumentException("Unknown address type: " + this.address.getType());
        }
    }

    private void startUnixSocket(BusAddress address) throws IOException {
        LOGGER.debug("enter");
        UnixServerSocketChannel uss = UnixServerSocketChannel.open();
        if (address.isAbstract()) {
            uss.socket().bind((SocketAddress)new UnixSocketAddress("\u0000" + address.getAbstract()));
        } else {
            uss.socket().bind((SocketAddress)new UnixSocketAddress(address.getPath()));
        }
        this.listenSocket = uss;
        while (this.daemonThread.isRunning()) {
            UnixSocketChannel s = uss.accept();
            if (new SASL(true).auth(SASL.SaslMode.SERVER, this.authTypes, address.getGuid(), s.socket().getOutputStream(), s.socket().getInputStream(), (Socket)s.socket())) {
                this.daemonThread.addSock((Socket)s.socket());
                continue;
            }
            s.close();
        }
        uss.close();
        LOGGER.debug("exit");
    }

    private void startTCPSocket(BusAddress address) throws IOException {
        LOGGER.debug("enter");
        try (ServerSocket ss = new ServerSocket(address.getPort(), 10, InetAddress.getByName(address.getHost()));){
            this.listenSocket = ss;
            while (this.daemonThread.isRunning()) {
                Socket s = ss.accept();
                boolean authOK = false;
                try {
                    authOK = new SASL(false).auth(SASL.SaslMode.SERVER, this.authTypes, address.getGuid(), s.getOutputStream(), s.getInputStream(), null);
                }
                catch (Exception e) {
                    LOGGER.debug("", (Throwable)e);
                }
                if (authOK) {
                    this.daemonThread.addSock(s);
                    continue;
                }
                s.close();
            }
            LOGGER.debug("exit");
        }
    }

    public void setAddress(BusAddress address) {
        this.address = address;
    }

    public void setAddress(String address) throws DBusException {
        this.setAddress(new BusAddress(address));
    }

    public void setAuthTypes(int authTypes) {
        this.authTypes = authTypes;
    }
}

