/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.transports;

import com.github.hypfvieh.util.SystemUtil;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import jnr.unixsocket.UnixSocketOptions;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.FreeBSDHelper;
import org.freedesktop.dbus.connections.transports.AbstractTransport;

public class UnixSocketTransport
extends AbstractTransport {
    private final UnixSocketAddress unixSocketAddress;
    private UnixServerSocketChannel unixServerSocket;

    UnixSocketTransport(BusAddress _address) throws IOException {
        super(_address);
        if (_address.isAbstract()) {
            this.unixSocketAddress = new UnixSocketAddress("\u0000" + _address.getAbstract());
        } else if (_address.hasPath()) {
            this.unixSocketAddress = new UnixSocketAddress(_address.getPath());
        } else {
            throw new IOException("Unix socket url has to specify 'path' or 'abstract'");
        }
        this.setSaslAuthMode(1);
    }

    @Override
    boolean hasFileDescriptorSupport() {
        return true;
    }

    @Override
    void connect() throws IOException {
        UnixSocketChannel us;
        if (this.getAddress().isListeningSocket()) {
            this.unixServerSocket = UnixServerSocketChannel.open();
            this.unixServerSocket.socket().bind((SocketAddress)this.unixSocketAddress);
            us = this.unixServerSocket.accept();
        } else {
            us = UnixSocketChannel.open((UnixSocketAddress)this.unixSocketAddress);
        }
        us.configureBlocking(true);
        if (!SystemUtil.isMacOs() && !FreeBSDHelper.isFreeBSD()) {
            us.setOption(UnixSocketOptions.SO_PASSCRED, (Object)true);
        }
        this.authenticate(us.socket().getOutputStream(), us.socket().getInputStream(), (Socket)us.socket());
        this.setInputOutput((Socket)us.socket());
    }

    @Override
    public void close() throws IOException {
        this.getLogger().debug("Disconnecting Transport");
        if (this.unixServerSocket != null && this.unixServerSocket.isOpen()) {
            this.unixServerSocket.close();
        }
        super.close();
    }
}

