/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffreyning.mybatisplus.ognl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.scripting.xmltags.OgnlClassResolver;

public class NhOgnlClassResolver
extends OgnlClassResolver {
    public List<String> baseList = new ArrayList<String>();
    public ConcurrentHashMap<String, Class> cacheCls = new ConcurrentHashMap(101);

    public Class classForName(String className, Map context) throws ClassNotFoundException {
        Class cls = this.cacheCls.get(className);
        if (cls != null) {
            return cls;
        }
        try {
            cls = super.classForName(className, context);
            return cls;
        }
        catch (ClassNotFoundException e) {
            for (String row : this.baseList) {
                String fullClassName = row + "." + className;
                try {
                    cls = super.classForName(fullClassName, context);
                    if (cls == null) continue;
                    this.cacheCls.put(className, cls);
                    return cls;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            if (cls == null) {
                throw new ClassNotFoundException(className);
            }
            return cls;
        }
    }
}

