/*
 * Decompiled with CFR 0.152.
 */
package com.kendelong.jmxconsole.web.controller;

import com.kendelong.jmxconsole.web.controller.AttributeData;
import com.kendelong.jmxconsole.web.controller.OperationData;
import com.kendelong.jmxconsole.web.controller.OperationParameterData;
import com.kendelong.web.jmxconsole.TypeConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.springframework.ui.ModelMap;

public class MbeanDataRetriever {
    private MBeanServer server;

    public MbeanDataRetriever() {
        this(null);
    }

    public MbeanDataRetriever(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            this.server = mbeanServer;
        } else {
            MBeanServerFactory.createMBeanServer();
            this.server = MBeanServerFactory.findMBeanServer(null).get(0);
        }
    }

    public Object listBeans() {
        Set<ObjectInstance> beans = this.server.queryMBeans(null, null);
        Map<String, List<ObjectInstance>> beansByDomain = beans.stream().collect(Collectors.groupingBy(oi -> oi.getObjectName().getDomain()));
        List data = beansByDomain.entrySet().stream().sorted((e1, e2) -> ((String)e1.getKey()).toLowerCase().compareTo(((String)e2.getKey()).toLowerCase())).map(e -> {
            HashMap<String, Object> domain = new HashMap<String, Object>();
            domain.put("name", e.getKey());
            domain.put("safeName", ((String)e.getKey()).replaceAll("[\\.=,]", ""));
            List instances = (List)e.getValue();
            List beanData = instances.stream().map(oi -> oi.getObjectName()).sorted().map(oname -> {
                HashMap<String, String> vals = new HashMap<String, String>();
                String props = oname.getCanonicalKeyPropertyListString();
                vals.put("name", props);
                vals.put("safeName", props.replaceAll("[\\.=,]", ""));
                return vals;
            }).collect(Collectors.toList());
            domain.put("beans", beanData);
            return domain;
        }).collect(Collectors.toList());
        return data;
    }

    public Object getDataForBean(String domain, String bean) throws Exception {
        ObjectName oname = new ObjectName(domain + ":" + bean);
        MBeanInfo mbeanInfo = this.server.getMBeanInfo(oname);
        List attrs = Stream.of(mbeanInfo.getAttributes()).map(attrInfo -> {
            String attrName = attrInfo.getName();
            Object value = null;
            try {
                value = this.server.getAttribute(oname, attrName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            AttributeData mba = new AttributeData((MBeanAttributeInfo)attrInfo, value);
            return mba;
        }).sorted().collect(Collectors.toList());
        List operations = Stream.of(mbeanInfo.getOperations()).map(opInfo -> {
            List<OperationParameterData> params = Stream.of(opInfo.getSignature()).map(paramInfo -> {
                OperationParameterData param = new OperationParameterData(paramInfo.getName(), paramInfo.getType(), paramInfo.getDescription());
                return param;
            }).sorted().collect(Collectors.toList());
            OperationData opData = new OperationData(opInfo.getName(), opInfo.getDescription(), params);
            return opData;
        }).sorted().collect(Collectors.toList());
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("className", mbeanInfo.getClassName());
        results.put("attributes", attrs);
        results.put("operations", operations);
        return results;
    }

    public void updateBeanData(String domain, String bean, Map<String, Object> model) throws Exception {
        ObjectName oname = new ObjectName(domain + ":" + bean);
        MBeanInfo mbeanInfo = this.server.getMBeanInfo(oname);
        for (String name : model.keySet()) {
            Object value = model.get(name);
            MBeanAttributeInfo info = Stream.of(mbeanInfo.getAttributes()).filter(a -> a.getName().equals(name)).findFirst().get();
            if (!info.isWritable()) continue;
            Attribute attr = new Attribute(name, TypeConverter.convertObjectValue(info.getType(), value.toString()));
            this.server.setAttribute(oname, attr);
        }
    }

    public String invokeOperation(String domain, String bean, String operation, ModelMap model) throws Exception {
        ObjectName oname = new ObjectName(domain + ":" + bean);
        MBeanInfo mbeanInfo = this.server.getMBeanInfo(oname);
        MBeanOperationInfo opInfo = Stream.of(mbeanInfo.getOperations()).filter(o -> o.getName().equals(operation)).findFirst().get();
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<String> signature = new ArrayList<String>();
        for (MBeanParameterInfo pInfo : opInfo.getSignature()) {
            Object param = model.get((Object)pInfo.getName());
            String type = pInfo.getType();
            Object oval = TypeConverter.convertObjectValue(type, param.toString());
            params.add(oval);
            signature.add(type);
        }
        Object result = this.server.invoke(oname, operation, params.toArray(), signature.toArray(new String[0]));
        return result != null ? result.toString() : null;
    }

    public static void main(String[] args) {
        System.out.println("bean=foo:hey.foo".replaceAll("[\\.=]", ""));
    }
}

