/*
 * Decompiled with CFR 0.152.
 */
package com.kendelong.web.jmxconsole;

import com.kendelong.web.jmxconsole.TypeConverter;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UpdateAttributeServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String beanName = null;
        try {
            MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
            beanName = request.getParameter("beanName");
            ObjectName oname = new ObjectName(beanName);
            MBeanInfo mbeanInfo = server.getMBeanInfo(oname);
            HashMap<String, MBeanAttributeInfo> attrInfoMap = new HashMap<String, MBeanAttributeInfo>();
            for (MBeanAttributeInfo ai : mbeanInfo.getAttributes()) {
                attrInfoMap.put(ai.getName(), ai);
            }
            Enumeration paramNames = request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String name = (String)paramNames.nextElement();
                if (!name.startsWith("attr_")) continue;
                String attributeName = name.split("_")[1];
                String value = request.getParameterValues(name)[0];
                Object objectValue = TypeConverter.convertObjectValue(((MBeanAttributeInfo)attrInfoMap.get(attributeName)).getType(), value);
                Attribute attribute = new Attribute(attributeName, objectValue);
                try {
                    server.setAttribute(oname, attribute);
                }
                catch (Exception e) {
                    System.out.println("Couldn't set " + attributeName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
        String parm = URLEncoder.encode(beanName, "UTF-8");
        response.sendRedirect("/jmx-console/showBean?beanName=" + parm);
    }
}

