/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.krasa;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class PrimitiveFixerPlugin
extends Plugin {
    private static final String OPTION_NAME = "XReplacePrimitives";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return "-XReplacePrimitives    :   Replaces primitive types of fields and methods by proper Class: int to java.lang.Integer, long to java.lang.Long, boolean to java.lang.Boolean  \n";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) throws SAXException {
        for (ClassOutline co : outline.getClasses()) {
            HashMap<String, Class<Boolean>> hashMap = new HashMap<String, Class<Boolean>>();
            hashMap.put("int", Integer.class);
            hashMap.put("long", Long.class);
            hashMap.put("boolean", Boolean.class);
            Map fields = co.implClass.fields();
            Map<String, JMethod> getterSetterMap = this.getMethodsMap(co);
            for (Map.Entry stringJFieldVarEntry : fields.entrySet()) {
                Class o;
                JFieldVar fieldVar = (JFieldVar)stringJFieldVarEntry.getValue();
                JType type = fieldVar.type();
                if (!type.isPrimitive() || (o = (Class)hashMap.get(type.name())) == null) continue;
                JCodeModel jCodeModel = new JCodeModel();
                JClass newType = jCodeModel.ref(o);
                fieldVar.type((JType)newType);
                String name = fieldVar.name().substring(0, 1).toUpperCase() + fieldVar.name().substring(1);
                JMethod jMethod = getterSetterMap.get("get" + name);
                this.setReturnType((JType)newType, jMethod);
                jMethod = getterSetterMap.get("set" + name);
                this.setParameter(newType, jMethod);
                jMethod = getterSetterMap.get("is" + name);
                this.setReturnType((JType)newType, jMethod);
            }
        }
        return true;
    }

    private void setParameter(JClass newType, JMethod jMethod) {
        if (jMethod != null) {
            JVar jVar = jMethod.listParams()[0];
            jVar.type((JType)newType);
        }
    }

    private void setReturnType(JType type, JMethod jMethod) {
        if (jMethod != null) {
            jMethod.type(type);
        }
    }

    private Map<String, JMethod> getMethodsMap(ClassOutline co) {
        HashMap<String, JMethod> methodsMap = new HashMap<String, JMethod>();
        Collection methods = co.implClass.methods();
        for (JMethod method : methods) {
            String name = method.name();
            if (!method.type().isPrimitive() || !name.startsWith("is") && !name.startsWith("get") && !name.startsWith("set")) continue;
            methodsMap.put(name, method);
        }
        return methodsMap;
    }
}

