/*
 * Decompiled with CFR 0.152.
 */
package de.oehme.xtend.contrib;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.oehme.xtend.contrib.macro.CommonQueries;
import java.util.Collections;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ExtractInterfaceProcessor
extends AbstractClassProcessor {
    public void doRegisterGlobals(ClassDeclaration cls, RegisterGlobalsContext context) {
        String _qualifiedInterfaceName = this.qualifiedInterfaceName(cls);
        context.registerInterface(_qualifiedInterfaceName);
    }

    public void doTransform(final MutableClassDeclaration cls, final @Extension TransformationContext context) {
        String _qualifiedInterfaceName = this.qualifiedInterfaceName((ClassDeclaration)cls);
        MutableInterfaceDeclaration _findInterface = context.findInterface(_qualifiedInterfaceName);
        Procedures.Procedure1<MutableInterfaceDeclaration> _function = new Procedures.Procedure1<MutableInterfaceDeclaration>(){

            public void apply(final MutableInterfaceDeclaration iface) {
                Iterable _implementedInterfaces = cls.getImplementedInterfaces();
                TypeReference _newTypeReference = context.newTypeReference((Type)iface, new TypeReference[0]);
                Iterable _plus = Iterables.concat((Iterable)_implementedInterfaces, Collections.unmodifiableList(Lists.newArrayList((Object[])new TypeReference[]{_newTypeReference})));
                cls.setImplementedInterfaces(_plus);
                Iterable _declaredMethods = cls.getDeclaredMethods();
                Functions.Function1<MutableMethodDeclaration, Boolean> _function = new Functions.Function1<MutableMethodDeclaration, Boolean>(){

                    public Boolean apply(MutableMethodDeclaration it) {
                        boolean _xblockexpression = false;
                        Visibility _visibility = it.getVisibility();
                        boolean _isStatic = it.isStatic();
                        _xblockexpression = !_isStatic;
                        return _xblockexpression;
                    }
                };
                Iterable _filter = IterableExtensions.filter((Iterable)_declaredMethods, (Functions.Function1)_function);
                Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                    public void apply(final MutableMethodDeclaration method) {
                        String _simpleName = method.getSimpleName();
                        Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                            public void apply(final MutableMethodDeclaration extracted) {
                                extracted.setVisibility(Visibility.PUBLIC);
                                TypeReference _returnType = method.getReturnType();
                                extracted.setReturnType(_returnType);
                                Iterable _parameters = method.getParameters();
                                Procedures.Procedure1<MutableParameterDeclaration> _function = new Procedures.Procedure1<MutableParameterDeclaration>(){

                                    public void apply(MutableParameterDeclaration it) {
                                        String _simpleName = it.getSimpleName();
                                        TypeReference _type = it.getType();
                                        extracted.addParameter(_simpleName, _type);
                                    }
                                };
                                IterableExtensions.forEach((Iterable)_parameters, (Procedures.Procedure1)_function);
                                boolean _isVarArgs = method.isVarArgs();
                                extracted.setVarArgs(_isVarArgs);
                                String _docComment = method.getDocComment();
                                extracted.setDocComment(_docComment);
                                Iterable _exceptions = method.getExceptions();
                                extracted.setExceptions((TypeReference[])Conversions.unwrapArray((Object)_exceptions, TypeReference.class));
                            }
                        };
                        iface.addMethod(_simpleName, (Procedures.Procedure1)_function);
                    }
                };
                IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function_1);
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_findInterface, (Procedures.Procedure1)_function);
    }

    public String qualifiedInterfaceName(ClassDeclaration cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = CommonQueries.packageName(cls);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)".");
        String _simpleInterfaceName = this.simpleInterfaceName(cls);
        _builder.append((Object)_simpleInterfaceName, "");
        return _builder.toString();
    }

    public String simpleInterfaceName(ClassDeclaration cls) {
        String _xblockexpression = null;
        String simpleName = cls.getSimpleName();
        String _xifexpression = null;
        boolean _startsWith = simpleName.startsWith("Default");
        if (_startsWith) {
            _xifexpression = simpleName.substring(7);
        } else {
            String _xifexpression_1 = null;
            boolean _endsWith = simpleName.endsWith("Impl");
            if (!_endsWith) {
                throw new IllegalArgumentException("Class name must start with 'Default' or end with 'Impl'");
            }
            int _length = simpleName.length();
            int _minus = _length - 4;
            _xifexpression_1 = simpleName.substring(0, _minus);
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

