/*
 * Decompiled with CFR 0.152.
 */
package de.oehme.xtend.contrib.macro;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.oehme.xtend.contrib.macro.Signature;
import java.util.Arrays;
import java.util.List;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ExecutableDeclaration;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonQueries {
    public static Signature signature(String name, TypeReference ... params) {
        ImmutableList _copyOf = ImmutableList.copyOf((Object[])params);
        return new Signature(name, (ImmutableList<? extends TypeReference>)_copyOf);
    }

    public static Signature signature(ExecutableDeclaration it) {
        String _simpleName = it.getSimpleName();
        Iterable _parameters = it.getParameters();
        Functions.Function1<ParameterDeclaration, TypeReference> _function = new Functions.Function1<ParameterDeclaration, TypeReference>(){

            public TypeReference apply(ParameterDeclaration p) {
                return p.getType();
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_parameters, (Functions.Function1)_function);
        return CommonQueries.signature(_simpleName, (TypeReference[])Conversions.unwrapArray((Object)_map, TypeReference.class));
    }

    public static Signature constructorSignature(ClassDeclaration cls, TypeReference ... params) {
        String _simpleName = cls.getSimpleName();
        return CommonQueries.signature(_simpleName, params);
    }

    public static boolean hasExecutable(ClassDeclaration cls, final Signature sig) {
        Iterable _declaredMembers = cls.getDeclaredMembers();
        Iterable _filter = Iterables.filter((Iterable)_declaredMembers, ExecutableDeclaration.class);
        Functions.Function1<ExecutableDeclaration, Boolean> _function = new Functions.Function1<ExecutableDeclaration, Boolean>(){

            public Boolean apply(ExecutableDeclaration it) {
                Signature _signature = CommonQueries.signature(it);
                return Objects.equal((Object)_signature, (Object)sig);
            }
        };
        return IterableExtensions.exists((Iterable)_filter, (Functions.Function1)_function);
    }

    public static boolean hasDataConstructor(ClassDeclaration cls) {
        Iterable<? extends FieldDeclaration> _persistentState = CommonQueries.persistentState(cls);
        Functions.Function1<FieldDeclaration, TypeReference> _function = new Functions.Function1<FieldDeclaration, TypeReference>(){

            public TypeReference apply(FieldDeclaration it) {
                return it.getType();
            }
        };
        Iterable _map = IterableExtensions.map(_persistentState, (Functions.Function1)_function);
        Signature _constructorSignature = CommonQueries.constructorSignature(cls, (TypeReference[])Conversions.unwrapArray((Object)_map, TypeReference.class));
        return CommonQueries.hasExecutable(cls, _constructorSignature);
    }

    public static boolean hasToString(ClassDeclaration cls) {
        Signature _signature = CommonQueries.signature("toString", new TypeReference[0]);
        return CommonQueries.hasExecutable(cls, _signature);
    }

    public static boolean hasEquals(ClassDeclaration cls) {
        Iterable _declaredMethods = cls.getDeclaredMethods();
        Functions.Function1<MethodDeclaration, Boolean> _function = new Functions.Function1<MethodDeclaration, Boolean>(){

            public Boolean apply(MethodDeclaration it) {
                Iterable _parameters;
                int _size;
                boolean _equals_1;
                boolean _and = false;
                boolean _and_1 = false;
                String _simpleName = it.getSimpleName();
                boolean _equals = Objects.equal((Object)_simpleName, (Object)"equals");
                _and_1 = !_equals ? false : (_equals_1 = (_size = IterableExtensions.size((Iterable)(_parameters = it.getParameters()))) == 1);
                if (!_and_1) {
                    _and = false;
                } else {
                    boolean _equals_2;
                    Iterable _parameters_1 = it.getParameters();
                    ParameterDeclaration _head = (ParameterDeclaration)IterableExtensions.head((Iterable)_parameters_1);
                    TypeReference _type = _head.getType();
                    String _name = _type.getName();
                    _and = _equals_2 = Objects.equal((Object)_name, (Object)"java.lang.Object");
                }
                return _and;
            }
        };
        return IterableExtensions.exists((Iterable)_declaredMethods, (Functions.Function1)_function);
    }

    public static boolean hasHashCode(ClassDeclaration cls) {
        Signature _signature = CommonQueries.signature("hashCode", new TypeReference[0]);
        return CommonQueries.hasExecutable(cls, _signature);
    }

    public static boolean hasGetter(FieldDeclaration field) {
        TypeDeclaration _declaringType = field.getDeclaringType();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"get");
        String _simpleName = field.getSimpleName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_simpleName);
        _builder.append((Object)_firstUpper, "");
        Signature _signature = CommonQueries.signature(_builder.toString(), new TypeReference[0]);
        return CommonQueries.hasExecutable((ClassDeclaration)_declaringType, _signature);
    }

    public static boolean hasSetter(FieldDeclaration field) {
        TypeDeclaration _declaringType = field.getDeclaringType();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"set");
        String _simpleName = field.getSimpleName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_simpleName);
        _builder.append((Object)_firstUpper, "");
        TypeReference _type = field.getType();
        Signature _signature = CommonQueries.signature(_builder.toString(), _type);
        return CommonQueries.hasExecutable((ClassDeclaration)_declaringType, _signature);
    }

    public static Iterable<? extends FieldDeclaration> persistentState(ClassDeclaration cls) {
        Iterable _declaredFields = cls.getDeclaredFields();
        Functions.Function1<FieldDeclaration, Boolean> _function = new Functions.Function1<FieldDeclaration, Boolean>(){

            public Boolean apply(FieldDeclaration it) {
                boolean _isStatic;
                boolean _not_1;
                boolean _not;
                boolean _and = false;
                boolean _isTransient = it.isTransient();
                boolean bl = _not = !_isTransient;
                _and = !_not ? false : (_not_1 = !(_isStatic = it.isStatic()));
                return _and;
            }
        };
        return IterableExtensions.filter((Iterable)_declaredFields, (Functions.Function1)_function);
    }

    public static Iterable<? extends MutableFieldDeclaration> persistentState(MutableClassDeclaration cls) {
        Iterable _declaredFields = cls.getDeclaredFields();
        Functions.Function1<MutableFieldDeclaration, Boolean> _function = new Functions.Function1<MutableFieldDeclaration, Boolean>(){

            public Boolean apply(MutableFieldDeclaration it) {
                boolean _isStatic;
                boolean _not_1;
                boolean _not;
                boolean _and = false;
                boolean _isTransient = it.isTransient();
                boolean bl = _not = !_isTransient;
                _and = !_not ? false : (_not_1 = !(_isStatic = it.isStatic()));
                return _and;
            }
        };
        return IterableExtensions.filter((Iterable)_declaredFields, (Functions.Function1)_function);
    }

    protected static boolean _isStatic(FieldDeclaration field) {
        return field.isStatic();
    }

    protected static boolean _isStatic(MethodDeclaration method) {
        return method.isStatic();
    }

    protected static TypeReference _propertyType(FieldDeclaration field) {
        return field.getType();
    }

    protected static TypeReference _propertyType(MethodDeclaration method) {
        return method.getReturnType();
    }

    public static String packageName(ClassDeclaration cls) {
        String _xblockexpression = null;
        String _qualifiedName = cls.getQualifiedName();
        String[] parts = _qualifiedName.split("\\.");
        int _size = ((List)Conversions.doWrapArray((Object)parts)).size();
        int _minus = _size - 1;
        Iterable _take = IterableExtensions.take((Iterable)((Iterable)Conversions.doWrapArray((Object)parts)), (int)_minus);
        _xblockexpression = IterableExtensions.join((Iterable)_take, (CharSequence)".");
        return _xblockexpression;
    }

    public static boolean isStatic(MemberDeclaration method) {
        if (method instanceof MethodDeclaration) {
            return CommonQueries._isStatic((MethodDeclaration)method);
        }
        if (method instanceof FieldDeclaration) {
            return CommonQueries._isStatic((FieldDeclaration)method);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(method).toString());
    }

    public static TypeReference propertyType(MemberDeclaration method) {
        if (method instanceof MethodDeclaration) {
            return CommonQueries._propertyType((MethodDeclaration)method);
        }
        if (method instanceof FieldDeclaration) {
            return CommonQueries._propertyType((FieldDeclaration)method);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(method).toString());
    }
}

