/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.commons.config;

import internal.org.springframework.content.commons.config.StoreFragment;
import internal.org.springframework.content.commons.config.StoreFragments;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class StoreFragmentsFactoryBean
implements FactoryBean<StoreFragments>,
BeanFactoryAware,
InitializingBean {
    private final List<String> fragmentBeanNames;
    private BeanFactory beanFactory;
    private StoreFragments storeFragments;

    public StoreFragmentsFactoryBean(List<String> fragmentBeanNames) {
        Assert.notNull(fragmentBeanNames, (String)"Fragment bean names must not be null!");
        this.fragmentBeanNames = fragmentBeanNames;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        List<StoreFragment> fragments = this.fragmentBeanNames.stream().map(it -> (StoreFragment)this.beanFactory.getBean(it, StoreFragment.class)).collect(Collectors.toList());
        this.storeFragments = new StoreFragments(fragments);
    }

    public StoreFragments getObject() throws Exception {
        return this.storeFragments;
    }

    public Class<?> getObjectType() {
        return StoreFragments.class;
    }
}

