/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy;

import antlr.collections.AST;
import de.hunsicker.io.Copy;
import de.hunsicker.io.FileBackup;
import de.hunsicker.io.FileFormat;
import de.hunsicker.io.IoHelper;
import de.hunsicker.jalopy.VersionMismatchException;
import de.hunsicker.jalopy.language.CodeInspector;
import de.hunsicker.jalopy.language.CompositeFactory;
import de.hunsicker.jalopy.language.JavaRecognizer;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.Environment;
import de.hunsicker.jalopy.storage.History;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.util.Version;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public final class Jalopy {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int FILE_INPUT = 1;
    private static final int FILE_OUTPUT = 2;
    private static final int ILLEGAL = 0;
    private static final int READER_INPUT = 16;
    private static final int STRING_INPUT = 4;
    private static final int STRING_OUTPUT = 8;
    private static final int WRITER_OUTPUT = 32;
    private static Version _version = Version.valueOf(Jalopy.loadVersionString());
    private static final int FILE_FILE = 3;
    private static final int FILE_STRING = 9;
    private static final int FILE_WRITER = 33;
    private static final int STRING_FILE = 6;
    private static final int STRING_STRING = 12;
    private static final int STRING_WRITER = 36;
    private static final int READER_FILE = 18;
    private static final int READER_STRING = 24;
    private static final int READER_WRITER = 48;
    private Checksum _inputFileChecksum;
    private CodeInspector _inspector;
    private File _backupDir;
    private File _backupFile;
    private File _destination;
    private File _inputFile;
    private File _outputFile;
    private FileFormat _inputFileFormat;
    private FileFormat _outputFileFormat;
    private JavaNode _tree;
    private final JavaRecognizer _recognizer;
    private Map _issues;
    private History.Method _historyMethod = History.Method.TIMESTAMP;
    private History.Policy _historyPolicy = History.Policy.DISABLED;
    private Reader _inputReader;
    State _state = State.UNDEFINED;
    private String _encoding;
    private String _inputString;
    private String _packageName;
    private StringBuffer _outputString;
    private StringWriter _outputStringBuffer;
    private Writer _outputWriter;
    private Object[] _args = new Object[5];
    private boolean _force;
    private boolean _holdBackup;
    private boolean _inspect;
    private int _backupLevel;
    private int _mode;
    private long _now;
    private long _timeParsing;
    private long _timePrinting;
    private long _timeTransforming;
    private CompositeFactory _factory = null;

    public Jalopy() {
        this.initConventionDefaults();
        this._issues = new HashMap(30);
        this._factory = new CompositeFactory();
        this._recognizer = new JavaRecognizer(this._factory);
        this._inspector = new CodeInspector(this._issues);
    }

    public static void setConvention(File file) throws IOException {
        Convention.importSettings(file);
    }

    public static void setConvention(URL url) throws IOException {
        Convention.importSettings(url);
    }

    public static void setConvention(String location) throws IOException {
        if (location.startsWith("http://") || location.startsWith("www.")) {
            Jalopy.setConvention(new URL(location));
        } else {
            Jalopy.setConvention(new File(location));
        }
    }

    public void setEncoding(String encoding) {
        if (encoding != null) {
            try {
                new String(EMPTY_BYTE_ARRAY, encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalArgumentException("invalid encoding specified -- " + encoding);
            }
        }
        this._encoding = encoding;
    }

    public void setFileFormat(FileFormat format) {
        this._outputFileFormat = format;
    }

    public void setFileFormat(String format) {
        this._outputFileFormat = FileFormat.valueOf(format);
    }

    public void setForce(boolean force) {
        this._force = force;
    }

    public void setHistoryMethod(History.Method method) {
        this._historyMethod = method;
    }

    public void setHistoryPolicy(History.Policy policy) {
        this._historyPolicy = policy;
    }

    public void setInspect(boolean enabled) {
        this._inspect = enabled;
    }

    public boolean isInspect() {
        return this._inspect;
    }

    public static Version getVersion() {
        return _version;
    }

    public void setOutput(Writer output) {
        this._outputWriter = output;
        this._mode += 32;
    }

    public String getProfileTimes() {
        long whole = this._timeParsing + this._timeTransforming + this._timePrinting;
        if (whole > 0L) {
            StringBuffer buf = new StringBuffer(100);
            buf.append(this._timeParsing);
            buf.append('(');
            buf.append(this._timeParsing * 100L / whole);
            buf.append("%) ");
            buf.append(this._timeTransforming);
            buf.append('(');
            buf.append(this._timeTransforming * 100L / whole);
            buf.append("%) ");
            buf.append(this._timePrinting);
            buf.append('(');
            buf.append(this._timePrinting * 100L / whole);
            buf.append("%)");
            return buf.toString();
        }
        return "";
    }

    public JavaRecognizer getRecognizer() {
        return this._recognizer;
    }

    public State getState() {
        return this._state;
    }

    public static void checkCompatibility(String packageName) throws VersionMismatchException {
    }

    public void setBackup(boolean backup) {
        this._holdBackup = backup;
    }

    public void setBackupDirectory(File directory) {
        if (!directory.isAbsolute()) {
            directory = new File(Convention.getProjectSettingsDirectory(), directory.getPath());
        }
        IoHelper.ensureDirectoryExists(directory.getAbsoluteFile());
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("invalid directory -- " + directory);
        }
        this._backupDir = directory.getAbsoluteFile();
    }

    public void setBackupDirectory(String directory) {
        this.setBackupDirectory(new File(directory));
    }

    public File getBackupDirectory() {
        return this._backupDir;
    }

    public void setBackupLevel(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("level has to be >= 0");
        }
        this._backupLevel = level;
        if (level == 0) {
            this.setBackup(false);
        }
    }

    public void setDestination(File destination) {
        if (destination == null || destination.exists() && !destination.isDirectory()) {
            throw new IllegalArgumentException("no valid directory -- " + destination);
        }
        if (!destination.exists()) {
            if (!destination.mkdirs()) {
                throw new RuntimeException("could not create destination directory -- " + destination);
            }
            Object[] args = new Object[]{destination};
            Loggers.IO.info((Object)Loggers.fmt("FILE_DESTINATION_CREATED", args), null);
        }
        this._destination = destination;
    }

    public void setInput(String input, String path) {
        if (input == null) {
            throw new NullPointerException();
        }
        if (path == null) {
            throw new NullPointerException();
        }
        this._inputFile = new File(path);
        this._inputFileChecksum = null;
        this._inputString = input;
        this._inputReader = new BufferedReader(new StringReader(input));
        if (!this.hasInput()) {
            this._mode += 4;
        }
    }

    public void setInput(InputStream input, String path) {
        if (input == null) {
            return;
        }
        if (path == null) {
            throw new IllegalArgumentException("no path given");
        }
        File file = new File(path);
        if (!(file.exists() && file.isFile() || System.in == input)) {
            throw new IllegalArgumentException("invalid path given -- " + path);
        }
        this._inputFile = new File(path);
        this._inputFileChecksum = null;
        this._inputReader = new BufferedReader(new InputStreamReader(input));
        if (!this.hasInput()) {
            this._mode += 16;
        }
    }

    public void setInput(Reader input, String path) {
        if (path == null) {
            throw new IllegalArgumentException("no path given");
        }
        if (input == null) {
            return;
        }
        File file = new File(path);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("invalid path given -- " + path);
        }
        this._inputFile = new File(path);
        this._inputFileChecksum = null;
        this._inputReader = input;
        if (!this.hasInput()) {
            this._mode += 16;
        }
    }

    public void setInput(File input) throws FileNotFoundException {
        this._inputReader = Jalopy.getBufferedReader(input, this._encoding);
        this._inputFile = input.getAbsoluteFile();
        this._inputFileChecksum = null;
        if (!this.hasInput()) {
            ++this._mode;
        }
    }

    public void setOutput(File output) {
        this._outputFile = output;
        this._mode += 2;
    }

    public void setOutput(StringBuffer output) {
        this._outputString = output;
        this._outputStringBuffer = new StringWriter();
        this._outputWriter = new BufferedWriter(this._outputStringBuffer);
        this._mode += 8;
    }

    public void cleanupBackupDirectory() {
        if (!this._holdBackup) {
            this.cleanupDirectory(this._backupDir);
        }
    }

    public boolean format() {
        return this.format(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean format(boolean runCleanup) {
        JavaNode tree = null;
        boolean formatSuccess = false;
        if (!this.hasInput()) {
            throw new IllegalStateException("no input source specified");
        }
        try {
            if (!this.isDirty()) {
                this._args[0] = this._inputFile;
                Loggers.IO.info((Object)Loggers.fmt("FILE_FOUND_HISTORY", this._args), null);
                this._state = State.OK;
                this.cleanup();
                boolean bl = false;
                return bl;
            }
            if (this._state != State.PARSED || this._state != State.INSPECTED) {
                tree = this.parse();
                if (this._state == State.ERROR) {
                    this.cleanup();
                    boolean bl = false;
                    return bl;
                }
            } else {
                tree = this._tree;
            }
            formatSuccess = this.format(tree, this._packageName, this._inputFileFormat, false);
        }
        catch (Throwable ex) {
            this._state = State.ERROR;
            ex.printStackTrace();
            this._args[0] = this._inputFile;
            this._args[1] = ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage();
            Loggers.IO.error((Object)Loggers.fmt("UNKNOWN_ERROR", this._args), ex);
        }
        finally {
            this.cleanup();
        }
        return formatSuccess;
    }

    public void inspect() {
        JavaNode tree = null;
        if (this._state != State.PARSED) {
            try {
                tree = this.parse();
                if (this._state == State.ERROR) {
                    return;
                }
            }
            catch (Throwable ex) {
                this._state = State.ERROR;
                this._args[0] = this._inputFile;
                this._args[1] = ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage();
                Loggers.IO.error((Object)Loggers.fmt("UNKNOWN_ERROR", this._args), ex);
            }
        } else {
            tree = this._tree;
        }
        this.inspect(tree);
    }

    public void inspect(JavaNode tree) {
        if (tree == null) {
            throw new NullPointerException();
        }
        switch (tree.getType()) {
            case 65: {
                break;
            }
            default: {
                throw new IllegalArgumentException("not a root node -- " + tree);
            }
        }
        long start = 0L;
        if (Loggers.IO.isDebugEnabled()) {
            start = System.currentTimeMillis();
            this._args[0] = this._inputFile;
            Loggers.IO.debug((Object)Loggers.fmt("FILE_INSPECT", this._args), null);
        }
        this._inspector.inspect((AST)tree, this._outputFile != null ? this._outputFile : this._inputFile);
        if (Loggers.IO.isDebugEnabled()) {
            long stop = System.currentTimeMillis();
            Loggers.IO.debug((Object)(this._inputFile + ":0:0:inspecting took " + (stop - start)));
        }
        if (this._state != State.ERROR) {
            this._state = State.INSPECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaNode parse() {
        long start = 0L;
        this._state = State.RUNNING;
        if (Loggers.IO.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            switch (this._mode) {
                case 1: 
                case 3: 
                case 9: 
                case 33: {
                    this._args[0] = this._inputFile;
                    Loggers.IO.info((Object)Loggers.fmt("FILE_PARSE", this._args), null);
                    this._recognizer.parse(this._inputReader, this._inputFile.getAbsolutePath());
                    break;
                }
                case 4: 
                case 6: 
                case 12: 
                case 16: 
                case 18: 
                case 24: 
                case 36: 
                case 48: {
                    this._args[0] = this._inputFile;
                    Loggers.IO.info((Object)Loggers.fmt("FILE_PARSE", this._args), null);
                    this._recognizer.parse(this._inputReader, this._inputFile.getAbsolutePath());
                    break;
                }
                default: {
                    throw new IllegalStateException("no input source specified");
                }
            }
            if (this._state == State.ERROR) {
                JavaNode javaNode = null;
                return javaNode;
            }
            if (Loggers.IO.isDebugEnabled()) {
                long stop = System.currentTimeMillis();
                Loggers.IO.debug((Object)(this._inputFile.getAbsolutePath() + ":0:0:parsing took " + (stop - start)));
                this._timeParsing += stop - start;
            }
            if (this._state != State.ERROR) {
                this._state = State.PARSED;
            }
            JavaNode tree = null;
            if (Loggers.IO.isDebugEnabled()) {
                Loggers.IO.debug((Object)((this._outputFile != null ? this._outputFile : this._inputFile) + ":0:0:transform"));
                start = System.currentTimeMillis();
                tree = (JavaNode)this._recognizer.getParseTree();
                long stop = System.currentTimeMillis();
                this._timeTransforming += stop - start;
                Loggers.IO.debug((Object)((this._outputFile != null ? this._outputFile : this._inputFile) + ":0:0:transforming took " + (stop - start)));
            } else {
                tree = (JavaNode)this._recognizer.getParseTree();
            }
            this._tree = tree;
            this._inputFileFormat = this._recognizer.getFileFormat();
            this._packageName = this._recognizer.getPackageName();
            JavaNode javaNode = tree;
            return javaNode;
        }
        finally {
            this.cleanupRecognizer();
        }
    }

    public void reset() {
        this.cleanup();
        this.initConventionDefaults();
    }

    void resetTimers() {
        this._timeParsing = 0L;
        this._timePrinting = 0L;
        this._timeTransforming = 0L;
    }

    private void cleanupDirectory(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                if (files[i].list().length > 0) {
                    this.cleanupDirectory(files[i]);
                    continue;
                }
                if (!files[i].delete()) continue;
                File parent = directory.getParentFile();
                if (directory.equals(this._backupDir)) continue;
                this.cleanupDirectory(parent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean format(JavaNode tree, String packageName, FileFormat format, boolean check) {
        block22: {
            String defaultEncoding;
            block20: {
                boolean issues2;
                block21: {
                    block18: {
                        boolean bl;
                        block19: {
                            defaultEncoding = null;
                            this._args[0] = this._inputFile;
                            if (!check || this.isDirty()) break block18;
                            Loggers.IO.info((Object)Loggers.fmt("FILE_FOUND_HISTORY", this._args), null);
                            this._state = State.OK;
                            bl = false;
                            if (defaultEncoding == null) break block19;
                            System.setProperty("file.encoding", defaultEncoding);
                        }
                        this.cleanup();
                        return bl;
                    }
                    if (this._encoding != null) {
                        defaultEncoding = System.getProperty("file.encoding");
                        System.setProperty("file.encoding", this._encoding);
                    }
                    if (this._inspect) {
                        this.inspect(tree);
                    }
                    this.print(tree, packageName, format);
                    if (this._inspect) {
                        Object[] issues2 = new Object[6];
                        for (Map.Entry entry : this._issues.entrySet()) {
                            JavaNode node;
                            for (node = (JavaNode)entry.getKey(); node != null && node.getParent() != null && node.newLine == 0; node = node.getParent()) {
                            }
                            Object message = entry.getValue();
                            issues2[0] = this._inputFile.getAbsolutePath();
                            issues2[1] = new Integer(node.newLine);
                            issues2[2] = new Integer(node.newColumn);
                            issues2[3] = message.toString();
                            issues2[4] = new Integer(node.getStartLine());
                            issues2[5] = node;
                            Loggers.PRINTER.warn((Object)Loggers.fmt("CODE_INSPECTOR", issues2), null);
                        }
                    }
                    if (this._state != State.ERROR) break block20;
                    this.restore(this._inputFile, this._backupFile);
                    issues2 = false;
                    if (defaultEncoding == null) break block21;
                    System.setProperty("file.encoding", defaultEncoding);
                }
                this.cleanup();
                return issues2;
            }
            try {
                if (this._outputStringBuffer != null) {
                    this._outputString.setLength(0);
                    this._outputString.append(this._outputStringBuffer.toString());
                }
                if (this._outputFile != null) {
                    this._inputReader.close();
                    if (this._outputWriter != null) {
                        this._outputWriter.close();
                        this._outputFile.setLastModified(this._now);
                    }
                    if (this._state == State.PARSED || this._state == State.INSPECTED || this._state == State.RUNNING) {
                        this._state = State.OK;
                    }
                }
                if (!this._holdBackup && this._backupFile != null && this._backupFile.exists()) {
                    this._backupFile.delete();
                    if (Loggers.IO.isDebugEnabled()) {
                        this._args[0] = this._inputFile;
                        this._args[1] = this._backupFile;
                        Loggers.IO.debug((Object)Loggers.fmt("FILE_BACKUP_REMOVE", this._args), null);
                    }
                }
                if (defaultEncoding == null) break block22;
            }
            catch (Throwable ex) {
                block23: {
                    try {
                        ex.printStackTrace();
                        this._state = State.ERROR;
                        this._args[0] = this._inputFile;
                        this._args[1] = ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage();
                        Loggers.IO.error((Object)Loggers.fmt("UNKNOWN_ERROR", this._args), ex);
                        this.restore(this._inputFile, this._backupFile);
                        if (defaultEncoding == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (defaultEncoding != null) {
                            System.setProperty("file.encoding", defaultEncoding);
                        }
                        this.cleanup();
                        throw throwable;
                    }
                    System.setProperty("file.encoding", defaultEncoding);
                }
                this.cleanup();
            }
            System.setProperty("file.encoding", defaultEncoding);
        }
        this.cleanup();
        return this._state != State.ERROR;
    }

    private boolean hasInput() {
        switch (this._mode) {
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 24: 
            case 33: 
            case 36: 
            case 48: {
                return true;
            }
        }
        return false;
    }

    private static String loadVersionString() {
        return "1.0b10";
    }

    private boolean isChecksum() {
        boolean result = this._outputFile != null && this._historyPolicy == History.Policy.FILE && (this._historyMethod == History.Method.CRC32 || this._historyMethod == History.Method.ADLER32);
        return result;
    }

    private File getDestinationFile(File destination, String packageName, String filename) throws IOException {
        StringBuffer buf = new StringBuffer(90);
        buf.append(destination);
        buf.append(File.separator);
        buf.append(packageName.replace('.', File.separatorChar));
        File test = new File(buf.toString());
        if (!test.exists()) {
            if (!test.mkdirs()) {
                throw new IOException("could not create target directory -- " + buf);
            }
            if (Loggers.IO.isDebugEnabled()) {
                Loggers.IO.debug((Object)("directory " + test + " created"));
            }
        }
        buf.append(File.separator);
        buf.append(filename);
        return new File(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirty() throws IOException {
        if (this._force) {
            return true;
        }
        if ((this._mode & 1) == 0) {
            return this._inputReader != null;
        }
        if (this._inputFile != null && !this._inputFile.exists() || this._inputFile.length() == 0L) {
            return false;
        }
        if (this._historyPolicy == History.Policy.FILE) {
            History.Entry entry = History.getInstance().get(this._inputFile);
            if (entry != null) {
                if (this._historyMethod == History.Method.TIMESTAMP) {
                    return entry.getModification() < this._inputFile.lastModified();
                }
                if (this._inputFileChecksum == null) {
                    if (this._historyMethod == History.Method.CRC32) {
                        this._inputFileChecksum = new CRC32();
                    } else if (this._historyMethod == History.Method.ADLER32) {
                        this._inputFileChecksum = new Adler32();
                    }
                    try (InputStream in = null;){
                        in = new BufferedInputStream(new FileInputStream(this._inputFile));
                        byte[] buffer = new byte[8192];
                        int count = 0;
                        do {
                            this._inputFileChecksum.update(buffer, 0, count);
                        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                    }
                    return this._inputFileChecksum.getValue() != entry.getModification();
                }
                return this._inputFileChecksum.getValue() != entry.getModification();
            }
            return true;
        }
        if (this._historyPolicy == History.Policy.COMMENT) {
            try (BufferedReader in = null;){
                int stop;
                int start;
                long lastmod;
                in = Jalopy.getBufferedReader(this._inputFile, this._encoding);
                String line = in.readLine().trim();
                in.close();
                if (line.startsWith("// %") && line.endsWith("%") && line.indexOf("modified") == -1 && (lastmod = Long.parseLong(line.substring(start = line.indexOf(37) + 1, stop = line.indexOf(58)))) >= this._inputFile.lastModified()) {
                    if (this._destination != null) {
                        String packageName = line.substring(stop + 1, line.length() - 1);
                        this.copyInputToOutput(this._inputFile, this._destination, packageName, lastmod);
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        return true;
    }

    private String getLineSeparator(FileFormat fileFormat, FileFormat detectedFileFormat) {
        if (fileFormat == FileFormat.AUTO) {
            return detectedFileFormat.toString();
        }
        return fileFormat.getLineSeparator();
    }

    private void setLocalVariables(Environment environment, File file, String packageName, String fileFormat, int indentSize) {
        environment.set(Environment.Variable.FILE_NAME.getName(), file.getName());
        environment.set(Environment.Variable.FILE.getName(), file.getAbsolutePath());
        environment.set(Environment.Variable.PACKAGE.getName(), "".equals(packageName) ? "default package" : packageName);
        environment.set(Environment.Variable.FILE_FORMAT.getName(), fileFormat);
        environment.set(Environment.Variable.TAB_SIZE.getName(), String.valueOf(indentSize));
        DateFormat df = DateFormat.getDateTimeInstance();
        environment.set(Environment.Variable.DATE.getName(), new Date());
        String className = file.getName();
        className = className.substring(0, className.length() - 5);
        environment.set(Environment.Variable.CLASS_NAME.getName(), className);
    }

    private boolean isWritable(File file) {
        if (file != null) {
            if (!file.exists()) {
                return true;
            }
            return file.canWrite();
        }
        return false;
    }

    private void addCommentHistoryEntry(String packageName, NodeWriter out) throws IOException {
        if (this._historyPolicy == History.Policy.COMMENT && this._inputFile != null) {
            StringBuffer buf = new StringBuffer(40);
            buf.append("// %");
            buf.append(this._now);
            buf.append(':');
            buf.append(packageName);
            buf.append('%');
            out.print(buf.toString(), 174);
            out.printNewline();
        }
    }

    private void addFileHistoryEntry(String packageName, History.ChecksumCharArrayWriter checksumWriter) throws IOException {
        if (this._historyPolicy == History.Policy.FILE && this._inputFile != null) {
            if (this.isChecksum()) {
                History.getInstance().add(this._inputFile, packageName, checksumWriter.getChecksum().getValue());
            } else {
                History.getInstance().add(this._inputFile, packageName, this._now);
            }
        }
    }

    private void cleanup() {
        try {
            if (this._inputReader != null) {
                this._inputReader.close();
                this._inputReader = null;
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        try {
            if (this._outputWriter != null) {
                this._outputWriter.close();
                this._outputWriter = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._mode = 0;
        this._issues.clear();
        this._inputFile = null;
        this._inputString = null;
        this._outputStringBuffer = null;
        this._outputString = null;
        this._outputFile = null;
        this._backupFile = null;
        this._packageName = null;
        this._inputFileFormat = null;
        this._tree = null;
        this.cleanupRecognizer();
    }

    private void cleanupRecognizer() {
        this._recognizer.reset();
    }

    private void copyInputToOutput(File inputFile, File destination, String packageName, long lastmod) throws IOException {
        File file = this.getDestinationFile(destination, packageName, inputFile.getName());
        if (!file.exists() || file.lastModified() != lastmod) {
            Copy.file(inputFile, file, true);
            file.setLastModified(lastmod);
            this._args[0] = inputFile;
            this._args[1] = file.getAbsolutePath();
            Loggers.IO.info((Object)Loggers.fmt("FILE_COPY", this._args), null);
        }
    }

    private File createBackup(String packageName) throws IOException {
        switch (this._mode) {
            case 3: {
                if (!this._inputFile.equals(this._outputFile)) break;
                IoHelper.ensureDirectoryExists(this._backupDir);
                File directory = new File(this._backupDir + File.separator + packageName.replace('.', File.separatorChar));
                File backupFile = FileBackup.create(this._inputFile, directory, this._backupLevel);
                if (Loggers.IO.isDebugEnabled()) {
                    this._args[1] = backupFile;
                    Loggers.IO.debug((Object)Loggers.fmt("FILE_COPY", this._args), null);
                }
                return backupFile;
            }
            case 6: 
            case 12: 
            case 36: {
                if (!this._inputFile.exists()) break;
                IoHelper.ensureDirectoryExists(this._backupDir);
                File directory = new File(this._backupDir + File.separator + packageName.replace('.', File.separatorChar));
                String filename = this._inputFile.getName();
                File backupFile = FileBackup.create(this._inputString, filename, directory, this._backupLevel);
                if (Loggers.IO.isDebugEnabled()) {
                    this._args[1] = backupFile;
                    Loggers.IO.debug((Object)Loggers.fmt("FILE_COPY", this._args), null);
                }
                return backupFile;
            }
        }
        return null;
    }

    private void initConventionDefaults() {
        this._backupDir = Convention.getBackupDirectory();
        this._backupLevel = 0;
        this._holdBackup = false;
        this._state = State.UNDEFINED;
        this._outputFileFormat = FileFormat.UNKNOWN;
        this._destination = null;
        this._encoding = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(JavaNode tree, String packageName, FileFormat format) throws IOException {
        if (this._state == State.ERROR) {
            return;
        }
        switch (this._mode) {
            case 3: {
                if (this._destination == null && !this.isChecksum()) {
                    this._backupFile = this.createBackup(packageName);
                }
                if (this._destination != null) {
                    this._outputFile = this.getDestinationFile(this._destination, packageName, this._outputFile.getName());
                }
                if (!this.isWritable(this._outputFile)) {
                    this._args[0] = this._outputFile.getAbsolutePath();
                    this._outputFile = null;
                    Loggers.IO.warn((Object)Loggers.fmt("FILE_NO_WRITE", this._args), null);
                    return;
                }
                if (this.isChecksum()) break;
                this._outputWriter = Jalopy.getBufferedWriter(this._outputFile, this._encoding);
                break;
            }
            case 9: 
            case 33: {
                this._backupFile = this.createBackup(packageName);
                break;
            }
            case 6: 
            case 18: {
                if (this._destination != null) {
                    this._outputFile = this.getDestinationFile(this._destination, packageName, this._outputFile.getName());
                }
                if (!this.isWritable(this._outputFile)) {
                    this._args[0] = this._outputFile.getAbsolutePath();
                    this._outputFile = null;
                    Loggers.IO.warn((Object)Loggers.fmt("FILE_NO_WRITE", this._args), null);
                    return;
                }
                this._outputWriter = Jalopy.getBufferedWriter(this._outputFile, this._encoding);
            }
            case 12: 
            case 24: 
            case 36: 
            case 48: {
                this._backupFile = this.createBackup(packageName);
                break;
            }
            default: {
                throw new IllegalStateException("both input source and output target has to be specified");
            }
        }
        this._now = System.currentTimeMillis();
        Writer outputWriter = null;
        History.ChecksumCharArrayWriter checksumWriter = null;
        if (this.isChecksum()) {
            checksumWriter = new History.ChecksumCharArrayWriter(this._historyMethod);
            outputWriter = new BufferedWriter(checksumWriter);
        } else {
            outputWriter = this._outputWriter;
        }
        NodeWriter out = new NodeWriter(outputWriter, this._factory, this._inputFile.getAbsolutePath(), this._issues, this.getLineSeparator(this._outputFileFormat, format), format.toString());
        out.setTracking(this._recognizer.hasAnnotations() || this._recognizer.hasPosition());
        Environment environment = Environment.getInstance().copy();
        this.setLocalVariables(environment, this._inputFile, packageName, this._outputFileFormat.getName(), out.getIndentSize());
        out.setEnvironment(environment);
        this.addCommentHistoryEntry(packageName, out);
        long start = 0L;
        try {
            long stop;
            if (Loggers.IO.isDebugEnabled()) {
                Loggers.IO.debug((Object)((this._outputFile != null ? this._outputFile : this._inputFile) + ":0:0:print"));
                start = System.currentTimeMillis();
                PrinterFactory.create((AST)tree, out).print((AST)tree, out);
                if (!this.isChecksum()) {
                    stop = System.currentTimeMillis();
                    this._timePrinting += stop - start;
                    Loggers.IO.debug((Object)((this._outputFile != null ? this._outputFile : this._inputFile) + ":0:0:printing took " + (stop - start)));
                }
            } else {
                PrinterFactory.create((AST)tree, out).print((AST)tree, out);
            }
            if (this.isChecksum()) {
                out.flush();
                if (this._inputFileChecksum == null || this._inputFileChecksum.getValue() != checksumWriter.getChecksum().getValue()) {
                    if (this._destination == null) {
                        this._backupFile = this.createBackup(packageName);
                    }
                    this._outputWriter = Jalopy.getBufferedWriter(this._outputFile, this._encoding);
                    checksumWriter.writeTo(this._outputWriter);
                } else {
                    Loggers.IO.info((Object)Loggers.fmt("FILE_MODIFIED_BUT_SAME", this._args), null);
                }
                if (Loggers.IO.isDebugEnabled()) {
                    stop = System.currentTimeMillis();
                    this._timePrinting += stop - start;
                    Loggers.IO.debug((Object)((this._outputFile != null ? this._outputFile : this._inputFile) + ":0:0:printing took " + (stop - start)));
                }
            }
            this.addFileHistoryEntry(packageName, checksumWriter);
        }
        finally {
            this.unsetLocalVariables(environment);
            if (out != null) {
                out.close();
            }
            if (this.isChecksum() && this._outputWriter != null) {
                this._outputWriter.close();
            }
        }
    }

    private static BufferedReader getBufferedReader(File file, String encoding) throws FileNotFoundException {
        BufferedReader reader;
        try {
            reader = encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding)) : new BufferedReader(new FileReader(file));
        }
        catch (UnsupportedEncodingException e) {
            throw new FileNotFoundException("Unsupported encoding " + encoding);
        }
        return reader;
    }

    private static BufferedWriter getBufferedWriter(File file, String encoding) throws IOException {
        BufferedWriter writer = encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding)) : new BufferedWriter(new FileWriter(file));
        return writer;
    }

    private void restore(File original, File backup) {
        if (original != null && backup != null) {
            this._args[0] = original.getAbsolutePath();
            this._args[1] = backup.getAbsolutePath();
            Loggers.IO.info((Object)Loggers.fmt("FILE_RESTORE", this._args), null);
            try {
                Copy.file(backup, original, true);
                original.setLastModified(backup.lastModified());
                backup.delete();
            }
            catch (IOException ex) {
                Loggers.IO.fatal((Object)Loggers.fmt("FILE_RESTORE_ERROR", this._args), (Throwable)ex);
            }
        }
    }

    private void unsetLocalVariables(Environment environment) {
        environment.unset(Environment.Variable.FILE_NAME.getName());
        environment.unset(Environment.Variable.FILE.getName());
        environment.unset(Environment.Variable.PACKAGE.getName());
        environment.unset(Environment.Variable.FILE_FORMAT.getName());
        environment.unset(Environment.Variable.TAB_SIZE.getName());
    }

    public static final class State {
        public static final State OK = new State("Jalopy.State [ok]");
        public static final State WARN = new State("Jalopy.State [warn]");
        public static final State ERROR = new State("Jalopy.State [error]");
        public static final State PARSED = new State("Jalopy.State [parsed]");
        public static final State INSPECTED = new State("Jalopy.State [inspected]");
        public static final State RUNNING = new State("Jalopy.State [running]");
        public static final State UNDEFINED = new State("Jalopy.State [undefined]");
        final String name;

        private State(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

