/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import antlr.CommonHiddenStreamToken;
import antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.JavaNodeModifier;
import de.hunsicker.jalopy.language.TreeWalker;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.util.ResourceBundleFactory;
import java.io.File;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class CodeInspector
extends TreeWalker {
    private static final List _favorableTypes = new ArrayList(20);
    private static final List _collectionTypes = new ArrayList(28);
    private static final HashMap _patternMap = new HashMap(30);
    private static final String BUNDLE_NAME = "de.hunsicker.jalopy.language.Bundle";
    protected static final Convention _settings = Convention.getInstance();
    private static final String STR_boolean = "boolean";
    private static final String STR_Object = "Object";
    private static final String STR_equals = "equals";
    private static final String STR_javalangObject = "java.lang.Object";
    private static final String STR_String = "String";
    private static final String STR_toString = "toString";
    private static final String STR_void = "void";
    private static final String STR_finalize = "finalize";
    private static final String STR_int = "int";
    private static final String STR_hashCode = "hashCode";
    private static final String STR_wait = "wait";
    private static final String STR_Exception = "Exception";
    private static final String STR_Throwable = "Throwable";
    private static final String STR_STRING_LITERAL_I18N = "STRING_LITERAL_I18N";
    private static final String STR_OBEY_CONTRACT_EQUALS = "OBEY_CONTRACT_EQUALS";
    private static final String STR_DONT_SUBSTITUTE_OBJECT_EQUALS = "DONT_SUBSTITUTE_OBJECT_EQUALS";
    private static final String STR_OVERRIDE_HASHCODE = "OVERRIDE_HASHCODE";
    private static final String STR_OVERRIDE_TO_STRING = "OVERRIDE_TO_STRING";
    private static final String STR_RETURN_ZERO_ARRAY = "RETURN_ZERO_ARRAY";
    private static final String STR_INTERFACE_ONLY_FOR_TYPE = "INTERFACE_ONLY_FOR_TYPE";
    private static final String STR_REPLACE_STRUCTURE_WITH_CLASS = "REPLACE_STRUCTURE_WITH_CLASS";
    private static final String STR_REFER_BY_INTERFACE = "REFER_BY_INTERFACE";
    private static final String STR_VARIABLE_SHADOW = "VARIABLE_SHADOW";
    private static final String STR_DONT_IGNORE_EXCEPTION = "DONT_IGNORE_EXCEPTION";
    private static final String STR_NEVER_THROW_EXCEPTION = "NEVER_THROW_EXCEPTION";
    private static final String STR_NEVER_THROW_THROWABLE = "NEVER_THROW_THROWABLE";
    private static final String STR_DECLARE_COLLECTION_COMMENT = "DECLARE_COLLECTION_COMMENT";
    private static final String STR_WRONG_COLLECTION_COMMENT = "WRONG_COLLECTION_COMMENT";
    private static final String STR_EMPTY_FINALLY = "EMPTY_FINALLY";
    private static final String STR_NEVER_WAIT_OUTSIDE_LOOP = "NEVER_WAIT_OUTSIDE_LOOP";
    private static final String STR_NAMING_CONVENTION = "NAMING_CONVENTION";
    private static final String EMPTY_STRING = "";
    private Map _issues;
    protected final String[] _args = new String[3];

    public CodeInspector(Map issues) {
        this._issues = issues;
    }

    private Pattern getPattern(String pattern) {
        if (_patternMap.get(pattern) == null) {
            _patternMap.put(pattern, Pattern.compile(pattern));
        }
        return (Pattern)_patternMap.get(pattern);
    }

    public void inspect(AST tree, File file) {
        this.walk(tree);
    }

    @Override
    public void visit(AST node) {
        switch (node.getType()) {
            case 13: {
                AST type = JavaNodeHelper.getFirstChild(node, 16);
                String returnType = type.getFirstChild().getText();
                if (_settings.getBoolean(ConventionKeys.TIP_REFER_BY_INTERFACE, false) && _favorableTypes.contains(returnType)) {
                    this.addIssue(node, STR_REFER_BY_INTERFACE, this._args);
                }
                this.checkCollectionReturnType((JavaNode)node, returnType);
                String name = type.getNextSibling().getText();
                this.checkVariableName(node, name);
                break;
            }
            case 30: {
                this.checkMethodCall(node);
                break;
            }
            case 108: {
                this.checkAssignment(node);
                break;
            }
            case 133: {
                this.checkCatch(node);
                break;
            }
            case 132: {
                this.checkFinally(node);
                break;
            }
            case 25: {
                this.checkLabelName(node);
                break;
            }
            case 12: {
                Method method = new Method(node);
                this.checkObjectEquals(node, method);
                this.checkReturnType(node, method);
                this.checkParameters(node, method);
                this.checkThrows(node, method);
                this.checkMethodName(node, method);
                if (method.isAbstract()) break;
                this.checkArrayReturnType(node, method);
                break;
            }
            case 11: {
                Constructor ctor = new Constructor(node);
                this.checkParameters(node, ctor);
                this.checkThrows(node, ctor);
                break;
            }
            case 17: {
                this.checkClass(node);
                this.checkClassName(node);
                break;
            }
            case 18: {
                this.checkInterface(node);
                this.checkInterfaceName(node);
                break;
            }
            case 19: {
                this.checkPackageName(node);
                break;
            }
            case 169: {
                this.checkStringLiteral(node);
            }
        }
    }

    private boolean isEqualsMethod(Method method) {
        if (method.getParameterCount() != 1) {
            return false;
        }
        if (method.modifierMask != 1 && !Modifier.isPublic(method.modifierMask)) {
            return false;
        }
        if (!STR_boolean.equals(method.returnType)) {
            return false;
        }
        if (!STR_equals.equals(method.name)) {
            return false;
        }
        Parameter parameter = (Parameter)method.parameters.get(0);
        if (parameter.modifierMask != 0) {
            return false;
        }
        return STR_Object.equals(parameter.typeName) || !STR_javalangObject.equals(parameter.typeName);
    }

    private boolean isFinalizeMethod(Method method) {
        if (method.getParameterCount() != 0) {
            return false;
        }
        if (method.modifierMask != 4 && !Modifier.isProtected(method.modifierMask)) {
            return false;
        }
        if (!STR_void.equals(method.returnType)) {
            return false;
        }
        return STR_finalize.equals(method.name);
    }

    private boolean isHashCodeMethod(Method method) {
        if (method.getParameterCount() != 0) {
            return false;
        }
        if (method.modifierMask != 1 && !Modifier.isPublic(method.modifierMask)) {
            return false;
        }
        if (!STR_int.equals(method.returnType)) {
            return false;
        }
        return STR_hashCode.equals(method.name);
    }

    private JavaNode getObjectBlock(JavaNode node) {
        JavaNode parent = node.getParent();
        switch (node.getType()) {
            case 9: {
                return node;
            }
        }
        return this.getObjectBlock(parent);
    }

    private boolean isSubstituteEqualsMethod(Method method) {
        if (method.getParameterCount() != 1) {
            return false;
        }
        if (method.modifierMask != 1 && !Modifier.isPublic(method.modifierMask)) {
            return false;
        }
        if (!STR_boolean.equals(method.returnType)) {
            return false;
        }
        if (!STR_equals.equals(method.name)) {
            return false;
        }
        Parameter parameter = (Parameter)method.parameters.get(0);
        if (parameter.modifierMask != 0) {
            return false;
        }
        return !STR_Object.equals(parameter.typeName) && !STR_javalangObject.equals(parameter.typeName);
    }

    private boolean isToStringMethod(Method method) {
        if (method.getParameterCount() != 0) {
            return false;
        }
        if (method.modifierMask != 1 && !Modifier.isPublic(method.modifierMask)) {
            return false;
        }
        if (!STR_String.equals(method.returnType)) {
            return false;
        }
        return STR_toString.equals(method.name);
    }

    protected void addIssue(AST node, String resourceKey, Object[] args) {
        if (!this._issues.containsKey(node)) {
            this._issues.put(node, MessageFormat.format(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString(resourceKey), args));
        } else {
            Object value = this._issues.get(node);
            if (value instanceof List) {
                List issuesForNode = (List)value;
                issuesForNode.add(MessageFormat.format(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString(resourceKey), args));
            } else {
                ArrayList<Object> issuesForNode = new ArrayList<Object>(4);
                issuesForNode.add(value);
                issuesForNode.add(MessageFormat.format(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString(resourceKey), args));
                this._issues.put(node, issuesForNode);
            }
        }
    }

    private void checkArrayReturnType(AST node, Method method) {
        String returnType;
        if (_settings.getBoolean(ConventionKeys.TIP_RETURN_ZERO_ARRAY, false) && (returnType = method.returnType).indexOf(91) > -1) {
            TreeWalker walker = new TreeWalker(){

                @Override
                public void visit(AST newNode) {
                    switch (newNode.getType()) {
                        case 125: {
                            AST child = newNode.getFirstChild();
                            int retType = 0;
                            switch (child.getType()) {
                                case 31: {
                                    retType = child.getFirstChild().getType();
                                    break;
                                }
                                case 106: {
                                    AST expr = JavaNodeHelper.advanceToFirstNonParen(child);
                                    switch (expr.getType()) {
                                        case 31: {
                                            retType = expr.getFirstChild().getType();
                                        }
                                    }
                                }
                            }
                            switch (retType) {
                                case 165: {
                                    if (_settings.getBoolean(ConventionKeys.TIP_RETURN_ZERO_ARRAY, false)) {
                                        CodeInspector.this.addIssue(newNode, CodeInspector.STR_RETURN_ZERO_ARRAY, CodeInspector.this._args);
                                    }
                                    this.stop();
                                }
                            }
                        }
                    }
                }
            };
            walker.walk(JavaNodeHelper.getFirstChild(node, 10));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkAssignment(AST node) {
        if (!_settings.getBoolean(ConventionKeys.TIP_VARIABLE_SHADOW, false)) return;
        AST lhs = node.getFirstChild();
        switch (lhs.getType()) {
            case 77: {
                AST rhs = lhs.getNextSibling();
                if (rhs == null) return;
                switch (rhs.getType()) {
                    case 77: {
                        if (!lhs.getText().equals(rhs.getText())) return;
                        JavaNode objBlock = this.getObjectBlock((JavaNode)node);
                        boolean foundReference = false;
                        block9: for (AST child = objBlock.getFirstChild(); child != null; child = child.getNextSibling()) {
                            switch (child.getType()) {
                                case 13: {
                                    String name = JavaNodeHelper.getFirstChild(child, 77).getText();
                                    if (!name.equals(lhs.getText())) continue block9;
                                    StringBuffer buf = new StringBuffer(100);
                                    buf.append("this.");
                                    buf.append(name);
                                    buf.append(" == ");
                                    buf.append(name);
                                    this._args[2] = buf.toString();
                                    if (_settings.getBoolean(ConventionKeys.TIP_VARIABLE_SHADOW, false)) {
                                        this.addIssue(node, STR_VARIABLE_SHADOW, this._args);
                                    }
                                    foundReference = true;
                                    continue block9;
                                }
                            }
                        }
                        if (foundReference) return;
                    }
                }
                return;
            }
        }
    }

    private void checkCatch(AST node) {
        JavaNode lcurly;
        JavaNode child;
        if (_settings.getBoolean(ConventionKeys.TIP_DONT_IGNORE_EXCEPTION, false) && (child = (JavaNode)(lcurly = (JavaNode)JavaNodeHelper.getFirstChild(node, 10)).getFirstChild()).getType() == 6 && !child.hasCommentsBefore()) {
            this.addIssue(node, STR_DONT_IGNORE_EXCEPTION, this._args);
        }
    }

    private void checkClass(AST node) {
        boolean checkReplaceStructure = _settings.getBoolean(ConventionKeys.TIP_REPLACE_STRUCTURE_WITH_CLASS, false);
        boolean checkOverrideHashCode = _settings.getBoolean(ConventionKeys.TIP_OVERRIDE_HASHCODE, false);
        boolean checkOverrideToString = _settings.getBoolean(ConventionKeys.TIP_OVERRIDE_TO_STRING, false);
        if (!(checkReplaceStructure || checkOverrideHashCode || checkOverrideToString)) {
            return;
        }
        AST classModifierMask = JavaNodeHelper.getFirstChild(node, 8);
        boolean isPublicClass = Modifier.isPublic(JavaNodeModifier.valueOf(classModifierMask));
        AST body = JavaNodeHelper.getFirstChild(node, 9);
        boolean violate = isPublicClass;
        boolean foundEquals = false;
        AST equalsNode = null;
        boolean foundHashCode = false;
        boolean foundToString = false;
        block5: for (AST child = body.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 5: 
                case 6: {
                    continue block5;
                }
                case 13: {
                    int vaiableModifierMask;
                    if (!checkReplaceStructure || !isPublicClass || Modifier.isPublic(vaiableModifierMask = JavaNodeModifier.valueOf(child.getFirstChild()))) continue block5;
                    violate = false;
                    continue block5;
                }
                case 12: {
                    violate = false;
                    Method method = null;
                    if (checkOverrideHashCode && !foundEquals && this.isEqualsMethod(method == null ? (method = new Method(child)) : method)) {
                        equalsNode = child;
                        foundEquals = true;
                    }
                    if (checkOverrideHashCode && !foundHashCode && this.isHashCodeMethod(method == null ? (method = new Method(child)) : method)) {
                        foundHashCode = true;
                    }
                    if (!checkOverrideToString || foundToString || !this.isToStringMethod(method == null ? (method = new Method(child)) : method)) continue block5;
                    foundToString = true;
                    continue block5;
                }
                default: {
                    violate = false;
                }
            }
        }
        if (checkReplaceStructure && isPublicClass && violate && checkReplaceStructure) {
            this.addIssue(node, STR_REPLACE_STRUCTURE_WITH_CLASS, this._args);
        }
        if (checkOverrideHashCode && foundEquals && !foundHashCode) {
            this.addIssue(equalsNode, STR_OVERRIDE_HASHCODE, this._args);
        }
        if (checkOverrideToString && !foundToString) {
            this.addIssue(node, STR_OVERRIDE_TO_STRING, this._args);
        }
    }

    private void checkClassName(AST node) {
        if (_settings.getBoolean(ConventionKeys.TIP_ADHERE_TO_NAMING_CONVENTION, false)) {
            String name = JavaNodeHelper.getFirstChild(node, 77).getText();
            if (!JavaNodeModifier.isAbstract(node)) {
                Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_CLASS, "[A-Z][a-zA-Z0-9]+"));
                if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                    this._args[0] = "Class";
                    this._args[1] = name;
                    this._args[2] = pattern.pattern();
                    this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                }
            } else {
                Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_CLASS_ABSTRACT, "[A-Z][a-zA-Z0-9]+"));
                if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                    this._args[0] = "Abstract class";
                    this._args[1] = name;
                    this._args[2] = pattern.pattern();
                    this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                }
            }
        }
    }

    private void checkCollectionReturnType(JavaNode node, String returnType) {
        if (!JavaNodeHelper.isLocalVariable((AST)node) && _collectionTypes.contains(returnType)) {
            if (!node.hasCommentsAfter() && _settings.getBoolean(ConventionKeys.TIP_DECLARE_COLLECTION_COMMENT, false)) {
                this.addIssue((AST)node, STR_DECLARE_COLLECTION_COMMENT, this._args);
            } else if (_settings.getBoolean(ConventionKeys.TIP_WRONG_COLLECTION_COMMENT, false)) {
                CommonHiddenStreamToken comment = node.getHiddenAfter();
                if (comment == null) {
                    this.addIssue((AST)node, STR_WRONG_COLLECTION_COMMENT, this._args);
                } else {
                    switch (comment.getType()) {
                        case 174: {
                            String text = comment.getText();
                            if (text.indexOf(60) != -1 && text.indexOf(62) != -1) break;
                            this.addIssue((AST)node, STR_WRONG_COLLECTION_COMMENT, this._args);
                            break;
                        }
                    }
                }
            }
        }
    }

    private void checkEqualsReturnType(AST node, Method method) {
        AST child;
        AST slist;
        if (_settings.getBoolean(ConventionKeys.TIP_OBEY_CONTRACT_EQUALS, false) && (slist = JavaNodeHelper.getFirstChild(node, 10)) != null && ((child = slist.getFirstChild()).getType() != 127 || child.getNextSibling().getType() != 6)) {
            TreeWalker walker = new TreeWalker(){

                @Override
                public void visit(AST newNode) {
                    switch (newNode.getType()) {
                        case 127: {
                            CodeInspector.this.addIssue(newNode, CodeInspector.STR_OBEY_CONTRACT_EQUALS, CodeInspector.this._args);
                            this.stop();
                        }
                    }
                }
            };
            walker.walk(slist);
        }
    }

    private void checkFinally(AST node) {
        if (_settings.getBoolean(ConventionKeys.TIP_EMPTY_FINALLY, false) && node.getFirstChild().getFirstChild().getType() == 6) {
            this.addIssue(node, STR_EMPTY_FINALLY, this._args);
        }
    }

    private void checkInterface(AST node) {
        if (_settings.getBoolean(ConventionKeys.TIP_INTERFACE_ONLY_FOR_TYPE, false)) {
            AST body = JavaNodeHelper.getFirstChild(node, 9);
            boolean violate = true;
            block4: for (AST child = body.getFirstChild(); child != null; child = child.getNextSibling()) {
                switch (child.getType()) {
                    case 6: {
                        if (!violate) continue block4;
                        violate = body.getFirstChild() != child;
                        continue block4;
                    }
                    case 13: {
                        continue block4;
                    }
                    default: {
                        violate = false;
                        break block4;
                    }
                }
            }
            if (violate) {
                this.addIssue(node, STR_INTERFACE_ONLY_FOR_TYPE, this._args);
            }
        }
    }

    private void checkInterfaceName(AST node) {
        if (_settings.getBoolean(ConventionKeys.TIP_ADHERE_TO_NAMING_CONVENTION, false)) {
            String name = JavaNodeHelper.getFirstChild(node, 77).getText();
            Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_INTERFACE, "[A-Z][a-zA-Z0-9]+"));
            if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                this._args[0] = "Interface";
                this._args[1] = name;
                this._args[2] = pattern.pattern();
                this.addIssue(node, STR_NAMING_CONVENTION, this._args);
            }
        }
    }

    private void checkLabelName(AST node) {
        if (_settings.getBoolean(ConventionKeys.TIP_ADHERE_TO_NAMING_CONVENTION, false)) {
            String name = node.getFirstChild().getText();
            Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_LABEL, "\\w+"));
            if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                this._args[0] = "Label";
                this._args[1] = name;
                this._args[2] = pattern.pattern();
                this.addIssue(node, STR_NAMING_CONVENTION, this._args);
            }
        }
    }

    private void checkMethodCall(AST node) {
        if (!_settings.getBoolean(ConventionKeys.TIP_NEVER_WAIT_OUTSIDE_LOOP, false)) {
            return;
        }
        AST child = node.getFirstChild();
        String name = null;
        switch (child.getType()) {
            case 77: {
                name = child.getText();
                break;
            }
            case 78: {
                name = JavaNodeHelper.isChained(child) ? JavaNodeHelper.getFirstChainLink(node).getNextSibling().getText() : child.getFirstChild().getNextSibling().getText();
            }
        }
        if (STR_wait.equals(name)) {
            JavaNode n = (JavaNode)node;
            JavaNode expr = n.getParent();
            block4 : switch (expr.getParent().getType()) {
                case 10: {
                    switch (expr.getParent().getParent().getType()) {
                        case 121: 
                        case 129: {
                            break block4;
                        }
                    }
                    this.addIssue((AST)n, STR_NEVER_WAIT_OUTSIDE_LOOP, this._args);
                    break;
                }
                case 121: 
                case 129: {
                    break;
                }
                default: {
                    this.addIssue((AST)n, STR_NEVER_WAIT_OUTSIDE_LOOP, this._args);
                }
            }
        }
    }

    private void checkMethodName(AST node, Method method) {
        if (_settings.getBoolean(ConventionKeys.TIP_ADHERE_TO_NAMING_CONVENTION, false)) {
            AST modifiers = JavaNodeHelper.getFirstChild(node, 8);
            int modifierMask = JavaNodeModifier.valueOf(modifiers);
            String name = method.name;
            if (Modifier.isStatic(modifierMask)) {
                if (Modifier.isFinal(modifierMask)) {
                    if (Modifier.isPublic(modifierMask)) {
                        Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_METHOD_PUBLIC_STATIC_FINAL, "[a-z][\\w]+"));
                        if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                            this._args[0] = "public static final method";
                            this._args[1] = name;
                            this._args[2] = pattern.pattern();
                            this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                        }
                    } else if (Modifier.isProtected(modifierMask)) {
                        Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_METHOD_PROTECTED_STATIC_FINAL, "[a-z][\\w]+"));
                        if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                            this._args[0] = "protected static final method";
                            this._args[1] = name;
                            this._args[2] = pattern.pattern();
                            this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                        }
                    } else if (Modifier.isPrivate(modifierMask)) {
                        Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_METHOD_PRIVATE_STATIC_FINAL, "[a-z][\\w]+"));
                        if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                            this._args[0] = "private static final method";
                            this._args[1] = name;
                            this._args[2] = pattern.pattern();
                            this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                        }
                    } else {
                        Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_METHOD_DEFAULT_STATIC_FINAL, "[a-z][\\w]+"));
                        if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                            this._args[0] = "static final method";
                            this._args[1] = name;
                            this._args[2] = pattern.pattern();
                            this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                        }
                    }
                } else if (Modifier.isPublic(modifierMask)) {
                    Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_METHOD_PUBLIC_STATIC, "[a-z][\\w]+"));
                    if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                        this._args[0] = "public static method";
                        this._args[1] = name;
                        this._args[2] = pattern.pattern();
                        this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                    }
                } else if (Modifier.isProtected(modifierMask)) {
                    Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_METHOD_PROTECTED_STATIC, "[a-z][\\w]+"));
                    if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                        this._args[0] = "protected static method";
                        this._args[1] = name;
                        this._args[2] = pattern.pattern();
                        this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                    }
                } else if (Modifier.isPrivate(modifierMask)) {
                    Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_METHOD_PRIVATE_STATIC, "[a-z][\\w]+"));
                    if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                        this._args[0] = "private static method";
                        this._args[1] = name;
                        this._args[2] = pattern.pattern();
                        this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                    }
                } else {
                    Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_METHOD_DEFAULT_STATIC, "[a-z][\\w]+"));
                    if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                        this._args[0] = "static method";
                        this._args[1] = name;
                        this._args[2] = pattern.pattern();
                        this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                    }
                }
            } else if (Modifier.isPublic(modifierMask)) {
                Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_METHOD_PUBLIC, "[a-z][\\w]+"));
                if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                    this._args[0] = "public method";
                    this._args[1] = name;
                    this._args[2] = pattern.pattern();
                    this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                }
            } else if (Modifier.isProtected(modifierMask)) {
                Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_METHOD_PROTECTED, "[a-z][\\w]+"));
                if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                    this._args[0] = "protected method";
                    this._args[1] = name;
                    this._args[2] = pattern.pattern();
                    this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                }
            } else if (Modifier.isPrivate(modifierMask)) {
                Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_METHOD_PRIVATE, "[a-z][\\w]+"));
                if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                    this._args[0] = "private method";
                    this._args[1] = name;
                    this._args[2] = pattern.pattern();
                    this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                }
            } else {
                Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_METHOD_DEFAULT, "[a-z][\\w]+"));
                if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                    this._args[0] = "method";
                    this._args[1] = name;
                    this._args[2] = pattern.pattern();
                    this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                }
            }
        }
    }

    private void checkObjectEquals(AST node, Method method) {
        if (this.isSubstituteEqualsMethod(method)) {
            this.addIssue(node, STR_DONT_SUBSTITUTE_OBJECT_EQUALS, this._args);
        } else if (this.isEqualsMethod(method)) {
            this.checkEqualsReturnType(node, method);
        }
    }

    private void checkPackageName(AST node) {
        if (_settings.getBoolean(ConventionKeys.TIP_ADHERE_TO_NAMING_CONVENTION, false)) {
            String name = JavaNodeHelper.getDottedName(JavaNodeHelper.getFirstChild(node, 78));
            Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_PACKAGE, "[a-z]+(?:\\.[a-z]+)*"));
            if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                this._args[0] = "Package";
                this._args[1] = name;
                this._args[2] = pattern.pattern();
                this.addIssue(node, STR_NAMING_CONVENTION, this._args);
            }
        }
    }

    private void checkParameters(AST node, Constructor type) {
        if (!_settings.getBoolean(ConventionKeys.TIP_REFER_BY_INTERFACE, false)) {
            return;
        }
        int size = type.parameters.size();
        for (int i = 0; i < size; ++i) {
            Parameter parameter = (Parameter)type.parameters.get(i);
            if (!_favorableTypes.contains(parameter.typeName)) continue;
            this.addIssue(node, STR_REFER_BY_INTERFACE, this._args);
        }
    }

    private void checkReturnType(AST node, Method method) {
        String returnType;
        if (!_settings.getBoolean(ConventionKeys.TIP_REFER_BY_INTERFACE, false)) {
            return;
        }
        if (method.hasReturnType() && _favorableTypes.contains(returnType = method.returnType)) {
            this.addIssue(node, STR_REFER_BY_INTERFACE, this._args);
        }
    }

    private void checkStringLiteral(AST node) {
        if (_settings.getBoolean(ConventionKeys.TIP_STRING_LITERAL_I18N, false)) {
            JavaNode n = (JavaNode)node;
            CommonHiddenStreamToken comment = n.getCommentAfter();
            if (comment == null) {
                this._args[0] = String.valueOf(n.getStartColumn());
                this.addIssue(node, STR_STRING_LITERAL_I18N, this._args);
            } else {
                switch (comment.getType()) {
                    case 176: {
                        if (comment.getText().indexOf("NOI18N") != -1) break;
                        this._args[0] = String.valueOf(n.getStartColumn());
                        this.addIssue(node, STR_STRING_LITERAL_I18N, this._args);
                        break;
                    }
                    default: {
                        this._args[0] = String.valueOf(n.getStartColumn());
                        this.addIssue(node, STR_STRING_LITERAL_I18N, this._args);
                    }
                }
            }
        }
    }

    private void checkThrows(AST node, Constructor type) {
        boolean checkThrowException = _settings.getBoolean(ConventionKeys.TIP_NEVER_THROW_EXCEPTION, false);
        boolean checkThrowThrowable = _settings.getBoolean(ConventionKeys.TIP_NEVER_THROW_THROWABLE, false);
        if (!checkThrowException && !checkThrowThrowable) {
            return;
        }
        if (type.hasExceptions()) {
            switch (node.getType()) {
                case 12: {
                    if (!this.isFinalizeMethod((Method)type)) break;
                    return;
                }
            }
            List exceptions = type.exceptions;
            int size = exceptions.size();
            for (int i = 0; i < size; ++i) {
                String name = (String)exceptions.get(i);
                if (checkThrowException && STR_Exception.equals(name)) {
                    this.addIssue(node, STR_NEVER_THROW_EXCEPTION, this._args);
                    continue;
                }
                if (!checkThrowThrowable || !STR_Throwable.equals(name)) continue;
                this.addIssue(node, STR_NEVER_THROW_THROWABLE, this._args);
            }
        }
    }

    private void checkVariableName(AST node, String name) {
        if (_settings.getBoolean(ConventionKeys.TIP_ADHERE_TO_NAMING_CONVENTION, false)) {
            if (JavaNodeHelper.isLocalVariable(node)) {
                Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_LOCAL_VARIABLE, "[a-z][\\w]*"));
                if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                    this._args[0] = "local variable";
                    this._args[1] = name;
                    this._args[2] = pattern.pattern();
                    this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                }
            } else {
                AST modifiers = JavaNodeHelper.getFirstChild(node, 8);
                int modifierMask = JavaNodeModifier.valueOf(modifiers);
                if (Modifier.isStatic(modifierMask)) {
                    if (Modifier.isFinal(modifierMask)) {
                        if (Modifier.isPublic(modifierMask)) {
                            Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_FIELD_PUBLIC_STATIC_FINAL, "[a-zA-Z][\\w]+"));
                            if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                                this._args[0] = "public static final field";
                                this._args[1] = name;
                                this._args[2] = pattern.pattern();
                                this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                            }
                        } else if (Modifier.isProtected(modifierMask)) {
                            Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_FIELD_PROTECTED_STATIC_FINAL, "[a-zA-Z][\\w]+"));
                            if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                                this._args[0] = "protected static final field";
                                this._args[1] = name;
                                this._args[2] = pattern.pattern();
                                this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                            }
                        } else if (Modifier.isPrivate(modifierMask)) {
                            Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_FIELD_PRIVATE_STATIC_FINAL, "[a-zA-Z][\\w]+"));
                            if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                                this._args[0] = "private static final field";
                                this._args[1] = name;
                                this._args[2] = pattern.pattern();
                                this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                            }
                        } else {
                            Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_FIELD_DEFAULT_STATIC_FINAL, "[a-zA-Z][\\w]+"));
                            if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                                this._args[0] = "static final field";
                                this._args[1] = name;
                                this._args[2] = pattern.pattern();
                                this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                            }
                        }
                    } else if (Modifier.isPublic(modifierMask)) {
                        Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_FIELD_PUBLIC_STATIC, "[a-z][\\w]+"));
                        if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                            this._args[0] = "public static field";
                            this._args[1] = name;
                            this._args[2] = pattern.pattern();
                            this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                        }
                    } else if (Modifier.isProtected(modifierMask)) {
                        Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_FIELD_PROTECTED_STATIC, "[a-z][\\w]+"));
                        if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                            this._args[0] = "protected static field";
                            this._args[1] = name;
                            this._args[2] = pattern.pattern();
                            this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                        }
                    } else if (Modifier.isPrivate(modifierMask)) {
                        Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_FIELD_PRIVATE_STATIC, "[a-z][\\w]+"));
                        if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                            this._args[0] = "private static field";
                            this._args[1] = name;
                            this._args[2] = pattern.pattern();
                            this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                        }
                    } else {
                        Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_FIELD_DEFAULT_STATIC, "[a-z][\\w]+"));
                        if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                            this._args[0] = "static field";
                            this._args[1] = name;
                            this._args[2] = pattern.pattern();
                            this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                        }
                    }
                } else if (Modifier.isPublic(modifierMask)) {
                    Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_FIELD_PUBLIC, "[a-z][\\w]+"));
                    if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                        this._args[0] = "public field";
                        this._args[1] = name;
                        this._args[2] = pattern.pattern();
                        this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                    }
                } else if (Modifier.isProtected(modifierMask)) {
                    Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_FIELD_PROTECTED, "[a-z][\\w]+"));
                    if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                        this._args[0] = "protected field";
                        this._args[1] = name;
                        this._args[2] = pattern.pattern();
                        this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                    }
                } else if (Modifier.isPrivate(modifierMask)) {
                    Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_FIELD_PRIVATE, "[a-z][\\w]+"));
                    if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                        this._args[0] = "private field";
                        this._args[1] = name;
                        this._args[2] = pattern.pattern();
                        this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                    }
                } else {
                    Pattern pattern = this.getPattern(_settings.get(ConventionKeys.REGEXP_FIELD_DEFAULT, "[a-z][\\w]+"));
                    if (!pattern.pattern().equals(EMPTY_STRING) && !pattern.matcher(name).matches()) {
                        this._args[0] = "field";
                        this._args[1] = name;
                        this._args[2] = pattern.pattern();
                        this.addIssue(node, STR_NAMING_CONVENTION, this._args);
                    }
                }
            }
        }
    }

    static {
        _favorableTypes.add("Vector");
        _favorableTypes.add("ArrayList");
        _favorableTypes.add("HashSet");
        _favorableTypes.add("TreeSet");
        _favorableTypes.add("HashMap");
        _favorableTypes.add("TreeMap");
        _favorableTypes.add("IdentityHashMap");
        _favorableTypes.add("WeakHashMap");
        _favorableTypes.add("Hashtable");
        _favorableTypes.add("java.util.ArrayList");
        _favorableTypes.add("java.util.Vector");
        _favorableTypes.add("java.util.HashSet");
        _favorableTypes.add("java.util.TreeSet");
        _favorableTypes.add("java.util.HashMap");
        _favorableTypes.add("java.util.TreeMap");
        _favorableTypes.add("java.util.IdentityHashMap");
        _favorableTypes.add("java.util.WeakHashMap");
        _favorableTypes.add("java.util.Hashtable");
        _collectionTypes.add("Collection");
        _collectionTypes.add("List");
        _collectionTypes.add("ArrayList");
        _collectionTypes.add("LinkedList");
        _collectionTypes.add("Vector");
        _collectionTypes.add("Set");
        _collectionTypes.add("ArraySet");
        _collectionTypes.add("HashSet");
        _collectionTypes.add("LinkedHashSet");
        _collectionTypes.add("SortedSet");
        _collectionTypes.add("TreeSet");
        _collectionTypes.add("Map");
        _collectionTypes.add("SortedMap");
        _collectionTypes.add("HashMap");
        _collectionTypes.add("Hashtable");
        _collectionTypes.add("TreeMap");
        _collectionTypes.add("IdentityHashMap");
        _collectionTypes.add("WeakHashMap");
        _collectionTypes.add("java.util.Collection");
        _collectionTypes.add("java.util.List");
        _collectionTypes.add("java.util.ArrayList");
        _collectionTypes.add("java.util.LinkedList");
        _collectionTypes.add("java.util.Vector");
        _collectionTypes.add("java.util.Set");
        _collectionTypes.add("java.util.ArraySet");
        _collectionTypes.add("java.util.HashSet");
        _collectionTypes.add("java.util.LinkedHashSet");
        _collectionTypes.add("java.util.SortedSet");
        _collectionTypes.add("java.util.TreeSet");
        _collectionTypes.add("java.util.Map");
        _collectionTypes.add("java.util.SortedMap");
        _collectionTypes.add("java.util.HashMap");
        _collectionTypes.add("java.util.Hashtable");
        _collectionTypes.add("java.util.TreeMap");
        _collectionTypes.add("java.util.IdentityHashMap");
        _collectionTypes.add("java.util.WeakHashMap");
    }

    private static final class Parameter {
        String name;
        String typeName;
        int modifierMask;

        public Parameter(AST node) {
            block5: for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                switch (child.getType()) {
                    case 8: {
                        this.modifierMask = JavaNodeModifier.valueOf(child);
                        continue block5;
                    }
                    case 16: {
                        this.typeName = child.getFirstChild().getText();
                        continue block5;
                    }
                    case 77: {
                        this.name = child.getText();
                    }
                }
            }
        }

        public int getModifierMask() {
            return this.modifierMask;
        }

        public String getName() {
            return this.name;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(50);
            buf.append(Modifier.toString(this.modifierMask));
            buf.append(' ');
            buf.append(this.typeName);
            buf.append(' ');
            buf.append(this.name);
            return buf.toString().trim();
        }
    }

    private static final class Method
    extends Constructor {
        String returnType;
        boolean isAbstract = true;

        public Method(AST node) {
            block8: for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                switch (child.getType()) {
                    case 8: {
                        this.modifierMask = JavaNodeModifier.valueOf(child);
                        continue block8;
                    }
                    case 16: {
                        this.returnType = child.getFirstChild().getText();
                        continue block8;
                    }
                    case 77: {
                        this.name = child.getText();
                        continue block8;
                    }
                    case 23: {
                        AST parameter = child.getFirstChild();
                        if (parameter == null) continue block8;
                        this.parameters = new ArrayList(5);
                        for (AST pchild = parameter; pchild != null; pchild = pchild.getNextSibling()) {
                            this.parameters.add(new Parameter(pchild));
                        }
                        continue block8;
                    }
                    case 116: {
                        this.exceptions = new ArrayList(4);
                        for (AST exception = child.getFirstChild(); exception != null; exception = exception.getNextSibling()) {
                            this.exceptions.add(exception.getText());
                        }
                        continue block8;
                    }
                    case 10: {
                        this.isAbstract = false;
                    }
                }
            }
        }

        public boolean isAbstract() {
            return this.isAbstract;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public boolean hasReturnType() {
            return !CodeInspector.STR_void.equals(this.returnType);
        }
    }

    private static class Constructor {
        public static final String TYPE_VOID = "void";
        List exceptions = Collections.EMPTY_LIST;
        List parameters = Collections.EMPTY_LIST;
        String name;
        int modifierMask;

        public Constructor(AST node) {
            block6: for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                switch (child.getType()) {
                    case 8: {
                        this.modifierMask = JavaNodeModifier.valueOf(child);
                        continue block6;
                    }
                    case 77: {
                        this.name = child.getText();
                        continue block6;
                    }
                    case 23: {
                        AST parameter = child.getFirstChild();
                        if (parameter == null) continue block6;
                        this.parameters = new ArrayList(5);
                        for (AST pchild = parameter; pchild != null; pchild = pchild.getNextSibling()) {
                            this.parameters.add(new Parameter(pchild));
                        }
                        continue block6;
                    }
                    case 116: {
                        this.exceptions = new ArrayList(4);
                        for (AST exception = child.getFirstChild(); exception != null; exception = exception.getNextSibling()) {
                            this.exceptions.add(exception.getText());
                        }
                        continue block6;
                    }
                }
            }
        }

        private Constructor() {
        }

        public List getExceptions() {
            return this.exceptions;
        }

        public String getName() {
            return this.name;
        }

        public int getParameterCount() {
            return this.parameters.size();
        }

        public List getParameters() {
            return this.parameters;
        }

        public boolean hasExceptions() {
            return !this.exceptions.isEmpty();
        }

        public boolean hasParameters() {
            return !this.parameters.isEmpty();
        }
    }
}

