/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;

public final class JavaNodeHelper {
    private JavaNodeHelper() {
    }

    public static boolean isAbstractMethod(AST node) {
        boolean result = false;
        switch (node.getType()) {
            case 12: {
                for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    switch (child.getType()) {
                        case 72: {
                            result = true;
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("no METHOD_DEF -- " + node);
            }
        }
        return result;
    }

    public static boolean isAnonymousInnerClass(AST node) {
        switch (node.getType()) {
            case 17: 
            case 18: {
                return ((JavaNode)node).getParent().getParent().getType() == 166;
            }
        }
        throw new IllegalArgumentException("invalid node -- " + node);
    }

    public static boolean isBlockNext(AST node) {
        if (node == null) {
            return false;
        }
        AST next = node.getNextSibling();
        if (next == null) {
            JavaNode parent = ((JavaNode)node).getParent();
            switch (parent.getType()) {
                case 8: 
                case 16: {
                    return false;
                }
                case 21: {
                    AST implementsClause = parent.getNextSibling();
                    if (implementsClause.getFirstChild() == null) {
                        return JavaNodeHelper.isBlockNext(implementsClause);
                    }
                    return false;
                }
                case 22: {
                    return JavaNodeHelper.isBlockNext((AST)parent);
                }
            }
            return false;
        }
        switch (next.getType()) {
            case 5: 
            case 9: 
            case 10: 
            case 66: 
            case 108: {
                return true;
            }
        }
        return false;
    }

    public static boolean isChained(AST node) {
        switch (node.getType()) {
            case 78: {
                AST next = node.getFirstChild();
                switch (next.getType()) {
                    case 30: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static String getDottedName(AST tree) {
        String result = null;
        switch (tree.getType()) {
            case 78: {
                AST left = tree.getFirstChild();
                AST right = left.getNextSibling();
                result = JavaNodeHelper.getDottedName(left) + '.' + JavaNodeHelper.getDottedName(right);
                break;
            }
            case 20: {
                StringBuffer buf = new StringBuffer(30);
                AST left = tree.getFirstChild();
                AST right = left.getNextSibling();
                buf.append(JavaNodeHelper.getDottedName(left));
                if (right != null) {
                    buf.append('.');
                    buf.append(JavaNodeHelper.getDottedName(right));
                }
                buf.append(" []");
                result = buf.toString();
                break;
            }
            case 30: {
                result = JavaNodeHelper.getDottedName(tree.getFirstChild()) + "()";
                break;
            }
            default: {
                result = tree.getText();
            }
        }
        return result;
    }

    public static boolean isEmptyBlock(AST node) {
        switch (node.getType()) {
            case 9: 
            case 10: 
            case 54: 
            case 57: 
            case 66: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type -- " + node);
            }
        }
        boolean result = false;
        block8: for (JavaNode child = (JavaNode)node.getFirstChild(); child != null; child = (JavaNode)child.getNextSibling()) {
            switch (child.getType()) {
                case 10: 
                case 66: {
                    result = JavaNodeHelper.isEmptyBlock((AST)child);
                    break block8;
                }
                case 5: {
                    if (!child.hasCommentsBefore() && !child.hasCommentsAfter()) continue block8;
                    return false;
                }
                case 6: {
                    return !child.hasCommentsBefore();
                }
                default: {
                    return child == null;
                }
            }
        }
        return result;
    }

    public static AST getFirstChainLink(AST node) {
        AST dot = node.getFirstChild();
        if (JavaNodeHelper.isChained(dot)) {
            return JavaNodeHelper.getFirstChainLink(dot.getFirstChild());
        }
        return node;
    }

    public static AST getFirstChild(AST node, int type) {
        AST result = null;
        for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != type) continue;
            result = child;
            break;
        }
        return result;
    }

    public static boolean isFreestandingBlock(JavaNode node) {
        boolean result = false;
        switch (node.getParent().getType()) {
            case 10: 
            case 14: 
            case 54: {
                result = true;
            }
        }
        return result;
    }

    public static boolean isInnerClass(AST node) {
        switch (node.getType()) {
            case 17: 
            case 18: {
                return ((JavaNode)node).getParent().getType() == 9;
            }
        }
        throw new IllegalArgumentException("invalid node -- " + node);
    }

    public static JavaNode getLastChild(AST node) {
        if (node == null) {
            return null;
        }
        switch (node.getType()) {
            case 78: {
                AST last;
                AST child = last = node.getFirstChild();
                if (child != null) {
                    switch (child.getType()) {
                        case 78: {
                            last = child;
                        }
                    }
                }
                return JavaNodeHelper.getLastChild(last.getNextSibling());
            }
        }
        AST first = node.getFirstChild();
        if (first == null) {
            return (JavaNode)node;
        }
        AST second = first.getNextSibling();
        if (second == null) {
            return (JavaNode)first;
        }
        AST last = second;
        for (AST child = second; child != null; child = child.getNextSibling()) {
            last = child;
        }
        return JavaNodeHelper.getLastChild(last);
    }

    public static boolean isLocalVariable(AST node) {
        if (node.getType() != 13) {
            throw new IllegalArgumentException("no VARIABLE_DEF node -- " + node);
        }
        return ((JavaNode)node).getParent().getType() != 9;
    }

    public static AST advanceToFirstNonParen(AST lparen) {
        if (lparen == null) {
            throw new NullPointerException();
        }
        if (lparen.getType() != 106) {
            throw new IllegalArgumentException(lparen + " no LPAREN");
        }
        block3: for (AST next = lparen.getNextSibling(); next != null; next = next.getNextSibling()) {
            switch (next.getType()) {
                case 106: {
                    continue block3;
                }
                default: {
                    return next;
                }
            }
        }
        return null;
    }
}

