/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import antlr.ANTLRStringBuffer;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.collections.AST;
import de.hunsicker.jalopy.language.Parser;
import de.hunsicker.jalopy.language.References;
import de.hunsicker.jalopy.language.antlr.InternalJavaParser;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.storage.Loggers;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class JavaParser
extends InternalJavaParser
implements Parser {
    public static final int JDK_1_3 = 13;
    public static final int JDK_1_4 = 14;
    public static final int JDK_1_5 = 15;
    static final String STR_TYPE = "TYPE";
    static final String STR_MODIFIERS = "MODIFIERS";
    static final String STR_OBJBLOCK = "OBJBLOCK";
    static final String STR_EXTENDS_CLAUSE = "EXTENDS_CLAUSE";
    static final String STR_INSTANCE_INIT = "INSTANCE_INIT";
    static final String STR_PARAMETERS = "PARAMETERS";
    static final String STR_CASESLIST = "CASESLIST";
    static final String STR_EXPR = "EXPR";
    static final String STR_ELIST = "ELIST";
    private List _unqualIdents = new NoList(100);
    private List _qualIdents = new NoList(30);
    private ANTLRStringBuffer _buf = new ANTLRStringBuffer(100);
    private List _buildList = new ArrayList(10);
    private References _references = new References();
    private boolean _insert = true;
    private List _strippedImports = new ArrayList();
    private Set _qualImports = new HashSet(20);
    private Set _unqualImports = new HashSet(10);
    private final Logger _logger = Logger.getLogger((String)"de.hunsicker.jalopy.language.java");
    private String _packageName = "";
    boolean stripQualification;
    private static final Integer UNKNOWN_POSITION = new Integer(0);

    protected JavaParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
    }

    public JavaParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 2);
    }

    protected JavaParser(TokenStream lexer, int k) {
        super(lexer, k);
    }

    public JavaParser(TokenStream lexer) {
        this(lexer, 2);
    }

    public JavaParser(ParserSharedInputState state) {
        super(state);
    }

    public void setStripQualification(boolean strip) {
    }

    public boolean isStripQualifation() {
        return this.stripQualification;
    }

    @Override
    public AST getParseTree() {
        if (this.stripQualification && this._insert) {
            if (this.returnAST == null) {
                return null;
            }
            AST top = this.returnAST.getFirstChild();
            switch (top.getType()) {
                case 19: 
                case 33: {
                    int size = this._strippedImports.size();
                    for (int i = 0; i < size; ++i) {
                        AST tmp = top.getNextSibling();
                        JavaNode imp = (JavaNode)this._strippedImports.get(i);
                        imp.setNextSibling(tmp);
                        top.setNextSibling((AST)imp);
                    }
                    break;
                }
            }
            this._insert = false;
        }
        return this.returnAST;
    }

    public void reportError(RecognitionException ex) {
        Object[] args = new Object[]{this.getFilename(), new Integer(ex.line), new Integer(ex.column), ex.getMessage()};
        this._logger.error((Object)Loggers.fmt("PARSER_ERROR", args), (Throwable)ex);
    }

    public void reportError(String message) {
        Object[] args = new Object[]{this.getFilename(), UNKNOWN_POSITION, UNKNOWN_POSITION, message};
        this._logger.error((Object)Loggers.fmt("PARSER_ERROR", args), null);
    }

    public void reportWarning(String message) {
        Object[] args = new Object[]{this.getFilename(), UNKNOWN_POSITION, UNKNOWN_POSITION, message};
        this._logger.warn((Object)Loggers.fmt("PARSER_ERROR", args), null);
    }

    public String getPackageName() {
        return this._packageName;
    }

    private void attachStuffBeforeCompoundStatement(JavaNode node, JavaNode statement) {
        node.setHiddenBefore(statement.getHiddenBefore());
        statement.setHiddenBefore(null);
    }

    private void attachStuffBeforeCtor(JavaNode node, JavaNode modifiers, JavaNode keyword) {
        JavaNode modifier = this.getFirstCommentNode(modifiers);
        if (modifier != null) {
            node.setHiddenBefore(modifier.getHiddenBefore());
            modifier.setHiddenBefore(null);
        } else if (keyword.getHiddenBefore() != null) {
            node.setHiddenBefore(keyword.getHiddenBefore());
            keyword.setHiddenBefore(null);
        }
    }

    private JavaNode getFirstCommentNode(JavaNode modifiers) {
        JavaNode fc = (JavaNode)modifiers.getFirstChild();
        if (fc != null && fc.getType() == 54 && (fc = (JavaNode)fc.getFirstChild()).getHiddenBefore() == null) {
            fc = (JavaNode)fc.getParent().getNextSibling();
        }
        return fc;
    }

    private void attachStuffBefore(JavaNode node, JavaNode modifiers, JavaNode type) {
        JavaNode modifier = this.getFirstCommentNode(modifiers);
        if (modifier != null) {
            node.setHiddenBefore(modifier.getHiddenBefore());
            modifier.setHiddenBefore(null);
        } else {
            for (JavaNode child = type; child != null; child = child.getFirstChild()) {
                if (child.getFirstChild() != null) continue;
                JavaNode t = child;
                if (t.getHiddenBefore() == null) break;
                node.setHiddenBefore(t.getHiddenBefore());
                t.setHiddenBefore(null);
                break;
            }
        }
    }

    public List getUnqualifiedIdents() {
        return this._unqualIdents;
    }

    public List getQualifiedIdents() {
        return this._qualIdents;
    }

    @Override
    public void reset() {
        this._buildList.clear();
        this._qualIdents.clear();
        this._qualImports.clear();
        this._strippedImports.clear();
        this._references.reset();
        this._unqualIdents.clear();
        this._unqualImports.clear();
        this._insert = true;
        this._packageName = "";
        this._buf.setLength(0);
        if (this.inputState != null) {
            this.inputState.reset();
        }
        this.setFilename("<unknown>");
        this.returnAST = null;
    }

    @Override
    protected void attachStuff(JavaNode[] nodes) {
        JavaNode node = nodes[0];
        switch (node.getType()) {
            case 13: 
            case 17: 
            case 18: 
            case 49: 
            case 52: {
                this.attachStuffBefore(node, nodes[1], nodes[2]);
                break;
            }
            case 50: {
                JavaNode t = (JavaNode)node.getFirstChild();
                if (t == null) break;
                if (t.getHiddenBefore() != null) {
                    node.setHiddenBefore(t.getHiddenBefore());
                    t.setHiddenBefore(null);
                }
                if ((t = (JavaNode)t.getNextSibling()) == null || t.getHiddenBefore() == null) break;
                node.setHiddenBefore(t.getHiddenBefore());
                t.setHiddenBefore(null);
                break;
            }
            case 12: {
                this.attachStuffBefore(node, nodes[1], nodes[2]);
                break;
            }
            case 11: {
                this.attachStuffBeforeCtor(nodes[0], nodes[1], nodes[2]);
                break;
            }
            case 14: {
                this.attachStuffBeforeCompoundStatement(nodes[0], nodes[1]);
            }
        }
    }

    private static final class NoList
    extends ArrayList {
        public NoList(int initialSize) {
            super(initialSize);
        }

        @Override
        public boolean add(Object element) {
            if (element == null) {
                return false;
            }
            if (this.contains(element)) {
                return false;
            }
            return super.add(element);
        }

        @Override
        public void add(int index, Object element) {
            if (element == null) {
                return;
            }
            if (this.contains(element)) {
                return;
            }
            super.add(index, element);
        }

        @Override
        public Object set(int index, Object element) {
            if (element == null) {
                return element;
            }
            if (this.contains(element)) {
                return element;
            }
            return super.set(index, element);
        }
    }
}

