/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.Transformation;
import de.hunsicker.jalopy.language.TransformationException;
import de.hunsicker.jalopy.language.TreeWalker;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.language.antlr.JavaNodeFactory;
import java.util.ArrayList;
import java.util.List;

final class LoggerTransformation
extends TreeWalker
implements Transformation {
    private static final String DEBUG = "debug";
    private static final String LEVEL_DEBUG = "Level.DEBUG";
    private static final String LOCALIZED_LOG = "l7dlog";
    private static final String PRIORITY_DEBUG = "Priority.DEBUG";
    private List _calls = new ArrayList(50);
    private JavaNodeFactory _factory;

    public LoggerTransformation(JavaNodeFactory factory) {
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(AST tree) throws TransformationException {
        try {
            this.walk(tree);
            int size = this._calls.size();
            block6: for (int i = 0; i < size; ++i) {
                AST node = (AST)this._calls.get(i);
                AST name = node.getFirstChild();
                switch (name.getType()) {
                    case 78: {
                        JavaNode expr;
                        AST firstPart = name.getFirstChild();
                        AST lastPart = firstPart.getNextSibling();
                        String methodName = lastPart.getText();
                        if (!this.isDebugCall(node, methodName) || this.isEnclosed(expr = ((JavaNode)node).getParent(), firstPart)) continue block6;
                        this.addConditional(expr, firstPart);
                    }
                }
            }
        }
        finally {
            this._calls.clear();
        }
    }

    @Override
    public void visit(AST node) {
        switch (node.getType()) {
            case 30: {
                this._calls.add(node);
            }
        }
    }

    private boolean isDebugCall(AST node, String name) {
        AST params;
        AST expr;
        if (DEBUG.equals(name)) {
            JavaNode n = (JavaNode)node;
            switch (n.getType()) {
                case 31: 
                case 108: {
                    return false;
                }
            }
            AST params2 = JavaNodeHelper.getFirstChild(node, 37);
            AST expr2 = params2.getFirstChild();
            return expr2 != null;
        }
        if (LOCALIZED_LOG.equals(name) && (expr = (params = JavaNodeHelper.getFirstChild(node, 37)).getFirstChild()) != null) {
            AST param = expr.getFirstChild();
            switch (param.getType()) {
                case 78: {
                    String n = JavaNodeHelper.getDottedName(param);
                    if (!LEVEL_DEBUG.equals(n) && !PRIORITY_DEBUG.equals(n)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isEnclosed(JavaNode expr, AST loggerName) {
        JavaNode parent = expr.getParent();
        switch (parent.getType()) {
            case 119: {
                return this.hasLogger((AST)parent, loggerName);
            }
            case 10: {
                return this.isEnclosed(parent, loggerName);
            }
        }
        return false;
    }

    private boolean hasLogger(AST ifExpression, AST logger) {
        boolean result = false;
        boolean qe = false;
        AST child = ifExpression.getFirstChild();
        if (child != null) {
            block4: for (AST next = child; next != null && !result && !qe; next = next.getNextSibling()) {
                switch (next.getType()) {
                    case 77: {
                        result = next.getText().equals(logger.getText());
                        continue block4;
                    }
                    case 107: {
                        qe = true;
                        continue block4;
                    }
                    default: {
                        result = this.hasLogger(next, logger);
                    }
                }
            }
        }
        return result;
    }

    private void addConditional(JavaNode expr, AST name) {
        JavaNode cond = this.createConditional(name);
        JavaNode parent = expr.getParent();
        JavaNode prev = expr.getPreviousSibling();
        JavaNode next = (JavaNode)expr.getNextSibling();
        cond.setParent(parent);
        cond.setPreviousSibling(prev);
        if (parent == prev) {
            prev.setFirstChild((AST)cond);
        } else {
            prev.setNextSibling((AST)cond);
        }
        JavaNode lparen = (JavaNode)cond.getFirstChild().getNextSibling().getNextSibling();
        lparen.setNextSibling((AST)expr);
        expr.setParent(cond);
        expr.setPreviousSibling(lparen);
        expr.setNextSibling(null);
        if (next != null) {
            cond.setNextSibling((AST)next);
            next.setPreviousSibling(cond);
        }
    }

    private JavaNode createConditional(AST name) {
        JavaNode qualifiedName = (JavaNode)this._factory.create(78);
        qualifiedName.addChild(this._factory.dupTree(name));
        ((JavaNode)qualifiedName.getFirstChild()).setHiddenBefore(null);
        ((JavaNode)qualifiedName.getFirstChild()).setHiddenAfter(null);
        AST methodName = this._factory.create(77, "isDebugEnabled");
        qualifiedName.addChild(methodName);
        AST methodCall = this._factory.create(30);
        methodCall.addChild((AST)qualifiedName);
        methodCall.addChild(this._factory.create(37));
        methodCall.addChild(this._factory.create(107));
        AST expr = this._factory.create(31);
        expr.addChild(methodCall);
        JavaNode ifNode = (JavaNode)this._factory.create(119);
        ifNode.addChild(this._factory.create(106));
        ifNode.addChild(expr);
        ifNode.addChild(this._factory.create(107));
        return ifNode;
    }
}

