/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.CompositeFactory;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.Transformation;
import de.hunsicker.jalopy.language.TransformationException;
import de.hunsicker.jalopy.language.TreeWalker;
import de.hunsicker.jalopy.language.antlr.ExtendedToken;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.language.antlr.Node;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.util.Helper;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;

final class SerializableTransformation
extends TreeWalker
implements Transformation {
    private static final String SERIAL_VERSION_UID = "serialVersionUID";
    private static final String SERIALIZABLE = "Serializable";
    private static final String EXTERNALIZABLE = "Externalizable";
    private ClassDefInfo _curClassDef;
    private List _classDefs = new ArrayList(5);
    private String _packageName;
    private CompositeFactory _factory = null;

    public SerializableTransformation(CompositeFactory factory) {
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(AST tree) throws TransformationException {
        try {
            this.walkNode(tree);
            int size = this._classDefs.size();
            for (int i = 0; i < size; ++i) {
                ClassDefInfo info = (ClassDefInfo)this._classDefs.get(i);
                if (!info.serializable || info.serialver) continue;
                try {
                    Class clazz = Helper.loadClass(info.name, this);
                    ObjectStreamClass oclazz = ObjectStreamClass.lookup(clazz);
                    long serialVersionUID = oclazz.getSerialVersionUID();
                    this.insertSerialVer(tree, info, serialVersionUID);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    Object[] args = new Object[]{tree.getText(), info.name};
                    Loggers.TRANSFORM.warn((Object)Loggers.fmt("TRANS_SERIALIZABLE_CLASS_NOT_FOUND", args), (Throwable)ex);
                }
            }
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public void visit(AST node) {
        block3: for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 77: {
                    if (!child.getText().equals(SERIAL_VERSION_UID)) break block3;
                    this._curClassDef.serialver = true;
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
    }

    @Override
    protected void walkNode(AST node) {
        if (node != null) {
            switch (node.getType()) {
                case 9: 
                case 65: {
                    this.walkNode(node.getFirstChild());
                    break;
                }
                case 19: {
                    this._packageName = JavaNodeHelper.getDottedName(node.getFirstChild());
                }
                case 5: 
                case 8: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 18: 
                case 21: 
                case 22: 
                case 33: 
                case 77: {
                    this.walkNode(node.getNextSibling());
                    break;
                }
                case 17: {
                    this._curClassDef = this.addToClassList(node);
                    if (this._curClassDef.serializable) {
                        this.walkNode(node.getFirstChild());
                    }
                    this.walkNode(node.getNextSibling());
                    break;
                }
                case 13: {
                    if (this._curClassDef.serializable && !this._curClassDef.serialver) {
                        this.visit(node);
                    }
                    this.walkNode(node.getNextSibling());
                    break;
                }
            }
        }
    }

    static boolean isClassSerializable(AST node) {
        AST clauses = JavaNodeHelper.getFirstChild(node, 22);
        for (AST clause = clauses.getFirstChild(); clause != null; clause = clause.getNextSibling()) {
            String name = clause.getText();
            if (!SERIALIZABLE.equals(name) && !EXTERNALIZABLE.equals(name)) continue;
            return true;
        }
        return false;
    }

    private ClassDefInfo addToClassList(AST node) {
        int count = this._classDefs.size();
        String ident = null;
        ident = this._packageName + "." + JavaNodeHelper.getFirstChild(node, 77).getText();
        if (count > 0) {
            int size = this._classDefs.size();
            for (int i = 0; i < size; ++i) {
                ClassDefInfo previousInfo = (ClassDefInfo)this._classDefs.get(i);
                if (!previousInfo.node.contains((JavaNode)node)) continue;
                ident = previousInfo.name + "$" + JavaNodeHelper.getFirstChild(node, 77).getText();
                break;
            }
        }
        ClassDefInfo info = new ClassDefInfo(node, ident);
        this._classDefs.add(info);
        return info;
    }

    private void cleanup() {
        this._classDefs.clear();
        this._curClassDef = null;
        this._packageName = null;
        this._curClassDef = null;
    }

    private void insertSerialVer(AST tree, ClassDefInfo info, long serialverUID) {
        JavaNode serialver = this._factory.getJavaNodeFactory().create(Integer.MAX_VALUE, 1, Integer.MAX_VALUE, 1);
        serialver.setType(13);
        serialver.setText("VARIABLE_DEF");
        AST modifiers = this._factory.getJavaNodeFactory().create(8, "MODIFIERS");
        AST privatemod = this._factory.getJavaNodeFactory().create(97, "private");
        AST finalmod = this._factory.getJavaNodeFactory().create(42, "final");
        AST staticmod = this._factory.getJavaNodeFactory().create(74, "static");
        modifiers.addChild(privatemod);
        modifiers.addChild(finalmod);
        modifiers.addChild(staticmod);
        AST type = this._factory.getJavaNodeFactory().create(16, "TYPE");
        AST typevalue = this._factory.getJavaNodeFactory().create(94, "long");
        type.addChild(typevalue);
        AST ident = this._factory.getJavaNodeFactory().create(77, SERIAL_VERSION_UID);
        AST assign = this._factory.getJavaNodeFactory().create(108, "=");
        AST expr = this._factory.getJavaNodeFactory().create(31, "EXPR");
        AST assignvalue = this._factory.getJavaNodeFactory().create(171, serialverUID + "L");
        expr.addChild(assignvalue);
        assign.addChild(expr);
        JavaNode semi = (JavaNode)this._factory.getJavaNodeFactory().create(72, ";");
        serialver.addChild(modifiers);
        serialver.addChild(type);
        serialver.addChild(ident);
        serialver.addChild(assign);
        serialver.addChild((AST)semi);
        Node description2 = (Node)this._factory.getNodeFactory().create();
        description2.setType(40);
        description2.setText("Use serialVersionUID for interoperability.");
        Node comment = (Node)this._factory.getNodeFactory().create(4, "/** Use serialVersionUID for interoperability. */");
        comment.addChild((AST)description2);
        ExtendedToken token = this._factory.getExtendedTokenFactory().create(4, "/** Use serialVersionUID for interoperability. */");
        token.setComment(comment);
        serialver.setHiddenBefore(token);
        JavaNode objblock = (JavaNode)JavaNodeHelper.getFirstChild((AST)info.node, 9);
        JavaNode lcurly = (JavaNode)objblock.getFirstChild();
        JavaNode next = (JavaNode)lcurly.getNextSibling();
        lcurly.setNextSibling((AST)serialver);
        serialver.setParent(objblock);
        serialver.setPreviousSibling(lcurly);
        serialver.setNextSibling((AST)next);
        if (next != null) {
            next.setPreviousSibling(serialver);
        }
        Object[] args = new Object[]{tree.getText(), info.name};
        Loggers.TRANSFORM.info((Object)Loggers.fmt("TRANS_SERIALIZABLE_ADD", args), null);
    }

    private static final class ClassDefInfo {
        public JavaNode node;
        public String name;
        public boolean serializable;
        public boolean serialver;

        public ClassDefInfo(AST node, String name) {
            this.node = (JavaNode)node;
            this.name = name;
            this.serializable = SerializableTransformation.isClassSerializable(node);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append('[');
            buf.append(this.node);
            buf.append(", name=");
            buf.append(this.name);
            buf.append(", hasField=");
            buf.append(this.serialver);
            buf.append(']');
            return buf.toString();
        }
    }
}

