/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.CompositeFactory;
import de.hunsicker.jalopy.language.DeclarationType;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.JavaNodeModifier;
import de.hunsicker.jalopy.language.NodeComparator;
import de.hunsicker.jalopy.language.Transformation;
import de.hunsicker.jalopy.language.TransformationException;
import de.hunsicker.jalopy.language.VariableDefNodeComparator;
import de.hunsicker.jalopy.language.antlr.ExtendedToken;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

final class SortTransformation
implements Transformation {
    private static final String EMPTY_STRING = "".intern();
    private final NodeComparator _defaultComparator = new NodeComparator();
    private final VariableDefNodeComparator _variablesComparator = new VariableDefNodeComparator();
    CompositeFactory _factory = null;

    public SortTransformation(CompositeFactory factory) {
        this._factory = factory;
    }

    @Override
    public void apply(AST tree) throws TransformationException {
        Convention settings = Convention.getInstance();
        boolean sortModifiers = settings.getBoolean(ConventionKeys.SORT_MODIFIERS, false);
        boolean sortBeanNames = settings.getBoolean(ConventionKeys.SORT_METHOD_BEAN, false);
        this._defaultComparator.setBeanSorting(sortBeanNames);
        this._defaultComparator.setModifierSorting(sortModifiers);
        this._variablesComparator.setModifierSorting(sortModifiers);
        this.sort(tree, this._defaultComparator);
    }

    public void sort(AST tree, Comparator comp) {
        if (tree == null) {
            return;
        }
        AST first = null;
        block3: for (AST child = tree.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 17: 
                case 18: {
                    first = child;
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        for (AST declaration = first; declaration != null; declaration = declaration.getNextSibling()) {
            this.sortDeclarations(declaration, comp, 1);
        }
    }

    private boolean isStatic(AST node) {
        return JavaNodeModifier.isStatic(JavaNodeHelper.getFirstChild(node, 8));
    }

    private void addChild(JavaNode node, JavaNode sibling) {
        node.setNextSibling((AST)sibling);
        sibling.setPreviousSibling(node);
        sibling.setNextSibling(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JavaNode addSiblings(List nodes, JavaNode node, boolean addSeparator, int indent, int maxwidth) {
        JavaNode cur = node;
        if (nodes.size() <= 0) return node;
        JavaNode next = (JavaNode)nodes.get(0);
        this.addChild(cur, next);
        cur = next;
        if (addSeparator) {
            ExtendedToken comment = this._factory.getExtendedTokenFactory().create(67, EMPTY_STRING);
            if (next.hasCommentsBefore()) {
                for (ExtendedToken tok = (ExtendedToken)next.getHiddenBefore(); tok != null; tok = (ExtendedToken)tok.getHiddenBefore()) {
                    if (tok.getHiddenBefore() != null) continue;
                    tok.setHiddenBefore(comment);
                    comment.setHiddenAfter(tok);
                    break;
                }
            } else {
                next.setHiddenBefore(comment);
            }
            Convention settings = Convention.getInstance();
            String fillCharacter = settings.get(ConventionKeys.SEPARATOR_FILL_CHARACTER, "\u00b7");
            switch (next.getType()) {
                case 13: {
                    if (this.isStatic((AST)cur)) {
                        this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_STATIC_VAR_INIT, "Static variables/initializers"), fillCharacter, indent, maxwidth);
                        break;
                    }
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_INSTANCE_VAR, "Instance variables"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 12: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_METHOD, "Methods"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 11: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_CTOR, "Constructors"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 17: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_CLASS, "Inner classes"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 18: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_INTERFACE, "Inner Interfaces"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 15: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_STATIC_VAR_INIT, "Static variables/initializers"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 14: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_INSTANCE_INIT, "Instance initializers"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 49: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_ENUM_INIT, "Enumeration initializers"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 50: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_ENUM_CONSTANT_INIT, "Enumeration constant initializers"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 52: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_ANNOTATION_INIT, "Annotation initializers"), fillCharacter, indent, maxwidth);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected type -- " + cur);
                }
            }
        }
        int size = nodes.size();
        for (int i = 1; i < size; ++i) {
            JavaNode next2 = (JavaNode)nodes.get(i);
            this.addChild(cur, next2);
            cur = next2;
        }
        return cur;
    }

    private void fillComment(ExtendedToken comment, String text, String character, int indent, int maxwidth) {
        StringBuffer buf = new StringBuffer(maxwidth);
        buf.append("//~ ");
        buf.append(text);
        buf.append(' ');
        int size = maxwidth - indent - 1;
        for (int i = text.length() + 4; i < size; ++i) {
            buf.append(character);
        }
        comment.setText(buf.toString());
    }

    private AST sortDeclarations(AST node, Comparator comp, int level) {
        JavaNode tmp;
        JavaNode lcurly = null;
        switch (node.getType()) {
            case 17: {
                lcurly = (JavaNode)JavaNodeHelper.getFirstChild(node, 9);
                break;
            }
            case 18: {
                lcurly = (JavaNode)JavaNodeHelper.getFirstChild(node, 9);
                break;
            }
            case 52: {
                lcurly = (JavaNode)JavaNodeHelper.getFirstChild(node, 9);
            }
            case 49: {
                lcurly = (JavaNode)JavaNodeHelper.getFirstChild(node, 9);
                break;
            }
            default: {
                return node;
            }
        }
        switch (lcurly.getFirstChild().getType()) {
            case 6: {
                return node;
            }
        }
        ArrayList<AST> staticStuff = new ArrayList<AST>(3);
        ArrayList<AST> variables = new ArrayList<AST>();
        ArrayList<AST> initializers = new ArrayList<AST>(3);
        ArrayList<AST> ctors = new ArrayList<AST>(5);
        ArrayList<AST> methods = new ArrayList<AST>();
        ArrayList<AST> classes = new ArrayList<AST>(3);
        ArrayList<AST> interfaces = new ArrayList<AST>(3);
        ArrayList<AST> annotations = new ArrayList<AST>(3);
        ArrayList<AST> enums = new ArrayList<AST>(3);
        ArrayList<AST> enumdef = new ArrayList<AST>(3);
        ArrayList<String> names = new ArrayList<String>();
        AST rcurly = null;
        block23: for (AST child = lcurly.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 12: {
                    methods.add(child);
                    continue block23;
                }
                case 13: {
                    if (this.isStatic(child)) {
                        staticStuff.add(child);
                        continue block23;
                    }
                    names.add(JavaNodeHelper.getFirstChild(child, 77).getText());
                    variables.add(child);
                    continue block23;
                }
                case 11: {
                    ctors.add(child);
                    continue block23;
                }
                case 15: {
                    staticStuff.add(child);
                    continue block23;
                }
                case 14: {
                    initializers.add(child);
                    continue block23;
                }
                case 17: {
                    classes.add(this.sortDeclarations(child, comp, level + 1));
                    continue block23;
                }
                case 18: {
                    interfaces.add(this.sortDeclarations(child, comp, level + 1));
                    continue block23;
                }
                case 6: {
                    rcurly = child;
                    continue block23;
                }
                case 52: {
                    annotations.add(child);
                    continue block23;
                }
                case 49: {
                    enums.add(this.sortDeclarations(child, comp, level + 1));
                    continue block23;
                }
                case 50: {
                    enumdef.add(child);
                    continue block23;
                }
                case 72: {
                    continue block23;
                }
                default: {
                    throw new IllegalArgumentException("cannot handle node -- " + child);
                }
            }
        }
        Convention settings = Convention.getInstance();
        if (settings.getBoolean(ConventionKeys.SORT_VARIABLE, false)) {
            this._variablesComparator.names = names;
            Collections.sort(variables, this._variablesComparator);
            names.clear();
        }
        if (settings.getBoolean(ConventionKeys.SORT_CTOR, false)) {
            Collections.sort(ctors, comp);
        }
        if (settings.getBoolean(ConventionKeys.SORT_METHOD, false)) {
            Collections.sort(methods, comp);
        }
        if (settings.getBoolean(ConventionKeys.SORT_CLASS, false)) {
            Collections.sort(classes, comp);
        }
        if (settings.getBoolean(ConventionKeys.SORT_INTERFACE, false)) {
            Collections.sort(interfaces, comp);
        }
        if (settings.getBoolean(ConventionKeys.SORT_ENUM, false)) {
            Collections.sort(enums, comp);
        }
        if (settings.getBoolean(ConventionKeys.SORT_ANNOTATION, false)) {
            Collections.sort(annotations, comp);
        }
        HashMap<String, ArrayList<AST>> nodemap = new HashMap<String, ArrayList<AST>>(10, 1.0f);
        nodemap.put(DeclarationType.STATIC_VARIABLE_INIT.getName(), staticStuff);
        nodemap.put(DeclarationType.VARIABLE.getName(), variables);
        nodemap.put(DeclarationType.INIT.getName(), initializers);
        nodemap.put(DeclarationType.CTOR.getName(), ctors);
        nodemap.put(DeclarationType.METHOD.getName(), methods);
        nodemap.put(DeclarationType.INTERFACE.getName(), interfaces);
        nodemap.put(DeclarationType.CLASS.getName(), classes);
        nodemap.put(DeclarationType.ANNOTATION.getName(), annotations);
        nodemap.put(DeclarationType.ENUM.getName(), enums);
        boolean addSeparator = false;
        addSeparator = level == 1 ? settings.getBoolean(ConventionKeys.COMMENT_INSERT_SEPARATOR, false) : settings.getBoolean(ConventionKeys.COMMENT_INSERT_SEPARATOR_RECURSIVE, false);
        String sortString = settings.get(ConventionKeys.SORT_ORDER, DeclarationType.getOrder());
        int maxwidth = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        int indent = settings.getInt(ConventionKeys.INDENT_SIZE, 4);
        JavaNode current = tmp = (JavaNode)this._factory.getJavaNodeFactory().create();
        if (!enumdef.isEmpty()) {
            current = this.addSiblings(enumdef, current, addSeparator, indent * level, maxwidth);
        }
        StringTokenizer tokens = new StringTokenizer(sortString, "|");
        while (tokens.hasMoreTokens()) {
            String nextToken = tokens.nextToken();
            current = this.addSiblings((List)nodemap.get(nextToken), current, addSeparator, indent * level, maxwidth);
        }
        current.setNextSibling(rcurly);
        JavaNode sibling = (JavaNode)tmp.getNextSibling();
        sibling.setPreviousSibling(lcurly);
        lcurly.setFirstChild((AST)sibling);
        tmp.setNextSibling(null);
        current.setNextSibling(rcurly);
        staticStuff.clear();
        variables.clear();
        initializers.clear();
        ctors.clear();
        methods.clear();
        classes.clear();
        interfaces.clear();
        annotations.clear();
        enumdef.clear();
        enums.clear();
        names.clear();
        return node;
    }
}

