/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.CommonHiddenStreamToken;
import antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.antlr.ExtendedToken;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.language.antlr.Node;
import de.hunsicker.jalopy.printer.JavadocPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.util.StringHelper;
import java.io.IOException;
import java.util.List;

abstract class AbstractPrinter
implements Printer {
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final String AT = "@";
    static final String AT_INTERFACE_SPACE = "@interface ";
    static final String ASSERT_SPACE = "assert ";
    static final String ASSIGN = "=";
    static final String ASSIGN_PADDED = " = ";
    static final String SPACE_ASSIGN = " =";
    static final String BRACES = "{}";
    static final String BRACKETS = "[]";
    static final String BRACKET_LEFT = "[";
    static final String BRACKET_LEFT_SPACE = "[ ";
    static final String BRACKET_RIGHT = "]";
    static final String CASE_SPACE = "case ";
    static final String CATCH = "catch";
    static final String CLASS_SPACE = "class ";
    static final String COMMA = ",";
    static final String COMMA_SPACE = ", ";
    static final String COLON = ":";
    static final String COLON_SPACE = ": ";
    static final String DEFAULT_COLON = "default:";
    static final String DEFAULT_SPACE_COLON = "default :";
    static final String DO = "do";
    static final String DOT = ".";
    static final String ELSE = "else";
    static final String ENUM_SPACE = "enum ";
    static final String EMPTY_STRING = "".intern();
    static final String EXTENDS_SPACE = "extends ";
    static final String FINALLY = "finally";
    static final String FOR = "for";
    static final String FOR_SPACE = "for ";
    static final String IF = "if";
    static final String IF_SPACE = "if ";
    static final String IMPLEMENTS_SPACE = "implements ";
    static final String IMPORT_SPACE = "import ";
    static final String INTERFACE_SPACE = "interface ";
    static final String L = "L";
    static final String LCURLY = "{";
    static final String LCURLY_SPACE = "{ ";
    static final String LPAREN = "(";
    static final String LPAREN_SPACE = "( ";
    static final String NEW_SPACE = "new ";
    static final String PACKAGE_SPACE = "package ";
    static final String PARENTHESES = "()";
    static final String QUESTION_SPACE = "? ";
    static final String RCURLY = "}";
    static final String SPACE_RCURLY = " }";
    static final String RETURN = "return";
    static final String RPAREN = ")";
    static final String SEMI = ";";
    static final String SPACE = " ";
    static final String SPACE_BRACKET_RIGHT = " ]";
    static final String SPACE_BRACKETS = " []";
    static final String SPACE_COLON_SPACE = " : ";
    static final String SPACE_DEFAULT_SPACE = " default ";
    static final String SPACE_EXTENDS_SPACE = " extends ";
    static final String SPACE_LCURLY = " {";
    static final String SPACE_IMPLEMENTS_SPACE = " implements ";
    static final String SPACE_QUESTION = " ?";
    static final String SPACE_QUESTION_SPACE = " ? ";
    static final String SPACE_RPAREN = " )";
    static final String SPACE_THROWS_SPACE = " throws ";
    static final String STATIC = "static";
    static final String STATIC_SPACE = "static ";
    static final String STRING = "String";
    static final String SUPER = "super";
    static final String SWITCH = "switch";
    static final String SUPER_SPACE = "super ";
    static final String SYNCHRONIZED = "synchronized";
    static final String THIS = "this";
    static final String THROW_SPACE = "throw ";
    static final String THROWS_SPACE = "throws ";
    static final String TRY = "try";
    static final String VOID = "void";
    static final String WHILE = "while";
    static final String WHILE_SPACE = "while ";
    static final String QUESTION = "?";
    protected static final Convention settings = Convention.getInstance();
    private static final boolean WHITESPACE_NO = false;
    private static final boolean WHITESPACE_YES = true;
    private final Object[] _args = new Object[2];

    protected AbstractPrinter() {
    }

    public final void printChildren(AST node, NodeWriter out) throws IOException {
        for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            PrinterFactory.create(child, out).print(child, out);
        }
    }

    @Override
    public abstract void print(AST var1, NodeWriter var2) throws IOException;

    public void trackPosition(JavaNode node, NodeWriter out) {
        this.trackPosition(node, out.line, out.column, out);
    }

    public void trackPosition(JavaNode node, int line, int column, NodeWriter out) {
        if (out.tracking && out.mode == 1) {
            node.updatePosition(line, column);
        }
    }

    protected void printIndentation(NodeWriter out) throws IOException {
        this.printIndentation(0, out);
    }

    protected void printIndentation(Marker marker, NodeWriter out) throws IOException {
        if (out.mode == 1) {
            if (marker != null) {
                int indentLength = out.getIndentLength();
                int length = marker.column >= indentLength ? marker.column - indentLength : marker.column;
                out.print(out.getString(length), 173);
            } else if (settings.getBoolean(ConventionKeys.INDENT_DEEP, false) && out.state.markers.isMarked()) {
                int indentLength = out.getIndentLength();
                marker = out.state.markers.getLast();
                int length = marker.column > indentLength ? marker.column - indentLength : marker.column;
                out.print(out.getString(length), 173);
            } else {
                out.print(out.getString(out.state.paramLevel * out.indentSize), 173);
            }
        }
    }

    protected void printIndentation(int diff, NodeWriter out) throws IOException {
        if (out.mode == 1) {
            if (!settings.getBoolean(ConventionKeys.INDENT_DEEP, false)) {
                out.print(out.getString(out.state.paramLevel * out.indentSize + diff), 173);
            } else if (out.state.markers.isMarked()) {
                int length;
                int indentLength = out.getIndentLength();
                Marker marker = out.state.markers.getLast();
                int n = length = marker.column > indentLength ? marker.column - indentLength : marker.column;
                if (length + diff >= 0) {
                    out.print(out.getString(length + diff), 173);
                } else if (length > 0) {
                    out.print(out.getString(length), 173);
                } else {
                    System.out.println("Warning marker bad " + marker.column + COMMA + indentLength);
                }
            }
        }
    }

    final boolean isChildOf(JavaNode node, JavaNode child) {
        block4: {
            block3: {
                JavaNode parent = child.getParent();
                if (parent == node) break block3;
                switch (parent.getType()) {
                    case 5: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 16: 
                    case 23: 
                    case 69: 
                    case 74: 
                    case 119: 
                    case 121: 
                    case 122: 
                    case 129: 
                    case 131: 
                    case 132: 
                    case 133: {
                        break block4;
                    }
                    default: {
                        return this.isChildOf(node, parent);
                    }
                }
            }
            return true;
        }
        return false;
    }

    int getOriginalBlankLines(JavaNode node) {
        int keepLinesUpTo = settings.getInt(ConventionKeys.BLANK_LINES_KEEP_UP_TO, 1);
        if (keepLinesUpTo <= 0) {
            return 0;
        }
        switch (node.getPreviousSibling().getType()) {
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 33: 
            case 65: {
                return 0;
            }
            case 13: {
                if (this.isLocalVariable(node)) break;
                return 0;
            }
        }
        switch (node.getType()) {
            case 31: {
                for (JavaNode child = (JavaNode)node.getFirstChild(); child != null; child = (JavaNode)child.getFirstChild()) {
                    CommonHiddenStreamToken t;
                    if (!child.hasCommentsBefore() || (t = child.getCommentBefore()) == null) continue;
                    int l = t.getLine() - node.getPreviousSibling().getEndLine() - 1;
                    if (l > keepLinesUpTo) {
                        return keepLinesUpTo;
                    }
                    return Math.max(l, 0);
                }
                break;
            }
            case 13: {
                if (this.isLocalVariable(node)) break;
                return 0;
            }
            case 6: {
                int blankLinesBeforeRcurly = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_BRACE_RIGHT, 0);
                if (blankLinesBeforeRcurly == -1) break;
                return blankLinesBeforeRcurly;
            }
        }
        JavaNode prev = node.getPreviousSibling();
        int result = 0;
        if (prev != null) {
            if (!node.hasCommentsBefore()) {
                if (node.getParent().getType() != 31) {
                    result = node.getStartLine() - prev.getEndLine() - 1;
                }
            } else if (node.getParent().getType() != 31) {
                result = node.getCommentBefore().getLine() - prev.getEndLine() - 1;
            }
        }
        if (result > keepLinesUpTo) {
            return keepLinesUpTo;
        }
        return result;
    }

    void logIssues(AST node, NodeWriter out) {
        if (out.mode == 1 && out.issues.containsKey(node)) {
            Object value = out.issues.get(node);
            this._args[0] = out.filename;
            this._args[1] = String.valueOf(out.line);
            StringBuffer buf = new StringBuffer(250);
            if (value instanceof List) {
                List issues = (List)value;
                int size = issues.size();
                for (int i = 0; i < size; ++i) {
                    buf.append(out.filename);
                    buf.append(':');
                    buf.append(out.line);
                    buf.append(':');
                    buf.append((String)issues.get(i));
                    Loggers.IO.warn((Object)buf.toString());
                    buf.setLength(0);
                }
            } else {
                buf.append(out.filename);
                buf.append(':');
                buf.append(out.line);
                buf.append(':');
                buf.append((String)value);
                Loggers.IO.warn((Object)buf.toString());
            }
        }
    }

    void printBlankLinesBefore(JavaNode node, NodeWriter out) throws IOException {
        int blankLines = this.getBlankLinesBefore(node, out);
        out.printBlankLines(blankLines);
        switch (node.getType()) {
            case 31: {
                out.blankLines = blankLines;
                out.expression = node;
            }
        }
    }

    boolean printCommentsAfter(AST node, NodeWriter out) throws IOException {
        if (out.mode != 1) {
            return false;
        }
        JavaNode n = (JavaNode)node;
        if (n.getHiddenAfter() == null) {
            return false;
        }
        boolean result = false;
        switch (node.getType()) {
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 103: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 126: 
            case 129: 
            case 131: 
            case 132: 
            case 133: {
                if (!settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false)) break;
                result = this.printCommentsAfter(node, false, false, out);
                break;
            }
            default: {
                result = this.printCommentsAfter(node, false, false, out);
            }
        }
        return result;
    }

    boolean printCommentsAfter(AST node, boolean newlineBefore, boolean newlineAfter, NodeWriter out) throws IOException {
        JavaNode n = (JavaNode)node;
        if (n.getHiddenAfter() == null || !n.hasCommentsAfter()) {
            return false;
        }
        if (node.getType() != 6 || out.getIndentLevel() != 0) {
            int offset = out.column - 1 + settings.getInt(ConventionKeys.INDENT_SIZE_COMMENT_ENDLINE, 1);
            CommonHiddenStreamToken firstComment = n.getHiddenAfter();
            if (firstComment.getHiddenAfter() != null) {
                this.printCommentAfter((AST)n, firstComment, newlineBefore, true, true, true, out);
                if (out.mode != 1) {
                    return false;
                }
                int indentLength = out.getIndentLength();
                for (CommonHiddenStreamToken comment = firstComment.getHiddenAfter(); comment != null; comment = comment.getHiddenAfter()) {
                    if (offset < indentLength) {
                        int indentLevel = out.getIndentLevel();
                        out.setIndentLevel(0);
                        out.print(out.getString(offset), 173);
                        out.setIndentLevel(indentLevel);
                    } else {
                        out.print(out.getString(offset - indentLength), 173);
                    }
                    this.printCommentAfter((AST)n, comment, newlineBefore, newlineAfter, false, false, out);
                }
            } else {
                this.printCommentAfter((AST)n, firstComment, newlineBefore, newlineAfter, true, true, out);
            }
        } else {
            boolean endlineComment;
            CommonHiddenStreamToken firstComment = n.getHiddenAfter();
            boolean bl = endlineComment = firstComment.getLine() == n.getEndLine();
            if (!endlineComment) {
                out.printNewline();
                out.printNewline();
            }
            this.printCommentAfter(node, firstComment, false, true, endlineComment, true, out);
            if (out.mode != 1) {
                return false;
            }
            for (CommonHiddenStreamToken comment = firstComment.getHiddenAfter(); comment != null; comment = comment.getHiddenAfter()) {
                this.printCommentAfter((AST)n, comment, newlineBefore, true, false, false, out);
            }
        }
        out.last = node.getType();
        return true;
    }

    boolean printCommentsBefore(AST node, NodeWriter out) throws IOException {
        return this.printCommentsBefore(node, true, out);
    }

    boolean printCommentsBefore(AST node, boolean newlineBefore, NodeWriter out) throws IOException {
        CommonHiddenStreamToken firstComment;
        if (out.mode == 2) {
            return false;
        }
        JavaNode n = (JavaNode)node;
        if (!newlineBefore) {
            switch (n.getParent().getType()) {
                case 50: {
                    newlineBefore = true;
                    break;
                }
            }
        }
        if (!n.hasCommentsBefore()) {
            this.printBlankLinesBefore(n, out);
            return false;
        }
        int linesToKeep = settings.getInt(ConventionKeys.BLANK_LINES_KEEP_UP_TO, 1);
        boolean keepLines = linesToKeep > -1;
        CommonHiddenStreamToken previousComment = null;
        for (CommonHiddenStreamToken comment = firstComment = n.getCommentBefore(); comment != null; comment = comment.getHiddenAfter()) {
            switch (comment.getType()) {
                case 4: 
                case 67: {
                    newlineBefore |= !out.newline;
                }
                case 70: 
                case 174: 
                case 176: {
                    if (n.getStartLine() != comment.getLine()) {
                        switch (out.last) {
                            case 67: {
                                break;
                            }
                            default: {
                                if (!keepLines || previousComment == null) break;
                                this.printBlankLinesBetweenComments(comment, previousComment, linesToKeep, out);
                            }
                        }
                        this.printCommentBefore(n, comment, comment == firstComment, comment == firstComment ? newlineBefore : !out.newline, true, out);
                        break;
                    }
                    this.printCommentBefore(n, comment, comment == firstComment, newlineBefore, false, out);
                    out.print(SPACE, out.last);
                    if (comment.getText() == null) break;
                    out.column -= comment.getText().length() - 1;
                    break;
                }
                case 173: {
                    break;
                }
                default: {
                    throw new RuntimeException("Strange comment type ! " + comment);
                }
            }
            previousComment = comment;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getBlankLinesBefore(JavaNode node, NodeWriter out) {
        int result = 0;
        if (!this.canHaveBlankLinesBefore(node)) return 0;
        block0 : switch (node.getType()) {
            case 116: {
                result = 1;
                break;
            }
            case 108: {
                break;
            }
            case 31: {
                switch (node.getParent().getType()) {
                    case 10: 
                    case 66: {
                        break block0;
                    }
                    default: {
                        return 0;
                    }
                }
            }
            case 13: {
                switch (node.getParent().getType()) {
                    case 38: {
                        return 0;
                    }
                }
                switch (out.last) {
                    case 13: {
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: {
                        result = 1;
                        break;
                    }
                    default: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_DECLARATION, 1);
                        break;
                    }
                }
                break;
            }
            case 6: {
                if (node.hasCommentsBefore()) break;
                if (node.getParent().getParent().getType() == 49) {
                    if (out.newline) break;
                    return 1;
                }
                switch (out.last) {
                    case 6: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: {
                        return settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_BRACE_RIGHT, 0);
                    }
                }
                result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_BRACE_RIGHT, 0);
                break;
            }
            case 119: {
                switch (out.last) {
                    case 25: 
                    case 120: {
                        break;
                    }
                    default: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_BLOCK, 1);
                        break;
                    }
                }
                break;
            }
            case 121: {
                if (node.getParent().getType() == 122) break;
            }
            case 69: 
            case 122: 
            case 126: 
            case 129: 
            case 131: {
                switch (out.last) {
                    case 25: {
                        break;
                    }
                    default: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_BLOCK, 1);
                        break;
                    }
                }
                break;
            }
            case 113: 
            case 130: {
                result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_CASE_BLOCK, 1);
                break;
            }
            case 123: 
            case 124: 
            case 125: {
                result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_CONTROL, 1);
                break;
            }
            case 10: {
                if (!JavaNodeHelper.isFreestandingBlock(node)) break;
                result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_BLOCK, 1);
                break;
            }
            case 120: 
            case 132: 
            case 133: {
                if (settings.getBoolean(ConventionKeys.BRACE_NEWLINE_RIGHT, false)) break;
                --result;
                break;
            }
            case 19: 
            case 25: 
            case 32: 
            case 33: 
            case 41: 
            case 45: 
            case 46: 
            case 72: 
            case 127: {
                break;
            }
            case 12: {
                JavaNode prev = node.getPreviousSibling();
                switch (prev.getType()) {
                    case 11: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: {
                        result = 1;
                        break;
                    }
                    case 12: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_METHOD, 1);
                        break;
                    }
                }
                break;
            }
            case 11: {
                JavaNode prev = node.getPreviousSibling();
                switch (prev.getType()) {
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: {
                        result = 1;
                        break;
                    }
                    case 11: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_METHOD, 1);
                        break;
                    }
                }
                break;
            }
            case 17: {
                JavaNode prev = node.getPreviousSibling();
                block48 : switch (prev.getType()) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        result = 1;
                        break;
                    }
                    case 18: {
                        if (out.indentLevel > 0) {
                            result = 1;
                            break;
                        }
                        result = 2;
                        break;
                    }
                    case 17: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_CLASS, 1);
                        if (out.indentLevel != 0) break block0;
                        ++result;
                        break;
                    }
                    case 72: {
                        switch (node.getParent().getType()) {
                            case 19: 
                            case 33: 
                            case 65: {
                                break;
                            }
                            default: {
                                break block48;
                            }
                        }
                    }
                    case 33: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_IMPORT, 2);
                        break;
                    }
                }
                break;
            }
            case 18: 
            case 49: {
                JavaNode prev = node.getPreviousSibling();
                switch (prev.getType()) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        result = 1;
                        break;
                    }
                    case 17: {
                        if (out.indentLevel > 0) {
                            result = 1;
                            break;
                        }
                        result = 2;
                        break;
                    }
                    case 18: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_INTERFACE, 1);
                        if (out.indentLevel != 0) break block0;
                        ++result;
                        break;
                    }
                    case 33: {
                        result = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_IMPORT, 2);
                        break;
                    }
                }
                break;
            }
            case 14: {
                result = 1;
                break;
            }
            case 15: {
                result = 1;
                break;
            }
            default: {
                return 0;
            }
        }
        block64 : switch (out.last) {
            case 6: 
            case 14: 
            case 15: {
                switch (node.getType()) {
                    case 6: 
                    case 113: 
                    case 120: 
                    case 130: 
                    case 132: 
                    case 133: {
                        break block64;
                    }
                    case 121: {
                        switch (node.getParent().getType()) {
                            case 122: {
                                result = 0;
                            }
                        }
                        break block64;
                    }
                }
                int blankLinesAfterBlock = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_BLOCK, 1);
                if (blankLinesAfterBlock <= result) break;
                result = blankLinesAfterBlock;
                break;
            }
            case 113: 
            case 130: {
                switch (node.getType()) {
                    case 113: 
                    case 123: 
                    case 125: 
                    case 130: {
                        result = 0;
                    }
                }
                break;
            }
            case 13: {
                switch (node.getType()) {
                    case 13: {
                        break block64;
                    }
                    case 6: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: {
                        break block64;
                    }
                }
                int blankLinesAfterDeclaration = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_DECLARATION, 0);
                if (blankLinesAfterDeclaration <= result) break;
                result = blankLinesAfterDeclaration;
                break;
            }
            case 5: 
            case 119: 
            case 121: 
            case 122: 
            case 129: {
                int blankLinesAfterOpenCurly = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_BRACE_LEFT, 0);
                if (blankLinesAfterOpenCurly <= -1) break;
                result = blankLinesAfterOpenCurly;
                break;
            }
        }
        switch (node.getType()) {
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                return result;
            }
            default: {
                int original = this.getOriginalBlankLines(node);
                if (original <= result) return result;
                return original;
            }
        }
    }

    private int getCommentBlankLines(CommonHiddenStreamToken comment, JavaNode previous, NodeWriter out) {
        switch (out.last) {
            case 68: {
                return 0;
            }
            case 5: {
                int blankLinesAfterOpenCurly = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_BRACE_LEFT, 0);
                if (blankLinesAfterOpenCurly <= -1) break;
                return blankLinesAfterOpenCurly;
            }
        }
        int result = 0;
        block4 : switch (comment.getType()) {
            case 174: {
                switch (out.last) {
                    case 174: {
                        result = 0;
                        break block4;
                    }
                }
                result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_SINGLE_LINE, 1);
                break;
            }
            case 70: {
                result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_SINGLE_LINE, 1);
                break;
            }
            case 176: {
                switch (out.last) {
                    case 176: {
                        result = 0;
                        break block4;
                    }
                }
                result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_MULTI_LINE, 1);
                break;
            }
            case 4: {
                switch (out.last) {
                    case 4: {
                        result = 0;
                        break block4;
                    }
                }
                result = settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_COMMENT_JAVADOC, 1);
                break;
            }
            case 67: {
                switch (out.last) {
                    case 6: {
                        result = 2;
                        break block4;
                    }
                }
                result = 1;
            }
        }
        switch (out.last) {
            case 19: {
                int linesAfterPackage = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_PACKAGE, 1);
                if (result > linesAfterPackage) {
                    result -= linesAfterPackage;
                    break;
                }
                result = 0;
            }
        }
        int keepLinesUpTo = settings.getInt(ConventionKeys.BLANK_LINES_KEEP_UP_TO, 1);
        int l = comment.getLine() - previous.getEndLine() - 1;
        if (l > keepLinesUpTo) {
            return keepLinesUpTo;
        }
        return Math.max(result, l);
    }

    private boolean isLocalVariable(JavaNode node) {
        switch (node.getParent().getType()) {
            case 9: {
                return false;
            }
        }
        return true;
    }

    private boolean canHaveBlankLinesBefore(JavaNode node) {
        JavaNode parent = node.getParent();
        switch (parent.getType()) {
            case 5: 
            case 9: 
            case 10: 
            case 65: {
                return true;
            }
            case 8: {
                return parent.getFirstChild() == node;
            }
            case 17: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 33: {
                return false;
            }
        }
        return this.canHaveBlankLinesBefore(parent);
    }

    private void printBlankLinesBefore(JavaNode node, CommonHiddenStreamToken comment, boolean first, NodeWriter out) throws IOException {
        int blankLines = 0;
        int blankLinesForComment = 0;
        block0 : switch (comment.getType()) {
            case 174: {
                switch (out.last) {
                    case 68: 
                    case 174: {
                        break block0;
                    }
                    case 4: 
                    case 6: 
                    case 13: 
                    case 17: 
                    case 18: 
                    case 67: 
                    case 70: 
                    case 176: {
                        if (first) {
                            blankLines = this.getBlankLinesBefore(node, out);
                        }
                        blankLinesForComment = 1;
                        break block0;
                    }
                }
                if (first) {
                    blankLines = this.getBlankLinesBefore(node, out);
                }
                blankLinesForComment = this.getCommentBlankLines(comment, node.getPreviousSibling(), out);
                break;
            }
            case 4: {
                switch (out.last) {
                    case 4: 
                    case 68: {
                        break block0;
                    }
                    case 6: 
                    case 13: 
                    case 17: 
                    case 18: 
                    case 67: 
                    case 70: 
                    case 174: 
                    case 176: {
                        if (first) {
                            blankLines = Math.max(this.getBlankLinesBefore(node, out), out.newline ? 0 : 1);
                        }
                        blankLinesForComment = this.getCommentBlankLines(comment, node.getPreviousSibling(), out);
                        break block0;
                    }
                }
                if (first) {
                    blankLines = Math.max(this.getBlankLinesBefore(node, out), out.newline ? 0 : 1);
                }
                blankLinesForComment = this.getCommentBlankLines(comment, node.getPreviousSibling(), out);
                break;
            }
            case 176: {
                switch (out.last) {
                    case 68: 
                    case 176: {
                        break block0;
                    }
                    case 4: 
                    case 67: 
                    case 70: 
                    case 174: {
                        if (first) {
                            blankLines = this.getBlankLinesBefore(node, out);
                        }
                        blankLinesForComment = 1;
                        break block0;
                    }
                }
                if (first) {
                    blankLines = this.getBlankLinesBefore(node, out);
                }
                blankLinesForComment = this.getCommentBlankLines(comment, node.getPreviousSibling(), out);
                break;
            }
            case 67: {
                switch (out.last) {
                    case 4: 
                    case 67: 
                    case 70: 
                    case 174: 
                    case 176: {
                        if (first) {
                            blankLines = this.getBlankLinesBefore(node, out);
                        }
                        blankLinesForComment = 1;
                        break block0;
                    }
                    case 68: {
                        break block0;
                    }
                }
                if (first) {
                    blankLines = this.getBlankLinesBefore(node, out);
                }
                blankLinesForComment = this.getCommentBlankLines(comment, node.getPreviousSibling(), out);
                break;
            }
            case 70: {
                switch (out.last) {
                    case 4: 
                    case 67: 
                    case 70: 
                    case 174: 
                    case 176: {
                        if (first) {
                            blankLines = this.getBlankLinesBefore(node, out);
                        }
                        blankLinesForComment = 1;
                        break block0;
                    }
                    case 68: {
                        break block0;
                    }
                }
                if (first) {
                    blankLines = this.getBlankLinesBefore(node, out);
                }
                blankLinesForComment = this.getCommentBlankLines(comment, node.getPreviousSibling(), out);
            }
        }
        if (this.canHaveBlankLinesBefore(node)) {
            out.printBlankLines(Math.max(blankLines, blankLinesForComment));
        } else if (out.expression != null) {
            if (this.isChildOf(out.expression, node)) {
                out.printBlankLines(blankLinesForComment - out.blankLines);
            }
        } else {
            out.printBlankLines(Math.max(blankLines, blankLinesForComment));
        }
    }

    private void printBlankLinesBetweenComments(CommonHiddenStreamToken comment, CommonHiddenStreamToken previousComment, int keepLines, NodeWriter out) throws IOException {
        int lines = 0;
        switch (previousComment.getType()) {
            case 70: {
                break;
            }
            default: {
                lines = comment.getLine() - previousComment.getLine() - 1;
            }
        }
        if (lines > keepLines) {
            out.printBlankLines(keepLines);
        } else if (lines > 0) {
            out.printBlankLines(lines);
        }
    }

    private void printCommentAfter(AST node, CommonHiddenStreamToken comment, boolean newlineBefore, boolean newlineAfter, boolean whitespaceBefore, boolean first, NodeWriter out) throws IOException {
        int last = out.last;
        boolean restore = false;
        int indent = 0;
        if (comment.getColumn() == 1 && !settings.getBoolean(ConventionKeys.INDENT_FIRST_COLUMN_COMMENT, true)) {
            restore = true;
            indent = out.getIndentLevel();
            out.setIndentLevel(0);
        }
        if (whitespaceBefore) {
            out.print(out.getString(settings.getInt(ConventionKeys.INDENT_SIZE_COMMENT_ENDLINE, 1)), 173);
        }
        switch (comment.getType()) {
            case 4: {
                throw new IllegalArgumentException("no valid endline comment -- " + comment + "(attached to " + node + RPAREN);
            }
            case 174: {
                out.print(comment.getText(), comment.getType());
                break;
            }
            case 176: {
                this.printMultiLineComment(comment, 176, out);
                break;
            }
            case 70: {
                this.printSpecialComment(comment, out);
                break;
            }
            case 67: {
                out.print(comment.getText(), comment.getType());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type -- " + comment);
            }
        }
        if (restore) {
            out.setIndentLevel(indent);
        }
        if (newlineAfter || this.shouldForceNewline(node, comment)) {
            out.printNewline();
        }
        out.last = last;
    }

    private void printCommentBefore(JavaNode node, CommonHiddenStreamToken comment, boolean first, boolean newlineBefore, boolean newlineAfter, NodeWriter out) throws IOException {
        if (newlineBefore) {
            this.printBlankLinesBefore(node, comment, first, out);
        }
        boolean retain = false;
        int indent = 0;
        if (comment.getType() == 70 || comment.getColumn() == 1 && !settings.getBoolean(ConventionKeys.INDENT_FIRST_COLUMN_COMMENT, true)) {
            indent = out.getIndentLevel();
            out.setIndentLevel(0);
            retain = true;
        }
        int type = comment.getType();
        switch (type) {
            case 174: {
                out.print(comment.getText(), type);
                break;
            }
            case 4: {
                ExtendedToken t = (ExtendedToken)comment;
                Node c = t.getComment();
                if (c != null) {
                    ((JavadocPrinter)PrinterFactory.create((AST)c, out)).print((AST)node, (AST)c, out);
                    break;
                }
                this.printMultiLineComment(comment, 4, out);
                break;
            }
            case 176: {
                this.printMultiLineComment(comment, 176, out);
                break;
            }
            case 70: {
                this.printSpecialComment(comment, out);
                break;
            }
            case 67: {
                out.print(comment.getText(), comment.getType());
                out.printNewline();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type -- " + comment);
            }
        }
        if (retain) {
            out.setIndentLevel(indent);
        }
        if (newlineAfter) {
            out.printNewline();
        }
    }

    private void printMultiLineComment(CommonHiddenStreamToken comment, int type, NodeWriter out) throws IOException {
        String[] lines = null;
        boolean format = settings.getBoolean(ConventionKeys.COMMENT_FORMAT_MULTI_LINE, false);
        lines = format ? StringHelper.wrapStringToArray(comment.getText(), Integer.MAX_VALUE, out.lineSeparator, false, 4) : comment.getText().split("/\r\n|\n|\r/");
        int lastLine = lines.length - 1;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() > 0) {
                out.print(StringHelper.trimTrailing(lines[i]), type);
            }
            if (i >= lastLine) continue;
            out.printNewline();
        }
    }

    private void printSpecialComment(CommonHiddenStreamToken comment, NodeWriter out) throws IOException {
        String[] lines = StringHelper.split(comment.getText(), out.originalLineSeparator);
        int lastLine = lines.length - 1;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() > 0) {
                out.print(StringHelper.trimTrailing(lines[i]), 70);
            }
            if (i >= lastLine) continue;
            out.printNewline();
        }
    }

    private boolean shouldForceNewline(AST node, CommonHiddenStreamToken comment) {
        switch (comment.getType()) {
            case 67: 
            case 70: 
            case 174: {
                if (settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false)) {
                    return !JavaNodeHelper.isBlockNext(node);
                }
                return true;
            }
        }
        return false;
    }

    protected void prepareComment(JavaNode lcurly, JavaNode rcurly, NodeWriter out) {
        if (out.mode == 2) {
            return;
        }
        String currentFile = "<unknown>";
        if (!out.getFilename().equals("<unknown>")) {
            currentFile = out.getFilename();
        } else {
            JavaNode tag = lcurly;
            System.out.println(out.mode + COMMA + 1 + COMMA + 2);
            out.state.args[0] = currentFile;
            out.state.args[1] = new Integer(out.line);
            out.state.args[2] = new Integer(out.column);
            out.state.args[3] = "File name is unknown! Line-";
            out.state.args[4] = new Integer(((Node)tag).getStartLine());
            out.state.args[5] = tag;
            Loggers.PRINTER_JAVADOC.info((Object)Loggers.fmt("TAG_ADD_MISSING", out.state.args), null);
        }
        String commentForNode = this.getNodeComment(lcurly, out, currentFile);
        CommonHiddenStreamToken firstComment = rcurly.getHiddenAfter();
        if (firstComment == null) {
            firstComment = new CommonHiddenStreamToken(174, commentForNode);
            firstComment.setLine(rcurly.getEndLine());
            rcurly.setHiddenAfter(firstComment);
            JavaNode tag = rcurly;
            out.state.args[0] = currentFile;
            out.state.args[1] = new Integer(out.line);
            out.state.args[2] = new Integer(out.column);
            out.state.args[3] = commentForNode;
            out.state.args[4] = " (Line " + ((Node)tag).getStartLine() + RPAREN;
            out.state.args[5] = tag;
            Loggers.PRINTER_JAVADOC.warn((Object)Loggers.fmt("TAG_ADD_MISSING", out.state.args), null);
        } else if (!firstComment.getText().equals(commentForNode)) {
            JavaNode tag = rcurly;
            out.state.args[0] = currentFile;
            out.state.args[1] = new Integer(out.line);
            out.state.args[2] = new Integer(out.column);
            out.state.args[3] = firstComment.getText();
            out.state.args[4] = commentForNode;
            out.state.args[5] = tag;
            Loggers.PRINTER_JAVADOC.warn((Object)Loggers.fmt("TAG_MISSPELLED_NAME", out.state.args), null);
            firstComment.setText(commentForNode);
        }
    }

    private String getNodeComment(JavaNode node, NodeWriter out, String currentFile) {
        JavaNode parent = node.getParent();
        String comment = "// mt comment";
        JavaNode anext = null;
        if (parent != null) {
            switch (parent.getType()) {
                case 119: {
                    if (node.getPreviousSibling().getType() == 120) {
                        comment = "// end else";
                        break;
                    }
                    if (parent.getPreviousSibling().getType() == 120) {
                        comment = "// end else if";
                        break;
                    }
                    comment = "// end if";
                    break;
                }
                case 126: {
                    comment = "// end switch";
                    break;
                }
                case 120: {
                    comment = "// end if else";
                    break;
                }
                case 133: {
                    comment = "// end catch";
                    break;
                }
                case 131: {
                    comment = "// end try";
                    break;
                }
                case 121: {
                    comment = "// end while";
                    break;
                }
                case 122: {
                    comment = "// end do";
                    break;
                }
                case 129: {
                    comment = "// end for";
                    break;
                }
                case 49: {
                    comment = "// end enum";
                    break;
                }
                case 132: {
                    comment = "// end finally";
                    break;
                }
                case 166: {
                    comment = "// end new";
                    break;
                }
                case 66: {
                    comment = "// end case";
                    break;
                }
                case 69: {
                    comment = "// end synchronized";
                    break;
                }
                case 18: {
                    anext = (JavaNode)parent.getFirstChild();
                    while ((anext = (JavaNode)anext.getNextSibling()) != null && anext.getType() != 77) {
                    }
                    if (anext != null) {
                        comment = "// end " + anext.getText();
                        break;
                    }
                    comment = "// TODO not found ";
                    break;
                }
                case 74: {
                    comment = "// end static";
                    break;
                }
                case 12: {
                    anext = (JavaNode)parent.getFirstChild();
                    while ((anext = (JavaNode)anext.getNextSibling()) != null && anext.getType() != 77) {
                    }
                    if (anext != null) {
                        comment = "// end " + anext.getText() + PARENTHESES;
                        break;
                    }
                    comment = "// TODO not found ";
                    break;
                }
                case 11: {
                    JavaNode prev = node;
                    while ((prev = prev.getPreviousSibling()) != null && prev.getType() != 77) {
                    }
                    if (prev != null) {
                        comment = "// end " + prev.getText() + PARENTHESES;
                        break;
                    }
                    comment = "// TODO not found ";
                    break;
                }
                case 17: {
                    anext = (JavaNode)parent.getFirstChild();
                    while ((anext = (JavaNode)anext.getNextSibling()) != null && anext.getType() != 77) {
                    }
                    if (anext != null) {
                        comment = "// end " + anext.getText();
                        break;
                    }
                    comment = "// TODO not found ";
                    break;
                }
                default: {
                    comment = "";
                    JavaNode tag = node;
                    out.state.args[0] = currentFile;
                    out.state.args[1] = new Integer(out.line);
                    out.state.args[2] = new Integer(out.column);
                    out.state.args[3] = "Unknown code " + new StringBuffer().append(parent);
                    out.state.args[4] = new StringBuffer().append(parent);
                    out.state.args[5] = tag;
                    Loggers.PRINTER_JAVADOC.warn((Object)Loggers.fmt("GENERATE_COMMENT", out.state.args), null);
                }
            }
        }
        return comment;
    }

    protected int countChildrenLines(JavaNode n, int current) {
        while (n != null) {
            current += n.nlAfter;
            n = (JavaNode)n.getNextSibling();
        }
        return current;
    }
}

