/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class ArrayInitializerPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new ArrayInitializerPrinter();

    protected ArrayInitializerPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    @Override
    public void print(AST node, NodeWriter out) throws IOException {
        int maxElementsPerLine = AbstractPrinter.settings.getInt(ConventionKeys.LINE_WRAP_ARRAY_ELEMENTS, 0);
        boolean wrapAsNeeded = maxElementsPerLine == 0;
        int lineLength = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        boolean bracesPadding = AbstractPrinter.settings.getBoolean(ConventionKeys.PADDING_BRACES, true);
        boolean spaceAfterComma = AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        int numElements = 0;
        int last = out.last;
        boolean multiArray = this.hasArrayChild(node);
        if (multiArray) {
            maxElementsPerLine = 1;
            wrapAsNeeded = false;
        }
        if (this.isFirstOfMultiArray((JavaNode)node)) {
            if (!out.newline) {
                out.printNewline();
            }
            this.printIndentation(out);
        }
        JavaNode firstElement = (JavaNode)node.getFirstChild();
        if (maxElementsPerLine != Integer.MAX_VALUE && out.mode == 1) {
            TestNodeWriter tester = out.testers.get();
            for (JavaNode child = firstElement; child != null; child = child.getNextSibling()) {
                switch (child.getType()) {
                    case 83: {
                        break;
                    }
                    default: {
                        ++numElements;
                    }
                }
                PrinterFactory.create((AST)child, out).print((AST)child, tester);
                if (wrapAsNeeded && tester.length > lineLength) break;
            }
            if (!(numElements <= maxElementsPerLine || wrapAsNeeded && out.column + tester.length <= lineLength)) {
                if (!out.newline) {
                    if (out.getIndentLength() != out.column - 1 && AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false) && ((JavaNode)node).getParent().getType() != 32) {
                        out.printNewline();
                        this.printIndentation(out);
                    } else {
                        switch (last) {
                            case 20: {
                                if (!AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_BEFORE_BRACES, true)) break;
                                out.print(" ", out.last);
                            }
                        }
                    }
                }
                if (this.printCommentsBefore(node, false, out) && out.newline) {
                    this.printIndentation(out);
                }
                out.print("{", 5);
                this.printCommentsAfter(node, false, false, out);
                Marker marker = null;
                if (AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_DEEP, false)) {
                    if (!out.state.markers.isMarked()) {
                        marker = out.state.markers.add(out.line, out.column - 2);
                        out.state.markers.add(out.line, out.state.markers.getLast().column + out.indentSize);
                    } else {
                        marker = out.state.markers.add(out.line, out.state.markers.getLast().column + out.indentSize);
                    }
                } else {
                    out.indent();
                }
                boolean wrapped = false;
                if (firstElement.getType() != 32 && (!multiArray || this.hasArrayParent(node))) {
                    out.printNewline();
                    this.printIndentation(out);
                    wrapped = true;
                }
                int count = 0;
                JavaNode rcurly = null;
                block21: for (JavaNode child = firstElement; child != null; child = (JavaNode)child.getNextSibling()) {
                    switch (child.getType()) {
                        case 83: {
                            if (!child.hasCommentsAfter()) {
                                out.print(",", 83);
                                continue block21;
                            }
                            out.print(",", 83);
                            wrapped = this.printCommentsAfter((AST)child, false, !this.isLastElement(child), out);
                            count = 0;
                            continue block21;
                        }
                        case 6: {
                            rcurly = child;
                            continue block21;
                        }
                        default: {
                            ++count;
                            if (!wrapped) {
                                int blankLines;
                                tester.reset();
                                PrinterFactory.create((AST)child, out).print((AST)child, tester);
                                if (!wrapAsNeeded && count > maxElementsPerLine || wrapAsNeeded && out.column + tester.length > lineLength) {
                                    if (!child.hasCommentsBefore() || child.getHiddenBefore().getLine() != child.getStartLine()) {
                                        out.printNewline();
                                        this.printIndentation(out);
                                        wrapped = true;
                                        count = 1;
                                        blankLines = this.getOriginalBlankLines(child);
                                        if (blankLines > 0) {
                                            out.printBlankLines(blankLines);
                                        }
                                    }
                                } else {
                                    blankLines = this.getOriginalBlankLines(child);
                                    if (blankLines > 0) {
                                        out.printNewline();
                                        this.printIndentation(out);
                                        wrapped = true;
                                        count = 1;
                                        out.printBlankLines(blankLines);
                                    } else if (spaceAfterComma && count > 1) {
                                        out.print(" ", 173);
                                    }
                                }
                            }
                            wrapped = false;
                            PrinterFactory.create((AST)child, out).print((AST)child, out);
                        }
                    }
                }
                if (marker != null) {
                    out.state.markers.remove(marker);
                } else {
                    out.unindent();
                }
                if (!out.newline) {
                    out.printNewline();
                }
                this.printIndentation(out);
                this.printCommentsBefore((AST)rcurly, false, out);
                out.print("}", 32);
                this.printCommentsAfter((AST)rcurly, true, false, out);
                out.testers.release(tester);
                return;
            }
            out.testers.release(tester);
        }
        switch (last) {
            case 20: {
                if (!AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_BEFORE_BRACES, true)) break;
                out.print(" ", out.last);
            }
        }
        if (this.printCommentsBefore(node, false, out) && out.newline) {
            this.printIndentation(out);
            out.print("{", 5);
        } else if (bracesPadding) {
            out.print("{ ", 5);
        } else {
            out.print("{", 5);
        }
        this.printCommentsAfter(node, false, false, out);
        out.indent();
        String comma = spaceAfterComma ? ", " : ",";
        JavaNode rcurly = null;
        block22: for (JavaNode child = (JavaNode)node.getFirstChild(); child != null; child = (JavaNode)child.getNextSibling()) {
            switch (child.getType()) {
                case 83: {
                    this.printCommentsBefore((AST)child, out);
                    if (!child.hasCommentsAfter()) {
                        if (this.isLast((AST)child)) {
                            out.print(",", 83);
                            continue block22;
                        }
                        out.print(comma, 83);
                        continue block22;
                    }
                    out.print(",", 83);
                    this.printCommentsAfter((AST)child, false, true, out);
                    continue block22;
                }
                default: {
                    switch (child.getType()) {
                        case 31: {
                            JavaNode c = (JavaNode)child.getFirstChild();
                            if (c.hasCommentsBefore()) {
                                out.printNewline();
                                this.printIndentation(out);
                                bracesPadding = false;
                            }
                            PrinterFactory.create((AST)child, out).print((AST)child, out);
                            if (!c.hasCommentsAfter()) continue block22;
                            bracesPadding = false;
                            continue block22;
                        }
                        case 6: {
                            rcurly = child;
                            if (!child.hasCommentsBefore()) continue block22;
                            bracesPadding = false;
                            continue block22;
                        }
                        default: {
                            PrinterFactory.create((AST)child, out).print((AST)child, out);
                            if (!child.hasCommentsAfter()) continue block22;
                            bracesPadding = false;
                        }
                    }
                }
            }
        }
        out.unindent();
        this.printCommentsBefore((AST)rcurly, false, out);
        if (out.newline) {
            this.printIndentation(out);
        }
        if (!out.newline && bracesPadding) {
            out.print(" }", 6);
        } else {
            out.print("}", 6);
        }
        this.printCommentsAfter((AST)rcurly, false, false, out);
    }

    private boolean isFirstOfMultiArray(JavaNode node) {
        JavaNode parent = node.getParent();
        return parent.getType() == 32 && node.getPreviousSibling() == parent;
    }

    private boolean isLast(AST node) {
        return node.getNextSibling().getType() == 6;
    }

    private boolean isLastElement(JavaNode node) {
        AST next = node.getNextSibling();
        return next == null || next.getType() == 6;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean hasArrayChild(AST node) {
        AST child = node.getFirstChild();
        while (child != null) {
            switch (child.getType()) {
                case 32: {
                    return true;
                }
                case 31: {
                    AST child1 = child.getFirstChild();
                    switch (child1.getType()) {
                        case 166: {
                            if (!this.hasArrayChild(child1.getFirstChild())) break;
                            return true;
                        }
                    }
                    break;
                }
            }
            child = child.getNextSibling();
        }
        return false;
    }

    private boolean hasArrayParent(AST node) {
        JavaNode parent = ((JavaNode)node).getParent();
        switch (parent.getType()) {
            case 32: {
                return true;
            }
            case 166: {
                return parent.getParent().getParent().getType() == 32;
            }
        }
        return false;
    }
}

