/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class ArrayTypePrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new ArrayTypePrinter();

    protected ArrayTypePrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    @Override
    public void print(AST node, NodeWriter out) throws IOException {
        AST child;
        boolean bracketsAfterIdentifier = AbstractPrinter.settings.getBoolean(ConventionKeys.ARRAY_BRACKETS_AFTER_IDENT, false);
        if (child != null) {
            block4: for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                switch (child.getType()) {
                    case 31: {
                        if (AbstractPrinter.settings.getBoolean(ConventionKeys.PADDING_BRACKETS, false)) {
                            out.print("[ ", 75);
                            PrinterFactory.create(child, out).print(child, out);
                            out.print(" ]", 76);
                            continue block4;
                        }
                        out.print("[", 75);
                        PrinterFactory.create(child, out).print(child, out);
                        out.print("]", 76);
                        continue block4;
                    }
                    case 20: {
                        this.print(child, out);
                        if (child.getNextSibling() != null) continue block4;
                        if (bracketsAfterIdentifier && this.canMoveBrackets(node)) {
                            ++out.state.arrayBrackets;
                            continue block4;
                        }
                        out.print("[]", 76);
                        continue block4;
                    }
                    default: {
                        PrinterFactory.create(child, out).print(child, out);
                        if (bracketsAfterIdentifier && this.canMoveBrackets(node)) {
                            ++out.state.arrayBrackets;
                            continue block4;
                        }
                        if (AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_BEFORE_BRACKETS_TYPES, false)) {
                            out.print(" []", 20);
                            continue block4;
                        }
                        out.print("[]", 76);
                    }
                }
            }
        } else if (AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_BEFORE_BRACKETS_TYPES, false)) {
            out.print(" []", 20);
        } else {
            out.print("[]", 76);
        }
        out.last = 20;
    }

    private boolean canMoveBrackets(AST node) {
        JavaNode parent = ((JavaNode)node).getParent();
        switch (parent.getType()) {
            case 16: {
                switch (parent.getParent().getType()) {
                    case 12: 
                    case 26: 
                    case 153: {
                        return false;
                    }
                }
                break;
            }
            case 26: 
            case 166: {
                return false;
            }
            case 20: {
                return this.canMoveBrackets((AST)parent);
            }
        }
        AST next = node.getNextSibling();
        if (next != null) {
            switch (next.getType()) {
                case 109: {
                    return false;
                }
            }
        }
        return true;
    }
}

