/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.OperatorPrinter;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class AssignmentPrinter
extends OperatorPrinter {
    static final int OFFSET_NONE = -1;
    private static final AssignmentPrinter INSTANCE = new AssignmentPrinter();

    private AssignmentPrinter() {
    }

    public static AssignmentPrinter getInstance() {
        return INSTANCE;
    }

    @Override
    public void print(AST node, NodeWriter out) throws IOException {
        this.print(node, false, out);
    }

    public void print(AST node, boolean wrapAfterAssign, NodeWriter out) throws IOException {
        this.logIssues(node, out);
        this.printCommentsBefore(node, out);
        boolean wrapLines = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP, true) && out.mode == 1;
        boolean preferWrapAfterLeftParen = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_LEFT_PAREN, false);
        boolean preferWrapAfterAssign = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_ASSIGN, false);
        boolean padding = AbstractPrinter.settings.getBoolean(ConventionKeys.PADDING_ASSIGNMENT_OPERATORS, true);
        int lineLength = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        boolean indentStandard = !AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_DEEP, false);
        boolean alignVarAssigns = AbstractPrinter.settings.getBoolean(ConventionKeys.ALIGN_VAR_DECL_ASSIGNS, AbstractPrinter.settings.getBoolean(ConventionKeys.ALIGN_VAR_ASSIGNS, false));
        AST expr = node.getFirstChild();
        if (this.isPartOfDeclaration(node)) {
            if (wrapLines) {
                boolean indent;
                JavaNode parent = ((JavaNode)node).getParent();
                if (!wrapAfterAssign && alignVarAssigns && !((JavaNode)node).getParent().hasJavadocComment(AbstractPrinter.settings.getBoolean(ConventionKeys.DONT_COMMENT_JAVADOC_WHEN_ML, false))) {
                    if (this.isNewChunk((AST)parent, 13)) {
                        out.state.assignOffset = -1;
                    }
                    this.alignAssignment(node, true, out);
                }
                boolean bl = indent = indentStandard || wrapAfterAssign || preferWrapAfterAssign || preferWrapAfterLeftParen;
                if (indent) {
                    out.indent();
                }
                Marker marker = null;
                if (wrapAfterAssign) {
                    if (padding) {
                        out.print(" =", 108);
                    } else {
                        out.print("=", 108);
                    }
                    if (!this.printCommentsAfter(node, false, true, out)) {
                        out.printNewline();
                    }
                    this.printIndentation(out);
                    marker = out.state.markers.add();
                    PrinterFactory.create(expr, out).print(expr, out);
                } else if (wrapLines) {
                    TestNodeWriter tester = out.testers.get();
                    PrinterFactory.create(expr, out).print(expr, tester);
                    if (preferWrapAfterAssign && tester.length + out.column + (padding ? 3 : 1) > lineLength) {
                        if (padding) {
                            out.print(" =", 108);
                        } else {
                            out.print("=", 108);
                        }
                        if (!this.printCommentsAfter(node, false, true, out)) {
                            out.printNewline();
                        }
                        this.printIndentation(out);
                    } else if (indentStandard) {
                        if (out.column > lineLength) {
                            if (padding) {
                                out.print(" =", 108);
                            } else {
                                out.print("=", 108);
                            }
                            if (!this.printCommentsAfter(node, false, true, out)) {
                                out.printNewline();
                            }
                            this.printIndentation(out);
                        } else {
                            if (padding) {
                                out.print(" = ", 108);
                            } else {
                                out.print("=", 108);
                            }
                            this.printCommentsAfter(node, false, false, out);
                            if (out.newline) {
                                this.printIndentation(out);
                            }
                        }
                    } else if (padding) {
                        marker = out.state.markers.add(out.line, out.column + 2);
                        out.print(" = ", 108);
                        this.printCommentsAfter(node, false, false, out);
                        if (out.newline) {
                            this.printIndentation(out);
                        }
                    } else {
                        out.print("=", 108);
                        out.state.markers.add();
                        this.printCommentsAfter(node, false, false, out);
                        if (out.newline) {
                            this.printIndentation(out);
                        }
                    }
                    PrinterFactory.create(expr, out).print(expr, out);
                    out.testers.release(tester);
                    if (marker != null) {
                        out.state.markers.remove(marker);
                    }
                } else {
                    if (padding) {
                        out.print(" = ", 108);
                    } else {
                        out.print("=", 108);
                    }
                    PrinterFactory.create(expr, out).print(expr, out);
                }
                if (indent) {
                    out.unindent();
                }
            } else {
                if (padding) {
                    out.print(" = ", 108);
                } else {
                    out.print("=", 108);
                }
                PrinterFactory.create(expr, out).print(expr, out);
            }
        } else {
            alignVarAssigns = AbstractPrinter.settings.getBoolean(ConventionKeys.ALIGN_VAR_ASSIGNS, false);
            AST rhs = this.printLeftHandSide(node, out);
            if (out.mode == 1) {
                boolean indent;
                TestNodeWriter tester = out.testers.get();
                tester.reset(out, false);
                PrinterFactory.create(rhs, out).print(rhs, tester);
                boolean bl = indent = indentStandard || wrapAfterAssign || preferWrapAfterAssign || preferWrapAfterLeftParen;
                if (indent) {
                    out.indent();
                }
                Marker marker = null;
                if (preferWrapAfterAssign && wrapLines && out.getIndentLength() < out.column && tester.line > 1) {
                    if (padding) {
                        out.print(" =", 108);
                    } else {
                        out.print("=", 108);
                    }
                    out.printNewline();
                    this.printIndentation(out);
                    marker = out.state.markers.add();
                } else {
                    if (alignVarAssigns) {
                        JavaNode parent = ((JavaNode)node).getParent();
                        if (this.isNewChunk((AST)parent, 108) || out.state.anonymousInnerClass) {
                            out.state.assignOffset = -1;
                        }
                        if (this.canAlign((JavaNode)node)) {
                            this.alignAssignment(node, false, out);
                        }
                    }
                    if (padding) {
                        marker = out.state.markers.add(out.line, out.column + 2);
                        out.print(" = ", 108);
                    } else {
                        out.print("=", 108);
                        marker = out.state.markers.add();
                    }
                    out.testers.release(tester);
                }
                this.printRightHandSide(rhs, out);
                if (indent) {
                    out.unindent();
                }
                if (marker != null) {
                    out.state.markers.remove(marker);
                }
            } else {
                if (padding) {
                    out.print(" = ", 108);
                } else {
                    out.print("=", 108);
                }
                this.printRightHandSide(rhs, out);
            }
        }
    }

    void align(int amount, NodeWriter out) throws IOException {
        out.print(out.getString(amount), 173);
    }

    private boolean isAssignment(AST node) {
        AST child = node.getFirstChild();
        switch (child.getType()) {
            case 108: {
                switch (child.getFirstChild().getType()) {
                    case 79: {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean isNewChunk(AST node, int type) {
        JavaNode n = (JavaNode)node;
        switch (n.getParent().getType()) {
            case 38: {
                return true;
            }
        }
        if (AbstractPrinter.settings.getBoolean(ConventionKeys.CHUNKS_BY_COMMENTS, true) && n.hasCommentsBefore()) {
            return true;
        }
        int maxLinesBetween = AbstractPrinter.settings.getInt(ConventionKeys.BLANK_LINES_KEEP_UP_TO, 1);
        if (maxLinesBetween > 0 && AbstractPrinter.settings.getBoolean(ConventionKeys.CHUNKS_BY_BLANK_LINES, true)) {
            JavaNode prev = n.getPreviousSibling();
            switch (type) {
                case 13: {
                    switch (prev.getType()) {
                        case 13: {
                            int totalLines;
                            return maxLinesBetween > 0 && (totalLines = this.countChildrenLines((JavaNode)n.getPreviousSibling().getFirstChild(), 0)) - 1 > maxLinesBetween;
                        }
                    }
                    break;
                }
                case 108: {
                    switch (prev.getType()) {
                        case 31: {
                            int totalLines;
                            return this.isAssignment((AST)prev) && maxLinesBetween > 0 && (totalLines = this.countChildrenLines((JavaNode)n.getPreviousSibling().getFirstChild(), 0)) - 1 > maxLinesBetween;
                        }
                        case 13: {
                            return maxLinesBetween > 0 && n.getStartLine() - n.getPreviousSibling().getStartLine() - 1 > maxLinesBetween;
                        }
                    }
                }
            }
        }
        return false;
    }

    private AST getNextSibling(AST node, JavaNode parent) {
        switch (parent.getType()) {
            case 13: 
            case 31: {
                return parent.getNextSibling();
            }
            case 79: 
            case 82: 
            case 84: 
            case 108: 
            case 149: 
            case 150: {
                return this.getNextSibling((AST)parent, parent.getParent());
            }
        }
        throw new IllegalArgumentException("unexpected parent node --" + parent);
    }

    private boolean isPartOfDeclaration(AST node) {
        return ((JavaNode)node).getParent().getType() == 13;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void alignAssignment(AST node, boolean variableAssign, NodeWriter out) throws IOException {
        JavaNode parent = ((JavaNode)node).getParent();
        AST next = this.getNextSibling(node, parent);
        if (out.state.assignOffset != -1) {
            if (out.column < out.state.assignOffset) {
                this.align(out.state.assignOffset - out.column, out);
            }
            if (next == null) return;
            switch (next.getType()) {
                case 13: {
                    if (!this.isNewChunk(next, 13)) return;
                    out.state.assignOffset = -1;
                    return;
                }
                case 31: {
                    if (this.isAssignment(next) && !this.isNewChunk(next, 108)) return;
                    out.state.assignOffset = -1;
                    return;
                }
                default: {
                    out.state.assignOffset = -1;
                    return;
                }
            }
        } else {
            if (next == null) return;
            switch (next.getType()) {
                case 31: {
                    if (variableAssign || !this.isAssignment(next)) {
                        out.state.assignOffset = -1;
                        return;
                    }
                    int length = 0;
                    TestNodeWriter tester = out.testers.get();
                    block15: for (JavaNode def = parent; def != null; def = def.getNextSibling()) {
                        switch (def.getType()) {
                            case 31: {
                                AST t;
                                if (!this.isAssignment((AST)def)) break block15;
                                tester.reset();
                                AST rhs = def.getFirstChild().getFirstChild();
                                PrinterFactory.create(rhs, out).print(rhs, tester);
                                if (tester.length > length) {
                                    length = tester.length;
                                }
                                if ((t = def.getNextSibling()) != null && this.isNewChunk(t, 108)) break block15;
                            }
                            default: {
                                continue block15;
                            }
                        }
                    }
                    out.state.assignOffset = length + out.getIndentLength() + 1;
                    if (out.column < out.state.assignOffset) {
                        this.align(out.state.assignOffset - out.column, out);
                    }
                    out.testers.release(tester);
                    return;
                }
                case 13: {
                    if (!variableAssign) {
                        out.state.assignOffset = -1;
                        return;
                    }
                    int length = -1;
                    TestNodeWriter tester = out.testers.get();
                    boolean alignVariables = AbstractPrinter.settings.getBoolean(ConventionKeys.ALIGN_VAR_IDENTS, false);
                    block16: for (JavaNode def = parent; def != null; def = def.getNextSibling()) {
                        switch (def.getType()) {
                            case 31: {
                                if (!this.isAssignment((AST)def)) break block16;
                                tester.reset();
                                AST rhs = def.getFirstChild().getFirstChild();
                                PrinterFactory.create(rhs, out).print(rhs, tester);
                                if (tester.length > length) {
                                    length = tester.length;
                                }
                                if (!this.isNewChunk((AST)def, 108)) continue block16;
                                break block16;
                            }
                            case 13: {
                                AST n;
                                tester.reset();
                                AST defModifier = def.getFirstChild();
                                PrinterFactory.create(defModifier, out).print(defModifier, tester);
                                AST defType = defModifier.getNextSibling();
                                PrinterFactory.create(defType, out).print(defType, tester);
                                if (alignVariables && out.state.variableOffset != -1 && out.state.variableOffset > tester.length) {
                                    tester.length = out.state.variableOffset - out.getIndentLength() - 1;
                                }
                                AST defIdent = defType.getNextSibling();
                                PrinterFactory.create(defIdent, out).print(defIdent, tester);
                                ++tester.length;
                                if (tester.length > length) {
                                    length = tester.length;
                                }
                                if ((n = def.getNextSibling()) == null || !this.isNewChunk(n, 13)) continue block16;
                                break block16;
                            }
                        }
                    }
                    out.testers.release(tester);
                    out.state.assignOffset = length + out.getIndentLength() + 1;
                    if (out.column >= out.state.assignOffset) return;
                    this.align(out.state.assignOffset - out.column, out);
                    return;
                }
                default: {
                    out.state.assignOffset = -1;
                }
            }
        }
    }

    private boolean canAlign(JavaNode node) {
        JavaNode parent = node.getParent();
        if (parent != null) {
            switch (parent.getType()) {
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 126: 
                case 129: {
                    return false;
                }
                case 9: 
                case 10: {
                    return true;
                }
            }
            return this.canAlign(parent);
        }
        return false;
    }
}

