/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.CommonHiddenStreamToken;
import antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.JavaNodeModifier;
import de.hunsicker.jalopy.language.antlr.ExtendedToken;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.language.antlr.Node;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.JavadocPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Environment;
import java.io.IOException;
import java.util.List;

abstract class BasicDeclarationPrinter
extends AbstractPrinter {
    static final String GENERATED_COMMENT = "<GENERATED_JAVADOC_COMMENT>";
    private static final String DELIMETER = "|";
    private int privacyMask = 7;

    protected BasicDeclarationPrinter() {
    }

    @Override
    public void print(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        this.logIssues(node, out);
    }

    protected void addClassComment(JavaNode node, NodeWriter out) {
        String t = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CLASS, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */").replaceAll("\\*/", "").trim();
        StringBuffer buf = new StringBuffer(t);
        String bottomText = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_BOTTOM, " */");
        String leadingSeparator = bottomText.substring(0, bottomText.indexOf(42) + 1);
        if (!JavadocPrinter.getValidTypeNames((AST)node, 23).isEmpty()) {
            buf.append(leadingSeparator);
            buf.append(DELIMETER);
            this.addParameters(buf, (AST)node, AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_PARAM, " * @param $paramType$ DOCUMENT ME!"), out.environment);
        }
        String bottom = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_BOTTOM, " */");
        buf.append(bottom);
        Node text = (Node)out.getJavaNodeFactory().create(40, out.environment.interpolate(buf.toString()));
        Node comment = (Node)out.getJavaNodeFactory().create(4, GENERATED_COMMENT);
        comment.setFirstChild((AST)text);
        ExtendedToken token = out.getCompositeFactory().getExtendedTokenFactory().create(4, null);
        token.setComment(comment);
        this.addComment(node, token);
    }

    protected void addComment(JavaNode node, NodeWriter out) {
        switch (node.getType()) {
            case 12: {
                if (!this.isEnabled(AbstractPrinter.settings.getInt(ConventionKeys.COMMENT_JAVADOC_METHOD_MASK, 0), (AST)node)) break;
                this.addMethodComment(node, out);
                break;
            }
            case 11: {
                if (!this.isEnabled(AbstractPrinter.settings.getInt(ConventionKeys.COMMENT_JAVADOC_CTOR_MASK, 0), (AST)node)) break;
                this.addCtorComment(node, out);
                break;
            }
            case 13: 
            case 50: {
                if (!this.isEnabled(AbstractPrinter.settings.getInt(ConventionKeys.COMMENT_JAVADOC_VARIABLE_MASK, 0), (AST)node)) break;
                this.addVariableComment(node, out);
                out.state.variableOffset = -1;
                break;
            }
            case 17: {
                if (!this.isEnabled(AbstractPrinter.settings.getInt(ConventionKeys.COMMENT_JAVADOC_CLASS_MASK, 0), (AST)node)) break;
                this.addClassComment(node, out);
                break;
            }
            case 18: 
            case 49: {
                if (!this.isEnabled(AbstractPrinter.settings.getInt(ConventionKeys.COMMENT_JAVADOC_CLASS_MASK, 0), (AST)node)) break;
                this.addInterfaceComment(node, out);
            }
        }
    }

    protected void addInterfaceComment(JavaNode node, NodeWriter out) {
        String t = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_INTERFACE, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */").replaceAll("\\*/", "").trim();
        StringBuffer buf = new StringBuffer(t);
        String bottomText = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_BOTTOM, " */");
        String leadingSeparator = bottomText.substring(0, bottomText.indexOf(42) + 1);
        if (!JavadocPrinter.getValidTypeNames((AST)node, 23).isEmpty()) {
            buf.append(leadingSeparator);
            buf.append(DELIMETER);
            this.addParameters(buf, (AST)node, AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_PARAM, " * @param $paramType$ DOCUMENT ME!"), out.environment);
        }
        buf.append(AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_BOTTOM, " */"));
        Node text = (Node)out.getJavaNodeFactory().create(40, out.environment.interpolate(buf.toString()));
        Node comment = (Node)out.getJavaNodeFactory().create(4, GENERATED_COMMENT);
        comment.setFirstChild((AST)text);
        ExtendedToken token = out.getCompositeFactory().getExtendedTokenFactory().create(4, null);
        token.setComment(comment);
        this.addComment(node, token);
    }

    protected void addMethodComment(JavaNode node, NodeWriter out) {
        AST exceptions;
        AST returnType;
        Node comment = (Node)out.getJavaNodeFactory().create(4, GENERATED_COMMENT);
        StringBuffer buf = new StringBuffer(150);
        String topText = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_TOP, "/**| * DOCUMENT ME!").trim();
        buf.append(topText);
        buf.append(DELIMETER);
        AST parameters = JavaNodeHelper.getFirstChild((AST)node, 23);
        String bottomText = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_BOTTOM, " */");
        String leadingSeparator = bottomText.substring(0, bottomText.indexOf(42) + 1);
        if (!JavadocPrinter.getValidTypeNames((AST)node, 23).isEmpty()) {
            buf.append(leadingSeparator);
            buf.append(DELIMETER);
            this.addParameters(buf, (AST)node, AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_PARAM, " * @param $paramType$ DOCUMENT ME!"), out.environment);
        }
        if (!"void".equals((returnType = JavaNodeHelper.getFirstChild((AST)node, 16).getFirstChild()).getText())) {
            buf.append(leadingSeparator);
            buf.append(DELIMETER);
            buf.append(AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_RETURN, " * @return DOCUMENT ME!"));
            buf.append(DELIMETER);
        }
        if ((exceptions = JavaNodeHelper.getFirstChild((AST)node, 116)) != null && exceptions.getFirstChild() != null) {
            buf.append(leadingSeparator);
            buf.append(DELIMETER);
            List types = JavadocPrinter.getValidTypeNames((AST)node, 116);
            this.addExceptions(buf, types, AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_EXCEPTION, " * @throws $exceptionType$ DOCUMENT ME!"), out.environment);
        }
        buf.append(bottomText);
        Node text = (Node)out.getJavaNodeFactory().create(40, buf.toString());
        comment.setFirstChild((AST)text);
        ExtendedToken token = out.getCompositeFactory().getExtendedTokenFactory().create(4, null);
        token.setComment(comment);
        this.addComment(node, token);
    }

    void addCommentIfNeeded(JavaNode node, NodeWriter out) {
        if (out.mode != 1) {
            return;
        }
        if (!(out.state.anonymousInnerClass || out.state.innerClass && !AbstractPrinter.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_INNER_CLASS, false))) {
            boolean hasJavadoc = node.hasJavadocComment(AbstractPrinter.settings.getBoolean(ConventionKeys.DONT_COMMENT_JAVADOC_WHEN_ML, false));
            if (!hasJavadoc && node.hasCommentsBefore()) {
                CommonHiddenStreamToken comment = node.getHiddenBefore();
                switch (comment.getType()) {
                    case 67: {
                        this.addComment(node, out);
                        break;
                    }
                    case 174: 
                    case 176: {
                        this.addComment(node, out);
                        break;
                    }
                }
            } else if (!hasJavadoc) {
                this.addComment(node, out);
            }
        }
    }

    private boolean isEnabled(int mask, AST node) {
        int value = JavaNodeModifier.valueOf(node) & this.privacyMask;
        return (mask & value) != 0 || value == 0 && (0x10 & mask) != 0;
    }

    private void addComment(JavaNode node, ExtendedToken comment) {
        ExtendedToken c = (ExtendedToken)node.getCommentBefore();
        if (c == null) {
            node.setHiddenBefore(comment);
        } else {
            comment.setHiddenAfter(c);
            c.setHiddenBefore(comment);
        }
    }

    private void addCtorComment(JavaNode node, NodeWriter out) {
        AST exceptions;
        Node comment = (Node)out.getJavaNodeFactory().create(4, GENERATED_COMMENT);
        String topText = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_TOP, "/**| * Creates a new $objectType$ object.").trim();
        StringBuffer buf = new StringBuffer();
        out.environment.set(Environment.Variable.TYPE_OBJECT.getName(), JavaNodeHelper.getFirstChild((AST)node, 77).getText());
        buf.append(out.environment.interpolate(topText));
        out.environment.unset(Environment.Variable.TYPE_OBJECT.getName());
        buf.append(DELIMETER);
        AST parameters = JavaNodeHelper.getFirstChild((AST)node, 23);
        String bottomText = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_BOTTOM, " */");
        String leadingSeparator = bottomText.substring(0, bottomText.indexOf(42) + 1);
        if (parameters.getFirstChild() != null) {
            buf.append(leadingSeparator);
            buf.append(DELIMETER);
            this.addParameters(buf, (AST)node, AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_PARAM, " * @param $paramType$ DOCUMENT ME!"), out.environment);
        }
        if ((exceptions = JavaNodeHelper.getFirstChild((AST)node, 116)) != null && exceptions.getFirstChild() != null) {
            buf.append(leadingSeparator);
            buf.append(DELIMETER);
            List types = JavadocPrinter.getValidTypeNames((AST)node, 116);
            this.addExceptions(buf, types, AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_EXCEPTION, " * @throws $exceptionType$ DOCUMENT ME!"), out.environment);
        }
        buf.append(bottomText);
        Node text = (Node)out.getJavaNodeFactory().create(40, buf.toString());
        comment.setFirstChild((AST)text);
        ExtendedToken token = out.getCompositeFactory().getExtendedTokenFactory().create(4, null);
        token.setComment(comment);
        this.addComment(node, token);
    }

    private void addExceptions(StringBuffer buf, List types, String text, Environment environment) {
        int size = types.size();
        for (int i = 0; i < size; ++i) {
            String type = (String)types.get(i);
            environment.set(Environment.Variable.TYPE_EXCEPTION.getName(), type);
            buf.append(environment.interpolate(text));
            buf.append(DELIMETER);
            environment.unset(Environment.Variable.TYPE_EXCEPTION.getName());
        }
    }

    private void addParameters(StringBuffer buf, AST node, String text, Environment environment) {
        String type;
        AST child;
        AST parameters = JavaNodeHelper.getFirstChild(node, 23);
        if (JavaNodeHelper.getFirstChild(node, 60) != null) {
            for (child = JavaNodeHelper.getFirstChild(node, 60).getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != 61) continue;
                type = "<" + JavaNodeHelper.getFirstChild(child, 77).getText() + ">";
                environment.set(Environment.Variable.TYPE_PARAM.getName(), type);
                buf.append(environment.interpolate(text));
                buf.append(DELIMETER);
                environment.unset(Environment.Variable.TYPE_PARAM.getName());
            }
        }
        if (parameters != null) {
            for (child = parameters.getFirstChild(); child != null; child = child.getNextSibling()) {
                switch (child.getType()) {
                    case 24: 
                    case 47: {
                        type = JavaNodeHelper.getFirstChild(child, 77).getText();
                        environment.set(Environment.Variable.TYPE_PARAM.getName(), type);
                        buf.append(environment.interpolate(text));
                        buf.append(DELIMETER);
                        environment.unset(Environment.Variable.TYPE_PARAM.getName());
                    }
                }
            }
        }
    }

    private void addVariableComment(JavaNode node, NodeWriter out) {
        String t = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_VARIABLE, "/**| * DOCUMENT ME!| */");
        Node text = (Node)out.getJavaNodeFactory().create(40, t);
        Node comment = (Node)out.getJavaNodeFactory().create(4, GENERATED_COMMENT);
        comment.setFirstChild((AST)text);
        ExtendedToken token = out.getCompositeFactory().getExtendedTokenFactory().create(4, null);
        token.setComment(comment);
        this.addComment(node, token);
    }
}

