/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import java.io.IOException;

class BasicPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new BasicPrinter();

    protected BasicPrinter() {
    }

    public static Printer getInstance() {
        return INSTANCE;
    }

    @Override
    public void print(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, false, out);
        int offset = out.print(node.getText(), node.getType());
        for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            PrinterFactory.create(child, out).print(child, out);
        }
        this.trackPosition((JavaNode)node, out.line, offset, out);
        if (out.state.arrayBrackets > 0) {
            for (int i = 0; i < out.state.arrayBrackets; ++i) {
                out.print("[]", node.getType());
            }
            out.state.arrayBrackets = 0;
        }
        this.printCommentsAfter(node, false, false, out);
    }
}

