/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

class BlockPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new BlockPrinter();

    protected BlockPrinter() {
    }

    public static Printer getInstance() {
        return INSTANCE;
    }

    @Override
    public void print(AST node, NodeWriter out) throws IOException {
        int closeBraceType;
        boolean leftBraceNewline;
        boolean insertEmptyStatement;
        boolean cuddleEmpty;
        boolean freestanding;
        boolean treatDifferent;
        boolean newLineAfter;
        boolean forceNewlineBefore;
        JavaNode lcurly;
        block55: {
            block56: {
                lcurly = (JavaNode)node;
                forceNewlineBefore = out.state.newlineBeforeLeftBrace;
                newLineAfter = false;
                treatDifferent = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_TREAT_DIFFERENT, false);
                if (treatDifferent) {
                    switch (lcurly.getParent().getType()) {
                        case 11: 
                        case 12: 
                        case 17: 
                        case 18: {
                            forceNewlineBefore = true;
                            break;
                        }
                        case 66: {
                            forceNewlineBefore = false;
                            treatDifferent = false;
                            break;
                        }
                        case 49: 
                        case 52: {
                            forceNewlineBefore = false;
                            break;
                        }
                        default: {
                            treatDifferent = false;
                        }
                    }
                }
                freestanding = JavaNodeHelper.isFreestandingBlock(lcurly);
                cuddleEmpty = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_EMPTY_CUDDLE, false);
                insertEmptyStatement = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_EMPTY_INSERT_STATEMENT, false);
                leftBraceNewline = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false);
                int n = closeBraceType = node.getType() == 10 ? 6 : 9;
                if (!JavaNodeHelper.isEmptyBlock(node)) break block55;
                if (!insertEmptyStatement) break block56;
                switch (((JavaNode)node).getParent().getType()) {
                    case 11: 
                    case 12: 
                    case 17: 
                    case 18: 
                    case 49: 
                    case 52: {
                        break block55;
                    }
                    default: {
                        this.printBracesEmptyStatement(lcurly, leftBraceNewline, forceNewlineBefore, freestanding, closeBraceType, out);
                        return;
                    }
                }
            }
            if (cuddleEmpty && !lcurly.getParent().hasCommentsAfter()) {
                this.printBracesCuddled(closeBraceType, lcurly, true, out);
                return;
            }
        }
        switch (out.last) {
            case 113: 
            case 130: {
                break;
            }
            default: {
                if (node.getFirstChild() != null) break;
                if (insertEmptyStatement) {
                    this.printBracesEmptyStatement(lcurly, leftBraceNewline, forceNewlineBefore, freestanding, closeBraceType, out);
                } else if (cuddleEmpty && !lcurly.getParent().hasCommentsAfter()) {
                    this.printBracesCuddled(closeBraceType, lcurly, false, out);
                } else {
                    int offset = out.printLeftBrace();
                    this.trackPosition(lcurly, out.line - 1, offset, out);
                    if (out.state.newlineBeforeLeftBrace) {
                        out.state.newlineBeforeLeftBrace = false;
                    }
                    out.printRightBrace(6, !treatDifferent, true);
                    JavaNode rcurly = (JavaNode)lcurly.getFirstChild();
                    this.trackPosition(rcurly, out.line - 1, offset + 1, out);
                    out.last = closeBraceType;
                }
                return;
            }
        }
        boolean brace = true;
        boolean indent = false;
        boolean forceNewLineAfter = true;
        int wrapLineCount = Integer.MAX_VALUE;
        boolean removeBlockBraces = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_REMOVE_BLOCK, true);
        if (freestanding) {
            if (removeBlockBraces && this.canRemoveBraces(lcurly)) {
                brace = false;
            }
            switch (lcurly.getParent().getType()) {
                case 54: {
                    forceNewLineAfter = !AbstractPrinter.settings.getBoolean(ConventionKeys.ANON_LCURLY_NO_NEW_LINE, true);
                    wrapLineCount = AbstractPrinter.settings.getInt(ConventionKeys.ANON_ALIGN_VALUES_WHEN_EXCEEDS, 0);
                    newLineAfter = false;
                }
            }
            indent = false;
        } else {
            switch (out.last) {
                case 119: {
                    if (!AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_REMOVE_IF_ELSE, false) || this.isBraceNecessary(node)) break;
                    brace = false;
                    indent = true;
                    out.printNewline();
                    break;
                }
                case 129: {
                    if (!AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_REMOVE_FOR, false) || this.isBraceNecessary(node)) break;
                    brace = false;
                    indent = true;
                    out.printNewline();
                    break;
                }
                case 121: {
                    if (!AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_REMOVE_WHILE, false) || this.isBraceNecessary(node)) break;
                    brace = false;
                    indent = true;
                    out.printNewline();
                    break;
                }
                case 122: {
                    if (!AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_REMOVE_DO_WHILE, false) || this.isBraceNecessary(node)) break;
                    brace = false;
                    indent = true;
                    out.printNewline();
                    break;
                }
                case 111: {
                    newLineAfter = false;
                    forceNewLineAfter = !AbstractPrinter.settings.getBoolean(ConventionKeys.ENUM_LCURLY_NO_NEW_LINE, true);
                    wrapLineCount = AbstractPrinter.settings.getInt(ConventionKeys.ENUM_ALIGN_VALUES_WHEN_EXCEEDS, 0);
                    indent = true;
                    break;
                }
                case 105: {
                    forceNewLineAfter = !AbstractPrinter.settings.getBoolean(ConventionKeys.ANON_DEF_LCURLY_NO_NEW_LINE, false);
                    wrapLineCount = AbstractPrinter.settings.getInt(ConventionKeys.ANON_DEF_ALIGN_VALUES_WHEN_EXCEEDS, 0);
                    newLineAfter = false;
                    indent = true;
                    break;
                }
                case 113: 
                case 130: {
                    if (!this.isBraceNecessary(node)) {
                        brace = false;
                        indent = true;
                    }
                    leftBraceNewline = false;
                    break;
                }
                default: {
                    switch (lcurly.getParent().getType()) {
                        case 54: {
                            forceNewLineAfter = !AbstractPrinter.settings.getBoolean(ConventionKeys.ANON_LCURLY_NO_NEW_LINE, true);
                            wrapLineCount = AbstractPrinter.settings.getInt(ConventionKeys.ANON_ALIGN_VALUES_WHEN_EXCEEDS, 0);
                            newLineAfter = false;
                            indent = true;
                        }
                    }
                }
            }
        }
        if (brace) {
            boolean indentBrace = !freestanding && !forceNewlineBefore;
            this.printLeftBrace(lcurly, leftBraceNewline, forceNewlineBefore, forceNewLineAfter, freestanding, indentBrace, out);
        } else if (indent) {
            out.indent();
            out.last = 5;
        }
        JavaNode rcurly = null;
        int enumCounter = 1;
        int currentLine = out.line;
        block30: for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 6: {
                    rcurly = (JavaNode)child;
                    break block30;
                }
                case 83: {
                    out.nextNewline = newLineAfter;
                    PrinterFactory.create(child, out).print(child, out);
                    if (!newLineAfter) continue block30;
                    out.printNewline();
                    out.nextNewline = false;
                    continue block30;
                }
                default: {
                    if (wrapLineCount != Integer.MAX_VALUE) {
                        if (++enumCounter > wrapLineCount) {
                            enumCounter = 1;
                            newLineAfter = true;
                        } else {
                            newLineAfter = false;
                        }
                    }
                    currentLine = out.line;
                    out.nextNewline = newLineAfter;
                    PrinterFactory.create(child, out).print(child, out);
                    if (currentLine == out.line) {
                        AST nextNode = child.getNextSibling();
                        if (newLineAfter && nextNode != null && nextNode.getType() != 83) {
                            newLineAfter = false;
                            out.printNewline();
                        }
                    } else {
                        newLineAfter = false;
                        enumCounter = 0;
                    }
                    out.nextNewline = false;
                }
            }
        }
        if (brace) {
            this.printCommentsBefore((AST)rcurly, out);
            boolean rightBraceNewline = this.isCloseBraceNewline(lcurly, closeBraceType, freestanding);
            boolean addCustomComment = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_ADD_COMMENT, false);
            int offset = out.printRightBrace(closeBraceType, !treatDifferent && !freestanding, rightBraceNewline && !rcurly.hasCommentsAfter() && !addCustomComment);
            this.trackPosition(rcurly, rightBraceNewline ? out.line - 1 : out.line, offset, out);
            if (addCustomComment) {
                this.prepareComment(lcurly, rcurly, out);
            }
            this.printCommentsAfter((AST)rcurly, false, false, out);
        } else if (indent) {
            out.unindent();
        }
    }

    private boolean isBraceNecessary(AST node) {
        switch (node.getType()) {
            case 9: {
                return true;
            }
        }
        int count = 0;
        block16: for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (count++) {
                case 0: {
                    switch (child.getType()) {
                        case 13: {
                            return true;
                        }
                        case 31: 
                        case 41: 
                        case 123: 
                        case 124: 
                        case 125: 
                        case 127: {
                            continue block16;
                        }
                        case 5: {
                            JavaNode lcurly = (JavaNode)child;
                            if (!lcurly.hasCommentsBefore() && !lcurly.hasCommentsAfter()) continue block16;
                            return true;
                        }
                        default: {
                            return true;
                        }
                    }
                }
                case 1: {
                    switch (child.getType()) {
                        case 6: {
                            JavaNode rcurly = (JavaNode)child;
                            return rcurly.hasCommentsBefore() || rcurly.hasCommentsAfter();
                        }
                    }
                    continue block16;
                }
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isCloseBraceNewline(JavaNode node, int type, boolean freestanding) {
        boolean rightBraceNewline = true;
        if (type == 9) {
            switch (node.getParent().getType()) {
                case 166: {
                    return false;
                }
                case 54: {
                    return false;
                }
            }
            return true;
        }
        if (!freestanding) {
            JavaNode next = (JavaNode)node.getNextSibling();
            if (next != null) {
                switch (next.getType()) {
                    case 120: 
                    case 132: 
                    case 133: {
                        rightBraceNewline = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_NEWLINE_RIGHT, false);
                        break;
                    }
                    case 121: {
                        switch (next.getParent().getType()) {
                            case 122: {
                                rightBraceNewline = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_NEWLINE_RIGHT, false);
                            }
                        }
                    }
                }
            } else {
                JavaNode parent = node.getParent();
                switch (parent.getType()) {
                    case 133: {
                        AST n = parent.getNextSibling();
                        if (n == null) break;
                        switch (n.getType()) {
                            case 132: 
                            case 133: {
                                rightBraceNewline = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_NEWLINE_RIGHT, false);
                            }
                        }
                    }
                }
            }
        }
        return rightBraceNewline;
    }

    private boolean canRemoveBraces(JavaNode lcurly) {
        switch (lcurly.getParent().getType()) {
            case 14: 
            case 54: {
                return false;
            }
        }
        if (lcurly.hasCommentsBefore()) {
            return false;
        }
        for (AST child = lcurly.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 13: {
                    return false;
                }
            }
        }
        return true;
    }

    private void printBracesCuddled(int type, JavaNode lcurly, boolean newlineAfter, NodeWriter out) throws IOException {
        JavaNode rcurly;
        out.print(out.getString(AbstractPrinter.settings.getInt(ConventionKeys.INDENT_SIZE_BRACE_CUDDLED, 1)), 173);
        out.print("{}", type);
        if (out.state.newlineBeforeLeftBrace) {
            out.state.newlineBeforeLeftBrace = false;
        }
        if (!this.printCommentsAfter((AST)(rcurly = (JavaNode)lcurly.getFirstChild()), false, newlineAfter, out) && newlineAfter) {
            out.printNewline();
        }
    }

    private void printBracesEmptyStatement(JavaNode lcurly, boolean leftBraceNewline, boolean forceNewlineBefore, boolean freestanding, int type, NodeWriter out) throws IOException {
        JavaNode rcurly = (JavaNode)lcurly.getFirstChild();
        this.printLeftBrace(lcurly, leftBraceNewline, forceNewlineBefore, false, freestanding, true, out);
        if (out.state.newlineBeforeLeftBrace) {
            out.state.newlineBeforeLeftBrace = false;
        }
        out.print(";", out.last);
        out.printNewline();
        boolean newLineAfterBrace = this.isCloseBraceNewline(lcurly, type, freestanding);
        int offset = out.printRightBrace(type, false);
        this.trackPosition(rcurly, out.line, offset, out);
        if (!this.printCommentsAfter((AST)rcurly, false, newLineAfterBrace, out) && newLineAfterBrace) {
            out.printNewline();
        }
        out.last = type;
    }

    private void printLeftBrace(JavaNode lcurly, boolean leftBraceNewline, boolean forceNewlineBefore, boolean forceNewLineAfter, boolean freestanding, boolean indent, NodeWriter out) throws IOException {
        AST next;
        int offset;
        if (lcurly.hasCommentsBefore() || freestanding) {
            this.printCommentsBefore((AST)lcurly, false, out);
        }
        boolean commentsAfter = lcurly.hasCommentsAfter();
        boolean bl = forceNewLineAfter = forceNewLineAfter && !commentsAfter;
        if (freestanding) {
            offset = out.printLeftBrace(false, forceNewLineAfter, false);
            this.trackPosition(lcurly, commentsAfter ? out.line : out.line - 1, offset, out);
        } else if (forceNewlineBefore) {
            offset = out.printLeftBrace(true, forceNewLineAfter, false);
            this.trackPosition(lcurly, commentsAfter ? out.line : out.line - 1, offset, out);
        } else if (out.newline) {
            offset = out.printLeftBrace(false, forceNewLineAfter, indent);
            this.trackPosition(lcurly, commentsAfter ? out.line : out.line - 1, offset, out);
        } else {
            offset = out.printLeftBrace(leftBraceNewline, forceNewLineAfter, indent);
            this.trackPosition(lcurly, commentsAfter ? out.line : out.line - 1, offset, out);
        }
        if (leftBraceNewline && commentsAfter && (next = lcurly.getFirstChild()) != null && next.getType() == 6) {
            out.printNewline();
        }
        if (out.state.newlineBeforeLeftBrace) {
            out.state.newlineBeforeLeftBrace = false;
        }
        if (commentsAfter) {
            this.printCommentsAfter((AST)lcurly, true, true, out);
        }
    }
}

