/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.ParenthesesScope;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

abstract class BlockStatementPrinter
extends AbstractPrinter {
    protected BlockStatementPrinter() {
    }

    @Override
    public void print(AST node, NodeWriter out) throws IOException {
        if (out.last == 25 && !AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_LABEL, true) && ((JavaNode)node).hasCommentsBefore()) {
            out.printNewline();
        }
        this.printCommentsBefore(node, out);
    }

    JavaNode printExpressionList(AST lparen, boolean insertBraces, NodeWriter out) throws IOException {
        JavaNode rparen;
        AST body;
        if (out.mode == 1 && AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_PAREN_GROUPING, false)) {
            switch (out.last) {
                case 106: {
                    if (out.newline) break;
                    out.printNewline();
                }
            }
        }
        PrinterFactory.create(lparen, out).print(lparen, out);
        Marker marker = out.state.markers.add();
        TestNodeWriter tester = null;
        AST expr = lparen.getNextSibling();
        boolean wrapped = false;
        if (out.mode == 1) {
            ParenthesesScope scope = new ParenthesesScope(out.state.paramLevel);
            out.state.expressionList = true;
            ++out.state.paramLevel;
            out.state.parenScope.addFirst(scope);
            int lineLength = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80);
            if (AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_LEFT_PAREN, false)) {
                if (!out.newline) {
                    tester = out.testers.get();
                    PrinterFactory.create(expr, out).print(expr, tester);
                    if (out.column + tester.length > lineLength) {
                        out.printNewline();
                        this.printIndentation(out);
                        wrapped = true;
                        if (AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_EXCEED, false)) {
                            scope.wrap = true;
                        }
                    }
                    out.testers.release(tester);
                } else {
                    this.printIndentation(out);
                    wrapped = true;
                    if (AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_EXCEED, false)) {
                        scope.wrap = true;
                    }
                }
                tester = out.testers.get();
                PrinterFactory.create(expr, out).print(expr, tester);
            }
            if (tester == null) {
                tester = out.testers.get();
                PrinterFactory.create(expr, out).print(expr, tester);
            }
            if (!wrapped && tester.length + out.column > lineLength) {
                if (AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_EXCEED, false)) {
                    scope.wrap = true;
                }
                wrapped = true;
            }
            out.testers.release(tester);
        }
        out.continuation = AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_CONTINUATION_BLOCK, true);
        PrinterFactory.create(expr, out).print(expr, out);
        out.continuation = false;
        out.state.wrap = false;
        if (wrapped && AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_RIGHT_PAREN, false)) {
            if (!out.newline) {
                out.printNewline();
            }
            if (AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_DEEP, false)) {
                this.printIndentation(-1, out);
            } else {
                out.print(EMPTY_STRING, 173);
            }
        }
        boolean hasBraces = (body = (rparen = (JavaNode)expr.getNextSibling()).getNextSibling()).getType() == 10;
        boolean leftBraceNewline = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false);
        if (!hasBraces && insertBraces && !leftBraceNewline) {
            out.pendingComment = rparen.getCommentAfter();
            if (out.pendingComment != null) {
                rparen.setHiddenAfter(null);
            }
        }
        PrinterFactory.create((AST)rparen, out).print((AST)rparen, out);
        if (out.mode == 1) {
            out.state.expressionList = false;
            --out.state.paramLevel;
            out.state.parenScope.removeFirst();
        }
        out.state.markers.remove(marker);
        return rparen;
    }
}

