/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.BasicDeclarationPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

public class EnumConstantPrinter
extends BasicDeclarationPrinter {
    private static final Printer INSTANCE = new EnumConstantPrinter();

    public static final Printer getInstance() {
        return INSTANCE;
    }

    @Override
    public void print(AST node, NodeWriter out) throws IOException {
        TestNodeWriter tester = out.testers.get();
        boolean spaceAfterComma = AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        tester.reset(out, false);
        this.printChildren(node, tester);
        int lineLength = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        if (tester.line > 1 || tester.column > lineLength) {
            out.printNewline();
        }
        out.testers.release(tester);
        this.addCommentIfNeeded((JavaNode)node, out);
        this.printCommentsBefore(node, false, out);
        this.printChildren(node, out);
        AST next = node.getNextSibling();
        if (next != null) {
            if (next.getType() == 50) {
                if (spaceAfterComma && !out.nextNewline) {
                    out.print(", ", out.last);
                } else {
                    out.print(",", out.last);
                }
            } else {
                out.print(";", out.last);
            }
        } else {
            out.print(";", out.last);
        }
        this.printCommentsAfter(next, false, true, out);
    }
}

