/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.BlockStatementPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.ParenthesesScope;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class ForPrinter
extends BlockStatementPrinter {
    private static final Printer INSTANCE = new ForPrinter();

    protected ForPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    @Override
    public void print(AST node, NodeWriter out) throws IOException {
        super.print(node, out);
        int offset = 1;
        offset = AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_BEFORE_STATEMENT_PAREN, true) ? out.print("for ", 129) : out.print("for", 129);
        this.trackPosition((JavaNode)node, out.line, offset, out);
        AST lparen = node.getFirstChild();
        PrinterFactory.create(lparen, out).print(lparen, out);
        Marker marker = out.state.markers.add();
        AST forNode = lparen.getNextSibling();
        AST rparen = forNode.getNextSibling();
        switch (forNode.getType()) {
            case 38: {
                rparen = this.for_init(forNode, out, marker);
                break;
            }
            case 51: {
                rparen = this.for_each(forNode, out, marker);
                break;
            }
            default: {
                throw new IllegalArgumentException("no viable printer for -- " + forNode);
            }
        }
        PrinterFactory.create(rparen, out).print(rparen, out);
        out.state.markers.remove(marker);
        if (out.mode == 1) {
            --out.state.paramLevel;
            out.state.parenScope.removeFirst();
        }
        out.last = 129;
        AST body = rparen.getNextSibling();
        switch (body.getType()) {
            case 10: {
                PrinterFactory.create(body, out).print(body, out);
                break;
            }
            default: {
                if (AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_INSERT_FOR, false)) {
                    out.printLeftBrace(AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false), true);
                    PrinterFactory.create(body, out).print(body, out);
                    out.printRightBrace();
                    break;
                }
                out.printNewline();
                out.indent();
                PrinterFactory.create(body, out).print(body, out);
                out.unindent();
            }
        }
        out.last = 6;
    }

    private AST for_each(AST forNode, NodeWriter out, Marker marker) throws IOException {
        if (out.mode == 1) {
            ++out.state.paramLevel;
            out.state.parenScope.addFirst(new ParenthesesScope(out.state.paramLevel));
        }
        AST forEachClause = forNode.getFirstChild();
        AST expresion = forEachClause.getNextSibling();
        PrinterFactory.create(forEachClause, out).print(forEachClause, out);
        out.print(" : ", forEachClause.getType());
        this.printChildren(expresion, out);
        return forNode.getNextSibling();
    }

    private AST for_init(AST forInit, NodeWriter out, Marker marker) throws IOException {
        AST firstSemi = forInit.getNextSibling();
        AST forCond = firstSemi.getNextSibling();
        AST secondSemi = forCond.getNextSibling();
        AST forIter = secondSemi.getNextSibling();
        int lineLength = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        boolean indentDeep = AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_DEEP, false);
        boolean firstWrap = false;
        if (out.mode == 1) {
            ++out.state.paramLevel;
            out.state.parenScope.addFirst(new ParenthesesScope(out.state.paramLevel));
            if (AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_LEFT_PAREN, false)) {
                AST child;
                TestNodeWriter tester = out.testers.get();
                for (AST c = child = forInit.getFirstChild(); c != null; c = c.getNextSibling()) {
                    PrinterFactory.create(c, out).print(c, tester);
                }
                child = forCond.getFirstChild();
                if (child != null) {
                    PrinterFactory.create(child, out).print(child, tester);
                }
                if ((child = forIter.getFirstChild()) != null) {
                    PrinterFactory.create(child, out).print(child, tester);
                }
                if (out.column + tester.length > lineLength) {
                    firstWrap = true;
                }
                out.testers.release(tester);
            }
        }
        this.printForInit(forInit, firstWrap, out);
        boolean wrapAll = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_EXCEED, false);
        boolean spaceAfterSemi = AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_SEMICOLON, true);
        out.continuation = AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_CONTINUATION_BLOCK, true);
        boolean secondWrap = false;
        if (out.mode == 1) {
            if (firstWrap && wrapAll) {
                secondWrap = true;
            } else {
                TestNodeWriter tester = out.testers.get();
                AST child = forCond.getFirstChild();
                if (child != null) {
                    PrinterFactory.create(child, out).print(child, tester);
                    tester.length = tester.length + (spaceAfterSemi ? 3 : 2);
                }
                if (out.column + tester.length > lineLength) {
                    secondWrap = true;
                }
                out.testers.release(tester);
            }
        }
        out.print(";", 38);
        this.printCommentsAfter(firstSemi, false, false, out);
        this.printForCond(forCond, secondWrap, out);
        boolean thirdWrap = false;
        if (out.mode == 1) {
            if (firstWrap && wrapAll) {
                thirdWrap = true;
            } else {
                TestNodeWriter tester = out.testers.get();
                AST child = forIter.getFirstChild();
                if (child != null) {
                    PrinterFactory.create(child, out).print(child, tester);
                    tester.length = tester.length + (spaceAfterSemi ? 5 : 3);
                }
                if (out.column + tester.length > lineLength) {
                    thirdWrap = true;
                }
                out.testers.release(tester);
            }
        }
        out.print(";", 38);
        this.printCommentsAfter(secondSemi, false, false, out);
        this.printForIter(forIter, thirdWrap, out);
        out.continuation = false;
        if ((firstWrap || secondWrap || thirdWrap) && AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_RIGHT_PAREN, false)) {
            if (!out.newline) {
                out.printNewline();
                if (indentDeep) {
                    out.print(out.getString(marker.column - 1 - out.getIndentLength()), 173);
                }
            }
            out.print(EMPTY_STRING, 173);
        }
        return forIter.getNextSibling();
    }

    private void printForCond(AST node, boolean wrap, NodeWriter out) throws IOException {
        if (node.getFirstChild() == null) {
            return;
        }
        if (wrap) {
            out.printNewline();
            this.printIndentation(out);
        } else if (AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_SEMICOLON, true)) {
            out.print(" ", 38);
        }
        for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            PrinterFactory.create(child, out).print(child, out);
        }
    }

    private void printForInit(AST node, boolean wrap, NodeWriter out) throws IOException {
        AST child;
        if (wrap) {
            out.printNewline();
            this.printIndentation(out);
        }
        if ((child = node.getFirstChild()) != null) {
            this.printVariableDefs(node, out);
        }
    }

    private void printForIter(AST node, boolean wrap, NodeWriter out) throws IOException {
        AST elist = node.getFirstChild();
        if (elist == null) {
            return;
        }
        if (wrap) {
            out.printNewline();
            this.printIndentation(out);
        } else if (AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_SEMICOLON, true)) {
            out.print(" ", 38);
        }
        boolean spaceAfterComma = AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        String comma = spaceAfterComma ? ", " : ",";
        block3: for (AST element = elist.getFirstChild(); element != null; element = element.getNextSibling()) {
            switch (element.getType()) {
                case 83: {
                    out.print(comma, 83);
                    continue block3;
                }
                default: {
                    PrinterFactory.create(element, out).print(element, out);
                }
            }
        }
    }

    private void printVariableDef(AST node, NodeWriter out, boolean printType) throws IOException {
        switch (node.getType()) {
            case 37: {
                boolean spaceAfterComma = AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
                String comma = spaceAfterComma ? ", " : ",";
                for (AST param = node.getFirstChild(); param != null; param = param.getNextSibling()) {
                    PrinterFactory.create(param, out).print(param, out);
                    if (param.getNextSibling() == null) continue;
                    out.print(comma, 83);
                }
                return;
            }
        }
        AST modifier = node.getFirstChild();
        AST type = modifier.getNextSibling();
        if (printType) {
            PrinterFactory.create(modifier, out).print(modifier, out);
            PrinterFactory.create(type, out).print(type, out);
        }
        AST identifier = type.getNextSibling();
        if (out.last != 83) {
            out.print(" ", out.last);
        }
        PrinterFactory.create(identifier, out).print(identifier, out);
        AST assign = identifier.getNextSibling();
        if (assign != null) {
            switch (assign.getType()) {
                case 72: {
                    break;
                }
                default: {
                    PrinterFactory.create(assign, out).print(assign, out);
                }
            }
        }
    }

    private void printVariableDefs(AST node, NodeWriter out) throws IOException {
        AST child = node.getFirstChild();
        boolean spaceAfterComma = AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        String comma = spaceAfterComma ? ", " : ",";
        switch (child.getType()) {
            case 13: {
                this.printVariableDef(child, out, true);
                for (child = child.getNextSibling(); child != null; child = child.getNextSibling()) {
                    out.print(comma, 83);
                    this.printVariableDef(child, out, false);
                }
                break;
            }
            case 37: {
                block8: for (AST var = child.getFirstChild(); var != null; var = var.getNextSibling()) {
                    switch (child.getType()) {
                        case 83: {
                            out.print(comma, 83);
                            continue block8;
                        }
                        default: {
                            PrinterFactory.create(var, out).print(var, out);
                        }
                    }
                }
                break;
            }
        }
    }
}

