/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.OperatorPrinter;
import de.hunsicker.jalopy.printer.ParenthesesScope;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

class InfixOperatorPrinter
extends OperatorPrinter {
    protected InfixOperatorPrinter() {
    }

    @Override
    public void print(AST node, NodeWriter out) throws IOException {
        this.print(node, true, out);
    }

    public void print(AST node, boolean paddOperator, NodeWriter out) throws IOException {
        Object lhsLeftParen = null;
        AST lhsRightParen = null;
        JavaNode lhs = null;
        JavaNode rhs = null;
        int count = 0;
        block8: for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 106: {
                    if (count == 0) {
                        lhsLeftParen = child;
                    }
                    ++count;
                    continue block8;
                }
                case 107: {
                    if (--count != 0) continue block8;
                    lhsRightParen = child;
                    rhs = (JavaNode)child.getNextSibling();
                    break block8;
                }
                default: {
                    lhs = (JavaNode)child;
                    if (count != 0) continue block8;
                    rhs = (JavaNode)child.getNextSibling();
                    break block8;
                }
            }
        }
        JavaNode rhsLeftParen = null;
        JavaNode rhsRightParen = null;
        count = 0;
        block9: for (JavaNode child = rhs; child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 106: {
                    if (count == 0) {
                        rhsLeftParen = child;
                    }
                    ++count;
                    continue block9;
                }
                case 107: {
                    if (--count != 0) continue block9;
                    rhsRightParen = child;
                    continue block9;
                }
                default: {
                    rhs = child;
                }
            }
        }
        boolean wrapLines = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP, true);
        boolean wrap = false;
        if (lhsLeftParen != null && rhsLeftParen != null) {
            wrap = InfixOperatorPrinter.canWrap(node, out);
            this.printImpl((JavaNode)node, lhs, rhs, (AST)lhsLeftParen, lhsRightParen, (AST)rhsLeftParen, (AST)rhsRightParen, wrapLines && wrap, paddOperator, out);
        } else {
            boolean insertParentheses = AbstractPrinter.settings.getBoolean(ConventionKeys.INSERT_EXPRESSION_PARENTHESIS, true);
            if (insertParentheses) {
                if (lhsLeftParen == null && this.getPrecedence((AST)lhs) > this.getPrecedence(node)) {
                    if (out.mode == 1) {
                        this.addParentheses(lhs, out);
                        lhsLeftParen = lhs.getPreviousSibling();
                        lhsRightParen = lhs.getNextSibling();
                    } else {
                        out.print("(", out.last);
                        out.print(")", out.last);
                    }
                }
                if (rhsLeftParen == null && this.getPrecedence((AST)rhs) > this.getPrecedence(node)) {
                    if (out.mode == 1) {
                        this.addParentheses(rhs, out);
                        rhsLeftParen = rhs.getPreviousSibling();
                        rhsRightParen = rhs.getNextSibling();
                    } else {
                        out.print("(", out.last);
                        out.print(")", out.last);
                    }
                }
            }
            if (wrapLines) {
                wrap = InfixOperatorPrinter.canWrap(node, out);
            }
            this.printImpl((JavaNode)node, lhs, rhs, (AST)lhsLeftParen, lhsRightParen, (AST)rhsLeftParen, (AST)rhsRightParen, wrapLines && wrap, paddOperator, out);
        }
    }

    private void wrapNewLine(JavaNode lhs, NodeWriter out, boolean islhs) throws IOException {
        if (out.mode == 1 && !out.newline && lhs.getFirstChild() != null && AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_PAREN_GROUPING, false)) {
            JavaNode parent = lhs.getParent();
            block6: while (true) {
                switch (parent.getType()) {
                    case 145: 
                    case 146: {
                        parent = parent.getParent();
                        continue block6;
                    }
                }
                break;
            }
            boolean allow = false;
            switch (lhs.getPreviousSibling().getType()) {
                case 106: 
                case 145: 
                case 146: {
                    allow = true;
                }
            }
            if (parent.getParent().getType() == 119 && allow) {
                out.printNewline();
            }
        }
    }

    private void printImpl(JavaNode operator, JavaNode lhs, JavaNode rhs, AST lhsLeftParen, AST lhsRightParen, AST rhsLeftParen, AST rhsRightParen, boolean wrapLines, boolean paddOperator, NodeWriter out) throws IOException {
        boolean wrapBeforeOperator;
        boolean wrapped;
        boolean continuationIndent;
        boolean continuation;
        block37: {
            TestNodeWriter tester;
            block38: {
                block36: {
                    if (lhsLeftParen == null) {
                        PrinterFactory.create((AST)lhs, out).print((AST)lhs, out);
                    } else {
                        this.printWithParentheses(lhs, lhsLeftParen, lhsRightParen, out);
                    }
                    continuation = out.continuation;
                    continuationIndent = AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_CONTINUATION_OPERATOR, false);
                    if (continuationIndent && !continuation) {
                        switch (operator.getType()) {
                            case 155: 
                            case 156: {
                                break;
                            }
                            default: {
                                out.continuation = true;
                            }
                        }
                    }
                    wrapped = false;
                    if (out.newline) {
                        wrapped = true;
                        this.printIndentation(out);
                    }
                    wrapBeforeOperator = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_OPERATOR, false);
                    boolean commentAfter = operator.hasCommentsAfter();
                    if (!wrapBeforeOperator) {
                        if (this.printCommentsBefore((AST)operator, false, out) && out.newline) {
                            this.printIndentation(out);
                        }
                        if (paddOperator) {
                            out.print(" ", 173);
                            out.print(operator.getText(), operator.getType());
                        } else {
                            out.print(operator.getText(), operator.getType());
                        }
                    }
                    if (!commentAfter) break block36;
                    this.printCommentsAfter((AST)operator, false, true, out);
                    wrapped = true;
                    this.printIndentation(out);
                    break block37;
                }
                if (!wrapLines) break block37;
                boolean wrapAll = false;
                if (!out.state.parenScope.isEmpty()) {
                    ParenthesesScope scope = (ParenthesesScope)out.state.parenScope.getFirst();
                    wrapAll = scope.wrap;
                }
                if (!wrapAll) break block38;
                switch (operator.getType()) {
                    case 155: 
                    case 156: {
                        if (!wrapped) {
                            tester = out.testers.get();
                            PrinterFactory.create((AST)rhs, out).print((AST)rhs, tester);
                            wrapped = this.performWrap(tester.length + (rhsLeftParen != null ? 2 : 0), (AST)operator, wrapBeforeOperator, paddOperator, out);
                            out.testers.release(tester);
                            break;
                        }
                        break block37;
                    }
                    default: {
                        out.printNewline();
                        this.printIndentation(out);
                        wrapped = true;
                        break;
                    }
                }
                break block37;
            }
            if (!wrapped) {
                tester = out.testers.get();
                PrinterFactory.create((AST)rhs, out).print((AST)rhs, tester);
                wrapped = this.performWrap(tester.length + (rhsLeftParen != null ? 2 : 0), (AST)operator, wrapBeforeOperator, paddOperator, out);
                out.testers.release(tester);
            }
        }
        if (wrapBeforeOperator) {
            if (this.printCommentsBefore((AST)operator, false, out) && out.newline) {
                this.printIndentation(out);
            }
            if (paddOperator) {
                if (!wrapped) {
                    out.print(" ", 173);
                }
                out.print(operator.getText(), operator.getType());
                out.print(" ", 173);
            } else {
                out.print(operator.getText(), operator.getType());
            }
        } else if (paddOperator && !wrapped) {
            out.print(" ", 173);
        }
        if (out.mode == 1) {
            this.wrapNewLine(lhs, out, true);
            this.wrapNewLine(rhs, out, false);
        }
        if (rhsLeftParen == null) {
            PrinterFactory.create((AST)rhs, out).print((AST)rhs, out);
        } else {
            this.printWithParentheses(rhs, rhsLeftParen, rhsRightParen, out);
        }
        if (rhs.hasCommentsAfter()) {
            JavaNode parent = operator.getParent();
            block6 : switch (parent.getType()) {
                case 31: {
                    AST next = parent.getNextSibling();
                    if (next != null) {
                        switch (next.getType()) {
                            case 107: {
                                break block6;
                            }
                        }
                        this.printIndentation(out);
                        break;
                    }
                    this.printIndentation(out);
                }
            }
        }
        if (continuationIndent && !continuation) {
            out.continuation = false;
        }
    }
}

