/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.CommonAST;
import antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.Recognizer;
import de.hunsicker.jalopy.language.TreeWalker;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.language.antlr.Node;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Environment;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.util.Lcs;
import de.hunsicker.util.StringHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class JavadocPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new JavadocPrinter();
    private static final String DELIMETER = "|";
    private static final AST EMPTY_NODE = new CommonAST();
    private static final int NONE = 0;
    private static final int DESCRIPTION = 1;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String KEY_TAG_REMOVE_OBSOLETE = "TAG_REMOVE_OBSOLETE";
    private static final String KEY_TAG_ADD_MISSING = "TAG_ADD_MISSING";
    private static final String KEY_TAG_MISSPELLED_NAME = "TAG_MISSPELLED_NAME";
    private static final String KEY_GENERATE_COMMENT = "GENERATE_COMMENT";
    private static final String TAG_CPARA = "</p>";
    protected static Pattern _pattern = Pattern.compile("(?: )*([a-zA-z0-9_.]*)\\s*(.*)");
    private ThreadLocal _stringBreaker = new ThreadLocal(){

        protected Object initialValue() {
            return new BreakIterator();
        }
    };

    private JavadocPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    @Override
    public void print(AST node, NodeWriter out) {
        throw new UnsupportedOperationException("use print(AST, AST, NodeWriter) instead");
    }

    public void print(AST node, AST comment, NodeWriter out) throws IOException {
        if (!out.newline) {
            out.printNewline();
        }
        out.javadocIndent = 0;
        JavaNode parentParent = null;
        parentParent = ((JavaNode)node).getParent();
        if (parentParent != null) {
            parentParent = parentParent.getParent();
        }
        boolean reformatComment = node.getType() == 17 || node.getType() == 50 || node.getType() == 49 || node.getType() == 13 && (parentParent.getType() == 17 || parentParent.getType() == 18 || parentParent.getType() == 49) || node.getType() == 12 || node.getType() == 11;
        boolean formatJavadoc = AbstractPrinter.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_PARSE, false);
        if ("<GENERATED_JAVADOC_COMMENT>".equals(comment.getText())) {
            String[] lines = StringHelper.split(comment.getFirstChild().getText(), DELIMETER);
            if (lines.length > 0) {
                out.state.args[0] = out.getFilename();
                out.state.args[1] = new Integer(out.line);
                out.state.args[2] = new Integer(out.getIndentLength() + 1);
                int size = lines.length - 1;
                for (int i = 0; i < size; ++i) {
                    out.print(lines[i], 4);
                    out.printNewline();
                }
                out.print(lines[lines.length - 1], 4);
                Loggers.PRINTER_JAVADOC.info((Object)Loggers.fmt(KEY_GENERATE_COMMENT, out.state.args), null);
            }
        } else if (!reformatComment) {
            int currentIndent = out.indentLevel;
            out.indentLevel = 0;
            out.print(comment.getText(), comment.getType());
            out.indentLevel = currentIndent;
        } else if (!formatJavadoc) {
            String[] lines = StringHelper.split(comment.getText(), out.originalLineSeparator);
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i].trim().startsWith("*")) {
                    out.print(" " + lines[i].trim(), 4);
                } else {
                    out.print(lines[i], 4);
                }
                if (i + 1 == lines.length) continue;
                out.printNewline();
            }
        } else {
            Recognizer _recognizer = out.getCompositeFactory().getRecognizer();
            String t = comment.getText();
            _recognizer.setLine(node.getLine());
            _recognizer.setColumn(node.getColumn());
            _recognizer.parse(t, out.filename);
            comment = _recognizer.getParseTree();
            out.print(this.getTopString(node.getType()), 4);
            String bottomText = this.getBottomString(node.getType());
            String asterix = bottomText.substring(0, bottomText.indexOf(42) + 1);
            asterix = this.getAsterix();
            AST firstTag = null;
            String commentText = t;
            if (!AbstractPrinter.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_PARSE_DESCRIPTION, true)) {
                boolean hasFirstTag;
                TestNodeWriter dummy = out.testers.get();
                firstTag = this.printDescriptionSection(node, comment, asterix, dummy);
                boolean bl = hasFirstTag = firstTag != EMPTY_NODE;
                if (hasFirstTag) {
                    commentText = commentText.substring(0, commentText.indexOf(firstTag.getText()));
                }
                out.testers.release(dummy);
                String[] lines = StringHelper.split(commentText, out.originalLineSeparator);
                if (lines.length == 1) {
                    lines[0] = lines[0].substring(3, lines[0].length() - 2);
                    out.print(lines[0], 4);
                } else if (lines.length > 0) {
                    lines[0] = lines[0].substring(3);
                    int i = 0;
                    if (!out.newline) {
                        out.printNewline();
                    }
                    int size = lines.length - 1;
                    while (i < size) {
                        String newline = " " + lines[i].trim();
                        if (!(size - 1 == i && newline.endsWith("*") || newline.length() == 1)) {
                            out.print(newline, 4);
                            out.printNewline();
                        }
                        ++i;
                    }
                }
            } else {
                firstTag = this.printDescriptionSection(node, comment, asterix, out);
            }
            if (firstTag != EMPTY_NODE || AbstractPrinter.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_CHECK_TAGS, false)) {
                this.printTagSection(node, comment, firstTag, asterix, out);
            }
            out.print(bottomText, 4);
        }
    }

    static List getValidTypeNames(AST node, int type) {
        switch (type) {
            case 23: {
                switch (node.getType()) {
                    case 11: 
                    case 12: {
                        break;
                    }
                    case 17: 
                    case 18: {
                        return JavadocPrinter.appendTypeNames(new ArrayList(4), node);
                    }
                    default: {
                        return Collections.EMPTY_LIST;
                    }
                }
                ArrayList<String> names = new ArrayList<String>(4);
                JavadocPrinter.appendTypeNames(names, node);
                for (AST child = JavaNodeHelper.getFirstChild(node, type).getFirstChild(); child != null; child = child.getNextSibling()) {
                    switch (child.getType()) {
                        case 24: 
                        case 47: {
                            names.add(JavaNodeHelper.getFirstChild(child, 77).getText());
                        }
                    }
                }
                return names;
            }
            case 116: {
                final ArrayList<String> names = new ArrayList<String>(3);
                AST exceptions = JavaNodeHelper.getFirstChild(node, type);
                if (exceptions != null) {
                    for (AST child = exceptions.getFirstChild(); child != null; child = child.getNextSibling()) {
                        switch (child.getType()) {
                            case 77: {
                                names.add(child.getText());
                            }
                        }
                    }
                }
                TreeWalker walker = new TreeWalker(){

                    /*
                     * Enabled aggressive block sorting
                     */
                    @Override
                    public void visit(AST aNode) {
                        switch (aNode.getType()) {
                            case 127: {
                                switch (aNode.getFirstChild().getFirstChild().getType()) {
                                    case 166: {
                                        String name = aNode.getFirstChild().getFirstChild().getFirstChild().getText();
                                        if (JavadocPrinter.isEnclosedWithTry((JavaNode)aNode) || names.contains(name)) return;
                                        names.add(name);
                                    }
                                }
                                return;
                            }
                        }
                    }
                };
                walker.walk(node);
                return names;
            }
        }
        return Collections.EMPTY_LIST;
    }

    static boolean isEnclosedWithTry(JavaNode node) {
        JavaNode parent = node.getParent();
        switch (parent.getType()) {
            case 11: 
            case 12: {
                return false;
            }
            case 131: {
                AST next = parent.getFirstChild().getNextSibling();
                if (next != null) {
                    switch (next.getType()) {
                        case 133: {
                            return true;
                        }
                    }
                }
                return false;
            }
        }
        switch (parent.getType()) {
            case 132: 
            case 133: {
                return JavadocPrinter.isEnclosedWithTry(parent.getParent());
            }
        }
        return JavadocPrinter.isEnclosedWithTry(parent);
    }

    private static List appendTypeNames(List names, AST node) {
        if (JavaNodeHelper.getFirstChild(node, 60) != null) {
            for (AST child = JavaNodeHelper.getFirstChild(node, 60).getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != 61) continue;
                names.add("<" + JavaNodeHelper.getFirstChild(child, 77).getText() + ">");
            }
        }
        return names;
    }

    private AST checkReturnTag(AST node, AST returnNode, NodeWriter out) {
        boolean needTag = false;
        block3: for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 16: {
                    if (child.getFirstChild().getType() != 87) {
                        needTag = true;
                        break block3;
                    }
                }
                default: {
                    continue block3;
                }
            }
        }
        if (returnNode != null) {
            if (!needTag) {
                out.state.args[0] = out.getFilename();
                out.state.args[1] = new Integer(out.line);
                out.state.args[2] = new Integer(out.column);
                out.state.args[3] = "@return";
                out.state.args[4] = new Integer(((Node)returnNode).getStartLine());
                returnNode = null;
                Loggers.PRINTER_JAVADOC.warn((Object)Loggers.fmt(KEY_TAG_REMOVE_OBSOLETE, out.state.args), null);
            }
        } else if (needTag) {
            returnNode = this.createTag(node, 17, null, out.environment, out);
        }
        return returnNode;
    }

    private void checkTags(AST node, List tags, int type, String asterix, int last, NodeWriter out) {
        switch (type) {
            case 116: {
                if (AbstractPrinter.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_CHECK_TAGS_THROWS, false)) break;
                return;
            }
        }
        List validNames = JavadocPrinter.getValidTypeNames(node, type);
        ArrayList validNamesCopy = new ArrayList(validNames);
        int capacity = (int)((double)tags.size() * 1.3);
        HashMap<String, AST> correct = new HashMap<String, AST>(capacity);
        ArrayList<AST> wrongOrObsolete = new ArrayList<AST>(capacity);
        int size = tags.size();
        for (int i = 0; i < size; ++i) {
            AST tag = (AST)tags.get(i);
            if (tag.getFirstChild() != null) {
                String description2 = tag.getFirstChild().getText().trim();
                String name = null;
                int offset = -1;
                offset = description2.indexOf(32);
                name = offset > -1 ? description2.substring(0, offset) : description2;
                if (validNamesCopy.contains(name)) {
                    correct.put(name, tag);
                    validNamesCopy.remove(name);
                    continue;
                }
                wrongOrObsolete.add(tag);
                continue;
            }
            switch (tag.getType()) {
                case 14: 
                case 15: 
                case 16: 
                case 18: {
                    wrongOrObsolete.add(tag);
                }
            }
        }
        ArrayList<Object> result = new ArrayList<Object>(validNames);
        Collections.fill(result, null);
        for (Map.Entry entry : correct.entrySet()) {
            result.set(validNames.indexOf(entry.getKey()), entry.getValue());
        }
        if (validNames.size() != tags.size()) {
            int emptySlots;
            AST tag;
            int size2 = wrongOrObsolete.size();
            for (int i = 0; i < size2; ++i) {
                int next = this.getNextEmptySlot(result);
                if (next == -1) {
                    int s = wrongOrObsolete.size();
                    for (int j = i; j < s; ++j) {
                        tag = (AST)wrongOrObsolete.get(j);
                        out.state.args[0] = out.getFilename();
                        out.state.args[1] = new Integer(out.line);
                        out.state.args[2] = new Integer(out.column);
                        out.state.args[3] = tag.getText();
                        out.state.args[4] = new Integer(((Node)tag).getStartLine());
                        out.state.args[5] = tag;
                        Loggers.PRINTER_JAVADOC.warn((Object)Loggers.fmt(KEY_TAG_REMOVE_OBSOLETE, out.state.args), null);
                    }
                    break;
                }
                AST tag2 = (AST)wrongOrObsolete.get(i);
                this.correctTagName(tag2, validNames, next, asterix, last, out);
                result.set(next, tag2);
            }
            if ((emptySlots = validNames.size() - this.getEmptySlotCount(result)) < validNames.size()) {
                int size3 = validNames.size();
                for (int i = emptySlots; i < size3; ++i) {
                    int next = this.getNextEmptySlot(result);
                    String name = (String)validNames.get(next);
                    tag = null;
                    String tagName = null;
                    switch (type) {
                        case 23: {
                            tag = this.createTag(node, 16, name, out.environment, out);
                            result.set(next, tag);
                            tagName = "@param";
                            break;
                        }
                        case 116: {
                            tag = this.createTag(node, 14, name, out.environment, out);
                            result.set(next, tag);
                            tagName = "@throws";
                        }
                    }
                    out.state.args[0] = out.getFilename();
                    out.state.args[1] = new Integer(out.line + next + (this.shouldHaveNewlineBefore(tag, last) ? 1 : 0));
                    out.state.args[2] = new Integer(out.getIndentLength() + asterix.length() + 1);
                    out.state.args[3] = tagName;
                    out.state.args[4] = name;
                    Loggers.PRINTER_JAVADOC.warn((Object)Loggers.fmt(KEY_TAG_ADD_MISSING, out.state.args), null);
                }
            }
            tags.clear();
            tags.addAll(result);
        } else {
            int size4 = result.size();
            for (int i = 0; i < size4; ++i) {
                AST tag = (AST)result.get(i);
                if (tag == null || tag.getFirstChild() == null) {
                    AST wrongTag = (AST)wrongOrObsolete.remove(0);
                    this.correctTagName(wrongTag, validNames, i, asterix, last, out);
                    tag = wrongTag;
                }
                tags.set(i, tag);
            }
        }
    }

    private int correctTagName(AST wrongTag, List validNames, int index, String asterix, int last, NodeWriter out) {
        AST child = wrongTag.getFirstChild();
        if (child != null) {
            String text = child.getText().trim();
            String oldName = null;
            int offset = -1;
            offset = text.indexOf(32);
            if (offset > -1) {
                oldName = text.substring(0, offset);
            } else {
                oldName = text;
                offset = text.length();
            }
            String match = this.getMatch(oldName, validNames);
            String newName = null;
            if (match != null) {
                newName = match;
                index = validNames.indexOf(match);
            } else {
                newName = (String)validNames.get(index);
            }
            out.state.args[0] = out.getFilename();
            out.state.args[1] = new Integer(out.line + index + (this.shouldHaveNewlineBefore(wrongTag, last) ? 1 : 0));
            out.state.args[2] = new Integer(out.getIndentLength() + asterix.length() + 1);
            out.state.args[3] = oldName;
            out.state.args[4] = newName;
            Loggers.PRINTER_JAVADOC.warn((Object)Loggers.fmt(KEY_TAG_MISSPELLED_NAME, out.state.args), null);
            text = " " + newName + text.substring(offset);
            child.setText(text);
        } else {
            String newName = (String)validNames.get(index);
            String text = " " + newName;
            Node c = (Node)out.getJavaNodeFactory().create(40, text);
            wrongTag.setFirstChild((AST)c);
        }
        return index;
    }

    private AST createTag(AST node, int type, String typeName, Environment environment, NodeWriter out) {
        AST tag = out.getJavaNodeFactory().create(type, EMPTY_STRING);
        if (typeName != null) {
            AST para = out.getJavaNodeFactory().create(40, this.getTagTemplateText(node, typeName, type, environment));
            tag.setFirstChild(para);
        } else {
            AST description2 = out.getJavaNodeFactory().create(40, this.getTagTemplateText(node, null, type, environment));
            tag.setFirstChild(description2);
        }
        return tag;
    }

    private void generalPrint(NodeWriter out, int nodeType, String text, String asterix) throws IOException {
        this.generalPrint(out, null, nodeType, text, asterix, -1);
    }

    private void generalPrint(NodeWriter out, AST node, String text, String asterix) throws IOException {
        this.generalPrint(out, node, -1, text, asterix, -1);
    }

    private void generalPrint(NodeWriter out, AST node, int nodeType, String text, String asterix, int length) throws IOException {
        boolean newLine = false;
        boolean newLineAfter = false;
        length = length > 0 ? (length += out.javadocIndent * out.indentSize) : out.javadocIndent * out.indentSize;
        if (nodeType < 0) {
            nodeType = node.getType();
        }
        switch (nodeType) {
            case 7: 
            case 9: {
                if (!out.newline) {
                    newLine = true;
                }
                ++out.javadocIndent;
                length += out.indentSize;
                break;
            }
            case 35: {
                newLineAfter = true;
            }
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 63: 
            case 82: {
                if (out.newline) break;
                newLine = true;
                break;
            }
            case 57: 
            case 59: 
            case 78: {
                ++out.javadocIndent;
                if (out.newline) break;
                newLine = true;
                break;
            }
            case 58: 
            case 60: {
                newLineAfter = true;
                newLine = true;
            }
            case 79: {
                if (!out.newline) {
                    newLine = true;
                }
                --out.javadocIndent;
                length -= out.indentSize;
                newLineAfter = true;
                break;
            }
            case 8: 
            case 10: {
                length -= out.indentSize;
                --out.javadocIndent;
                break;
            }
            case 83: {
                if (out.newline) break;
                newLine = true;
            }
        }
        int maxwidth = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80) - 3 - out.getIndentLength() - length;
        if (out.newline) {
            out.print(asterix, 4);
            if (length > -1) {
                out.print(out.getString(length + 1), 173);
            }
        }
        String[] lines = this.split(text, maxwidth, out.column, true);
        if (newLine) {
            out.printNewline();
            out.print(asterix, 4);
            if (length > -1) {
                out.print(out.getString(length + 1), 173);
            }
        }
        if (lines.length > 1) {
            for (int x = 0; x < lines.length; ++x) {
                out.print(lines[x], nodeType);
                if (x + 1 >= lines.length) continue;
                out.printNewline();
                out.print(asterix, 4);
                if (length <= 0) continue;
                out.print(out.getString(length + 1), 173);
            }
        } else if (lines.length == 1) {
            out.print(lines[0], nodeType);
        }
        if (newLineAfter) {
            out.printNewline();
        }
    }

    private String getAsterix() {
        int asterix;
        String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_PARAM, " * @param $paramType$ DOCUMENT ME!");
        int description2 = StringHelper.indexOfNonWhitespace(text, (asterix = text.indexOf(42)) + 1);
        if (description2 > -1) {
            return text.substring(0, description2);
        }
        if (asterix > -1) {
            return text.substring(0, asterix + 1);
        }
        return EMPTY_STRING;
    }

    private String getBottomString(int type) {
        switch (type) {
            case 12: {
                return AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_BOTTOM, " */");
            }
            case 11: {
                return AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_BOTTOM, " */");
            }
            case 13: {
                String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_VARIABLE, "/**| * DOCUMENT ME!| */").trim();
                int offset = text.lastIndexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(offset + 1);
                }
                return " */";
            }
            case 17: {
                String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CLASS, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */").trim();
                int offset = text.lastIndexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(offset + 1);
                }
                return " */";
            }
            case 18: {
                String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_INTERFACE, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */").trim();
                int offset = text.lastIndexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(offset + 1);
                }
                return " */";
            }
        }
        return " */";
    }

    private int getEmptySlotCount(List list) {
        int empty = 0;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (list.get(i) != null) continue;
            ++empty;
        }
        return empty;
    }

    private String getMatch(String string, List list) {
        if (string == null) {
            return null;
        }
        if (list.contains(string)) {
            return string;
        }
        Lcs lcs = new Lcs();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String tag = (String)list.get(i);
            lcs.init(string, tag);
            double similarity = lcs.getPercentage();
            if (!(similarity > 75.0)) continue;
            return tag;
        }
        return null;
    }

    private int getNextEmptySlot(List list) {
        int result = -1;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (list.get(i) != null) continue;
            return i;
        }
        return result;
    }

    private int getParamCount(AST node) {
        int count = 0;
        if (JavaNodeHelper.getFirstChild(node, 23) != null) {
            for (AST param = JavaNodeHelper.getFirstChild(node, 23).getFirstChild(); param != null; param = param.getNextSibling()) {
                ++count;
            }
        }
        if (JavaNodeHelper.getFirstChild(node, 60) != null) {
            for (AST child = JavaNodeHelper.getFirstChild(node, 60).getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != 61) continue;
                ++count;
            }
        }
        return count;
    }

    private String getTagTemplateText(AST node, String typeName, int type, Environment environment) {
        switch (type) {
            case 16: {
                switch (node.getType()) {
                    case 12: {
                        String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_PARAM, " * @param $paramType$ DOCUMENT ME!");
                    }
                    case 11: 
                    case 17: 
                    case 18: {
                        String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_PARAM, " * @param $paramType$ DOCUMENT ME!");
                        int offset = text.indexOf(42);
                        environment.set(Environment.Variable.TYPE_PARAM.getName(), typeName);
                        if (offset > -1) {
                            text = text.substring(offset + 1).trim();
                        }
                        text = environment.interpolate(text);
                        environment.unset(Environment.Variable.TYPE_PARAM.getName());
                        return text;
                    }
                }
                throw new IllegalArgumentException("invalid node type to add @param tag -- " + node);
            }
            case 14: 
            case 15: {
                switch (node.getType()) {
                    case 12: {
                        String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_EXCEPTION, " * @throws $exceptionType$ DOCUMENT ME!");
                    }
                    case 11: {
                        String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_EXCEPTION, " * @throws $exceptionType$ DOCUMENT ME!");
                        int offset = text.indexOf(42);
                        environment.set(Environment.Variable.TYPE_EXCEPTION.getName(), typeName);
                        if (offset > -1) {
                            text = text.substring(offset + 1).trim();
                        }
                        text = environment.interpolate(text);
                        environment.unset(Environment.Variable.TYPE_EXCEPTION.getName());
                        return text;
                    }
                }
                throw new IllegalArgumentException("invalid node type to add @throws tag -- " + node);
            }
            case 17: {
                switch (node.getType()) {
                    case 12: {
                        String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_RETURN, " * @return DOCUMENT ME!");
                        int offset = text.indexOf(42);
                        if (offset > -1) {
                            text = text.substring(offset + 1).trim();
                        }
                        return text;
                    }
                }
                throw new IllegalArgumentException("invalid node type to add @return tag -- " + node);
            }
        }
        return EMPTY_STRING;
    }

    private String getTopString(int type) {
        switch (type) {
            case 12: {
                String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_TOP, "/**| * DOCUMENT ME!");
                int offset = text.indexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(0, offset);
                }
                return text;
            }
            case 11: {
                String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_TOP, "/**| * Creates a new $objectType$ object.");
                int offset = text.indexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(0, offset);
                }
                return text;
            }
            case 13: {
                String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_VARIABLE, "/**| * DOCUMENT ME!| */").trim();
                int offset = text.indexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(0, offset);
                }
                return "/**";
            }
            case 17: {
                String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CLASS, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */").trim();
                int offset = text.indexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(0, offset);
                }
                return "/**";
            }
            case 18: {
                String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_INTERFACE, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */").trim();
                int offset = text.indexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(0, offset);
                }
                return "/**";
            }
        }
        return "/**";
    }

    private boolean hasInheritDoc(AST comment) {
        AST child = comment.getFirstChild();
        if (child != null) {
            switch (child.getType()) {
                case 26: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean isValidNode(AST node) {
        switch (node.getType()) {
            case 11: 
            case 12: 
            case 17: 
            case 18: {
                return true;
            }
            case 13: {
                return !JavaNodeHelper.isLocalVariable(node);
            }
        }
        return false;
    }

    private String mergeChildren(AST node, String newLineString, String asterix) {
        StringBuffer buf = new StringBuffer(150);
        block7: for (AST child = node; child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 7: 
                case 9: 
                case 41: 
                case 43: 
                case 45: 
                case 47: 
                case 49: 
                case 51: 
                case 57: 
                case 59: 
                case 61: 
                case 75: 
                case 78: 
                case 82: 
                case 84: 
                case 86: 
                case 88: 
                case 90: 
                case 92: 
                case 94: 
                case 96: 
                case 98: 
                case 100: 
                case 102: 
                case 104: 
                case 106: 
                case 108: 
                case 110: 
                case 112: 
                case 114: 
                case 116: 
                case 118: 
                case 121: 
                case 123: {
                    buf.append(child.getText());
                    buf.append(this.mergeChildren(child.getFirstChild(), newLineString, asterix));
                    continue block7;
                }
                case 63: 
                case 65: 
                case 67: {
                    buf.append(child.getText());
                    buf.append(this.mergeChildren(child.getFirstChild(), newLineString, asterix));
                    buf.append(" ");
                    continue block7;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    buf.append("{");
                    buf.append(child.getText());
                    buf.append(this.mergeChildren(child.getFirstChild(), newLineString, asterix));
                    buf.append("}");
                    continue block7;
                }
                case 77: {
                    throw new IllegalStateException("<pre> tag not supported within tag description");
                }
                case 37: {
                    buf.append(child.getText());
                    buf.append(newLineString);
                    buf.append(asterix);
                    continue block7;
                }
                default: {
                    buf.append(child.getText());
                }
            }
        }
        return buf.toString();
    }

    private void printBlockquote(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
        node = this.printContent(node.getFirstChild(), asterix, out);
        this.generalPrint(out, node, node.getText(), asterix);
    }

    private void printComment(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
    }

    private void printCommentLines(String[] lines, String asterix, NodeWriter out) throws IOException {
        this.printCommentLines(lines, asterix, out, false);
    }

    private void printCommentLines(String[] lines, String asterix, NodeWriter out, boolean trim) throws IOException {
        int maxColumn = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        if (trim) {
            for (int i = 0; i < lines.length; ++i) {
                if (asterix != null && out.column + lines[i].length() > maxColumn) {
                    out.printNewline();
                    out.print(asterix, 40);
                }
                out.print(lines[i].trim(), 40);
            }
        } else {
            for (int i = 0; i < lines.length; ++i) {
                if (asterix != null && out.column + lines[i].length() > maxColumn) {
                    out.printNewline();
                    out.print(asterix, 40);
                }
                out.print(lines[i], 40);
            }
        }
    }

    private AST printContent(AST node, String asterix, NodeWriter out) throws IOException {
        AST next = EMPTY_NODE;
        block12: for (AST child = node; child != null; child = child.getNextSibling()) {
            block13: while (true) {
                switch (child.getType()) {
                    case 39: {
                        this.printComment(child, asterix, out);
                        continue block12;
                    }
                    case 5: 
                    case 6: 
                    case 33: 
                    case 36: 
                    case 37: 
                    case 40: 
                    case 84: 
                    case 86: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 94: 
                    case 96: 
                    case 98: 
                    case 100: 
                    case 102: 
                    case 104: 
                    case 106: 
                    case 108: 
                    case 110: 
                    case 112: 
                    case 114: 
                    case 116: 
                    case 118: 
                    case 120: 
                    case 121: 
                    case 123: {
                        child = this.printText(child, asterix, out);
                        continue block13;
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        child = this.printText(child, asterix, out);
                        continue block13;
                    }
                    case 55: {
                        this.printParagraph(child, asterix, out);
                        continue block12;
                    }
                    case 75: {
                        this.printBlockquote(child, asterix, out);
                        continue block12;
                    }
                    case 35: {
                        this.generalPrint(out, child, child.getText(), asterix);
                        continue block12;
                    }
                    case 41: 
                    case 43: 
                    case 45: 
                    case 47: 
                    case 49: 
                    case 51: {
                        this.printHeading(child, asterix, out);
                        continue block12;
                    }
                    case 78: {
                        this.printTable(child, asterix, out);
                        continue block12;
                    }
                    case 77: {
                        this.printPreformatted(child, asterix, out);
                        continue block12;
                    }
                    case 57: 
                    case 59: 
                    case 61: {
                        this.printList(child, asterix, out);
                        continue block12;
                    }
                    default: {
                        next = child;
                        break block12;
                    }
                }
                break;
            }
        }
        return next;
    }

    private AST printDescriptionSection(AST node, AST comment, String asterix, NodeWriter out) throws IOException {
        switch (node.getType()) {
            case 13: 
            case 50: {
                if (!AbstractPrinter.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_FIELDS_SHORT, true) || !this.printSingleLineDescription(node, comment, out)) break;
                return EMPTY_NODE;
            }
        }
        out.printNewline();
        out.print(asterix, 4);
        AST result = this.printContent(comment.getFirstChild(), asterix, out);
        if (!out.newline) {
            out.printNewline();
        }
        return result;
    }

    private void printHeading(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
        if (node.getFirstChild() != null && (node = this.printText(node.getFirstChild(), asterix, out)) != EMPTY_NODE) {
            this.generalPrint(out, node, node.getText(), asterix);
        }
        out.last = 42;
    }

    private void printList(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
        AST child = null;
        for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.printListItem(child, asterix, out);
        }
    }

    private void printListItem(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
        AST newnode = this.printContent(node.getFirstChild(), asterix, out);
        if (newnode != EMPTY_NODE) {
            this.generalPrint(out, newnode, newnode.getText(), asterix);
        }
    }

    private void printNewlineBefore(AST tag, int last, String asterix, NodeWriter out) throws IOException {
        if (this.shouldHaveNewlineBefore(tag, last)) {
            if (!out.newline) {
                out.printNewline();
            }
            out.print(StringHelper.trimTrailing(asterix), 40);
            out.printNewline();
        }
    }

    private void printParagraph(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
        if (node.getFirstChild() != null) {
            block7: for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                block8: while (true) {
                    switch (child.getType()) {
                        case 5: 
                        case 6: 
                        case 33: 
                        case 36: 
                        case 37: 
                        case 40: 
                        case 84: 
                        case 86: 
                        case 88: 
                        case 90: 
                        case 92: 
                        case 94: 
                        case 96: 
                        case 98: 
                        case 100: 
                        case 102: 
                        case 104: 
                        case 106: 
                        case 108: 
                        case 110: 
                        case 112: 
                        case 114: 
                        case 116: 
                        case 118: 
                        case 121: 
                        case 123: {
                            child = this.printText(child, asterix, out);
                            continue block8;
                        }
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: {
                            out.print("{", 5);
                            child = this.printText(child, asterix, out);
                            out.print("}", 6);
                            continue block8;
                        }
                        case 75: {
                            this.printBlockquote(child, asterix, out);
                            continue block7;
                        }
                        case 77: {
                            this.printPreformatted(child, asterix, out);
                            continue block7;
                        }
                        case 57: 
                        case 59: 
                        case 61: {
                            this.printList(child, asterix, out);
                            continue block7;
                        }
                    }
                    break;
                }
            }
            this.generalPrint(out, 56, TAG_CPARA, asterix);
        } else {
            this.generalPrint(out, 56, TAG_CPARA, asterix);
        }
        if (!out.newline) {
            out.printNewline();
        }
    }

    private void printPreformatted(AST node, String asterix, NodeWriter out) throws IOException {
        String[] lines = this.split(node.getText(), out.originalLineSeparator, '*');
        this.printCommentLines(lines, asterix, out);
        out.last = 77;
    }

    private int printReturnTag(AST tag, String asterix, int maxWidth, boolean added, int last, NodeWriter out) throws IOException {
        if (tag != null) {
            if (added) {
                out.state.args[0] = out.getFilename();
                out.state.args[1] = new Integer(out.line + (this.shouldHaveNewlineBefore(tag, last) ? 1 : 0));
                out.state.args[2] = new Integer(out.getIndentLength() + asterix.length() + 1);
                out.state.args[3] = "@return";
                out.state.args[4] = EMPTY_STRING;
                Loggers.PRINTER_JAVADOC.warn((Object)Loggers.fmt(KEY_TAG_ADD_MISSING, out.state.args), null);
            }
            return this.printTag(tag, asterix, maxWidth, last, out);
        }
        return last;
    }

    private boolean printSingleLineDescription(AST node, AST comment, NodeWriter out) throws IOException {
        StringBuffer buf = new StringBuffer();
        int maxwidth = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80) - 3 - out.getIndentLength();
        for (AST child = comment.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 30: 
                case 55: {
                    return false;
                }
                case 5: 
                case 6: 
                case 33: 
                case 36: 
                case 37: 
                case 40: {
                    buf.append(child.getText());
                    break;
                }
                case 84: 
                case 86: 
                case 88: 
                case 90: 
                case 92: 
                case 94: 
                case 96: 
                case 98: 
                case 100: 
                case 102: 
                case 104: 
                case 106: 
                case 108: 
                case 110: 
                case 112: 
                case 114: 
                case 116: 
                case 118: 
                case 121: 
                case 123: {
                    buf.append(child.getText());
                    buf.append(this.mergeChildren(child.getFirstChild(), "", ""));
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    buf.append("{");
                    buf.append(child.getText());
                    for (AST part = child.getFirstChild(); part != null; part = part.getNextSibling()) {
                        buf.append(part.getText());
                    }
                    buf.append("}");
                }
            }
            if (buf.length() <= maxwidth) continue;
            return false;
        }
        if (buf.length() < maxwidth) {
            out.print(" ", 4);
            out.print(buf.toString().trim(), 4);
            return true;
        }
        return false;
    }

    private void printTable(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
        for (AST row = node.getFirstChild(); row != null; row = row.getNextSibling()) {
            this.printTableRow(row, asterix, out);
        }
    }

    private void printTableData(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
        if (node.getFirstChild() != null) {
            AST nextNode = this.printContent(node.getFirstChild(), asterix, out);
            this.generalPrint(out, nextNode, nextNode.getText(), asterix);
        }
    }

    private void printTableRow(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
        for (AST cell = node.getFirstChild(); cell != null; cell = cell.getNextSibling()) {
            this.printTableData(cell, asterix, out);
        }
    }

    private int printTag(AST tag, String asterix, int maxwidth, int last, NodeWriter out) throws IOException {
        if (tag != null) {
            this.printNewlineBefore(tag, last, asterix, out);
            if (out.newline) {
                out.print(asterix, 4);
            }
            String ident = tag.getText();
            out.print(ident, 4);
            switch (tag.getType()) {
                case 23: {
                    AST child = tag.getFirstChild();
                    if (child == null) break;
                    String description2 = this.mergeChildren(child, out.lineSeparator, asterix);
                    switch (description2.charAt(0)) {
                        case ' ': 
                        case '<': 
                        case '{': {
                            out.print(" ", 4);
                        }
                    }
                    out.print(description2.trim(), 4);
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 22: {
                    this.printTagDescription(tag.getFirstChild(), ident, asterix, maxwidth, true, out);
                    break;
                }
                default: {
                    this.printTagDescription(tag.getFirstChild(), ident, asterix, maxwidth, false, out);
                }
            }
            out.printNewline();
            return tag.getType();
        }
        return last;
    }

    private void printTagDescription(AST child, String name, String asterix, int maxwidth, boolean normalize, NodeWriter out) throws IOException {
        if (child != null) {
            Matcher matcher;
            String description2 = this.mergeChildren(child, out.lineSeparator, asterix);
            switch (description2.charAt(0)) {
                case ' ': 
                case '<': 
                case '{': {
                    out.print(" ", 4);
                }
            }
            if (normalize && description2.charAt(0) != '@' && (matcher = _pattern.matcher(description2)).matches() && matcher.group(1) != null) {
                StringBuffer buf = new StringBuffer(description2.length());
                buf.append(matcher.group(1));
                buf.append(" ");
                buf.append(matcher.group(2));
                description2 = buf.toString();
            }
            int length = name.length();
            String[] lines = this.split(description2.trim(), maxwidth - length - 1, 0, true);
            int size = lines.length - 1;
            for (int i = 0; i < size; ++i) {
                out.print(lines[i], 4);
                out.printNewline();
                out.print(asterix, 4);
                out.print(out.getString(length + 1), 173);
            }
            out.print(lines[lines.length - 1], 4);
        }
    }

    private void printTagSection(AST node, AST comment, AST firstTag, String asterix, NodeWriter out) throws IOException {
        ArrayList<AST> parameterTags = Collections.EMPTY_LIST;
        ArrayList<AST> annotationTags = Collections.EMPTY_LIST;
        AST serialTag = null;
        AST serialDataTag = null;
        ArrayList<AST> serialFieldsTags = Collections.EMPTY_LIST;
        AST sinceTag = null;
        ArrayList<AST> seesTags = Collections.EMPTY_LIST;
        AST versionTag = null;
        ArrayList<AST> customTags = Collections.EMPTY_LIST;
        ArrayList<AST> authorTags = Collections.EMPTY_LIST;
        AST deprecatedTag = null;
        AST returnTag = null;
        ArrayList<AST> exceptionTags = Collections.EMPTY_LIST;
        boolean checkTags = AbstractPrinter.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_CHECK_TAGS, false);
        if (checkTags) {
            checkTags = this.shouldCheckTags(node, comment);
        }
        block25: for (AST tag = firstTag; tag != null; tag = tag.getNextSibling()) {
            switch (tag.getType()) {
                case 16: {
                    if (parameterTags.isEmpty()) {
                        parameterTags = new ArrayList<AST>(4);
                    }
                    parameterTags.add(tag);
                    continue block25;
                }
                case 20: {
                    serialTag = tag;
                    continue block25;
                }
                case 21: {
                    serialDataTag = tag;
                    continue block25;
                }
                case 22: {
                    if (serialFieldsTags.isEmpty()) {
                        serialFieldsTags = new ArrayList<AST>(4);
                    }
                    serialFieldsTags.add(tag);
                    continue block25;
                }
                case 19: {
                    sinceTag = tag;
                    continue block25;
                }
                case 18: {
                    if (seesTags.isEmpty()) {
                        seesTags = new ArrayList<AST>(4);
                    }
                    seesTags.add(tag);
                    if (!checkTags || tag.getNextSibling() != null || tag != firstTag) continue block25;
                    checkTags = false;
                    continue block25;
                }
                case 23: {
                    versionTag = tag;
                    continue block25;
                }
                case 13: {
                    deprecatedTag = tag;
                    continue block25;
                }
                case 12: {
                    if (authorTags.isEmpty()) {
                        authorTags = new ArrayList<AST>(4);
                    }
                    authorTags.add(tag);
                    continue block25;
                }
                case 17: {
                    returnTag = tag;
                    continue block25;
                }
                case 38: {
                    if (annotationTags.isEmpty()) {
                        annotationTags = new ArrayList<AST>(4);
                    }
                    annotationTags.add(tag);
                    continue block25;
                }
                case 14: 
                case 15: {
                    if (exceptionTags.isEmpty()) {
                        exceptionTags = new ArrayList<AST>(4);
                    }
                    exceptionTags.add(tag);
                    continue block25;
                }
                case 11: 
                case 30: {
                    if (customTags.isEmpty()) {
                        customTags = new ArrayList<AST>(5);
                    }
                    customTags.add(tag);
                }
            }
        }
        int maxwidth = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80) - out.getIndentLength() - 3;
        int last = 0;
        if (comment.getFirstChild() != firstTag) {
            last = 1;
        } else if (checkTags) {
            out.print("DOCUMENT ME!", 40);
            out.printNewline();
            last = 1;
        }
        boolean returnTagAdded = false;
        boolean checkParameterTags = false;
        boolean checkThrowsTags = false;
        switch (node.getType()) {
            case 13: {
                last = this.printTag(serialTag, asterix, maxwidth, last, out);
                last = this.printTags(serialFieldsTags, asterix, maxwidth, last, out);
                break;
            }
            case 12: {
                if (checkTags) {
                    boolean tagPresent = returnTag != null;
                    returnTag = this.checkReturnTag(node, returnTag, out);
                    returnTagAdded = !tagPresent && returnTag != null;
                }
            }
            case 11: {
                last = this.printTag(serialDataTag, asterix, maxwidth, last, out);
            }
            case 17: 
            case 18: {
                if (node.getType() == 17 || node.getType() == 18) {
                    last = this.printTags(authorTags, asterix, maxwidth, last, out);
                    last = this.printTag(versionTag, asterix, maxwidth, last, out);
                    last = this.printTag(serialTag, asterix, maxwidth, last, out);
                }
                if (this.getParamCount(node) > 0) {
                    if (checkTags) {
                        if (parameterTags.isEmpty()) {
                            parameterTags = new ArrayList(5);
                        }
                        checkParameterTags = true;
                    }
                    last = checkParameterTags ? this.printTags(parameterTags, asterix, maxwidth, node, 23, last, out) : this.printTags(parameterTags, asterix, maxwidth, last, out);
                }
                switch (node.getType()) {
                    case 12: {
                        last = this.printReturnTag(returnTag, asterix, maxwidth, returnTagAdded, last, out);
                    }
                    case 11: {
                        if (checkTags) {
                            if (exceptionTags.isEmpty()) {
                                exceptionTags = new ArrayList();
                            }
                            checkThrowsTags = true;
                        }
                        last = checkThrowsTags ? this.printTags(exceptionTags, asterix, maxwidth, node, 116, last, out) : this.printTags(exceptionTags, asterix, maxwidth, last, out);
                    }
                }
            }
        }
        last = this.printTags(customTags, asterix, maxwidth, last, out);
        last = this.printTags(seesTags, asterix, maxwidth, last, out);
        last = this.printTag(sinceTag, asterix, maxwidth, last, out);
        last = this.printTag(deprecatedTag, asterix, maxwidth, last, out);
        last = this.printTags(annotationTags, asterix, maxwidth, last, out);
    }

    private int printTags(List tags, String asterix, int maxwidth, AST node, int tagType, int last, NodeWriter out) throws IOException {
        if (tagType != -1) {
            this.checkTags(node, tags, tagType, asterix, last, out);
        }
        return this.printTags(tags, asterix, maxwidth, last, out);
    }

    private int printTags(List tags, String asterix, int maxwidth, int last, NodeWriter out) throws IOException {
        int size = tags.size();
        for (int i = 0; i < size; ++i) {
            last = this.printTag((AST)tags.get(i), asterix, maxwidth, last, out);
        }
        return last;
    }

    private AST printText(AST node, String asterix, NodeWriter out) throws IOException {
        StringBuffer buf = new StringBuffer(200);
        AST next = EMPTY_NODE;
        block9: for (AST child = node; child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 39: {
                    this.printComment(child, asterix, out);
                    continue block9;
                }
                case 5: 
                case 6: 
                case 33: 
                case 36: 
                case 37: 
                case 40: 
                case 120: {
                    buf.append(child.getText());
                    continue block9;
                }
                case 84: 
                case 86: 
                case 88: 
                case 90: 
                case 92: 
                case 94: 
                case 96: 
                case 98: 
                case 100: 
                case 102: 
                case 104: 
                case 106: 
                case 108: 
                case 110: 
                case 112: 
                case 114: 
                case 116: 
                case 118: 
                case 121: 
                case 123: {
                    buf.append(child.getText());
                    buf.append(this.mergeChildren(child.getFirstChild(), out.lineSeparator, asterix));
                    continue block9;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    buf.append("{");
                    buf.append(child.getText());
                    for (AST part = child.getFirstChild(); part != null; part = part.getNextSibling()) {
                        switch (part.getType()) {
                            case 121: {
                                buf.append(' ');
                            }
                        }
                        buf.append(part.getText());
                    }
                    buf.append("}");
                    continue block9;
                }
                default: {
                    next = child;
                    break block9;
                }
            }
        }
        if (buf.length() > 0) {
            this.generalPrint(out, node, buf.toString().trim(), asterix);
        }
        return next;
    }

    private boolean shouldCheckTags(AST node, AST comment) {
        return this.isValidNode(node) && !this.hasInheritDoc(comment);
    }

    private boolean shouldHaveNewlineBefore(AST tag, int last) {
        boolean result = false;
        block0 : switch (last) {
            case 1: {
                result = true;
                break;
            }
            case 0: {
                break;
            }
            default: {
                switch (tag.getType()) {
                    case 14: 
                    case 15: {
                        switch (last) {
                            case 14: 
                            case 15: {
                                break block0;
                            }
                        }
                        result = true;
                        break block0;
                    }
                    case 23: {
                        break block0;
                    }
                    case 11: 
                    case 12: 
                    case 16: 
                    case 30: {
                        if (last == tag.getType()) break block0;
                        result = true;
                        break block0;
                    }
                    case 17: {
                        result = true;
                        break block0;
                    }
                    case 18: {
                        if (last == tag.getType()) break block0;
                        result = true;
                        break block0;
                    }
                    default: {
                        switch (last) {
                            case 12: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 23: {
                                result = true;
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    private String[] split(String str, String delim, char character) {
        if (character > '\uffffffff') {
            String line;
            int startOffset = 0;
            int endOffset = -1;
            int sepLength = delim.length();
            ArrayList<String> lines = new ArrayList<String>(15);
            while ((endOffset = str.indexOf(delim, startOffset)) > -1) {
                line = str.substring(startOffset, endOffset);
                lines.add(this.trimLeadingWhitespace(line, character));
                startOffset = endOffset + sepLength;
            }
            if (startOffset > 0) {
                line = this.trimLeadingWhitespace(str.substring(startOffset), character);
                lines.add(line);
            } else {
                lines.add(this.trimLeadingWhitespace(str, character));
            }
            return lines.toArray(EMPTY_STRING_ARRAY);
        }
        return StringHelper.split(str, delim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] split(String str, int width, int columnStart, boolean trim) {
        ArrayList<String> lines = new ArrayList<String>();
        if (trim) {
            str = str.trim();
        }
        if (str.length() + columnStart < width) {
            lines.add(str);
        } else {
            BreakIterator iterator = (BreakIterator)this._stringBreaker.get();
            try {
                iterator.setText(str);
                int lineStart = 0;
                int nextStart = iterator.next();
                int prevStart = 0;
                block6: while (true) {
                    if (nextStart - lineStart + columnStart < width && nextStart != -10) {
                        prevStart = nextStart;
                        nextStart = iterator.next();
                        switch (iterator._type) {
                            case 2: {
                                prevStart = nextStart + 4;
                                break;
                            }
                            default: {
                                continue block6;
                            }
                        }
                    }
                    if (prevStart == 0) {
                        prevStart = nextStart;
                    }
                    if (nextStart == -10) {
                        if (prevStart - lineStart + (str.length() - prevStart) + columnStart < width) {
                            lines.add(str.substring(lineStart, str.length()).trim());
                        } else if (prevStart > 0 && prevStart != -10) {
                            if (trim) {
                                lines.add(str.substring(lineStart, prevStart).trim());
                                lines.add(str.substring(prevStart).trim());
                            } else {
                                lines.add(str.substring(lineStart, prevStart));
                                lines.add(str.substring(prevStart));
                            }
                        } else if (trim) {
                            lines.add(str.substring(lineStart).trim());
                        } else {
                            lines.add(str.substring(lineStart));
                        }
                        prevStart = str.length();
                    } else if (trim) {
                        lines.add(str.substring(lineStart, prevStart).trim());
                    } else {
                        lines.add(str.substring(lineStart, prevStart));
                    }
                    lineStart = prevStart;
                    prevStart = 0;
                    columnStart = 0;
                    if (lineStart >= str.length()) break;
                }
            }
            finally {
                iterator.reset();
            }
        }
        return lines.toArray(EMPTY_STRING_ARRAY);
    }

    private String trimLeadingWhitespace(String str, char character) {
        int off = StringHelper.indexOfNonWhitespace(str);
        if (off > -1 && str.charAt(off) == character) {
            return str.substring(off + 1);
        }
        return str;
    }

    private static class BreakIterator {
        private static final int WHITESPACE = 1;
        private static final int BREAK = 2;
        public static final int DONE = -10;
        private static final String TAG_BREAK = "<br>";
        private static final String TAG_BREAK_WELL = "<br/>";
        int _type;
        private String _text;
        private int _end = -1;
        private int _pos = -1;

        public int getBreakType() {
            return this._type;
        }

        public int next() {
            this._type = 1;
            this._pos = this._text.indexOf(32, this._end + 1);
            if (this._pos > -1) {
                int br;
                int tab = this._text.indexOf(9, this._end + 1);
                if (tab > -1 && tab < this._pos) {
                    this._pos = tab;
                }
                if ((br = this._text.indexOf(TAG_BREAK, this._end + 1)) == -1) {
                    br = this._text.indexOf(TAG_BREAK_WELL, this._end + 1);
                }
                if (br > -1 && br < this._pos) {
                    this._pos = br;
                    this._type = 2;
                }
            }
            if (this._pos == -1) {
                return -10;
            }
            this._end = this._pos;
            return this._pos;
        }

        public void reset() {
            this._text = null;
            this._end = -1;
            this._pos = -1;
        }

        public void setText(String text) {
            this._text = text;
        }
    }
}

