/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class LeftParenthesisPrinter
extends AbstractPrinter {
    private static final LeftParenthesisPrinter INSTANCE = new LeftParenthesisPrinter();

    private LeftParenthesisPrinter() {
    }

    public static LeftParenthesisPrinter getInstance() {
        return INSTANCE;
    }

    @Override
    public void print(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        if (AbstractPrinter.settings.getBoolean(ConventionKeys.PADDING_PAREN, false)) {
            out.print("( ", 106);
        } else {
            out.print("(", 106);
        }
        this.printCommentsAfter(node, false, true, out);
        if (out.mode == 1 && AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_PAREN_GROUPING, false)) {
            block0 : switch (node.getType()) {
                case 106: {
                    JavaNode parent = ((JavaNode)node).getParent();
                    switch (parent.getType()) {
                        case 11: 
                        case 12: 
                        case 30: 
                        case 78: 
                        case 119: 
                        case 121: 
                        case 122: 
                        case 126: 
                        case 129: 
                        case 133: 
                        case 166: {
                            break block0;
                        }
                    }
                    this.wrap(node, parent, out);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void wrap(AST leftParen, JavaNode parent, NodeWriter out) throws IOException {
        int lineLength;
        TestNodeWriter tester = out.testers.get();
        AST rightParen = null;
        int count = 0;
        block4: for (AST child = leftParen; child != null; child = child.getNextSibling()) {
            PrinterFactory.create(child, out).print(child, tester);
            switch (child.getType()) {
                case 106: {
                    ++count;
                    break;
                }
                case 107: {
                    if (--count != 0) break;
                    rightParen = child;
                    break block4;
                }
            }
        }
        if (out.column + tester.length > (lineLength = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80))) {
            out.printNewline();
            if (AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_DEEP, false)) {
                out.state.markers.add(out.line, out.state.markers.getLast().column + out.indentSize);
            } else {
                out.indent();
            }
            out.state.parentheses.add(rightParen);
            this.printIndentation(out);
        }
        out.testers.release(tester);
    }
}

