/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class SynchronizedPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new SynchronizedPrinter();

    protected SynchronizedPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    @Override
    public void print(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        out.print("synchronized", 103);
        if (AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_BEFORE_STATEMENT_PAREN, true)) {
            out.print(" ", 103);
        }
        AST lparen = node.getFirstChild();
        PrinterFactory.create(lparen, out).print(lparen, out);
        AST expr = lparen.getNextSibling();
        PrinterFactory.create(expr, out).print(expr, out);
        AST rparen = expr.getNextSibling();
        PrinterFactory.create(rparen, out).print(rparen, out);
        AST body = rparen.getNextSibling();
        PrinterFactory.create(body, out).print(body, out);
        out.last = 6;
    }
}

