/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.OperatorPrinter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class TernaryIfElsePrinter
extends OperatorPrinter {
    private static final Printer INSTANCE = new TernaryIfElsePrinter();

    private TernaryIfElsePrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    @Override
    public void print(AST node, NodeWriter out) throws IOException {
        Marker marker = out.state.markers.add();
        AST secondOperand = this.printOperand(node.getFirstChild(), marker, out);
        Marker m = this.printQuestionMark(node, secondOperand, out);
        JavaNode colon = (JavaNode)this.printOperand(secondOperand, marker, out);
        this.printColon(colon, m, out);
        this.printOperand(colon.getNextSibling(), marker, out);
        out.state.markers.remove(marker);
    }

    private JavaNode getNextOperand(AST node) {
        block3: for (AST child = node; child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 106: {
                    continue block3;
                }
                default: {
                    return (JavaNode)child;
                }
            }
        }
        throw new IllegalArgumentException("not part of operand -- " + node);
    }

    private boolean needParentheses(JavaNode node) {
        switch (node.getType()) {
            case 34: 
            case 35: 
            case 79: 
            case 82: 
            case 84: 
            case 85: 
            case 96: 
            case 108: 
            case 112: 
            case 118: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: {
                return true;
            }
        }
        return false;
    }

    private void printColon(JavaNode colon, Marker marker, NodeWriter out) throws IOException {
        boolean wrapLines = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP, true) && out.mode == 1;
        boolean wrapBeforeColon = AbstractPrinter.settings.getBoolean(ConventionKeys.ALIGN_TERNARY_VALUES, false);
        if (out.newline) {
            this.printIndentation(marker, out);
        } else if (wrapBeforeColon) {
            out.printNewline();
            if (marker == null) {
                this.printIndentation(out);
            } else {
                this.printIndentation(marker, out);
            }
        } else if (wrapLines) {
            TestNodeWriter tester = out.testers.get();
            JavaNode thirdOp = this.getNextOperand(colon.getNextSibling());
            PrinterFactory.create((AST)thirdOp, out).print((AST)thirdOp, tester);
            if (tester.length + out.column > AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80)) {
                out.printNewline();
                if (marker == null) {
                    this.printIndentation(out);
                } else {
                    this.printIndentation(marker, out);
                }
            } else {
                out.print(" ", out.last);
            }
            out.testers.release(tester);
        } else {
            out.print(" ", out.last);
        }
        out.print(":", 118);
        if (!this.printCommentsAfter((AST)colon, false, true, out) && !out.newline) {
            out.print(" ", 118);
        }
    }

    private AST printOperand(AST node, Marker marker, NodeWriter out) throws IOException {
        boolean parentheses = false;
        block6: for (AST child = node; child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 106: {
                    parentheses = true;
                    PrinterFactory.create(child, out).print(child, out);
                    continue block6;
                }
                default: {
                    if (parentheses || node.getFirstChild() == child) {
                        PrinterFactory.create(child, out).print(child, out);
                    } else if (AbstractPrinter.settings.getBoolean(ConventionKeys.INSERT_EXPRESSION_PARENTHESIS, true) && this.needParentheses((JavaNode)child)) {
                        JavaNode operator = (JavaNode)child;
                        if (out.mode == 1) {
                            this.addParentheses(operator, out);
                            JavaNode leftParen = operator.getPreviousSibling();
                            PrinterFactory.create((AST)leftParen, out).print((AST)leftParen, out);
                            PrinterFactory.create(child, out).print(child, out);
                        } else {
                            out.print("(", out.last);
                            PrinterFactory.create(child, out).print(child, out);
                        }
                    } else {
                        PrinterFactory.create(child, out).print(child, out);
                    }
                    block7: for (child = child.getNextSibling(); child != null; child = child.getNextSibling()) {
                        switch (child.getType()) {
                            case 107: {
                                PrinterFactory.create(child, out).print(child, out);
                                continue block7;
                            }
                            default: {
                                return child;
                            }
                        }
                    }
                    return null;
                }
            }
        }
        throw new IllegalStateException();
    }

    private Marker printQuestionMark(AST node, AST secondOperand, NodeWriter out) throws IOException {
        boolean wrapLines = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP, true) && out.mode == 1;
        boolean wrapBeforeQuestion = AbstractPrinter.settings.getBoolean(ConventionKeys.ALIGN_TERNARY_EXPRESSION, false);
        if (out.newline) {
            this.printIndentation(out);
        } else if (wrapBeforeQuestion) {
            out.printNewline();
            this.printIndentation(out);
        } else if (wrapLines) {
            TestNodeWriter tester = out.testers.get();
            JavaNode secondOp = this.getNextOperand(secondOperand);
            PrinterFactory.create((AST)secondOp, out).print((AST)secondOp, tester);
            if (tester.length + out.column + 3 > AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80)) {
                out.printNewline();
                this.printIndentation(out);
            } else {
                out.print(" ", out.last);
            }
            out.testers.release(tester);
        } else {
            out.print(" ", out.last);
        }
        Marker marker = null;
        if (AbstractPrinter.settings.getBoolean(ConventionKeys.ALIGN_TERNARY_OPERATOR, true) && (wrapLines || wrapBeforeQuestion)) {
            marker = out.state.markers.add();
        }
        out.print("?", 79);
        if (!this.printCommentsAfter(node, false, true, out) && !out.newline) {
            out.print(" ", 118);
        }
        return marker;
    }
}

