/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class ThrowsPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new ThrowsPrinter();

    protected ThrowsPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    @Override
    public void print(AST node, NodeWriter out) throws IOException {
        boolean indentCustom;
        if (((JavaNode)node).hasCommentsBefore()) {
            this.printCommentsBefore(node, true, out);
        }
        AST firstType = node.getFirstChild();
        boolean wrappedBefore = false;
        boolean wrappedAfter = false;
        Marker marker = null;
        boolean wrapLines = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP, true) && out.mode == 1;
        int lineLength = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        boolean indentDeep = AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_DEEP, false);
        int indentLength = out.getIndentLength();
        int deepIndent = AbstractPrinter.settings.getInt(ConventionKeys.INDENT_SIZE_DEEP, 55);
        int indentSize = AbstractPrinter.settings.getInt(ConventionKeys.INDENT_SIZE_THROWS, -1);
        boolean bl = indentCustom = indentSize > -1;
        if (out.mode == 1 && (out.newline || AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_THROWS, false) || wrapLines && this.exceedsBarriers(node, firstType, lineLength, deepIndent, out))) {
            wrappedBefore = true;
            if (!out.newline) {
                out.printNewline();
            }
            if (indentCustom) {
                out.print(out.getString(indentSize), 173);
                out.print("throws ", 116);
                marker = out.state.markers.add();
            } else if (indentDeep && this.canAlign(firstType, lineLength, deepIndent, out)) {
                marker = out.state.markers.getLast();
                out.print(out.getString(marker.column - indentLength - 7), 173);
                out.print("throws ", 116);
            } else {
                indentDeep = false;
                out.indent();
                out.print("throws ", 116);
                marker = out.state.markers.add();
            }
        } else {
            out.print(" throws ", 116);
            marker = out.state.markers.add();
        }
        boolean spaceAfterComma = AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        boolean forceWrapping = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_THROWS, false);
        boolean wrapAll = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_THROWS_EXCEED, false) && out.mode == 1;
        TestNodeWriter tester = null;
        if (wrapLines || wrapAll) {
            tester = out.testers.get();
        }
        if (!forceWrapping && wrapAll) {
            PrinterFactory.create(node, out).print(node, tester);
            if (tester.length - 7 + out.column > lineLength) {
                forceWrapping = true;
            }
            tester.reset();
        }
        boolean newline = false;
        block3: for (AST child = firstType; child != null; child = child.getNextSibling()) {
            newline = false;
            switch (child.getType()) {
                case 83: {
                    AST next;
                    out.print(",", 83);
                    if (forceWrapping) {
                        out.printNewline();
                        newline = true;
                        if (!wrappedAfter) {
                            wrappedAfter = true;
                            if (!indentDeep) {
                                out.indent();
                            }
                        }
                        if (indentCustom && wrappedBefore) {
                            this.printIndentation(indentSize, out);
                        } else {
                            this.printIndentation(out);
                        }
                    } else if (wrapLines && (next = child.getNextSibling()) != null) {
                        PrinterFactory.create(next, out).print(next, tester);
                        if (tester.length + out.column > lineLength) {
                            out.printNewline();
                            newline = true;
                            if (!wrappedAfter) {
                                wrappedAfter = true;
                                if (!indentDeep) {
                                    out.indent();
                                }
                            }
                            if (indentCustom && wrappedBefore) {
                                this.printIndentation(indentSize, out);
                            } else {
                                this.printIndentation(out);
                            }
                        }
                        tester.reset();
                    }
                    if (!spaceAfterComma || newline) continue block3;
                    out.print(" ", 173);
                    continue block3;
                }
                default: {
                    PrinterFactory.create(child, out).print(child, out);
                }
            }
        }
        if (tester != null) {
            out.testers.release(tester);
        }
        if (!indentDeep) {
            if (!indentCustom && wrappedBefore) {
                out.unindent();
            }
            if (wrappedAfter) {
                out.unindent();
            }
        }
        if (AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_TREAT_DIFFERENT_IF_WRAPPED, false) && (wrappedBefore || wrappedAfter || out.state.parametersWrapped)) {
            out.state.newlineBeforeLeftBrace = true;
        }
    }

    private boolean canAlign(AST node, int lineLength, int deepIndent, NodeWriter out) throws IOException {
        TestNodeWriter tester = out.testers.get();
        PrinterFactory.create(node, out).print(node, tester);
        Marker marker = out.state.markers.getLast();
        if (marker.column - 7 < deepIndent && marker.column + tester.length < lineLength && marker.column - out.getIndentLength() - 7 > 0) {
            out.testers.release(tester);
            return true;
        }
        out.testers.release(tester);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exceedsBarriers(AST node, AST firstType, int lineLength, int deepIndent, NodeWriter out) throws IOException {
        if (out.column + 1 > deepIndent) {
            return true;
        }
        TestNodeWriter tester = out.testers.get();
        try {
            PrinterFactory.create(node, out).print(node, tester);
            if (out.column + tester.length > lineLength) {
                boolean bl = true;
                return bl;
            }
            tester.reset();
            PrinterFactory.create(firstType, out).print(firstType, tester);
            if (out.column + 7 + tester.length > lineLength) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            out.testers.release(tester);
        }
    }
}

