/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class TryCatchFinallyPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new TryCatchFinallyPrinter();

    protected TryCatchFinallyPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    @Override
    public void print(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        out.print("try", 131);
        this.printCommentsAfter(node, false, false, out);
        block5: for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 10: {
                    PrinterFactory.create(child, out).print(child, out);
                    continue block5;
                }
                case 133: {
                    this.printCatch(child, out);
                    continue block5;
                }
                case 132: {
                    this.printFinallyPart(child, out);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("illegal type -- " + child);
                }
            }
        }
        out.last = 6;
    }

    private void printCatch(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        this.logIssues(node, out);
        if (!out.newline) {
            out.print(out.getString(AbstractPrinter.settings.getInt(ConventionKeys.INDENT_SIZE_BRACE_RIGHT_AFTER, 1)), 173);
        }
        out.print("catch", 133);
        if (AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_BEFORE_STATEMENT_PAREN, true)) {
            out.print(" ", 133);
        }
        AST lparen = node.getFirstChild();
        PrinterFactory.create(lparen, out).print(lparen, out);
        AST parameters = lparen.getNextSibling();
        PrinterFactory.create(parameters, out).print(parameters, out);
        AST rparen = parameters.getNextSibling();
        PrinterFactory.create(rparen, out).print(rparen, out);
        JavaNode body = (JavaNode)rparen.getNextSibling();
        PrinterFactory.create((AST)body, out).print((AST)body, out);
    }

    private void printFinallyPart(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        this.logIssues(node, out);
        if (!out.newline) {
            out.print(out.getString(AbstractPrinter.settings.getInt(ConventionKeys.INDENT_SIZE_BRACE_RIGHT_AFTER, 1)), 173);
        }
        out.print("finally", 132);
        this.printCommentsAfter(node, out);
        JavaNode body = (JavaNode)node.getFirstChild();
        PrinterFactory.create((AST)body, out).print((AST)body, out);
    }
}

