/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import java.io.IOException;

public class TypeArgumentsPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new TypeArgumentsPrinter();

    public static final Printer getInstance() {
        return INSTANCE;
    }

    @Override
    public void print(AST node, NodeWriter out) throws IOException {
        out.print("<", node.getType());
        boolean first = true;
        for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.processTypeArguement(child, out, first);
            first = false;
        }
        out.print(">", node.getType());
    }

    private void processTypeArguement(AST node, NodeWriter out, boolean first) throws IOException {
        if (node.getType() == 83) {
            PrinterFactory.create(node, out).print(node, out);
        } else {
            block5: for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                switch (child.getType()) {
                    case 62: {
                        out.print("?", child.getType());
                        this.processTypeArguement(child, out, true);
                        continue block5;
                    }
                    case 63: {
                        out.print("extends ", child.getType());
                        this.processTypeArguement(child, out, true);
                        continue block5;
                    }
                    case 64: {
                        out.print("super ", child.getType());
                        this.processTypeArguement(child, out, true);
                        continue block5;
                    }
                    default: {
                        PrinterFactory.create(child, out).print(child, out);
                    }
                }
            }
        }
    }
}

