/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.storage;

import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Environment {
    private static final String DELIMETER = "|";
    private static Pattern _variablesPattern = Pattern.compile("\\$([a-zA-Z_][a-zA-Z0-9_.]+):?(.*?)\\$");
    private static final Environment INSTANCE = new Environment(true);
    private final Matcher _matcher = _variablesPattern.matcher("");
    private Map _variables;
    private static final Map variableMap = Environment.getVariableMap();

    private Environment(boolean initial) {
        if (initial) {
            this._variables = new HashMap(25);
            this._variables.putAll(System.getProperties());
            Convention settings = Convention.getInstance();
            String variables = settings.get(ConventionKeys.ENVIRONMENT, ConventionDefaults.ENVIRONMENT);
            if (!"".equals(variables)) {
                StringTokenizer tokens = new StringTokenizer(variables, DELIMETER);
                while (tokens.hasMoreElements()) {
                    String pair = tokens.nextToken();
                    int delimOffset = pair.indexOf(94);
                    String key = pair.substring(0, delimOffset);
                    String value = pair.substring(delimOffset + 1);
                    this._variables.put(key, value);
                }
            }
        }
    }

    public static Environment getInstance() {
        return INSTANCE;
    }

    public Environment copy() {
        Environment environment = new Environment(false);
        environment._variables = new HashMap(Environment.INSTANCE._variables);
        return environment;
    }

    public String interpolate(String str) {
        HashMap<String, String> keys = new HashMap<String, String>(10);
        this._matcher.reset(str);
        while (this._matcher.find()) {
            String result = this._matcher.group(1);
            String pattern = this._matcher.group(2);
            String value = null;
            Variable variable = (Variable)variableMap.get(result);
            value = variable != null ? variable.format(this._variables.get(result), pattern) : (String)this._variables.get(result);
            if (value == null || value.length() <= 0) continue;
            keys.put("\\$" + result + (pattern.length() == 0 ? "" : ":" + pattern) + "\\$", value);
        }
        for (Map.Entry entry : keys.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            str = str.replaceAll(key, value);
        }
        return str;
    }

    public void set(String variable, Object value) {
        this._variables.put(variable, value);
    }

    public String toString() {
        return this._variables.toString();
    }

    public void unset(String variable) {
        this._variables.remove(variable);
    }

    private static Map getVariableMap() {
        HashMap<String, Variable> vMap = new HashMap<String, Variable>(10);
        vMap.put(Variable.FILE.getName(), Variable.FILE);
        vMap.put(Variable.FILE_NAME.getName(), Variable.FILE_NAME);
        vMap.put(Variable.FILE_FORMAT.getName(), Variable.FILE_FORMAT);
        vMap.put(Variable.TAB_SIZE.getName(), Variable.TAB_SIZE);
        vMap.put(Variable.CONVENTION.getName(), Variable.CONVENTION);
        vMap.put(Variable.PACKAGE.getName(), Variable.PACKAGE);
        vMap.put(Variable.TYPE_PARAM.getName(), Variable.TYPE_PARAM);
        vMap.put(Variable.TYPE_EXCEPTION.getName(), Variable.TYPE_EXCEPTION);
        vMap.put(Variable.TYPE_OBJECT.getName(), Variable.TYPE_OBJECT);
        vMap.put(Variable.CLASS_NAME.getName(), Variable.CLASS_NAME);
        vMap.put(Variable.DATE.getName(), Variable.DATE);
        return vMap;
    }

    public static class Variable {
        public static final Variable FILE = new Variable("file");
        public static final Variable FILE_NAME = new Variable("fileName");
        public static final Variable FILE_FORMAT = new Variable("fileFormat");
        public static final Variable TAB_SIZE = new Variable("tabSize");
        public static final Variable CONVENTION = new Variable("convention");
        public static final Variable PACKAGE = new Variable("package");
        public static final Variable TYPE_PARAM = new Variable("paramType");
        public static final Variable TYPE_EXCEPTION = new Variable("exceptionType");
        public static final Variable TYPE_OBJECT = new Variable("objectType");
        public static final Variable DATE = new Variable("date"){

            @Override
            public String format(Object value, String pattern) {
                if (pattern == null || pattern.trim().length() == 0) {
                    return new SimpleDateFormat().format(value);
                }
                return new SimpleDateFormat(pattern).format(value);
            }
        };
        public static final Variable CLASS_NAME = new Variable("className");
        String name;
        int hashCode;

        private Variable(String name) {
            this.name = name.intern();
            this.hashCode = this.name.hashCode();
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Variable) {
                return this.name == ((Variable)o).name;
            }
            return false;
        }

        public String format(Object value, String pattern) {
            return value.toString();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.name;
        }
    }
}

