/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.storage;

import de.hunsicker.io.IoHelper;
import de.hunsicker.jalopy.storage.Convention;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public final class History {
    private static final History INSTANCE = new History();
    private static Map _history;

    private History() {
        this.initialize();
    }

    public static History getInstance() {
        return INSTANCE;
    }

    public synchronized void add(File file, String packageName, long modification) throws IOException {
        if (file.exists() && file.isFile()) {
            _history.put(file.getCanonicalPath(), new Entry(packageName, modification));
        }
    }

    public synchronized void clear() {
        _history.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() throws IOException {
        File file = Convention.getHistoryFile();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try (ObjectOutputStream p = new ObjectOutputStream(out);){
            p.writeObject(_history);
        }
    }

    public synchronized Entry get(File file) throws IOException {
        return (Entry)_history.get(file.getCanonicalPath());
    }

    public synchronized void remove(File file) throws IOException {
        _history.remove(file.getCanonicalPath());
    }

    private synchronized void initialize() {
        try {
            File file = Convention.getHistoryFile();
            _history = file.exists() ? (Map)IoHelper.deserialize(file) : new HashMap();
        }
        catch (Throwable ex) {
            _history = new HashMap();
        }
        Runtime.getRuntime().addShutdownHook(new TerminationHandler());
    }

    private final class TerminationHandler
    extends Thread {
        private TerminationHandler() {
        }

        @Override
        public synchronized void run() {
            try {
                if (_history != null) {
                    History.this.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final class Policy {
        public static final Policy DISABLED = new Policy("disabled", "History.Policy [disabled]");
        public static final Policy COMMENT = new Policy("comment", "History.Policy [comment]");
        public static final Policy FILE = new Policy("file", "History.Policy [file]");
        final String displayName;
        final String name;

        private Policy(String name, String displayName) {
            this.name = name.intern();
            this.displayName = displayName;
        }

        public static Policy valueOf(String name) {
            String n = name.intern();
            if (Policy.FILE.name == n) {
                return FILE;
            }
            if (Policy.COMMENT.name == n) {
                return COMMENT;
            }
            if (Policy.DISABLED.name == n) {
                return DISABLED;
            }
            throw new IllegalArgumentException("no valid history policy name -- " + name);
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.displayName;
        }
    }

    public static final class Method {
        public static final Method TIMESTAMP = new Method("timestamp", "Timestamp");
        public static final Method CRC32 = new Method("crc32", "CRC32 Checksum");
        public static final Method ADLER32 = new Method("adler32", "Adler32 Checksum");
        String displayName;
        String name;

        private Method(String name, String displayName) {
            this.name = name.intern();
            this.displayName = displayName;
        }

        public static Method valueOf(String methodName) {
            if ((methodName = methodName.intern()) == Method.TIMESTAMP.name) {
                return TIMESTAMP;
            }
            if (methodName == Method.CRC32.name) {
                return CRC32;
            }
            if (methodName == Method.ADLER32.name) {
                return ADLER32;
            }
            throw new IllegalArgumentException("no valid history method name -- " + methodName);
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.displayName;
        }
    }

    public static final class Entry
    implements Serializable {
        static final long serialVersionUID = 7661537884776942605L;
        String packageName;
        long lastmod;

        public Entry(String packageName, long modification) {
            this.packageName = packageName;
            this.lastmod = modification;
        }

        public long getModification() {
            return this.lastmod;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(30);
            buf.append('%');
            buf.append(this.lastmod);
            buf.append(':');
            buf.append(this.packageName);
            buf.append('%');
            return buf.toString();
        }
    }

    public static final class ChecksumCharArrayWriter
    extends CharArrayWriter {
        private Checksum _checksum;

        public ChecksumCharArrayWriter(Method method) {
            if (method == Method.ADLER32) {
                this._checksum = new Adler32();
            } else if (method == Method.CRC32) {
                this._checksum = new CRC32();
            } else {
                throw new IllegalArgumentException("invalid check sum history method -- " + method.toString());
            }
        }

        public Checksum getChecksum() {
            return this._checksum;
        }

        @Override
        public void write(char[] c, int off, int len) {
            super.write(c, off, len);
            String string = new String(c, off, len);
            byte[] bytes = string.getBytes();
            this._checksum.update(bytes, 0, bytes.length);
        }
    }
}

