/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.api.rtm;

import com.github.seratch.jslack.api.model.event.Event;
import com.github.seratch.jslack.api.rtm.RTMEventHandler;
import com.github.seratch.jslack.api.rtm.RTMEventsDispatcher;
import com.github.seratch.jslack.api.rtm.RTMMessageHandler;
import com.github.seratch.jslack.common.json.GsonFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMEventsDispatcherImpl
implements RTMEventsDispatcher {
    private static final Logger log = LoggerFactory.getLogger(RTMEventsDispatcherImpl.class);
    private final ConcurrentMap<String, List<RTMEventHandler<?>>> eventTypeAndHandlers = new ConcurrentHashMap();

    @Override
    public void register(RTMEventHandler<? extends Event> handler) {
        String eventType = handler.getEventType();
        ArrayList<RTMEventHandler<? extends Event>> handlers = (ArrayList<RTMEventHandler<? extends Event>>)this.eventTypeAndHandlers.get(eventType);
        if (handlers == null) {
            handlers = new ArrayList<RTMEventHandler<? extends Event>>();
        }
        handlers.add(handler);
        this.eventTypeAndHandlers.put(eventType, handlers);
    }

    @Override
    public void deregister(RTMEventHandler<? extends Event> handler) {
        String eventType = handler.getEventType();
        ArrayList handlers = (ArrayList)this.eventTypeAndHandlers.get(eventType);
        if (handlers == null) {
            handlers = new ArrayList();
        }
        ArrayList<RTMEventHandler> newHandlers = new ArrayList<RTMEventHandler>();
        for (RTMEventHandler h : handlers) {
            if (h.equals(handler)) continue;
            newHandlers.add(h);
        }
        this.eventTypeAndHandlers.put(eventType, newHandlers);
    }

    @Override
    public void dispatch(String json) {
        String eventType = RTMEventsDispatcherImpl.detectEventType(json);
        if (eventType == null) {
            log.debug("Failed to detect event type from the given JSON data: {}", (Object)json);
            return;
        }
        List RTMEventHandlers = (List)this.eventTypeAndHandlers.get(eventType);
        if (RTMEventHandlers == null || RTMEventHandlers.size() == 0) {
            log.debug("No event handler registered for type: {}", (Object)eventType);
        } else {
            Class clazz = ((RTMEventHandler)RTMEventHandlers.get(0)).getEventClass();
            Event event = (Event)GsonFactory.createSnakeCase().fromJson(json, clazz);
            for (RTMEventHandler handler : RTMEventHandlers) {
                handler.acceptUntypedObject(event);
            }
        }
    }

    @Override
    public RTMMessageHandler toMessageHandler() {
        final RTMEventsDispatcherImpl self = this;
        RTMMessageHandler messageHandler = new RTMMessageHandler(){

            @Override
            public void handle(String message) {
                self.dispatch(message);
            }
        };
        return messageHandler;
    }

    public static String detectEventType(String json) {
        StringBuilder sb = new StringBuilder();
        char[] chars = json.toCharArray();
        for (int idx = 0; idx < chars.length - 6; ++idx) {
            if (chars[idx] != '\"' || chars[idx + 1] != 't' || chars[idx + 2] != 'y' || chars[idx + 3] != 'p' || chars[idx + 4] != 'e' || chars[idx + 5] != '\"' || chars[idx + 6] != ':') continue;
            idx += 7;
            int doubleQuoteCount = 0;
            boolean isPreviousCharEscape = false;
            while (doubleQuoteCount < 2 && idx < chars.length) {
                char c = chars[idx];
                if (c == '\"' && !isPreviousCharEscape) {
                    ++doubleQuoteCount;
                } else if (doubleQuoteCount == 1) {
                    sb.append(c);
                }
                isPreviousCharEscape = c == '\\';
                ++idx;
            }
            break;
        }
        return sb.toString();
    }
}

