/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\b\u0000\u0018\u0000 \u00112\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0000H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/github/spotbugs/snom/internal/SemanticVersion;", "", "version", "", "<init>", "(Ljava/lang/String;)V", "major", "", "getMajor", "()I", "minor", "getMinor", "patch", "getPatch", "compareTo", "other", "toString", "Companion", "spotbugs-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSemanticVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticVersion.kt\ncom/github/spotbugs/snom/internal/SemanticVersion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class SemanticVersion
implements Comparable<SemanticVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int patch;
    private static final Pattern PATTERN = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");

    public SemanticVersion(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Matcher matcher = PATTERN.matcher(version);
        if (!matcher.matches()) {
            boolean bl = false;
            String string = version + " is not valid as a semantic version";
            throw new IllegalArgumentException(string.toString());
        }
        String string = matcher.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        String string2 = string;
        int n = 10;
        this.major = Integer.parseInt(string2, CharsKt.checkRadix((int)n));
        String string3 = matcher.group(2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
        string2 = string3;
        n = 10;
        this.minor = Integer.parseInt(string2, CharsKt.checkRadix((int)n));
        String string4 = matcher.group(3);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"group(...)");
        string2 = string4;
        n = 10;
        this.patch = Integer.parseInt(string2, CharsKt.checkRadix((int)n));
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @Override
    public int compareTo(@Nullable SemanticVersion other) {
        return Comparator.comparingInt(arg_0 -> SemanticVersion.compareTo$lambda$2(SemanticVersion::compareTo$lambda$1, arg_0)).thenComparingInt(arg_0 -> SemanticVersion.compareTo$lambda$4(SemanticVersion::compareTo$lambda$3, arg_0)).thenComparingInt(arg_0 -> SemanticVersion.compareTo$lambda$6(SemanticVersion::compareTo$lambda$5, arg_0)).compare(this, other);
    }

    @NotNull
    public String toString() {
        return "SemanticVersion(" + this.major + '.' + this.minor + '.' + this.patch + ')';
    }

    private static final int compareTo$lambda$1(SemanticVersion obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.major;
    }

    private static final int compareTo$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int compareTo$lambda$3(SemanticVersion obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.minor;
    }

    private static final int compareTo$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int compareTo$lambda$5(SemanticVersion obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.patch;
    }

    private static final int compareTo$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\b\u0012\u0004\b\u0007\u0010\u0003\u00a8\u0006\t"}, d2={"Lcom/github/spotbugs/snom/internal/SemanticVersion$Companion;", "", "<init>", "()V", "PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getPATTERN$annotations", "Ljava/util/regex/Pattern;", "spotbugs-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getPATTERN$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

