/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.spotbugs;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.NodeList;
import groovy.xml.XmlParser;
import java.beans.Transient;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.codehaus.mojo.spotbugs.SpotBugsInfo;

public abstract class BaseViolationCheckMojo
extends AbstractMojo
implements GroovyObject {
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File spotbugsXmlOutputDirectory;
    @Parameter(defaultValue="spotbugsXml.xml", property="spotbugs.outputXmlFilename")
    private String spotbugsXmlOutputFilename;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classFilesDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true)
    private File testClassFilesDirectory;
    @Parameter(defaultValue="false", property="spotbugs.includeTests")
    private boolean includeTests;
    @Parameter(defaultValue="false", property="spotbugs.debug")
    private boolean debug;
    @Parameter(defaultValue="false", property="spotbugs.skip")
    private boolean skip;
    @Parameter(defaultValue="true", property="spotbugs.failOnError")
    private boolean failOnError;
    @Parameter(property="spotbugs.failThreshold")
    private String failThreshold;
    @Parameter(defaultValue="0", property="spotbugs.maxAllowedViolations")
    private int maxAllowedViolations;
    @Parameter(defaultValue="false", property="spotbugs.quiet")
    private boolean quiet;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public BaseViolationCheckMojo() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void execute() {
        IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), "Executing spotbugs:check");
        if (this.skip) {
            IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), "Spotbugs plugin skipped");
            return;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "doSourceFilesExist", 2, this)) == false) {
            IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), "Nothing for SpotBugs to do here.");
            return;
        }
        IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), "Executing spotbugs:check");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, this.spotbugsXmlOutputDirectory)) == false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "mkdirs", 0, this.spotbugsXmlOutputDirectory)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MojoExecutionException.class, "Cannot create xml output directory"));
        }
        CallSite outputFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, new GStringImpl(new Object[]{this.spotbugsXmlOutputDirectory, this.spotbugsXmlOutputFilename}, new String[]{"", "/", ""})));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, outputFile)) == false) {
            IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), "Output directory does not exist!");
            return;
        }
        CallSite xml = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("init", "<init>", 0, XmlParser.class), outputFile));
        CallSite bugs = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "BugInstance", 0, xml));
        int bugCount = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "size", 0, bugs));
        IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{bugCount}, new String[]{"BugInstance size is ", ""}));
        int errorCount = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("getProperty", "Error", 0, xml)));
        IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{errorCount}, new String[]{"Error size is ", ""}));
        if (bugCount <= 0) {
            IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), "No errors/warnings found");
            return;
        }
        if (this.maxAllowedViolations > 0 && bugCount <= this.maxAllowedViolations) {
            IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{bugCount}, new String[]{"Total ", " violations are found as acceptable using configured property maxAllowedViolations "}), new GStringImpl(new Object[]{this.maxAllowedViolations, IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class), IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class)}, new String[]{":", ".", "Below are list of bugs ignored :", ""})));
            IndyInterface.bootstrap("invoke", "printBugs", 2, this, bugCount, bugs);
            return;
        }
        IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "Total bugs: ", bugCount));
        int priorityThresholdNum = DefaultTypeTransformation.intUnbox((Object)(IndyInterface.bootstrap("cast", "()", 0, this.failThreshold) != false ? IndyInterface.bootstrap("invoke", "indexOf", 0, IndyInterface.bootstrap("getProperty", "spotbugsPriority", 0, SpotBugsInfo.class), this.failThreshold) : IndyInterface.bootstrap("getProperty", "MAX_VALUE", 0, Integer.class)));
        if (priorityThresholdNum == -1) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MojoExecutionException.class, new GStringImpl(new Object[]{this.failThreshold}, new String[]{"Invalid value for failThreshold: ", ""})));
        }
        int bugCountAboveThreshold = 0;
        Object i = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, ScriptBytecodeAdapter.createRange((Object)0, (Object)IndyInterface.bootstrap("invoke", "minus", 0, bugCount, true), (boolean)false, (boolean)false)));
        if (callSite != null) {
            while (callSite.hasNext()) {
                i = callSite.next();
                CallSite bug = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, bugs, i));
                int priorityNum = (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "@priority", 0, bug), Integer.class));
                CallSite priorityName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "spotbugsPriority", 0, SpotBugsInfo.class), priorityNum));
                CallSite logMsg = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, priorityName, ": "), IndyInterface.bootstrap("invoke", "text", 0, IndyInterface.bootstrap("getProperty", "LongMessage", 0, bug))), IndyInterface.bootstrap("getProperty", "BLANK", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("getProperty", "@classname", 0, IndyInterface.bootstrap("getProperty", "SourceLine", 0, bug))), IndyInterface.bootstrap("getProperty", "BLANK", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("invoke", "text", 0, IndyInterface.bootstrap("getProperty", "Message", 0, IndyInterface.bootstrap("getProperty", "SourceLine", 0, bug)))), IndyInterface.bootstrap("getProperty", "BLANK", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("getProperty", "@type", 0, bug)));
                if (priorityNum <= priorityThresholdNum) {
                    bugCountAboveThreshold = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "plus", 0, bugCountAboveThreshold, true));
                    if (!(!this.quiet)) continue;
                    IndyInterface.bootstrap("invoke", "error", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), logMsg);
                    continue;
                }
                if (!(!this.quiet)) continue;
                IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), logMsg);
            }
        }
        IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class), IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class)), "To see bug detail using the Spotbugs GUI, use the following command \"mvn spotbugs:gui\""), IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class)));
        if ((DefaultTypeTransformation.booleanUnbox((Object)bugCountAboveThreshold) || DefaultTypeTransformation.booleanUnbox((Object)errorCount)) && this.failOnError) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MojoExecutionException.class, new GStringImpl(new Object[]{bugCountAboveThreshold, errorCount}, new String[]{"failed with ", " bugs and ", " errors"})));
        }
    }

    private boolean doSourceFilesExist() {
        CallSite sourceFiles = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDirectory", 0, this.classFilesDirectory)) != false) {
            IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "looking for class files with extensions: ", IndyInterface.bootstrap("getProperty", "EXTENSIONS", 0, SpotBugsInfo.class)));
            IndyInterface.bootstrap("invoke", "addAll", 0, sourceFiles, IndyInterface.bootstrap("invoke", "listFiles", 0, FileUtils.class, this.classFilesDirectory, IndyInterface.bootstrap("getProperty", "EXTENSIONS", 0, SpotBugsInfo.class), true));
        }
        if (this.includeTests && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isDirectory", 0, this.testClassFilesDirectory))) {
            IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "looking for test class files: ", IndyInterface.bootstrap("getProperty", "EXTENSIONS", 0, SpotBugsInfo.class)));
            IndyInterface.bootstrap("invoke", "addAll", 0, sourceFiles, IndyInterface.bootstrap("invoke", "listFiles", 0, FileUtils.class, this.testClassFilesDirectory, IndyInterface.bootstrap("getProperty", "EXTENSIONS", 0, SpotBugsInfo.class), true));
        }
        IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "SourceFiles: ", IndyInterface.bootstrap("invoke", "toString", 0, Arrays.class, sourceFiles)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, sourceFiles)) == false;
    }

    private void printBugs(int total, NodeList bugs) {
        Object i = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, ScriptBytecodeAdapter.createRange((Object)0, (Object)IndyInterface.bootstrap("invoke", "minus", 0, total, true), (boolean)false, (boolean)false)));
        if (callSite != null) {
            while (callSite.hasNext()) {
                i = callSite.next();
                CallSite bug = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, bugs, i));
                IndyInterface.bootstrap("invoke", "error", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "text", 0, IndyInterface.bootstrap("getProperty", "LongMessage", 0, bug)), IndyInterface.bootstrap("getProperty", "BLANK", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("getProperty", "@classname", 0, IndyInterface.bootstrap("getProperty", "SourceLine", 0, bug))), IndyInterface.bootstrap("getProperty", "BLANK", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("invoke", "text", 0, IndyInterface.bootstrap("getProperty", "Message", 0, IndyInterface.bootstrap("getProperty", "SourceLine", 0, bug)))), IndyInterface.bootstrap("getProperty", "BLANK", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("getProperty", "@type", 0, bug)));
            }
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != BaseViolationCheckMojo.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public File getSpotbugsXmlOutputDirectory() {
        return this.spotbugsXmlOutputDirectory;
    }

    @Generated
    public void setSpotbugsXmlOutputDirectory(File file) {
        this.spotbugsXmlOutputDirectory = file;
    }

    @Generated
    public String getSpotbugsXmlOutputFilename() {
        return this.spotbugsXmlOutputFilename;
    }

    @Generated
    public void setSpotbugsXmlOutputFilename(String string) {
        this.spotbugsXmlOutputFilename = string;
    }

    @Generated
    public File getClassFilesDirectory() {
        return this.classFilesDirectory;
    }

    @Generated
    public void setClassFilesDirectory(File file) {
        this.classFilesDirectory = file;
    }

    @Generated
    public File getTestClassFilesDirectory() {
        return this.testClassFilesDirectory;
    }

    @Generated
    public void setTestClassFilesDirectory(File file) {
        this.testClassFilesDirectory = file;
    }

    @Generated
    public boolean getIncludeTests() {
        return this.includeTests;
    }

    @Generated
    public boolean isIncludeTests() {
        return this.includeTests;
    }

    @Generated
    public void setIncludeTests(boolean bl) {
        this.includeTests = bl;
    }

    @Generated
    public boolean getDebug() {
        return this.debug;
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Generated
    public boolean getSkip() {
        return this.skip;
    }

    @Generated
    public boolean isSkip() {
        return this.skip;
    }

    @Generated
    public void setSkip(boolean bl) {
        this.skip = bl;
    }

    @Generated
    public boolean getFailOnError() {
        return this.failOnError;
    }

    @Generated
    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Generated
    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    @Generated
    public String getFailThreshold() {
        return this.failThreshold;
    }

    @Generated
    public void setFailThreshold(String string) {
        this.failThreshold = string;
    }

    @Generated
    public int getMaxAllowedViolations() {
        return this.maxAllowedViolations;
    }

    @Generated
    public void setMaxAllowedViolations(int n) {
        this.maxAllowedViolations = n;
    }

    @Generated
    public boolean getQuiet() {
        return this.quiet;
    }

    @Generated
    public boolean isQuiet() {
        return this.quiet;
    }

    @Generated
    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }
}

