/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class WireMockClassRule
implements MethodRule,
TestRule {
    private final Options options;
    private final WireMockServer wireMockServer;

    public WireMockClassRule(Options options) {
        this.options = options;
        this.wireMockServer = new WireMockServer(options);
    }

    public WireMockClassRule(int port, Integer httpsPort) {
        this(WireMockConfiguration.wireMockConfig().port(port).httpsPort(httpsPort));
    }

    public WireMockClassRule(int port) {
        this(WireMockConfiguration.wireMockConfig().port(port));
    }

    public WireMockClassRule() {
        this(WireMockConfiguration.wireMockConfig());
    }

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        return this.apply(base, null);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                if (WireMockClassRule.this.wireMockServer.isRunning()) {
                    try {
                        base.evaluate();
                    }
                    finally {
                        WireMock.reset();
                    }
                }
                WireMockClassRule.this.wireMockServer.start();
                WireMock.configureFor("localhost", WireMockClassRule.this.options.portNumber());
                try {
                    base.evaluate();
                }
                finally {
                    WireMockClassRule.this.wireMockServer.stop();
                }
            }
        };
    }
}

