/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MemoizingMatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;

public abstract class MemoizingStringValuePattern
extends StringValuePattern {
    private final LoadingCache<String, MatchResult> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, MatchResult>(){

        public MatchResult load(String value) {
            return new MemoizingMatchResult(MemoizingStringValuePattern.this.calculateMatch(value));
        }
    });

    public MemoizingStringValuePattern(String expectedValue) {
        super(expectedValue);
    }

    @Override
    public final MatchResult match(String value) {
        if (value == null) {
            return MatchResult.noMatch();
        }
        try {
            return (MatchResult)this.cache.get((Object)value);
        }
        catch (ExecutionException e) {
            return Exceptions.throwUnchecked(e, MatchResult.class);
        }
    }

    protected abstract MatchResult calculateMatch(String var1);
}

