/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.drawing.cell;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.drawing.DrawingContext;
import org.vandeseer.easytable.drawing.cell.AbstractCellDrawer;
import org.vandeseer.easytable.structure.cell.VerticalTextCell;
import org.vandeseer.easytable.util.PdfUtil;

public class VerticalTextCellDrawer
extends AbstractCellDrawer<VerticalTextCell> {
    public VerticalTextCellDrawer(VerticalTextCell cell) {
        this.cell = cell;
    }

    @Override
    public void drawContent(DrawingContext drawingContext) {
        float startX = drawingContext.getStartingPoint().x;
        float startY = drawingContext.getStartingPoint().y;
        PDFont currentFont = ((VerticalTextCell)this.cell).getFont();
        int currentFontSize = ((VerticalTextCell)this.cell).getFontSize();
        Color currentTextColor = ((VerticalTextCell)this.cell).getTextColor();
        float yOffset = startY + ((VerticalTextCell)this.cell).getPaddingBottom();
        float height = ((VerticalTextCell)this.cell).getRow().getHeight();
        if (((VerticalTextCell)this.cell).getRowSpan() > 1) {
            float rowSpanAdaption = ((VerticalTextCell)this.cell).calculateHeightForRowSpan() - ((VerticalTextCell)this.cell).getRow().getHeight();
            yOffset -= rowSpanAdaption;
            height = ((VerticalTextCell)this.cell).calculateHeightForRowSpan();
        }
        List<String> lines = ((VerticalTextCell)this.cell).isWordBreak() ? PdfUtil.getOptimalTextBreakLines(((VerticalTextCell)this.cell).getText(), currentFont, currentFontSize, height - ((VerticalTextCell)this.cell).getVerticalPadding()) : Collections.singletonList(((VerticalTextCell)this.cell).getText());
        float xOffset = startX + ((VerticalTextCell)this.cell).getPaddingLeft() - PdfUtil.getFontHeight(currentFont, currentFontSize);
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            this.drawText(line, currentFont, currentFontSize, currentTextColor, xOffset += PdfUtil.getFontHeight(currentFont, currentFontSize) + (i > 0 ? PdfUtil.getFontHeight(currentFont, currentFontSize) * ((VerticalTextCell)this.cell).getLineSpacing() : 0.0f), yOffset, drawingContext.getContentStream());
        }
    }

    @Override
    protected float calculateInnerHeight() {
        return 0.0f;
    }

    protected void drawText(String text, PDFont font, int fontSize, Color color, float x, float y, PDPageContentStream contentStream) throws IOException {
        AffineTransform transform = AffineTransform.getTranslateInstance(x, y);
        transform.concatenate(AffineTransform.getRotateInstance(1.5707963267948966));
        transform.concatenate(AffineTransform.getTranslateInstance(-x, -y - (float)fontSize));
        contentStream.moveTo(x, y);
        contentStream.beginText();
        contentStream.setTextMatrix(transform);
        contentStream.setNonStrokingColor(color);
        contentStream.setFont(font, (float)fontSize);
        contentStream.newLineAtOffset(x, y);
        contentStream.showText(text);
        contentStream.endText();
        contentStream.setCharacterSpacing(0.0f);
    }

    public VerticalTextCellDrawer() {
    }
}

