/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.structure.cell.paragraph;

import java.awt.Color;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.Settings;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphProcessable;
import rst.pdfbox.layout.elements.Paragraph;
import rst.pdfbox.layout.text.FontDescriptor;
import rst.pdfbox.layout.text.NewLine;
import rst.pdfbox.layout.text.TextFragment;

public class StyledText
implements ParagraphProcessable {
    @NonNull
    private String text;
    private Float fontSize;
    private PDFont font;
    private Color color;

    @Override
    public void process(Paragraph paragraph, Settings settings) {
        Float actualFontSize = Float.valueOf(this.getFontSize() != null ? this.getFontSize().floatValue() : (float)settings.getFontSize().intValue());
        PDFont actualFont = this.getFont() != null ? this.getFont() : settings.getFont();
        Color actualColor = this.getColor() != null ? this.getColor() : settings.getTextColor();
        String[] lines = this.getText().split("\\r?\\n");
        for (int i = 0; i < lines.length; ++i) {
            paragraph.add((TextFragment)new rst.pdfbox.layout.text.StyledText(lines[i], actualFontSize.floatValue(), actualFont, actualColor));
            if (i >= lines.length - 1) continue;
            paragraph.add((TextFragment)new NewLine(new FontDescriptor(actualFont, actualFontSize.floatValue())));
        }
    }

    StyledText(@NonNull String text, Float fontSize, PDFont font, Color color) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
        this.fontSize = fontSize;
        this.font = font;
        this.color = color;
    }

    public static StyledTextBuilder builder() {
        return new StyledTextBuilder();
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public PDFont getFont() {
        return this.font;
    }

    public Color getColor() {
        return this.color;
    }

    public static class StyledTextBuilder {
        private String text;
        private Float fontSize;
        private PDFont font;
        private Color color;

        StyledTextBuilder() {
        }

        public StyledTextBuilder text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return this;
        }

        public StyledTextBuilder fontSize(Float fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public StyledTextBuilder font(PDFont font) {
            this.font = font;
            return this;
        }

        public StyledTextBuilder color(Color color) {
            this.color = color;
            return this;
        }

        public StyledText build() {
            return new StyledText(this.text, this.fontSize, this.font, this.color);
        }

        public String toString() {
            return "StyledText.StyledTextBuilder(text=" + this.text + ", fontSize=" + this.fontSize + ", font=" + this.font + ", color=" + this.color + ")";
        }
    }
}

