/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.springdata.jest;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.lucene.queryparser.flexible.core.util.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.util.Assert;

class CriteriaQueryProcessor {
    CriteriaQueryProcessor() {
    }

    QueryBuilder createQueryFromCriteria(Criteria criteria) {
        if (criteria == null) {
            return null;
        }
        LinkedList<QueryBuilder> shouldQueryBuilderList = new LinkedList<QueryBuilder>();
        LinkedList<QueryBuilder> mustNotQueryBuilderList = new LinkedList<QueryBuilder>();
        LinkedList<QueryBuilder> mustQueryBuilderList = new LinkedList<QueryBuilder>();
        ListIterator chainIterator = criteria.getCriteriaChain().listIterator();
        QueryBuilder firstQuery = null;
        boolean negateFirstQuery = false;
        while (chainIterator.hasNext()) {
            Criteria chainedCriteria = (Criteria)chainIterator.next();
            QueryBuilder queryFragmentForCriteria = this.createQueryFragmentForCriteria(chainedCriteria);
            if (queryFragmentForCriteria == null) continue;
            if (firstQuery == null) {
                firstQuery = queryFragmentForCriteria;
                negateFirstQuery = chainedCriteria.isNegating();
                continue;
            }
            if (chainedCriteria.isOr()) {
                shouldQueryBuilderList.add(queryFragmentForCriteria);
                continue;
            }
            if (chainedCriteria.isNegating()) {
                mustNotQueryBuilderList.add(queryFragmentForCriteria);
                continue;
            }
            mustQueryBuilderList.add(queryFragmentForCriteria);
        }
        if (firstQuery != null) {
            if (!shouldQueryBuilderList.isEmpty() && mustNotQueryBuilderList.isEmpty() && mustQueryBuilderList.isEmpty()) {
                shouldQueryBuilderList.add(0, firstQuery);
            } else if (negateFirstQuery) {
                mustNotQueryBuilderList.add(0, firstQuery);
            } else {
                mustQueryBuilderList.add(0, firstQuery);
            }
        }
        BoolQueryBuilder query = null;
        if (!(shouldQueryBuilderList.isEmpty() && mustNotQueryBuilderList.isEmpty() && mustQueryBuilderList.isEmpty())) {
            query = QueryBuilders.boolQuery();
            for (QueryBuilder qb : shouldQueryBuilderList) {
                query.should(qb);
            }
            for (QueryBuilder qb : mustNotQueryBuilderList) {
                query.mustNot(qb);
            }
            for (QueryBuilder qb : mustQueryBuilderList) {
                query.must(qb);
            }
        }
        return query;
    }

    private QueryBuilder createQueryFragmentForCriteria(Criteria chainedCriteria) {
        BoolQueryBuilder query;
        if (chainedCriteria.getQueryCriteriaEntries().isEmpty()) {
            return null;
        }
        Iterator it = chainedCriteria.getQueryCriteriaEntries().iterator();
        boolean singeEntryCriteria = chainedCriteria.getQueryCriteriaEntries().size() == 1;
        String fieldName = chainedCriteria.getField().getName();
        Assert.notNull((Object)fieldName, (String)"Unknown field");
        if (singeEntryCriteria) {
            Criteria.CriteriaEntry entry = (Criteria.CriteriaEntry)it.next();
            query = this.processCriteriaEntry(entry, fieldName);
        } else {
            query = QueryBuilders.boolQuery();
            while (it.hasNext()) {
                Criteria.CriteriaEntry entry = (Criteria.CriteriaEntry)it.next();
                query.must(this.processCriteriaEntry(entry, fieldName));
            }
        }
        this.addBoost((QueryBuilder)query, chainedCriteria.getBoost());
        return query;
    }

    private QueryBuilder processCriteriaEntry(Criteria.CriteriaEntry entry, String fieldName) {
        Object value = entry.getValue();
        if (value == null) {
            return null;
        }
        Criteria.OperationKey key = entry.getKey();
        BoolQueryBuilder query = null;
        String searchText = StringUtils.toString((Object)value);
        switch (key) {
            case EQUALS: {
                query = QueryBuilders.queryStringQuery((String)searchText).field(fieldName).defaultOperator(Operator.AND);
                break;
            }
            case CONTAINS: {
                query = QueryBuilders.queryStringQuery((String)("*" + searchText + "*")).field(fieldName).analyzeWildcard(Boolean.valueOf(true));
                break;
            }
            case STARTS_WITH: {
                query = QueryBuilders.queryStringQuery((String)(searchText + "*")).field(fieldName).analyzeWildcard(Boolean.valueOf(true));
                break;
            }
            case ENDS_WITH: {
                query = QueryBuilders.queryStringQuery((String)("*" + searchText)).field(fieldName).analyzeWildcard(Boolean.valueOf(true));
                break;
            }
            case EXPRESSION: {
                query = QueryBuilders.queryStringQuery((String)searchText).field(fieldName);
                break;
            }
            case LESS_EQUAL: {
                query = QueryBuilders.rangeQuery((String)fieldName).lte(value);
                break;
            }
            case GREATER_EQUAL: {
                query = QueryBuilders.rangeQuery((String)fieldName).gte(value);
                break;
            }
            case BETWEEN: {
                Object[] ranges = (Object[])value;
                query = QueryBuilders.rangeQuery((String)fieldName).from(ranges[0]).to(ranges[1]);
                break;
            }
            case LESS: {
                query = QueryBuilders.rangeQuery((String)fieldName).lt(value);
                break;
            }
            case GREATER: {
                query = QueryBuilders.rangeQuery((String)fieldName).gt(value);
                break;
            }
            case FUZZY: {
                query = QueryBuilders.fuzzyQuery((String)fieldName, (String)searchText);
                break;
            }
            case IN: {
                query = QueryBuilders.boolQuery();
                Iterable collection = (Iterable)value;
                for (Object item : collection) {
                    query.should((QueryBuilder)QueryBuilders.queryStringQuery((String)item.toString()).field(fieldName));
                }
                break;
            }
            case NOT_IN: {
                query = QueryBuilders.boolQuery();
                Iterable collection = (Iterable)value;
                for (Object item : collection) {
                    query.mustNot((QueryBuilder)QueryBuilders.queryStringQuery((String)item.toString()).field(fieldName));
                }
                break;
            }
        }
        return query;
    }

    private void addBoost(QueryBuilder query, float boost) {
        if (Float.isNaN(boost)) {
            return;
        }
        query.boost(boost);
    }
}

