/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.springdata.jest;

import com.github.vanroy.springdata.jest.CriteriaFilterProcessor;
import com.github.vanroy.springdata.jest.CriteriaQueryProcessor;
import com.github.vanroy.springdata.jest.MappingBuilder;
import com.github.vanroy.springdata.jest.aggregation.AggregatedPage;
import com.github.vanroy.springdata.jest.aggregation.impl.AggregatedPageImpl;
import com.github.vanroy.springdata.jest.internal.ExtendedSearchResult;
import com.github.vanroy.springdata.jest.internal.MultiDocumentResult;
import com.github.vanroy.springdata.jest.internal.SearchScrollResult;
import com.github.vanroy.springdata.jest.mapper.DefaultErrorMapper;
import com.github.vanroy.springdata.jest.mapper.DefaultJestResultsMapper;
import com.github.vanroy.springdata.jest.mapper.ErrorMapper;
import com.github.vanroy.springdata.jest.mapper.JestGetResultMapper;
import com.github.vanroy.springdata.jest.mapper.JestMultiGetResultMapper;
import com.github.vanroy.springdata.jest.mapper.JestResultsExtractor;
import com.github.vanroy.springdata.jest.mapper.JestResultsMapper;
import com.github.vanroy.springdata.jest.mapper.JestScrollResultMapper;
import com.github.vanroy.springdata.jest.mapper.JestSearchResultMapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import io.searchbox.core.ClearScroll;
import io.searchbox.core.Count;
import io.searchbox.core.CountResult;
import io.searchbox.core.Delete;
import io.searchbox.core.DocumentResult;
import io.searchbox.core.Get;
import io.searchbox.core.Index;
import io.searchbox.core.MultiGet;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.SearchScroll;
import io.searchbox.core.Update;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.DeleteIndex;
import io.searchbox.indices.IndicesExists;
import io.searchbox.indices.Refresh;
import io.searchbox.indices.aliases.AddAliasMapping;
import io.searchbox.indices.aliases.AliasMapping;
import io.searchbox.indices.aliases.GetAliases;
import io.searchbox.indices.aliases.ModifyAliases;
import io.searchbox.indices.aliases.RemoveAliasMapping;
import io.searchbox.indices.mapping.GetMapping;
import io.searchbox.indices.mapping.PutMapping;
import io.searchbox.indices.settings.GetSettings;
import io.searchbox.indices.type.TypeExist;
import io.searchbox.params.SearchType;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.annotations.Setting;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.GetResultMapper;
import org.springframework.data.elasticsearch.core.MultiGetResultMapper;
import org.springframework.data.elasticsearch.core.ResultsExtractor;
import org.springframework.data.elasticsearch.core.ScrolledPage;
import org.springframework.data.elasticsearch.core.SearchResultMapper;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.MappingElasticsearchConverter;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.SimpleElasticsearchMappingContext;
import org.springframework.data.elasticsearch.core.query.AliasQuery;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.GetQuery;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.ScriptField;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JestElasticsearchTemplate
implements ElasticsearchOperations,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(JestElasticsearchTemplate.class);
    private final JestClient client;
    private final ElasticsearchConverter elasticsearchConverter;
    private final JestResultsMapper resultsMapper;
    private final ErrorMapper errorMapper;
    private final Supplier<SearchSourceBuilder> searchSourceBuilderProvider;

    public JestElasticsearchTemplate(JestClient client) {
        this(client, null, null, null, null);
    }

    public JestElasticsearchTemplate(JestClient client, JestResultsMapper resultMapper) {
        this(client, null, resultMapper);
    }

    public JestElasticsearchTemplate(JestClient client, JestResultsMapper resultMapper, ErrorMapper errorMapper) {
        this(client, null, resultMapper, errorMapper, null);
    }

    public JestElasticsearchTemplate(JestClient client, ErrorMapper errorMapper) {
        this(client, null, null, errorMapper, null);
    }

    public JestElasticsearchTemplate(JestClient client, ElasticsearchConverter elasticsearchConverter, JestResultsMapper resultsMapper) {
        this(client, elasticsearchConverter, resultsMapper, null, null);
    }

    public JestElasticsearchTemplate(JestClient client, ElasticsearchConverter elasticsearchConverter, JestResultsMapper resultsMapper, ErrorMapper errorMapper, Supplier<SearchSourceBuilder> searchSourceBuilderProvider) {
        this.client = client;
        this.elasticsearchConverter = elasticsearchConverter == null ? new MappingElasticsearchConverter((MappingContext)new SimpleElasticsearchMappingContext()) : elasticsearchConverter;
        this.resultsMapper = resultsMapper == null ? new DefaultJestResultsMapper(this.elasticsearchConverter.getMappingContext()) : resultsMapper;
        this.errorMapper = errorMapper == null ? new DefaultErrorMapper() : errorMapper;
        this.searchSourceBuilderProvider = searchSourceBuilderProvider == null ? SearchSourceBuilder::new : searchSourceBuilderProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readFileFromClasspath(String url) {
        String line;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        ClassPathResource classPathResource = new ClassPathResource(url);
        InputStreamReader inputStreamReader = new InputStreamReader(classPathResource.getInputStream());
        bufferedReader = new BufferedReader(inputStreamReader);
        String lineSeparator = System.getProperty("line.separator");
        while ((line = bufferedReader.readLine()) != null) {
            stringBuilder.append(line).append(lineSeparator);
        }
        if (bufferedReader == null) return stringBuilder.toString();
        try {
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (IOException e) {
            logger.debug(String.format("Unable to close buffered reader.. %s", e.getMessage()));
        }
        return stringBuilder.toString();
        catch (Exception e) {
            String string;
            try {
                logger.debug(String.format("Failed to load file from url: %s: %s", url, e.getMessage()));
                string = null;
                if (bufferedReader == null) return string;
            }
            catch (Throwable throwable) {
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    logger.debug(String.format("Unable to close buffered reader.. %s", e2.getMessage()));
                }
                throw throwable;
            }
            try {
                bufferedReader.close();
                return string;
            }
            catch (IOException e3) {
                logger.debug(String.format("Unable to close buffered reader.. %s", e3.getMessage()));
            }
            return string;
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        if (this.elasticsearchConverter instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.elasticsearchConverter).setApplicationContext(context);
        }
    }

    public ElasticsearchConverter getElasticsearchConverter() {
        return this.elasticsearchConverter;
    }

    public Client getClient() {
        throw new UnsupportedOperationException();
    }

    public <T> boolean createIndex(Class<T> clazz) {
        return this.createIndexIfNotCreated(clazz);
    }

    public boolean createIndex(String indexName) {
        return this.executeWithAcknowledge((Action<?>)new CreateIndex.Builder(indexName).build());
    }

    public boolean createIndex(String indexName, Object settings) {
        CreateIndex.Builder createIndexBuilder = new CreateIndex.Builder(indexName);
        if (settings instanceof String) {
            createIndexBuilder.payload(String.valueOf(settings));
        } else if (settings instanceof Map) {
            createIndexBuilder.payload((Map)settings);
        }
        return this.executeWithAcknowledge((Action<?>)createIndexBuilder.build());
    }

    public <T> boolean createIndex(Class<T> clazz, Object settings) {
        return this.createIndex(this.getPersistentEntityFor(clazz).getIndexName(), settings);
    }

    public <T> boolean putMapping(Class<T> clazz) {
        String mapping;
        if (clazz.isAnnotationPresent(Mapping.class)) {
            String mappingPath = clazz.getAnnotation(Mapping.class).mappingPath();
            if (StringUtils.hasText((String)mappingPath)) {
                String mappings = JestElasticsearchTemplate.readFileFromClasspath(mappingPath);
                if (StringUtils.hasText((String)mappings)) {
                    return this.putMapping(clazz, mappings);
                }
            } else {
                logger.info("mappingPath in @Mapping has to be defined. Building mappings using @Field");
            }
        }
        ElasticsearchPersistentEntity<Object> persistentEntity = this.getPersistentEntityFor(clazz);
        try {
            ElasticsearchPersistentProperty idProperty = (ElasticsearchPersistentProperty)persistentEntity.getIdProperty();
            if (idProperty == null) {
                throw new IllegalArgumentException(String.format("No Id property for %s found", clazz.getSimpleName()));
            }
            mapping = this.xContentBuilderToString(MappingBuilder.buildMapping(clazz, persistentEntity.getIndexType(), idProperty.getFieldName(), persistentEntity.getParentType()));
        }
        catch (Exception e) {
            throw new ElasticsearchException("Failed to build mapping for " + clazz.getSimpleName(), (Throwable)e);
        }
        return this.putMapping(clazz, mapping);
    }

    public boolean putMapping(String indexName, String type, Object mapping) {
        Assert.notNull((Object)indexName, (String)"No index defined for putMapping()");
        Assert.notNull((Object)type, (String)"No type defined for putMapping()");
        try {
            String source = null;
            if (mapping instanceof String) {
                source = String.valueOf(mapping);
            } else if (mapping instanceof Map) {
                XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
                builder.map((Map)mapping);
                source = this.xContentBuilderToString(builder);
            } else if (mapping instanceof XContentBuilder) {
                source = this.xContentBuilderToString((XContentBuilder)mapping);
            } else if (mapping instanceof DocumentMapper) {
                source = ((DocumentMapper)mapping).mappingSource().toString();
            }
            PutMapping.Builder requestBuilder = new PutMapping.Builder(indexName, type, (Object)source);
            return this.executeWithAcknowledge((Action<?>)requestBuilder.build());
        }
        catch (Exception e) {
            throw new ElasticsearchException("Failed to build mapping for " + indexName + ":" + type, (Throwable)e);
        }
    }

    private String xContentBuilderToString(XContentBuilder builder) {
        builder.close();
        ByteArrayOutputStream bos = (ByteArrayOutputStream)builder.getOutputStream();
        return bos.toString();
    }

    public <T> boolean putMapping(Class<T> clazz, Object mapping) {
        return this.putMapping(this.getPersistentEntityFor(clazz).getIndexName(), this.getPersistentEntityFor(clazz).getIndexType(), mapping);
    }

    public <T> Map getMapping(Class<T> clazz) {
        return this.getMapping(this.getPersistentEntityFor(clazz).getIndexName(), this.getPersistentEntityFor(clazz).getIndexType());
    }

    public Map getMapping(String indexName, String type) {
        Assert.notNull((Object)indexName, (String)"No index defined for putMapping()");
        Assert.notNull((Object)type, (String)"No type defined for putMapping()");
        Map mappings = null;
        try {
            GetMapping.Builder getMappingBuilder = new GetMapping.Builder();
            ((GetMapping.Builder)getMappingBuilder.addIndex(indexName)).addType(type);
            Object result = this.execute((Action)getMappingBuilder.build());
            if (!result.getJsonObject().has(indexName)) {
                logger.info("Index {} did not exist when retrieving mappings for type {}.", (Object)indexName, (Object)type);
            } else {
                JsonObject index = result.getJsonObject().get(indexName).getAsJsonObject();
                if (index != null) {
                    JsonObject mappingElem = index.get("mappings").getAsJsonObject();
                    if (!mappingElem.has(type)) {
                        logger.info("Type {} did not exist in index {} when retrieving mappings.", (Object)type, (Object)indexName);
                    } else {
                        mappings = (Map)this.resultsMapper.getEntityMapper().mapToObject(mappingElem.get(type).toString(), Map.class);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ElasticsearchException("Error while getting mapping for indexName : " + indexName + " type : " + type + " " + e.getMessage());
        }
        return mappings;
    }

    public Map getSetting(String indexName) {
        Assert.notNull((Object)indexName, (String)"No index defined for getSettings");
        GetSettings.Builder getSettingsBuilder = new GetSettings.Builder();
        getSettingsBuilder.addIndex(indexName);
        Object result = this.execute((Action)getSettingsBuilder.build());
        JsonObject entries = result.getJsonObject().get(indexName).getAsJsonObject().get("settings").getAsJsonObject().get("index").getAsJsonObject();
        HashMap<String, String> mappings = new HashMap<String, String>();
        this.flatMap("index", entries, mappings);
        return mappings;
    }

    private void flatMap(String prefix, JsonObject jsonObject, Map<String, String> mappings) {
        Set entries = jsonObject.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value.isJsonPrimitive()) {
                mappings.put(prefix + "." + key, value.getAsString());
                continue;
            }
            if (!value.isJsonObject()) continue;
            this.flatMap(prefix + "." + key, value.getAsJsonObject(), mappings);
        }
    }

    public <T> Map getSetting(Class<T> clazz) {
        return this.getSetting(this.getPersistentEntityFor(clazz).getIndexName());
    }

    public <T> T queryForObject(GetQuery query, Class<T> clazz) {
        return this.queryForObject(query, clazz, this.resultsMapper);
    }

    public <T> T queryForObject(GetQuery query, Class<T> clazz, GetResultMapper mapper) {
        throw new UnsupportedOperationException();
    }

    public <T> T queryForObject(GetQuery query, Class<T> clazz, JestGetResultMapper mapper) {
        return this.queryForObject(null, query, clazz, mapper);
    }

    public <T> T queryForObject(String indexName, GetQuery query, Class<T> clazz) {
        return this.queryForObject(indexName, query, clazz, this.resultsMapper);
    }

    public <T> T queryForObject(String indexName, GetQuery query, Class<T> clazz, JestGetResultMapper mapper) {
        ElasticsearchPersistentEntity<Object> persistentEntity = this.getPersistentEntityFor(clazz);
        String index = indexName == null ? persistentEntity.getIndexName() : indexName;
        Get.Builder build = (Get.Builder)new Get.Builder(index, query.getId()).type(persistentEntity.getIndexType());
        DocumentResult result = (DocumentResult)this.execute((Action<T>)build.build(), true);
        return mapper.mapResult(result, clazz);
    }

    public <T> T queryForObject(CriteriaQuery query, Class<T> clazz) {
        Page<T> page = this.queryForPage(query, clazz);
        Assert.isTrue((page.getTotalElements() < 2L ? 1 : 0) != 0, (String)("Expected 1 but found " + page.getTotalElements() + " results"));
        return page.getTotalElements() > 0L ? (T)page.getContent().get(0) : null;
    }

    public <T> T queryForObject(StringQuery query, Class<T> clazz) {
        Page<T> page = this.queryForPage(query, clazz);
        Assert.isTrue((page.getTotalElements() < 2L ? 1 : 0) != 0, (String)("Expected 1 but found " + page.getTotalElements() + " results"));
        return page.getTotalElements() > 0L ? (T)page.getContent().get(0) : null;
    }

    public <T> AggregatedPage<T> queryForPage(SearchQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz, (JestSearchResultMapper)this.resultsMapper);
    }

    public <T> AggregatedPage<T> queryForPage(SearchQuery query, Class<T> clazz, SearchResultMapper mapper) {
        throw new UnsupportedOperationException();
    }

    public <T> AggregatedPage<T> queryForPage(SearchQuery query, Class<T> clazz, JestSearchResultMapper mapper) {
        SearchResult response = this.doSearch(this.prepareSearch((Query)query, clazz), query);
        return mapper.mapResults(response, clazz, query.getAggregations(), query.getPageable());
    }

    public <T> T query(SearchQuery query, ResultsExtractor<T> resultsExtractor) {
        throw new UnsupportedOperationException();
    }

    public <T> T query(SearchQuery query, JestResultsExtractor<T> resultsExtractor) {
        SearchResult response = this.doSearch(this.prepareSearch((Query)query), query);
        return resultsExtractor.extract(response);
    }

    public <T> List<T> queryForList(CriteriaQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz).getContent();
    }

    public <T> List<T> queryForList(StringQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz).getContent();
    }

    public <T> List<T> queryForList(SearchQuery query, Class<T> clazz) {
        return this.queryForPage(query, (Class)clazz).getContent();
    }

    public <T> List<String> queryForIds(SearchQuery query) {
        SearchSourceBuilder search = this.prepareSearch((Query)query).query(query.getQuery()).fetchSource(false);
        if (query.getFilter() != null) {
            search.postFilter(query.getFilter());
        }
        SearchResult result = this.executeSearch((Query)query, search);
        return this.extractIds(result);
    }

    public <T> Page<T> queryForPage(CriteriaQuery criteriaQuery, Class<T> clazz) {
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        QueryBuilder elasticsearchFilter = new CriteriaFilterProcessor().createFilterFromCriteria(criteriaQuery.getCriteria());
        SearchSourceBuilder searchRequestBuilder = this.prepareSearch((Query)criteriaQuery, clazz);
        if (elasticsearchQuery != null) {
            searchRequestBuilder.query(elasticsearchQuery);
        } else {
            searchRequestBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (criteriaQuery.getMinScore() > 0.0f) {
            searchRequestBuilder.minScore(criteriaQuery.getMinScore());
        }
        if (elasticsearchFilter != null) {
            searchRequestBuilder.postFilter(elasticsearchFilter);
        }
        SearchResult response = this.executeSearch((Query)criteriaQuery, searchRequestBuilder);
        return this.resultsMapper.mapResults(response, clazz, criteriaQuery.getPageable());
    }

    public <T> Page<T> queryForPage(StringQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz, (JestSearchResultMapper)this.resultsMapper);
    }

    public <T> Page<T> queryForPage(StringQuery query, Class<T> clazz, SearchResultMapper mapper) {
        throw new UnsupportedOperationException();
    }

    public <T> Page<T> queryForPage(StringQuery query, Class<T> clazz, JestSearchResultMapper mapper) {
        SearchResult response = this.executeSearch((Query)query, this.prepareSearch((Query)query, clazz).query((QueryBuilder)QueryBuilders.wrapperQuery((String)query.getSource())));
        return mapper.mapResults(response, clazz, query.getPageable());
    }

    public <T> CloseableIterator<T> stream(CriteriaQuery query, Class<T> clazz) {
        long scrollTimeInMillis = TimeValue.timeValueMinutes((long)1L).millis();
        return this.doStream(scrollTimeInMillis, (ScrolledPage)this.startScroll(scrollTimeInMillis, query, clazz), clazz, this.resultsMapper);
    }

    public <T> CloseableIterator<T> stream(SearchQuery query, Class<T> clazz) {
        return this.stream(query, clazz, this.resultsMapper);
    }

    public <T> CloseableIterator<T> stream(SearchQuery query, Class<T> clazz, SearchResultMapper mapper) {
        throw new UnsupportedOperationException();
    }

    public <T> CloseableIterator<T> stream(SearchQuery query, Class<T> clazz, JestResultsMapper mapper) {
        long scrollTimeInMillis = TimeValue.timeValueMinutes((long)1L).millis();
        return this.doStream(scrollTimeInMillis, (ScrolledPage)this.startScroll(scrollTimeInMillis, query, clazz, (JestSearchResultMapper)mapper), clazz, mapper);
    }

    private <T> CloseableIterator<T> doStream(final long scrollTimeInMillis, final ScrolledPage<T> page, final Class<T> clazz, final JestResultsMapper mapper) {
        return new CloseableIterator<T>(){
            private volatile Iterator<T> currentHits;
            private volatile String scrollId;
            private volatile boolean finished;
            {
                this.currentHits = page.iterator();
                this.scrollId = page.getScrollId();
                this.finished = !this.currentHits.hasNext();
            }

            public void close() {
                try {
                    if (!this.finished && this.scrollId != null && this.currentHits != null && this.currentHits.hasNext()) {
                        JestElasticsearchTemplate.this.clearScroll(this.scrollId);
                    }
                }
                finally {
                    this.currentHits = null;
                    this.scrollId = null;
                }
            }

            public boolean hasNext() {
                if (this.finished) {
                    return false;
                }
                if (this.currentHits == null || !this.currentHits.hasNext()) {
                    ScrolledPage scroll = (ScrolledPage)JestElasticsearchTemplate.this.continueScroll(this.scrollId, scrollTimeInMillis, clazz, mapper);
                    this.currentHits = scroll.iterator();
                    this.finished = !this.currentHits.hasNext();
                    this.scrollId = scroll.getScrollId();
                }
                return this.currentHits.hasNext();
            }

            public T next() {
                if (this.hasNext()) {
                    return this.currentHits.next();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public <T> long count(CriteriaQuery criteriaQuery, Class<T> clazz) {
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        QueryBuilder elasticsearchFilter = new CriteriaFilterProcessor().createFilterFromCriteria(criteriaQuery.getCriteria());
        if (elasticsearchFilter == null) {
            return this.doCount(this.prepareCount((Query)criteriaQuery, clazz), elasticsearchQuery);
        }
        return this.doCount(this.prepareSearch((Query)criteriaQuery, clazz), elasticsearchQuery, elasticsearchFilter);
    }

    public <T> long count(SearchQuery searchQuery, Class<T> clazz) {
        QueryBuilder elasticsearchQuery = searchQuery.getQuery();
        QueryBuilder elasticsearchFilter = searchQuery.getFilter();
        if (elasticsearchFilter == null) {
            return this.doCount(this.prepareCount((Query)searchQuery, clazz), elasticsearchQuery);
        }
        return this.doCount(this.prepareSearch((Query)searchQuery, clazz), elasticsearchQuery, elasticsearchFilter);
    }

    public <T> long count(CriteriaQuery query) {
        return this.count(query, null);
    }

    public <T> long count(SearchQuery query) {
        return this.count(query, null);
    }

    private long doCount(Count.Builder countRequestBuilder, QueryBuilder elasticsearchQuery) {
        if (elasticsearchQuery != null) {
            countRequestBuilder.query(this.searchSourceBuilderProvider.get().query(elasticsearchQuery).toString());
        }
        CountResult result = (CountResult)this.execute((Action)countRequestBuilder.build());
        return result.getCount().longValue();
    }

    private long doCount(SearchSourceBuilder searchRequestBuilder, QueryBuilder elasticsearchQuery, QueryBuilder elasticsearchFilter) {
        if (elasticsearchQuery != null) {
            searchRequestBuilder.query(elasticsearchQuery);
        } else {
            searchRequestBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (elasticsearchFilter != null) {
            searchRequestBuilder.postFilter(elasticsearchFilter);
        }
        CountResult result = (CountResult)this.execute((Action)new Count.Builder().query(searchRequestBuilder.toString()).build());
        return result.getCount().longValue();
    }

    private <T> Count.Builder prepareCount(Query query, Class<T> clazz) {
        String[] indexName = !CollectionUtils.isEmpty((Collection)query.getIndices()) ? query.getIndices().toArray(new String[query.getIndices().size()]) : this.retrieveIndexNameFromPersistentEntity(clazz);
        String[] types = !CollectionUtils.isEmpty((Collection)query.getTypes()) ? query.getTypes().toArray(new String[query.getTypes().size()]) : this.retrieveTypeFromPersistentEntity(clazz);
        Assert.notNull((Object)indexName, (String)"No index defined for Query");
        Count.Builder countRequestBuilder = (Count.Builder)new Count.Builder().addIndices(Arrays.asList(indexName));
        if (types != null) {
            countRequestBuilder.addTypes(Arrays.asList(types));
        }
        return countRequestBuilder;
    }

    public <T> LinkedList<T> multiGet(SearchQuery searchQuery, Class<T> clazz, MultiGetResultMapper getResultMapper) {
        throw new UnsupportedOperationException();
    }

    public <T> LinkedList<T> multiGet(SearchQuery searchQuery, Class<T> clazz, JestMultiGetResultMapper getResultMapper) {
        return getResultMapper.mapResults(this.getMultiResponse((Query)searchQuery, clazz), clazz);
    }

    public <T> LinkedList<T> multiGet(SearchQuery searchQuery, Class<T> clazz) {
        return this.resultsMapper.mapResults(this.getMultiResponse((Query)searchQuery, clazz), clazz);
    }

    private <T> MultiDocumentResult getMultiResponse(Query searchQuery, Class<T> clazz) {
        String indexName = !CollectionUtils.isEmpty((Collection)searchQuery.getIndices()) ? (String)searchQuery.getIndices().get(0) : this.getPersistentEntityFor(clazz).getIndexName();
        String type = !CollectionUtils.isEmpty((Collection)searchQuery.getTypes()) ? (String)searchQuery.getTypes().get(0) : this.getPersistentEntityFor(clazz).getIndexType();
        Assert.notNull((Object)indexName, (String)"No index defined for Query");
        Assert.notNull((Object)type, (String)"No type define for Query");
        Assert.notEmpty((Collection)searchQuery.getIds(), (String)"No Id define for Query");
        MultiGet.Builder.ById builder = new MultiGet.Builder.ById(indexName, type).addId(searchQuery.getIds());
        return new MultiDocumentResult((JestResult)this.execute((Action<T>)builder.build()));
    }

    public String index(IndexQuery query) {
        String documentId = ((DocumentResult)this.execute((Action)this.prepareIndex(query))).getId();
        if (query.getObject() != null && this.isDocument(query.getObject().getClass())) {
            this.setPersistentEntityId(query.getObject(), documentId);
        }
        return documentId;
    }

    public UpdateResponse update(UpdateQuery updateQuery) {
        DocumentResult result = (DocumentResult)this.execute((Action)this.prepareUpdate(updateQuery));
        return new UpdateResponse(null, result.getType(), result.getId(), result.getJsonObject().get("_version").getAsLong(), DocWriteResponse.Result.CREATED);
    }

    public void bulkIndex(List<IndexQuery> queries) {
        Bulk.Builder bulk = new Bulk.Builder();
        for (IndexQuery query : queries) {
            bulk.addAction((BulkableAction)this.prepareIndex(query));
        }
        BulkResult bulkResult = new BulkResult(this.execute((Action)bulk.build()));
        if (!bulkResult.isSucceeded()) {
            HashMap<String, String> failedDocuments = new HashMap<String, String>();
            for (BulkResult.BulkResultItem item : bulkResult.getFailedItems()) {
                failedDocuments.put(item.id, item.error);
            }
            throw new ElasticsearchException("Bulk indexing has failures. Use ElasticsearchException.getFailedDocuments() for detailed messages [" + failedDocuments + "]", failedDocuments);
        }
    }

    public void bulkUpdate(List<UpdateQuery> queries) {
        Bulk.Builder bulk = new Bulk.Builder();
        for (UpdateQuery query : queries) {
            bulk.addAction((BulkableAction)this.prepareUpdate(query));
        }
        BulkResult bulkResult = new BulkResult(this.execute((Action)bulk.build()));
        if (!bulkResult.isSucceeded()) {
            HashMap<String, String> failedDocuments = new HashMap<String, String>();
            for (BulkResult.BulkResultItem item : bulkResult.getFailedItems()) {
                failedDocuments.put(item.id, item.error);
            }
            throw new ElasticsearchException("Bulk indexing has failures. Use ElasticsearchException.getFailedDocuments() for detailed messages [" + failedDocuments + "]", failedDocuments);
        }
    }

    public String delete(String indexName, String type, String id) {
        return ((DocumentResult)this.execute((Action)((Delete.Builder)((Delete.Builder)new Delete.Builder(id).index(indexName)).type(type)).build(), true)).getId();
    }

    public <T> void delete(CriteriaQuery criteriaQuery, Class<T> clazz) {
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        Assert.notNull((Object)elasticsearchQuery, (String)"Query can not be null.");
        DeleteQuery deleteQuery = new DeleteQuery();
        deleteQuery.setQuery(elasticsearchQuery);
        this.delete(deleteQuery, clazz);
    }

    public <T> String delete(Class<T> clazz, String id) {
        ElasticsearchPersistentEntity<Object> persistentEntity = this.getPersistentEntityFor(clazz);
        return this.delete(persistentEntity.getIndexName(), persistentEntity.getIndexType(), id);
    }

    public <T> void delete(DeleteQuery deleteQuery, Class<T> clazz) {
        String indexName = StringUtils.hasText((String)deleteQuery.getIndex()) ? deleteQuery.getIndex() : this.getPersistentEntityFor(clazz).getIndexName();
        String typeName = StringUtils.hasText((String)deleteQuery.getType()) ? deleteQuery.getType() : this.getPersistentEntityFor(clazz).getIndexType();
        Integer pageSize = deleteQuery.getPageSize() != null ? deleteQuery.getPageSize() : 1000;
        Long scrollTimeInMillis = deleteQuery.getScrollTimeInMillis() != null ? deleteQuery.getScrollTimeInMillis() : 10000L;
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery(deleteQuery.getQuery()).withIndices(new String[]{indexName}).withTypes(new String[]{typeName}).withPageable((Pageable)PageRequest.of((int)0, (int)pageSize)).build();
        JestSearchResultMapper onlyIdSearchResultMapper = new JestSearchResultMapper(){

            public <U> AggregatedPage<U> mapResults(SearchResult response, Class<U> clazz, Pageable pageable) {
                ArrayList<String> result = new ArrayList<String>();
                for (SearchResult.Hit searchHit : response.getHits(JsonObject.class)) {
                    result.add(((JsonObject)searchHit.source).get("es_metadata_id").getAsString());
                }
                if (result.size() > 0) {
                    return new AggregatedPageImpl(result, ((ExtendedSearchResult)response).getScrollId());
                }
                return new AggregatedPageImpl(Collections.emptyList(), ((ExtendedSearchResult)response).getScrollId());
            }

            public <U> AggregatedPage<U> mapResults(SearchResult response, Class<U> clazz, List<AbstractAggregationBuilder> aggregations, Pageable pageable) {
                return this.mapResults(response, clazz, pageable);
            }
        };
        Page<String> scrolledResult = this.startScroll((long)scrollTimeInMillis, (SearchQuery)searchQuery, String.class, onlyIdSearchResultMapper);
        ArrayList ids = new ArrayList();
        JestScrollResultMapper onlyIdResultMapper = new JestScrollResultMapper(){

            public <U> Page<U> mapResults(SearchScrollResult response, Class<U> clazz) {
                ArrayList<String> result = new ArrayList<String>();
                for (SearchScrollResult.Hit<JsonObject, Void> searchHit : response.getHits(JsonObject.class)) {
                    result.add(((JsonObject)searchHit.source).get("es_metadata_id").getAsString());
                }
                if (result.size() > 0) {
                    return new AggregatedPageImpl(result, response.getScrollId());
                }
                return new AggregatedPageImpl(Collections.emptyList(), response.getScrollId());
            }
        };
        do {
            ids.addAll(scrolledResult.getContent());
        } while ((scrolledResult = this.continueScroll(((ScrolledPage)scrolledResult).getScrollId(), (long)scrollTimeInMillis, String.class, onlyIdResultMapper)).getContent().size() != 0);
        if (!ids.isEmpty()) {
            Bulk.Builder bulk = new Bulk.Builder();
            for (String id : ids) {
                bulk.addAction((BulkableAction)((Delete.Builder)((Delete.Builder)new Delete.Builder(id).index(indexName)).type(typeName)).build());
            }
            this.execute((Action<T>)bulk.build());
        }
        this.clearScroll(((ScrolledPage)scrolledResult).getScrollId());
    }

    public void delete(DeleteQuery deleteQuery) {
        Assert.notNull((Object)deleteQuery.getIndex(), (String)"No index defined for Query");
        Assert.notNull((Object)deleteQuery.getType(), (String)"No type define for Query");
        this.delete(deleteQuery, null);
    }

    public <T> boolean deleteIndex(Class<T> clazz) {
        return this.deleteIndex(this.getPersistentEntityFor(clazz).getIndexName());
    }

    public boolean deleteIndex(String indexName) {
        Assert.notNull((Object)indexName, (String)"No index defined for delete operation");
        return this.indexExists(indexName) && this.executeWithAcknowledge((Action<?>)new DeleteIndex.Builder(indexName).build());
    }

    public <T> boolean indexExists(Class<T> clazz) {
        return this.indexExists(this.getPersistentEntityFor(clazz).getIndexName());
    }

    public boolean indexExists(String indexName) {
        return this.executeWithAcknowledge((Action<?>)new IndicesExists.Builder(indexName).build());
    }

    public boolean typeExists(String index, String type) {
        return this.executeWithAcknowledge((Action<?>)((TypeExist.Builder)new TypeExist.Builder(index).addType(type)).build());
    }

    public void refresh(String indexName) {
        this.execute((Action)((Refresh.Builder)new Refresh.Builder().addIndex(indexName)).build());
    }

    public <T> void refresh(Class<T> clazz) {
        ElasticsearchPersistentEntity<Object> persistentEntity = this.getPersistentEntityFor(clazz);
        this.execute((Action<T>)((Refresh.Builder)new Refresh.Builder().addIndex(persistentEntity.getIndexName())).build());
    }

    private <T> SearchSourceBuilder prepareScroll(Query query, Class<T> clazz) {
        this.setPersistentEntityIndexAndType(query, clazz);
        return this.prepareScroll(query);
    }

    private SearchSourceBuilder prepareScroll(Query query) {
        SearchSourceBuilder searchSourceBuilder = this.searchSourceBuilderProvider.get();
        if (query.getPageable() != null && query.getPageable().isPaged()) {
            searchSourceBuilder.size(query.getPageable().getPageSize());
        }
        searchSourceBuilder.from(0);
        if (!CollectionUtils.isEmpty((Collection)query.getFields())) {
            searchSourceBuilder.fetchSource(JestElasticsearchTemplate.toArray(query.getFields()), null);
        }
        if (query.getSort() != null) {
            for (Sort.Order order : query.getSort()) {
                searchSourceBuilder.sort(order.getProperty(), order.getDirection() == Sort.Direction.DESC ? SortOrder.DESC : SortOrder.ASC);
            }
        }
        if (query.getMinScore() > 0.0f) {
            searchSourceBuilder.minScore(query.getMinScore());
        }
        return searchSourceBuilder;
    }

    private SearchResult doScroll(SearchSourceBuilder searchSourceBuilder, CriteriaQuery criteriaQuery, long scrollTimeInMillis) {
        Assert.notNull((Object)criteriaQuery.getIndices(), (String)"No index defined for Query");
        Assert.notNull((Object)criteriaQuery.getTypes(), (String)"No type define for Query");
        Assert.notNull((Object)criteriaQuery.getPageable(), (String)"Query.pageable is required for scan & scroll");
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        QueryBuilder elasticsearchFilter = new CriteriaFilterProcessor().createFilterFromCriteria(criteriaQuery.getCriteria());
        searchSourceBuilder.query((QueryBuilder)(elasticsearchQuery != null ? elasticsearchQuery : QueryBuilders.matchAllQuery()));
        if (elasticsearchFilter != null) {
            searchSourceBuilder.postFilter(elasticsearchFilter);
        }
        Search.Builder search = (Search.Builder)((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(searchSourceBuilder.toString()).addTypes((Collection)criteriaQuery.getTypes())).addIndices((Collection)criteriaQuery.getIndices())).setParameter("size", (Object)criteriaQuery.getPageable().getPageSize())).setParameter("scroll", (Object)(scrollTimeInMillis + "ms"));
        return new ExtendedSearchResult((SearchResult)this.execute((Action)search.build()));
    }

    private SearchResult doScroll(SearchSourceBuilder searchSourceBuilder, SearchQuery searchQuery, long scrollTimeInMillis) {
        Assert.notNull((Object)searchQuery.getIndices(), (String)"No index defined for Query");
        Assert.notNull((Object)searchQuery.getTypes(), (String)"No type define for Query");
        Assert.notNull((Object)searchQuery.getPageable(), (String)"Query.pageable is required for scan & scroll");
        QueryBuilder elasticsearchQuery = searchQuery.getQuery();
        searchSourceBuilder.query((QueryBuilder)(elasticsearchQuery != null ? elasticsearchQuery : QueryBuilders.matchAllQuery()));
        if (searchQuery.getFilter() != null) {
            searchSourceBuilder.postFilter(searchQuery.getFilter());
        }
        Search.Builder search = (Search.Builder)((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(searchSourceBuilder.toString()).addTypes((Collection)searchQuery.getTypes())).addIndices((Collection)searchQuery.getIndices())).setParameter("size", (Object)searchQuery.getPageable().getPageSize())).setParameter("scroll", (Object)(scrollTimeInMillis + "ms"));
        return new ExtendedSearchResult((SearchResult)this.execute((Action)search.build()));
    }

    public <T> Page<T> startScroll(long scrollTimeInMillis, SearchQuery searchQuery, Class<T> clazz) {
        SearchResult response = this.doScroll(this.prepareScroll((Query)searchQuery, clazz), searchQuery, scrollTimeInMillis);
        return this.resultsMapper.mapResults(response, clazz, searchQuery.getPageable());
    }

    public <T> Page<T> startScroll(long scrollTimeInMillis, CriteriaQuery criteriaQuery, Class<T> clazz) {
        SearchResult response = this.doScroll(this.prepareScroll((Query)criteriaQuery, clazz), criteriaQuery, scrollTimeInMillis);
        return this.resultsMapper.mapResults(response, clazz, criteriaQuery.getPageable());
    }

    public <T> Page<T> startScroll(long scrollTimeInMillis, SearchQuery searchQuery, Class<T> clazz, SearchResultMapper mapper) {
        throw new UnsupportedOperationException();
    }

    public <T> Page<T> startScroll(long scrollTimeInMillis, SearchQuery searchQuery, Class<T> clazz, JestSearchResultMapper mapper) {
        SearchResult response = this.doScroll(this.prepareScroll((Query)searchQuery, clazz), searchQuery, scrollTimeInMillis);
        return mapper.mapResults(response, clazz, searchQuery.getPageable());
    }

    public <T> Page<T> startScroll(long scrollTimeInMillis, CriteriaQuery criteriaQuery, Class<T> clazz, SearchResultMapper mapper) {
        throw new UnsupportedOperationException();
    }

    public <T> Page<T> startScroll(long scrollTimeInMillis, CriteriaQuery criteriaQuery, Class<T> clazz, JestSearchResultMapper mapper) {
        SearchResult response = this.doScroll(this.prepareScroll((Query)criteriaQuery, clazz), criteriaQuery, scrollTimeInMillis);
        return mapper.mapResults(response, clazz, criteriaQuery.getPageable());
    }

    public <T> Page<T> continueScroll(@Nullable String scrollId, long scrollTimeInMillis, Class<T> clazz) {
        SearchScroll scroll = new SearchScroll.Builder(scrollId, scrollTimeInMillis + "ms").build();
        SearchScrollResult response = new SearchScrollResult((JestResult)this.execute((Action<T>)scroll));
        return this.resultsMapper.mapResults(response, clazz);
    }

    public <T> Page<T> continueScroll(@Nullable String scrollId, long scrollTimeInMillis, Class<T> clazz, SearchResultMapper mapper) {
        throw new UnsupportedOperationException();
    }

    public <T> Page<T> continueScroll(@Nullable String scrollId, long scrollTimeInMillis, Class<T> clazz, JestScrollResultMapper mapper) {
        SearchScroll scroll = new SearchScroll.Builder(scrollId, scrollTimeInMillis + "ms").build();
        SearchScrollResult response = new SearchScrollResult((JestResult)this.execute((Action<T>)scroll));
        return mapper.mapResults(response, clazz);
    }

    public void clearScroll(String scrollId) {
        this.execute((Action)new ClearScroll.Builder().addScrollId(scrollId).build(), true);
    }

    public <T> Page<T> moreLikeThis(MoreLikeThisQuery query, Class<T> clazz) {
        ElasticsearchPersistentEntity<Object> persistentEntity = this.getPersistentEntityFor(clazz);
        String indexName = StringUtils.hasText((String)query.getIndexName()) ? query.getIndexName() : persistentEntity.getIndexName();
        String type = StringUtils.hasText((String)query.getType()) ? query.getType() : persistentEntity.getIndexType();
        Assert.notNull((Object)indexName, (String)"No 'indexName' defined for MoreLikeThisQuery");
        Assert.notNull((Object)type, (String)"No 'type' defined for MoreLikeThisQuery");
        Assert.notNull((Object)query.getId(), (String)"No document id defined for MoreLikeThisQuery");
        MoreLikeThisQueryBuilder moreLikeThisQueryBuilder = QueryBuilders.moreLikeThisQuery((MoreLikeThisQueryBuilder.Item[])JestElasticsearchTemplate.toArray(new MoreLikeThisQueryBuilder.Item(indexName, type, query.getId())));
        if (query.getMinTermFreq() != null) {
            moreLikeThisQueryBuilder.minTermFreq(query.getMinTermFreq().intValue());
        }
        if (query.getMaxQueryTerms() != null) {
            moreLikeThisQueryBuilder.maxQueryTerms(query.getMaxQueryTerms().intValue());
        }
        if (!CollectionUtils.isEmpty((Collection)query.getStopWords())) {
            moreLikeThisQueryBuilder.stopWords(JestElasticsearchTemplate.toArray(query.getStopWords()));
        }
        if (query.getMinDocFreq() != null) {
            moreLikeThisQueryBuilder.minDocFreq(query.getMinDocFreq().intValue());
        }
        if (query.getMaxDocFreq() != null) {
            moreLikeThisQueryBuilder.maxDocFreq(query.getMaxDocFreq().intValue());
        }
        if (query.getMinWordLen() != null) {
            moreLikeThisQueryBuilder.minWordLength(query.getMinWordLen().intValue());
        }
        if (query.getMaxWordLen() != null) {
            moreLikeThisQueryBuilder.maxWordLength(query.getMaxWordLen().intValue());
        }
        if (query.getBoostTerms() != null) {
            moreLikeThisQueryBuilder.boostTerms(query.getBoostTerms().floatValue());
        }
        return this.queryForPage((SearchQuery)new NativeSearchQueryBuilder().withQuery((QueryBuilder)moreLikeThisQueryBuilder).build(), (Class)clazz);
    }

    public Boolean addAlias(AliasQuery query) {
        Assert.notNull((Object)query.getIndexName(), (String)"No index defined for Alias");
        Assert.notNull((Object)query.getAliasName(), (String)"No alias defined");
        AddAliasMapping.Builder aliasAction = new AddAliasMapping.Builder(query.getIndexName(), query.getAliasName());
        if (query.getFilterBuilder() == null) {
            if (query.getFilter() != null) {
                aliasAction.setFilter(query.getFilter());
            } else if (StringUtils.hasText((String)query.getRouting())) {
                aliasAction.addRouting(query.getRouting());
            } else if (StringUtils.hasText((String)query.getSearchRouting())) {
                aliasAction.addSearchRouting(query.getSearchRouting());
            } else if (StringUtils.hasText((String)query.getIndexRouting())) {
                aliasAction.addIndexRouting(query.getIndexRouting());
            }
        }
        return this.executeWithAcknowledge((Action<?>)new ModifyAliases.Builder((AliasMapping)aliasAction.build()).build());
    }

    public Boolean removeAlias(AliasQuery query) {
        Assert.notNull((Object)query.getIndexName(), (String)"No index defined for Alias");
        Assert.notNull((Object)query.getAliasName(), (String)"No alias defined");
        RemoveAliasMapping removeAlias = new RemoveAliasMapping.Builder(query.getIndexName(), query.getAliasName()).build();
        return this.executeWithAcknowledge((Action<?>)new ModifyAliases.Builder((AliasMapping)removeAlias).build());
    }

    public List<AliasMetaData> queryForAlias(String indexName) {
        GetAliases getAliases = ((GetAliases.Builder)new GetAliases.Builder().addIndex(indexName)).build();
        Object result = this.execute((Action)getAliases);
        if (!result.isSucceeded()) {
            return Collections.emptyList();
        }
        Set entries = result.getJsonObject().getAsJsonObject(indexName).getAsJsonObject("aliases").entrySet();
        ArrayList<AliasMetaData> aliases = new ArrayList<AliasMetaData>(entries.size());
        for (Map.Entry entry : entries) {
            aliases.add(AliasMetaData.newAliasMetaDataBuilder((String)((String)entry.getKey())).build());
        }
        return aliases;
    }

    public Set<String> getIndicesFromAlias(String aliasName) {
        Object result = this.execute((Action)((GetAliases.Builder)new GetAliases.Builder().addIndex(aliasName)).build());
        if (!result.isSucceeded()) {
            return Collections.emptySet();
        }
        Set entries = result.getJsonObject().entrySet();
        HashSet<String> indices = new HashSet<String>(entries.size());
        for (Map.Entry entry : entries) {
            indices.add((String)entry.getKey());
        }
        return indices;
    }

    public ElasticsearchPersistentEntity<Object> getPersistentEntityFor(Class clazz) {
        Assert.isTrue((boolean)clazz.isAnnotationPresent(Document.class), (String)("Unable to identify index name. " + clazz.getSimpleName() + " is not a Document. Make sure the document class is annotated with @Document(indexName=\"foo\")"));
        return (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz);
    }

    private <T extends JestResult> T execute(Action<T> action) {
        return this.execute(action, false);
    }

    private <T extends JestResult> T execute(Action<T> action, boolean acceptNotFound) {
        try {
            JestResult result = this.client.execute(action);
            this.errorMapper.mapError(action, result, acceptNotFound);
            return (T)result;
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to execute action", (Throwable)e);
        }
    }

    private boolean executeWithAcknowledge(Action<?> action) {
        return this.execute(action, true).isSucceeded();
    }

    private <T> SearchSourceBuilder prepareSearch(Query query, Class<T> clazz) {
        this.setPersistentEntityIndexAndType(query, clazz);
        return this.prepareSearch(query);
    }

    private SearchSourceBuilder prepareSearch(Query query) {
        Assert.notNull((Object)query.getIndices(), (String)"No index defined for Query");
        Assert.notNull((Object)query.getTypes(), (String)"No type defined for Query");
        SearchSourceBuilder searchSourceBuilder = this.searchSourceBuilderProvider.get();
        int startRecord = 0;
        if (query.getPageable() != null && query.getPageable().isPaged()) {
            startRecord = query.getPageable().getPageNumber() * query.getPageable().getPageSize();
            searchSourceBuilder.size(query.getPageable().getPageSize());
        }
        searchSourceBuilder.from(startRecord);
        if (!query.getFields().isEmpty()) {
            searchSourceBuilder.fetchSource(JestElasticsearchTemplate.toArray(query.getFields()), null);
        }
        if (query.getSourceFilter() != null) {
            SourceFilter sourceFilter = query.getSourceFilter();
            searchSourceBuilder.fetchSource(sourceFilter.getIncludes(), sourceFilter.getExcludes());
        }
        if (query.getSort() != null) {
            for (Sort.Order order : query.getSort()) {
                searchSourceBuilder.sort(order.getProperty(), order.getDirection() == Sort.Direction.DESC ? SortOrder.DESC : SortOrder.ASC);
            }
        }
        if (query.getMinScore() > 0.0f) {
            searchSourceBuilder.minScore(query.getMinScore());
        }
        return searchSourceBuilder;
    }

    private SearchResult doSearch(SearchSourceBuilder searchSourceBuilder, SearchQuery searchQuery) {
        if (searchQuery.getFilter() != null) {
            searchSourceBuilder.postFilter(searchQuery.getFilter());
        }
        if (!CollectionUtils.isEmpty((Collection)searchQuery.getElasticsearchSorts())) {
            for (SortBuilder sort : searchQuery.getElasticsearchSorts()) {
                searchSourceBuilder.sort(sort);
            }
        }
        if (searchQuery.getHighlightFields() != null) {
            HighlightBuilder highlighter = SearchSourceBuilder.highlight();
            for (SortBuilder highlightField : searchQuery.getHighlightFields()) {
                highlighter.field((HighlightBuilder.Field)highlightField);
            }
            searchSourceBuilder.highlighter(highlighter);
        }
        if (!CollectionUtils.isEmpty((Collection)searchQuery.getAggregations())) {
            for (AbstractAggregationBuilder aggregationBuilder : searchQuery.getAggregations()) {
                searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)searchQuery.getIndicesBoost())) {
            for (IndexBoost indexBoost : searchQuery.getIndicesBoost()) {
                searchSourceBuilder.indexBoost(indexBoost.getIndexName(), indexBoost.getBoost());
            }
        }
        if (!searchQuery.getScriptFields().isEmpty()) {
            for (ScriptField scriptedField : searchQuery.getScriptFields()) {
                searchSourceBuilder.scriptField(scriptedField.fieldName(), scriptedField.script());
            }
        }
        return this.executeSearch((Query)searchQuery, searchSourceBuilder.query(searchQuery.getQuery()));
    }

    private SearchResult executeSearch(Query query, SearchSourceBuilder request) {
        Search.Builder search = new Search.Builder(request.toString());
        if (query != null) {
            ((Search.Builder)((Search.Builder)search.addTypes((Collection)query.getTypes())).addIndices((Collection)query.getIndices())).setSearchType(SearchType.valueOf((String)query.getSearchType().name()));
        }
        return new ExtendedSearchResult((SearchResult)this.execute((Action)search.build()));
    }

    private Index prepareIndex(IndexQuery query) {
        try {
            Index.Builder indexBuilder;
            String type;
            String indexName = !StringUtils.hasText((String)query.getIndexName()) ? this.retrieveIndexNameFromPersistentEntity(query.getObject().getClass())[0] : query.getIndexName();
            String string = type = !StringUtils.hasText((String)query.getType()) ? this.retrieveTypeFromPersistentEntity(query.getObject().getClass())[0] : query.getType();
            if (query.getObject() != null) {
                String entityId = null;
                if (this.isDocument(query.getObject().getClass())) {
                    entityId = this.getPersistentEntityId(query.getObject());
                }
                indexBuilder = new Index.Builder((Object)this.resultsMapper.getEntityMapper().mapToString(query.getObject()));
                if (entityId != null) {
                    ((Index.Builder)((Index.Builder)indexBuilder.index(indexName)).type(type)).id(entityId);
                } else {
                    ((Index.Builder)indexBuilder.index(indexName)).type(type);
                }
            } else if (query.getSource() != null) {
                indexBuilder = (Index.Builder)((Index.Builder)new Index.Builder((Object)query.getSource()).index(indexName)).type(type);
            } else {
                throw new ElasticsearchException("object or source is null, failed to index the document [id: " + query.getId() + "]");
            }
            if (query.getVersion() != null) {
                indexBuilder.setParameter("version", (Object)query.getVersion());
                indexBuilder.setParameter("version_type", (Object)VersionType.EXTERNAL.name().toLowerCase());
            }
            if (query.getId() != null) {
                indexBuilder.id(query.getId());
            }
            if (query.getParentId() != null) {
                indexBuilder.setParameter("parent", (Object)query.getParentId());
            }
            return indexBuilder.build();
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to index the document [id: " + query.getId() + "]", (Throwable)e);
        }
    }

    private Update prepareUpdate(UpdateQuery query) {
        String indexName = StringUtils.hasText((String)query.getIndexName()) ? query.getIndexName() : this.getPersistentEntityFor(query.getClazz()).getIndexName();
        String type = StringUtils.hasText((String)query.getType()) ? query.getType() : this.getPersistentEntityFor(query.getClazz()).getIndexType();
        Assert.notNull((Object)indexName, (String)"No index defined for Query");
        Assert.notNull((Object)type, (String)"No type define for Query");
        Assert.notNull((Object)query.getId(), (String)"No Id define for Query");
        Assert.notNull((Object)query.getUpdateRequest(), (String)"No IndexRequest define for Query");
        HashMap<String, Object> payLoadMap = new HashMap<String, Object>();
        if (query.getUpdateRequest().script() == null) {
            if (query.DoUpsert()) {
                payLoadMap.put("doc_as_upsert", Boolean.TRUE);
                payLoadMap.put("doc", query.getUpdateRequest().doc().sourceAsMap());
            } else {
                payLoadMap.put("doc", query.getUpdateRequest().doc().sourceAsMap());
            }
        }
        try {
            String payload = this.resultsMapper.getEntityMapper().mapToString(payLoadMap);
            Update.Builder updateBuilder = (Update.Builder)((Update.Builder)((Update.Builder)new Update.Builder((Object)payload).index(indexName)).type(type)).id(query.getId());
            return updateBuilder.build();
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to index the document [id: " + query.getId() + "]", (Throwable)e);
        }
    }

    private <T> Map getDefaultSettings(ElasticsearchPersistentEntity<T> persistentEntity) {
        if (persistentEntity.isUseServerConfiguration()) {
            return new HashMap();
        }
        return new MapBuilder().put((Object)"index.number_of_shards", (Object)String.valueOf(persistentEntity.getShards())).put((Object)"index.number_of_replicas", (Object)String.valueOf(persistentEntity.getReplicas())).put((Object)"index.refresh_interval", (Object)persistentEntity.getRefreshInterval()).put((Object)"index.store.type", (Object)persistentEntity.getIndexStoreType()).map();
    }

    private <T> boolean createIndexIfNotCreated(Class<T> clazz) {
        return this.indexExists(this.getPersistentEntityFor(clazz).getIndexName()) || this.createIndexWithSettings(clazz);
    }

    private <T> boolean createIndexWithSettings(Class<T> clazz) {
        if (clazz.isAnnotationPresent(Setting.class)) {
            String settingPath = clazz.getAnnotation(Setting.class).settingPath();
            if (StringUtils.hasText((String)settingPath)) {
                String settings = JestElasticsearchTemplate.readFileFromClasspath(settingPath);
                if (StringUtils.hasText((String)settings)) {
                    return this.createIndex(this.getPersistentEntityFor(clazz).getIndexName(), (Object)settings);
                }
            } else {
                logger.info("settingPath in @Setting has to be defined. Using default instead.");
            }
        }
        return this.createIndex(this.getPersistentEntityFor(clazz).getIndexName(), (Object)this.getDefaultSettings(this.getPersistentEntityFor(clazz)));
    }

    private boolean isDocument(Class clazz) {
        return clazz.isAnnotationPresent(Document.class);
    }

    private String getPersistentEntityId(Object entity) {
        ElasticsearchPersistentEntity<Object> persistentEntity = this.getPersistentEntityFor(entity.getClass());
        Object identifier = persistentEntity.getIdentifierAccessor(entity).getIdentifier();
        return Optional.ofNullable(identifier).map(String::valueOf).orElse(null);
    }

    private static String[] toArray(List<String> values) {
        String[] valuesAsArray = new String[values.size()];
        return values.toArray(valuesAsArray);
    }

    private static MoreLikeThisQueryBuilder.Item[] toArray(MoreLikeThisQueryBuilder.Item ... values) {
        return values;
    }

    private void setPersistentEntityId(Object entity, String id) {
        ElasticsearchPersistentEntity<Object> persistentEntity = this.getPersistentEntityFor(entity.getClass());
        ElasticsearchPersistentProperty idProperty = (ElasticsearchPersistentProperty)persistentEntity.getIdProperty();
        if (idProperty != null && idProperty.getType().isAssignableFrom(String.class)) {
            persistentEntity.getPropertyAccessor(entity).setProperty((PersistentProperty)idProperty, (Object)id);
        }
    }

    private void setPersistentEntityIndexAndType(Query query, Class clazz) {
        if (query.getIndices().isEmpty()) {
            query.addIndices(this.retrieveIndexNameFromPersistentEntity(clazz));
        }
        if (query.getTypes().isEmpty()) {
            query.addTypes(this.retrieveTypeFromPersistentEntity(clazz));
        }
    }

    private String[] retrieveIndexNameFromPersistentEntity(Class clazz) {
        if (clazz != null) {
            return new String[]{this.getPersistentEntityFor(clazz).getIndexName()};
        }
        return null;
    }

    private String[] retrieveTypeFromPersistentEntity(Class clazz) {
        if (clazz != null) {
            return new String[]{this.getPersistentEntityFor(clazz).getIndexType()};
        }
        return null;
    }

    private List<String> extractIds(SearchResult result) {
        ArrayList<String> ids = new ArrayList<String>();
        for (SearchResult.Hit hit : result.getHits(JsonObject.class)) {
            if (hit == null) continue;
            ids.add(hit.id);
        }
        return ids;
    }
}

