/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.play.core.splitinstall;

import android.app.Activity;
import android.content.IntentSender;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.IntentSenderRequest;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.android.play.core.common.IntentSenderForResultStarter;
import com.google.android.play.core.splitinstall.SplitInstallException;
import com.google.android.play.core.splitinstall.SplitInstallManager;
import com.google.android.play.core.splitinstall.SplitInstallRequest;
import com.google.android.play.core.splitinstall.SplitInstallSessionState;
import com.google.android.play.core.splitinstall.SplitInstallStateUpdatedListener;
import com.google.android.play.core.splitinstall.internal.zzn;
import com.google.android.play.core.splitinstall.zzbc;
import com.google.android.play.core.splitinstall.zzbe;
import com.google.android.play.core.splitinstall.zzs;
import com.google.android.play.core.splitinstall.zzx;
import com.google.android.play.core.splitinstall.zzy;
import com.google.android.play.core.splitinstall.zzz;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

final class zzaa
implements SplitInstallManager {
    private final zzbc zza;
    private final zzx zzb;
    private final zzs zzc;
    private final zzbe zzd;
    private final Handler zze = new Handler(Looper.getMainLooper());

    @Override
    public final Task<Void> cancelInstall(int n) {
        return this.zza.zzc(n);
    }

    @Override
    public final Task<Void> deferredInstall(List<String> list) {
        return this.zza.zzd(list);
    }

    @Override
    public final Task<Void> deferredLanguageInstall(List<Locale> list) {
        if (Build.VERSION.SDK_INT < 21) {
            return Tasks.forException((Exception)((Object)new SplitInstallException(-5)));
        }
        return this.zza.zze(zzaa.zze(list));
    }

    @Override
    public final Task<Void> deferredLanguageUninstall(List<Locale> list) {
        if (Build.VERSION.SDK_INT < 21) {
            return Tasks.forException((Exception)((Object)new SplitInstallException(-5)));
        }
        return this.zza.zzf(zzaa.zze(list));
    }

    @Override
    public final Task<Void> deferredUninstall(List<String> list) {
        this.zzd.zzc(list);
        return this.zza.zzg(list);
    }

    @Override
    public final Task<SplitInstallSessionState> getSessionState(int n) {
        return this.zza.zzh(n);
    }

    @Override
    public final Task<List<SplitInstallSessionState>> getSessionStates() {
        return this.zza.zzi();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Task<Integer> startInstall(SplitInstallRequest splitInstallRequest) {
        zzn zzn2;
        block7: {
            List<Locale> list;
            block6: {
                Set set;
                zzn2 = new zzn();
                zzn2.zzb(1);
                if (!splitInstallRequest.getLanguages().isEmpty() && Build.VERSION.SDK_INT < 21) {
                    return Tasks.forException((Exception)((Object)new SplitInstallException(-5)));
                }
                list = splitInstallRequest.getLanguages();
                if (list.isEmpty() || (set = this.zzc.zzd()) == null) break block6;
                HashSet<String> hashSet = new HashSet<String>();
                list = list.iterator();
                while (list.hasNext()) {
                    hashSet.add(((Locale)list.next()).getLanguage());
                }
                if (!set.containsAll(hashSet)) break block7;
            }
            list = splitInstallRequest.getModuleNames();
            if (this.zzc.zzc().containsAll(list) && (Build.VERSION.SDK_INT < 21 || Collections.disjoint(splitInstallRequest.getModuleNames(), this.zzd.zza()))) {
                this.zze.post((Runnable)new zzy(this, splitInstallRequest));
                return Tasks.forResult((Object)0);
            }
        }
        this.zzd.zzd(splitInstallRequest.getModuleNames());
        return this.zza.zzj(splitInstallRequest.getModuleNames(), zzaa.zze(splitInstallRequest.getLanguages()), zzn2);
    }

    static /* bridge */ /* synthetic */ zzx zzc(zzaa zzaa2) {
        return zzaa2.zzb;
    }

    static /* bridge */ /* synthetic */ List zzd(List list) {
        return zzaa.zze(list);
    }

    private static List zze(List object) {
        ArrayList<String> arrayList = new ArrayList<String>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Locale locale = (Locale)object.next();
            if (Build.VERSION.SDK_INT < 21) continue;
            arrayList.add(locale.toLanguageTag());
        }
        return arrayList;
    }

    @Override
    public final Set<String> getInstalledLanguages() {
        Set set = ((zzaa)((Object)set)).zzc.zzd();
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    @Override
    public final Set<String> getInstalledModules() {
        return this.zzc.zzc();
    }

    zzaa(zzbc zzbc2, zzx zzx2, zzs zzs2, zzbe zzbe2) {
        this.zza = zzbc2;
        this.zzb = zzx2;
        this.zzc = zzs2;
        this.zzd = zzbe2;
    }

    @Override
    public final synchronized void zza(SplitInstallStateUpdatedListener splitInstallStateUpdatedListener) {
        this.zzb.zzi(splitInstallStateUpdatedListener);
    }

    @Override
    public final synchronized void registerListener(SplitInstallStateUpdatedListener splitInstallStateUpdatedListener) {
        this.zzb.zzb(splitInstallStateUpdatedListener);
    }

    @Override
    public final synchronized void zzb(SplitInstallStateUpdatedListener splitInstallStateUpdatedListener) {
        this.zzb.zzj(splitInstallStateUpdatedListener);
    }

    @Override
    public final synchronized void unregisterListener(SplitInstallStateUpdatedListener splitInstallStateUpdatedListener) {
        this.zzb.zzd(splitInstallStateUpdatedListener);
    }

    @Override
    public final boolean startConfirmationDialogForResult(SplitInstallSessionState splitInstallSessionState, ActivityResultLauncher<IntentSenderRequest> activityResultLauncher) {
        if (splitInstallSessionState.status() != 8 || splitInstallSessionState.resolutionIntent() == null) {
            return false;
        }
        activityResultLauncher.launch((Object)new IntentSenderRequest.Builder(splitInstallSessionState.resolutionIntent().getIntentSender()).build());
        return true;
    }

    @Override
    public final boolean startConfirmationDialogForResult(SplitInstallSessionState splitInstallSessionState, Activity activity, int n) throws IntentSender.SendIntentException {
        return this.startConfirmationDialogForResult(splitInstallSessionState, new zzz(this, activity), n);
    }

    @Override
    public final boolean startConfirmationDialogForResult(SplitInstallSessionState splitInstallSessionState, IntentSenderForResultStarter intentSenderForResultStarter, int n) throws IntentSender.SendIntentException {
        if (splitInstallSessionState.status() != 8 || splitInstallSessionState.resolutionIntent() == null) {
            return false;
        }
        intentSenderForResultStarter.startIntentSenderForResult(splitInstallSessionState.resolutionIntent().getIntentSender(), n, null, 0, 0, 0, null);
        return true;
    }
}

