/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * BigQuery-specific metadata about a location. This will be set on
 * google.cloud.location.Location.metadata in Cloud Location API responses.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LocationMetadata extends com.google.api.client.json.GenericJson {

  /**
   * The legacy BigQuery location ID, e.g. “EU” for the “europe” location. This is for any API
   * consumers that need the legacy “US” and “EU” locations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String legacyLocationId;

  /**
   * The legacy BigQuery location ID, e.g. “EU” for the “europe” location. This is for any API
   * consumers that need the legacy “US” and “EU” locations.
   * @return value or {@code null} for none
   */
  public java.lang.String getLegacyLocationId() {
    return legacyLocationId;
  }

  /**
   * The legacy BigQuery location ID, e.g. “EU” for the “europe” location. This is for any API
   * consumers that need the legacy “US” and “EU” locations.
   * @param legacyLocationId legacyLocationId or {@code null} for none
   */
  public LocationMetadata setLegacyLocationId(java.lang.String legacyLocationId) {
    this.legacyLocationId = legacyLocationId;
    return this;
  }

  @Override
  public LocationMetadata set(String fieldName, Object value) {
    return (LocationMetadata) super.set(fieldName, value);
  }

  @Override
  public LocationMetadata clone() {
    return (LocationMetadata) super.clone();
  }

}
