/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for SnapshotDefinition.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SnapshotDefinition extends com.google.api.client.json.GenericJson {

  /**
   * [Required] Reference describing the ID of the table that is snapshotted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableReference baseTableReference;

  /**
   * [Required] The time at which the base table was snapshot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime snapshotTime;

  /**
   * [Required] Reference describing the ID of the table that is snapshotted.
   * @return value or {@code null} for none
   */
  public TableReference getBaseTableReference() {
    return baseTableReference;
  }

  /**
   * [Required] Reference describing the ID of the table that is snapshotted.
   * @param baseTableReference baseTableReference or {@code null} for none
   */
  public SnapshotDefinition setBaseTableReference(TableReference baseTableReference) {
    this.baseTableReference = baseTableReference;
    return this;
  }

  /**
   * [Required] The time at which the base table was snapshot.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getSnapshotTime() {
    return snapshotTime;
  }

  /**
   * [Required] The time at which the base table was snapshot.
   * @param snapshotTime snapshotTime or {@code null} for none
   */
  public SnapshotDefinition setSnapshotTime(com.google.api.client.util.DateTime snapshotTime) {
    this.snapshotTime = snapshotTime;
    return this;
  }

  @Override
  public SnapshotDefinition set(String fieldName, Object value) {
    return (SnapshotDefinition) super.set(fieldName, value);
  }

  @Override
  public SnapshotDefinition clone() {
    return (SnapshotDefinition) super.clone();
  }

}
