/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Search space for int array.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IntArrayHparamSearchSpace extends com.google.api.client.json.GenericJson {

  /**
   * Candidates for the int array parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<IntArray> candidates;

  static {
    // hack to force ProGuard to consider IntArray used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(IntArray.class);
  }

  /**
   * Candidates for the int array parameter.
   * @return value or {@code null} for none
   */
  public java.util.List<IntArray> getCandidates() {
    return candidates;
  }

  /**
   * Candidates for the int array parameter.
   * @param candidates candidates or {@code null} for none
   */
  public IntArrayHparamSearchSpace setCandidates(java.util.List<IntArray> candidates) {
    this.candidates = candidates;
    return this;
  }

  @Override
  public IntArrayHparamSearchSpace set(String fieldName, Object value) {
    return (IntArrayHparamSearchSpace) super.set(fieldName, value);
  }

  @Override
  public IntArrayHparamSearchSpace clone() {
    return (IntArrayHparamSearchSpace) super.clone();
  }

}
