/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket.dev;

import com.google.appengine.api.socket.SocketServicePb;
import com.google.appengine.repackaged.com.google.io.protocol.proto.ProtocolDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MockSocketOptionMap {
    private List<MockSocketOption> fakeSocketOptions = new ArrayList<MockSocketOption>();
    static Pattern p = Pattern.compile("(\\w*):(\\w*)=(\\p{XDigit}*)");
    private static final ProtocolDescriptor.EnumType SOCKET_OPTION_NAME_ENUM;
    private static final ProtocolDescriptor.EnumType SOCKET_OPTION_LEVEL_ENUM;

    public static MockSocketOptionMap createFromOptionsSpec(String optionsSpec) {
        MockSocketOptionMap result = new MockSocketOptionMap();
        if (optionsSpec != null && !optionsSpec.isEmpty()) {
            result.addMockOptions(optionsSpec);
        }
        return result;
    }

    public MockSocketOptionMap() {
    }

    public MockSocketOptionMap(MockSocketOptionMap other) {
        this.fakeSocketOptions.addAll(other.fakeSocketOptions);
    }

    void addMockOptions(String options) {
        for (String option : options.split(",")) {
            this.addMockOption(option);
        }
    }

    void addMockOption(String option) {
        Matcher m = p.matcher(option);
        m.matches();
        assert (m.matches());
        String string = String.valueOf(m.group(1));
        SocketServicePb.SocketOption.SocketOptionLevel level = MockSocketOptionMap.findOptionLevel(string.length() != 0 ? "SOCKET_".concat(string) : new String("SOCKET_"));
        if (level == null) {
            String string2 = String.valueOf(m.group(1));
            throw new IllegalArgumentException(string2.length() != 0 ? "Illegal socket option level: ".concat(string2) : new String("Illegal socket option level: "));
        }
        String string3 = String.valueOf(m.group(2));
        SocketServicePb.SocketOption.SocketOptionName name = MockSocketOptionMap.findOptionName(string3.length() != 0 ? "SOCKET_".concat(string3) : new String("SOCKET_"));
        if (name == null) {
            String string4 = String.valueOf(m.group(2));
            throw new IllegalArgumentException(string4.length() != 0 ? "Illegal socket option name: ".concat(string4) : new String("Illegal socket option name: "));
        }
        this.addMockOption(level, name, this.hexStringToByteArray(m.group(3)));
    }

    void addMockOption(SocketServicePb.SocketOption.SocketOptionLevel level, SocketServicePb.SocketOption.SocketOptionName name, byte[] value) {
        this.fakeSocketOptions.add(new MockSocketOption(level.getValue(), name.getValue(), value));
    }

    byte[] getMockOption(SocketServicePb.SocketOption pbOption) {
        return this.getMockOption(pbOption.getLevel(), pbOption.getOption());
    }

    byte[] getMockOption(int level, int name) {
        for (MockSocketOption o : this.fakeSocketOptions) {
            if (o.getLevel() != level || o.getName() != name) continue;
            return o.getValue();
        }
        return null;
    }

    private byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int c1 = Character.digit(s.charAt(i), 16);
            int c2 = Character.digit(s.charAt(i + 1), 16);
            assert (c1 != -1);
            assert (c2 != -1);
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    static SocketServicePb.SocketOption.SocketOptionLevel findOptionLevel(String levelString) {
        if (SOCKET_OPTION_LEVEL_ENUM == null) {
            return null;
        }
        for (ProtocolDescriptor.EnumTypeTag t : SOCKET_OPTION_LEVEL_ENUM.tags()) {
            if (!t.getName().equals(levelString)) continue;
            return SocketServicePb.SocketOption.SocketOptionLevel.valueOf((int)t.getValue());
        }
        return null;
    }

    static SocketServicePb.SocketOption.SocketOptionName findOptionName(String nameString) {
        if (SOCKET_OPTION_NAME_ENUM == null) {
            return null;
        }
        for (ProtocolDescriptor.EnumTypeTag t : SOCKET_OPTION_NAME_ENUM.tags()) {
            if (!t.getName().equals(nameString)) continue;
            return SocketServicePb.SocketOption.SocketOptionName.valueOf((int)t.getValue());
        }
        return null;
    }

    static {
        ProtocolDescriptor reflectionTool = SocketServicePb.SocketOption.IMMUTABLE_DEFAULT_INSTANCE.getProtocolType().getProtocolDescriptor();
        ProtocolDescriptor.EnumType sol = null;
        ProtocolDescriptor.EnumType son = null;
        for (ProtocolDescriptor.EnumType et : reflectionTool.enumTypes()) {
            if (et.getName().equals("SocketOptionLevel")) {
                sol = et;
            }
            if (!et.getName().equals("SocketOptionName")) continue;
            son = et;
        }
        SOCKET_OPTION_LEVEL_ENUM = sol;
        SOCKET_OPTION_NAME_ENUM = son;
    }

    private static class MockSocketOption {
        int level;
        int name;
        byte[] value;

        public int getLevel() {
            return this.level;
        }

        public int getName() {
            return this.name;
        }

        public byte[] getValue() {
            return this.value;
        }

        public MockSocketOption(int level, int name, byte[] value) {
            this.level = level;
            this.name = name;
            this.value = value;
        }
    }
}

